/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.repository.git;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.iterators.ReverseListIterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.commons.crypto.TextEncryptor;
import org.craftercms.commons.crypto.impl.PbkAesTextEncryptor;
import org.craftercms.commons.monitoring.VersionMonitor;
import org.craftercms.studio.api.v1.constant.GitRepositories;
import org.craftercms.studio.api.v1.constant.RepoOperation;
import org.craftercms.studio.api.v1.dal.DeploymentSyncHistory;
import org.craftercms.studio.api.v1.dal.GitLog;
import org.craftercms.studio.api.v1.dal.GitLogMapper;
import org.craftercms.studio.api.v1.dal.RemoteRepository;
import org.craftercms.studio.api.v1.dal.RemoteRepositoryMapper;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryCredentialsException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteUrlException;
import org.craftercms.studio.api.v1.exception.repository.RemoteAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotBareException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.deployment.DeploymentException;
import org.craftercms.studio.api.v1.service.deployment.DeploymentHistoryProvider;
import org.craftercms.studio.api.v1.service.security.SecurityProvider;
import org.craftercms.studio.api.v1.to.DeploymentItemTO;
import org.craftercms.studio.api.v1.to.RemoteRepositoryInfoTO;
import org.craftercms.studio.api.v1.to.RepoOperationTO;
import org.craftercms.studio.api.v1.to.VersionTO;
import org.craftercms.studio.api.v1.util.StudioConfiguration;
import org.craftercms.studio.api.v1.util.filter.DmFilterWrapper;
import org.craftercms.studio.impl.v1.repository.git.GitContentRepository;
import org.craftercms.studio.impl.v1.repository.git.GitContentRepositoryConstants;
import org.craftercms.studio.impl.v1.repository.git.GitContentRepositoryHelper;
import org.craftercms.studio.impl.v1.repository.git.TreeCopier;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RemoteAddCommand;
import org.eclipse.jgit.api.RemoteRemoveCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.TagCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.AndRevFilter;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.eclipse.jgit.revwalk.filter.MessageRevFilter;
import org.eclipse.jgit.revwalk.filter.NotRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.web.context.ServletContextAware;

public class GitContentRepository
implements ContentRepository,
ServletContextAware,
DeploymentHistoryProvider {
    private static final Logger logger = LoggerFactory.getLogger(GitContentRepository.class);
    private GitContentRepositoryHelper helper = null;
    private TextEncryptor encryptor;
    private static final String IN_PROGRESS_BRANCH_NAME_SUFIX = "_in_progress";
    private static final String STUDIO_MANIFEST_LOCATION = "/META-INF/MANIFEST.MF";
    protected ServletContext ctx;
    protected SecurityProvider securityProvider;
    protected StudioConfiguration studioConfiguration;
    protected ServicesConfig servicesConfig;
    @Autowired
    protected GitLogMapper gitLogMapper;
    @Autowired
    protected RemoteRepositoryMapper remoteRepositoryMapper;

    public boolean contentExists(String site, String path) {
        boolean toReturn = false;
        Repository repo = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
        try {
            RevTree tree = this.helper.getTreeForLastCommit(repo);
            try (TreeWalk tw = TreeWalk.forPath((Repository)repo, (String)this.helper.getGitPath(path), (RevTree)tree);){
                String gitPath;
                if (tw != null && tw.getObjectId(0) != null) {
                    toReturn = true;
                    tw.close();
                } else if (tw == null && (StringUtils.isEmpty((CharSequence)(gitPath = this.helper.getGitPath(path))) || gitPath.equals("."))) {
                    toReturn = true;
                }
            }
            catch (IOException e) {
                logger.info("Content not found for site: " + site + " path: " + path, new Object[]{e});
            }
        }
        catch (IOException e) {
            logger.error("Failed to create RevTree for site: " + site + " path: " + path, (Exception)e, new Object[0]);
        }
        return toReturn;
    }

    public InputStream getContent(String site, String path) throws ContentNotFoundException {
        ObjectStream toReturn = null;
        Repository repo = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
        try {
            RevTree tree = this.helper.getTreeForLastCommit(repo);
            try (TreeWalk tw = TreeWalk.forPath((Repository)repo, (String)this.helper.getGitPath(path), (RevTree)tree);){
                if (tw != null && tw.getObjectId(0) != null) {
                    ObjectId id = tw.getObjectId(0);
                    ObjectLoader objectLoader = repo.open((AnyObjectId)id);
                    toReturn = objectLoader.openStream();
                    tw.close();
                }
            }
            catch (IOException e) {
                logger.error("Error while getting content for file at site: " + site + " path: " + path, (Exception)e, new Object[0]);
            }
        }
        catch (IOException e) {
            logger.error("Failed to create RevTree for site: " + site + " path: " + path, (Exception)e, new Object[0]);
        }
        return toReturn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getContentSize(String site, String path) {
        Repository repo = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
        try {
            RevTree tree = this.helper.getTreeForLastCommit(repo);
            try (TreeWalk tw = TreeWalk.forPath((Repository)repo, (String)this.helper.getGitPath(path), (RevTree)tree);){
                if (tw == null) return -1L;
                if (tw.getObjectId(0) == null) return -1L;
                ObjectId id = tw.getObjectId(0);
                ObjectLoader objectLoader = repo.open((AnyObjectId)id);
                long l = objectLoader.getSize();
                return l;
            }
        }
        catch (IOException e) {
            logger.error("Error while getting content for file at site: " + site + " path: " + path, (Exception)e, new Object[0]);
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeContent(String site, String path, InputStream content) {
        String commitId = null;
        Repository repository = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
        synchronized (repository) {
            Repository repo = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
            if (repo != null) {
                if (this.helper.writeFile(repo, site, path, content)) {
                    PersonIdent user = this.helper.getCurrentUserIdent();
                    String username = this.securityProvider.getCurrentUser();
                    String comment = this.studioConfiguration.getProperty("studio.repo.sandbox.write.commitMessage").replace("{username}", username).replace("{path}", path);
                    commitId = this.helper.commitFile(repo, site, path, comment, user);
                } else {
                    logger.error("Failed to write content site: " + site + " path: " + path, new Object[0]);
                }
            } else {
                logger.error("Missing repository during write for site: " + site + " path: " + path, new Object[0]);
            }
        }
        return commitId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createFolder(String site, String path, String name) {
        String commitId = null;
        Repository repository = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
        synchronized (repository) {
            boolean result;
            Repository repo;
            Path emptyFilePath;
            block22: {
                emptyFilePath = Paths.get(path, name, ".keep");
                repo = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
                try {
                    File file = new File(repo.getDirectory().getParent(), emptyFilePath.toString());
                    File folder = file.getParentFile();
                    if (folder != null && !folder.exists()) {
                        folder.mkdirs();
                    }
                    if (!file.createNewFile()) {
                        logger.error("error writing file: site: " + site + " path: " + emptyFilePath, new Object[0]);
                        result = false;
                        break block22;
                    }
                    try (Git git = new Git(repo);){
                        git.add().addFilepattern(this.helper.getGitPath(emptyFilePath.toString())).call();
                        git.close();
                        result = true;
                    }
                    catch (GitAPIException e) {
                        logger.error("error adding file to git: site: " + site + " path: " + emptyFilePath, (Exception)((Object)e), new Object[0]);
                        result = false;
                    }
                }
                catch (IOException e) {
                    logger.error("error writing file: site: " + site + " path: " + emptyFilePath, (Exception)e, new Object[0]);
                    result = false;
                }
            }
            if (result) {
                commitId = this.helper.commitFile(repo, site, emptyFilePath.toString(), "Created folder site: " + site + " path: " + path + "/" + name, this.helper.getCurrentUserIdent());
            }
        }
        return commitId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deleteContent(String site, String path, String approver) {
        String commitId = null;
        Repository repository = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
        synchronized (repository) {
            Repository repo = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
            try (Git git = new Git(repo);){
                String pathToDelete = this.helper.getGitPath(path);
                Path toDelete = Paths.get(repo.getDirectory().getParent(), pathToDelete);
                Path parentToDelete = Paths.get(pathToDelete, new String[0]).getParent();
                git.rm().addFilepattern(pathToDelete).setCached(false).call();
                String pathToCommit = pathToDelete;
                if (toDelete.toFile().isFile()) {
                    pathToCommit = this.deleteParentFolder(git, parentToDelete);
                }
                commitId = this.helper.commitFile(repo, site, pathToCommit, "Delete file " + path, StringUtils.isEmpty((CharSequence)approver) ? this.helper.getCurrentUserIdent() : this.helper.getAuthorIdent(approver));
                git.close();
            }
            catch (GitAPIException e) {
                logger.error("Error while deleting content for site: " + site + " path: " + path, (Exception)((Object)e), new Object[0]);
            }
        }
        return commitId;
    }

    private String deleteParentFolder(Git git, Path parentFolder) throws GitAPIException {
        String parent;
        String toRet = parent = parentFolder.toString();
        String folderToDelete = this.helper.getGitPath(parent);
        Path toDelete = Paths.get(git.getRepository().getDirectory().getParent(), parent);
        String[] children = toDelete.toFile().list();
        if (children != null && children.length < 2) {
            if (children.length == 1 || children[0].equals(".keep")) {
                Path ancestor = parentFolder.getParent();
                git.rm().addFilepattern(this.helper.getGitPath(folderToDelete + "/" + ".keep")).setCached(false).call();
            } else {
                Path ancestor = parentFolder.getParent();
                git.rm().addFilepattern(this.helper.getGitPath(parentFolder.toString())).setCached(false).call();
            }
        }
        return toRet;
    }

    public Map<String, String> moveContent(String site, String fromPath, String toPath) {
        return this.moveContent(site, fromPath, toPath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> moveContent(String site, String fromPath, String toPath, String newName) {
        TreeMap<String, String> toRet = new TreeMap<String, String>();
        Repository repository = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
        synchronized (repository) {
            Repository repo = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
            String gitFromPath = this.helper.getGitPath(fromPath);
            String gitToPath = StringUtils.isEmpty((CharSequence)newName) ? this.helper.getGitPath(toPath) : this.helper.getGitPath(toPath + "/" + newName);
            try (Git git = new Git(repo);){
                Path sourcePath = Paths.get(repo.getDirectory().getParent(), gitFromPath);
                File sourceFile = sourcePath.toFile();
                Path targetPath = Paths.get(repo.getDirectory().getParent(), gitToPath);
                File targetFile = targetPath.toFile();
                if (sourceFile.getCanonicalFile().equals(targetFile.getCanonicalFile())) {
                    sourceFile.renameTo(targetFile);
                } else if (targetFile.isFile()) {
                    if (sourceFile.isFile()) {
                        sourceFile.renameTo(targetFile);
                    } else {
                        logger.error("Invalid move operation: Trying to rename a directory to a file for site: " + site + " fromPath: " + fromPath + " toPath: " + toPath + " newName: " + newName, new Object[0]);
                    }
                } else if (sourceFile.isDirectory()) {
                    File[] dirList;
                    for (File child : dirList = sourceFile.listFiles()) {
                        if (child.equals(sourceFile)) continue;
                        FileUtils.moveToDirectory((File)child, (File)targetFile, (boolean)true);
                    }
                    FileUtils.deleteDirectory((File)sourceFile);
                } else if (sourceFile.isFile()) {
                    FileUtils.moveFile((File)sourceFile, (File)targetFile);
                } else {
                    FileUtils.moveToDirectory((File)sourceFile, (File)targetFile, (boolean)true);
                }
                git.add().addFilepattern(gitToPath).call();
                Status gitStatus = git.status().addPath(gitToPath).call();
                Set changeSet = gitStatus.getAdded();
                for (String pathToCommit : changeSet) {
                    String pathRemoved = pathToCommit.replace(gitToPath, gitFromPath);
                    RevCommit commit = git.commit().setOnly(pathToCommit).setOnly(pathRemoved).setAuthor(this.helper.getCurrentUserIdent()).setCommitter(this.helper.getCurrentUserIdent()).setMessage("Moving " + fromPath + " to " + toPath + (StringUtils.isNotEmpty((CharSequence)newName) ? newName : "")).call();
                    String commitId = commit.getName();
                    toRet.put(pathToCommit, commitId);
                }
                git.close();
            }
            catch (IOException | GitAPIException e) {
                logger.error("Error while moving content for site: " + site + " fromPath: " + fromPath + " toPath: " + toPath + " newName: " + newName, new Object[0]);
            }
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String copyContent(String site, String fromPath, String toPath) {
        String commitId = null;
        Repository repository = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
        synchronized (repository) {
            Repository repo = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
            String gitFromPath = this.helper.getGitPath(fromPath);
            String gitToPath = this.helper.getGitPath(toPath);
            try (Git git = new Git(repo);){
                Path sourcePath = Paths.get(repo.getDirectory().getParent(), fromPath);
                File sourceFile = sourcePath.toFile();
                Path targetPath = Paths.get(repo.getDirectory().getParent(), toPath);
                File targetFile = targetPath.toFile();
                FileUtils.copyDirectory((File)sourceFile, (File)targetFile);
                git.add().addFilepattern(gitToPath).call();
                RevCommit commit = git.commit().setOnly(gitFromPath).setOnly(gitToPath).setAuthor(this.helper.getCurrentUserIdent()).setCommitter(this.helper.getCurrentUserIdent()).setMessage("Copying " + fromPath + " to " + toPath).call();
                commitId = commit.getName();
                git.close();
            }
            catch (IOException | GitAPIException e) {
                logger.error("Error while copying content for site: " + site + " fromPath: " + fromPath + " toPath: " + toPath + " newName: ", new Object[0]);
            }
        }
        return commitId;
    }

    public RepositoryItem[] getContentChildren(String site, String path) {
        ArrayList<RepositoryItem> retItems;
        block36: {
            retItems = new ArrayList<RepositoryItem>();
            Repository repo = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
            try {
                RevTree tree = this.helper.getTreeForLastCommit(repo);
                try (TreeWalk tw = TreeWalk.forPath((Repository)repo, (String)this.helper.getGitPath(path), (RevTree)tree);){
                    if (tw != null) {
                        ObjectLoader loader = repo.open((AnyObjectId)tw.getObjectId(0));
                        if (loader.getType() == 2) {
                            int depth = tw.getDepth();
                            tw.enterSubtree();
                            while (tw.next()) {
                                if (tw.getDepth() != depth + 1) continue;
                                RepositoryItem item = new RepositoryItem();
                                item.name = tw.getNameString();
                                String visitFolderPath = "/" + tw.getPathString();
                                loader = repo.open((AnyObjectId)tw.getObjectId(0));
                                item.isFolder = loader.getType() == 2;
                                int lastIdx = visitFolderPath.lastIndexOf("/" + item.name);
                                if (lastIdx > 0) {
                                    item.path = visitFolderPath.substring(0, lastIdx);
                                }
                                if (ArrayUtils.contains((Object[])GitContentRepositoryConstants.IGNORE_FILES, (Object)item.name)) continue;
                                retItems.add(item);
                            }
                            tw.close();
                        } else {
                            logger.debug("Object is not tree for site: " + site + " path: " + path + " - it does not have children", new Object[0]);
                        }
                        break block36;
                    }
                    String gitPath = this.helper.getGitPath(path);
                    if (!StringUtils.isEmpty((CharSequence)gitPath) && !gitPath.equals(".")) break block36;
                    try (TreeWalk treeWalk = new TreeWalk(repo);){
                        treeWalk.addTree((AnyObjectId)tree);
                        while (treeWalk.next()) {
                            ObjectLoader loader = repo.open((AnyObjectId)treeWalk.getObjectId(0));
                            RepositoryItem item = new RepositoryItem();
                            item.name = treeWalk.getNameString();
                            String visitFolderPath = "/" + treeWalk.getPathString();
                            loader = repo.open((AnyObjectId)treeWalk.getObjectId(0));
                            item.isFolder = loader.getType() == 2;
                            int lastIdx = visitFolderPath.lastIndexOf("/" + item.name);
                            item.path = lastIdx > 0 ? visitFolderPath.substring(0, lastIdx) : "";
                            if (ArrayUtils.contains((Object[])GitContentRepositoryConstants.IGNORE_FILES, (Object)item.name)) continue;
                            retItems.add(item);
                        }
                    }
                    catch (IOException e) {
                        logger.error("Error while getting children for site: " + site + " path: " + path, (Exception)e, new Object[0]);
                    }
                }
                catch (IOException e) {
                    logger.error("Error while getting children for site: " + site + " path: " + path, (Exception)e, new Object[0]);
                }
            }
            catch (IOException e) {
                logger.error("Failed to create RevTree for site: " + site + " path: " + path, (Exception)e, new Object[0]);
            }
        }
        RepositoryItem[] items = new RepositoryItem[retItems.size()];
        items = retItems.toArray(items);
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionTO[] getContentVersionHistory(String site, String path) {
        ArrayList<VersionTO> versionHistory = new ArrayList<VersionTO>();
        Repository repository = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
        synchronized (repository) {
            Repository repo = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
            try {
                ObjectId head = repo.resolve("HEAD");
                String gitPath = this.helper.getGitPath(path);
                try (Git git = new Git(repo);){
                    Iterable commits = git.log().add((AnyObjectId)head).addPath(gitPath).call();
                    for (RevCommit revCommit : commits) {
                        VersionTO versionTO = new VersionTO();
                        versionTO.setVersionNumber(revCommit.getName());
                        versionTO.setLastModifier(revCommit.getAuthorIdent().getName());
                        versionTO.setLastModifiedDate(Instant.ofEpochSecond(revCommit.getCommitTime()).atZone(ZoneOffset.UTC));
                        versionTO.setComment(revCommit.getFullMessage());
                        versionHistory.add(versionTO);
                    }
                    git.close();
                }
                catch (IOException e) {
                    logger.error("error while getting history for content item " + path, new Object[0]);
                }
            }
            catch (IOException | GitAPIException e) {
                logger.error("Failed to create Git repo for site: " + site + " path: " + path, (Exception)e, new Object[0]);
            }
        }
        VersionTO[] toRet = new VersionTO[versionHistory.size()];
        return versionHistory.toArray(toRet);
    }

    public String createVersion(String site, String path, boolean majorVersion) {
        return this.createVersion(site, path, "", majorVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createVersion(String site, String path, String comment, boolean majorVersion) {
        String toReturn = "";
        Repository repository = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.PUBLISHED);
        synchronized (repository) {
            if (majorVersion) {
                Repository repo = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.PUBLISHED);
                String gitPath = this.helper.getGitPath(path);
                try (Git git = new Git(repo);){
                    PersonIdent currentUserIdent = this.helper.getCurrentUserIdent();
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HHmmssX");
                    Calendar cal = Calendar.getInstance();
                    String versionLabel = dateFormat.format(cal.getTime());
                    TagCommand tagCommand = git.tag().setName(versionLabel).setMessage(comment).setTagger(currentUserIdent);
                    tagCommand.call();
                    toReturn = versionLabel;
                    git.close();
                }
                catch (GitAPIException err) {
                    logger.error("error creating new version for site:  " + site + " path: " + path, (Exception)((Object)err), new Object[0]);
                }
            } else {
                logger.info("request to create minor revision ignored for site: " + site + " path: " + path, new Object[0]);
            }
        }
        return toReturn;
    }

    public String revertContent(String site, String path, String version, boolean major, String comment) {
        String commitId = null;
        try {
            InputStream versionContent = this.getContentVersion(site, path, version);
            commitId = this.writeContent(site, path, versionContent);
            this.createVersion(site, path, major);
        }
        catch (ContentNotFoundException err) {
            logger.error("error reverting content for site:  " + site + " path: " + path, (Exception)((Object)err), new Object[0]);
        }
        return commitId;
    }

    public InputStream getContentVersion(String site, String path, String version) throws ContentNotFoundException {
        ObjectStream toReturn = null;
        Repository repo = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
        try {
            RevTree tree = this.helper.getTreeForCommit(repo, version);
            try (TreeWalk tw = TreeWalk.forPath((Repository)repo, (String)this.helper.getGitPath(path), (RevTree)tree);){
                if (tw != null) {
                    ObjectId id = tw.getObjectId(0);
                    ObjectLoader objectLoader = repo.open((AnyObjectId)id);
                    toReturn = objectLoader.openStream();
                    tw.close();
                }
            }
            catch (IOException e) {
                logger.error("Error while getting content for file at site: " + site + " path: " + path + " version: " + version, (Exception)e, new Object[0]);
            }
        }
        catch (IOException e) {
            logger.error("Failed to create RevTree for site: " + site + " path: " + path + " version: " + version, (Exception)e, new Object[0]);
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockItem(String site, String path) {
        Repository repo = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
        Repository repository = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
        synchronized (repository) {
            try (TreeWalk tw = new TreeWalk(repo);){
                RevTree tree = this.helper.getTreeForLastCommit(repo);
                tw.addTree((AnyObjectId)tree);
                tw.setRecursive(false);
                tw.setFilter((TreeFilter)PathFilter.create((String)path));
                if (!tw.next()) {
                    return;
                }
                File repoRoot = repo.getWorkTree();
                Paths.get(repoRoot.getPath(), tw.getPathString());
                File file = new File(tw.getPathString());
                LockFile lock = new LockFile(file);
                lock.lock();
                tw.close();
            }
            catch (IOException e) {
                logger.error("Error while locking file for site: " + site + " path: " + path, (Exception)e, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockItemForPublishing(String site, String path) {
        Repository repo;
        Repository repository = repo = this.helper.getRepository(site, GitRepositories.PUBLISHED);
        synchronized (repository) {
            try (TreeWalk tw = new TreeWalk(repo);){
                RevTree tree = this.helper.getTreeForLastCommit(repo);
                tw.addTree((AnyObjectId)tree);
                tw.setRecursive(false);
                tw.setFilter((TreeFilter)PathFilter.create((String)path));
                if (!tw.next()) {
                    return;
                }
                File repoRoot = repo.getWorkTree();
                Paths.get(repoRoot.getPath(), tw.getPathString());
                File file = new File(tw.getPathString());
                LockFile lock = new LockFile(file);
                lock.lock();
                tw.close();
            }
            catch (IOException e) {
                logger.error("Error while locking file for site: " + site + " path: " + path, (Exception)e, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unLockItem(String site, String path) {
        Repository repo = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
        Repository repository = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
        synchronized (repository) {
            try (TreeWalk tw = new TreeWalk(repo);){
                RevTree tree = this.helper.getTreeForLastCommit(repo);
                tw.addTree((AnyObjectId)tree);
                tw.setRecursive(false);
                tw.setFilter((TreeFilter)PathFilter.create((String)path));
                if (!tw.next()) {
                    return;
                }
                File repoRoot = repo.getWorkTree();
                Paths.get(repoRoot.getPath(), tw.getPathString());
                File file = new File(tw.getPathString());
                LockFile lock = new LockFile(file);
                lock.unlock();
                tw.close();
            }
            catch (IOException e) {
                logger.error("Error while unlocking file for site: " + site + " path: " + path, (Exception)e, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unLockItemForPublishing(String site, String path) {
        Repository repo;
        Repository repository = repo = this.helper.getRepository(site, GitRepositories.PUBLISHED);
        synchronized (repository) {
            try (TreeWalk tw = new TreeWalk(repo);){
                RevTree tree = this.helper.getTreeForLastCommit(repo);
                tw.addTree((AnyObjectId)tree);
                tw.setRecursive(false);
                tw.setFilter((TreeFilter)PathFilter.create((String)path));
                if (!tw.next()) {
                    return;
                }
                File repoRoot = repo.getWorkTree();
                Paths.get(repoRoot.getPath(), tw.getPathString());
                File file = new File(tw.getPathString());
                LockFile lock = new LockFile(file);
                lock.unlock();
                tw.close();
            }
            catch (IOException e) {
                logger.error("Error while unlocking file for site: " + site + " path: " + path, (Exception)e, new Object[0]);
            }
        }
    }

    public void bootstrap() throws Exception {
        this.helper = new GitContentRepositoryHelper(this.studioConfiguration, this.securityProvider, this.servicesConfig);
        this.encryptor = new PbkAesTextEncryptor(this.studioConfiguration.getProperty("studio.security.cipher.key"), this.studioConfiguration.getProperty("studio.security.cipher.salt"));
        if (Boolean.parseBoolean(this.studioConfiguration.getProperty("studio.repo.bootstrapRepo"))) {
            if (this.helper.createGlobalRepo()) {
                String bootstrapFolderPath = this.ctx.getRealPath("/repo-bootstrap/global");
                Path source = FileSystems.getDefault().getPath(bootstrapFolderPath, new String[0]);
                logger.info("Bootstrapping with baseline @ " + source.toFile().toString(), new Object[0]);
                Path globalConfigPath = this.helper.buildRepoPath(GitRepositories.GLOBAL);
                TreeCopier tc = new TreeCopier(source, globalConfigPath);
                EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
                Files.walkFileTree(source, opts, Integer.MAX_VALUE, (FileVisitor<? super Path>)tc);
                String studioManifestLocation = this.ctx.getRealPath(STUDIO_MANIFEST_LOCATION);
                if (Files.exists(Paths.get(studioManifestLocation, new String[0]), new LinkOption[0])) {
                    FileUtils.copyFile((File)Paths.get(studioManifestLocation, new String[0]).toFile(), (File)Paths.get(globalConfigPath.toAbsolutePath().toString(), this.studioConfiguration.getProperty("studio.repo.blueprintsPath"), "BLUEPRINTS.MF").toFile());
                }
                Repository globalConfigRepo = this.helper.getRepository("", GitRepositories.GLOBAL);
                try (Git git = new Git(globalConfigRepo);){
                    Status status = git.status().call();
                    if (status.hasUncommittedChanges() || !status.isClean()) {
                        git.add().addFilepattern(".").call();
                        git.commit().setMessage("Initial commit.").call();
                    }
                    git.close();
                }
                catch (GitAPIException err) {
                    logger.error("error creating initial commit for global configuration", (Exception)((Object)err), new Object[0]);
                }
            } else {
                Path globalConfigPath = this.helper.buildRepoPath(GitRepositories.GLOBAL);
                Path blueprintsPath = Paths.get(globalConfigPath.toAbsolutePath().toString(), this.studioConfiguration.getProperty("studio.repo.blueprintsPath"));
                String studioManifestLocation = this.ctx.getRealPath(STUDIO_MANIFEST_LOCATION);
                String blueprintsManifestLocation = Paths.get(blueprintsPath.toAbsolutePath().toString(), "BLUEPRINTS.MF").toAbsolutePath().toString();
                boolean blueprintManifestExists = Files.exists(Paths.get(blueprintsManifestLocation, new String[0]), new LinkOption[0]);
                FileInputStream studioManifestStream = FileUtils.openInputStream((File)new File(studioManifestLocation));
                Manifest studioManifest = new Manifest(studioManifestStream);
                VersionMonitor studioVersion = VersionMonitor.getVersion((Manifest)studioManifest);
                FileInputStream blueprintsManifestStream = null;
                Manifest blueprintsManifest = null;
                VersionMonitor blueprintsVersion = null;
                if (blueprintManifestExists) {
                    blueprintsManifestStream = FileUtils.openInputStream((File)new File(blueprintsManifestLocation));
                    blueprintsManifest = new Manifest(blueprintsManifestStream);
                    blueprintsVersion = VersionMonitor.getVersion((Manifest)blueprintsManifest);
                }
                if (!blueprintManifestExists || !StringUtils.equals((CharSequence)studioVersion.getBuild(), (CharSequence)blueprintsVersion.getBuild()) || StringUtils.equals((CharSequence)studioVersion.getBuild(), (CharSequence)blueprintsVersion.getBuild()) && !StringUtils.equals((CharSequence)studioVersion.getBuild_date(), (CharSequence)blueprintsVersion.getBuild_date())) {
                    File[] blueprintFolders;
                    String bootstrapBlueprintsFolderPath = this.ctx.getRealPath("/repo-bootstrap/global/" + this.studioConfiguration.getProperty("studio.repo.blueprintsPath"));
                    File bootstrapBlueprintsFolder = new File(bootstrapBlueprintsFolderPath);
                    for (File blueprintFolder : blueprintFolders = bootstrapBlueprintsFolder.listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */)) {
                        String blueprintName = blueprintFolder.getName();
                        FileUtils.deleteDirectory((File)Paths.get(blueprintsPath.toAbsolutePath().toString(), blueprintName).toFile());
                        TreeCopier tc = new TreeCopier(Paths.get(blueprintFolder.getAbsolutePath(), new String[0]), Paths.get(blueprintsPath.toAbsolutePath().toString(), blueprintName));
                        EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
                        Files.walkFileTree(Paths.get(blueprintFolder.getAbsolutePath(), new String[0]), opts, Integer.MAX_VALUE, (FileVisitor<? super Path>)tc);
                    }
                    FileUtils.copyFile((File)Paths.get(studioManifestLocation, new String[0]).toFile(), (File)Paths.get(globalConfigPath.toAbsolutePath().toString(), this.studioConfiguration.getProperty("studio.repo.blueprintsPath"), "BLUEPRINTS.MF").toFile());
                }
                Repository globalRepo = this.helper.getRepository("", GitRepositories.GLOBAL);
                try (Git git = new Git(globalRepo);){
                    Status status = git.status().call();
                    if (status.hasUncommittedChanges() || !status.isClean()) {
                        git.add().addFilepattern(".").call();
                        git.commit().setAll(true).setMessage("Blueprints updated.").call();
                    }
                    git.close();
                }
                catch (GitAPIException err) {
                    logger.error("error creating initial commit for global configuration", (Exception)((Object)err), new Object[0]);
                }
            }
        }
        if (!this.helper.buildGlobalRepo()) {
            logger.error("Failed to create global repository!", new Object[0]);
        }
    }

    public boolean createSiteFromBlueprint(String blueprintName, String site, String sandboxBranch) {
        boolean toReturn = this.helper.createSiteGitRepo(site, sandboxBranch);
        if (toReturn) {
            toReturn = this.helper.copyContentFromBlueprint(blueprintName, site);
        }
        if (toReturn) {
            toReturn = this.helper.updateSitenameConfigVar(site);
        }
        if (toReturn) {
            toReturn = this.helper.performInitialCommit(site, "Initial commit.", sandboxBranch);
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteSite(String site) {
        boolean toReturn;
        Repository repository = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
        if (repository != null) {
            Repository repository2 = repository;
            synchronized (repository2) {
                Repository publishedRepository = this.helper.getRepository(site, GitRepositories.PUBLISHED);
                if (publishedRepository != null) {
                    Repository repository3 = publishedRepository;
                    synchronized (repository3) {
                        toReturn = this.helper.deleteSiteGitRepo(site);
                    }
                } else {
                    toReturn = this.helper.deleteSiteGitRepo(site);
                }
            }
        }
        Path sitePath = Paths.get(this.studioConfiguration.getProperty("studio.repo.basePath"), this.studioConfiguration.getProperty("studio.repo.sitesRepoBasePath"), site);
        try {
            FileUtils.deleteDirectory((File)sitePath.toFile());
            toReturn = true;
        }
        catch (IOException e) {
            logger.error("Error while deleting site " + site, (Exception)e, new Object[0]);
            toReturn = false;
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialPublish(String site, String sandboxBranch, String environment, String author, String comment) throws DeploymentException {
        Repository repo = this.helper.getRepository(site, GitRepositories.PUBLISHED);
        String commitId = "";
        String sandboxBranchName = sandboxBranch;
        if (StringUtils.isEmpty((CharSequence)sandboxBranchName)) {
            sandboxBranchName = this.studioConfiguration.getProperty("studio.repo.siteSandboxBranch");
        }
        Repository repository = repo;
        synchronized (repository) {
            try (Git git = new Git(repo);){
                logger.debug("Fetch from sandbox for site " + site, new Object[0]);
                git.fetch().call();
                logger.debug("Checkout published/master branch for site " + site, new Object[0]);
                try {
                    git.checkout().setName(sandboxBranchName).call();
                    git.pull().setRemote("origin").setRemoteBranchName(sandboxBranchName).setStrategy(MergeStrategy.THEIRS).call();
                }
                catch (RefNotFoundException e) {
                    logger.error("Failed to checkout published master and to pull content from sandbox for site " + site, (Exception)((Object)e), new Object[0]);
                    throw new DeploymentException("Failed to checkout published master and to pull content from sandbox for site " + site);
                }
                logger.debug("Checkout environment branch " + environment + " for site " + site, new Object[0]);
                try {
                    git.checkout().setCreateBranch(true).setForce(true).setStartPoint(sandboxBranchName).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setName(environment).call();
                }
                catch (RefNotFoundException e) {
                    logger.info("Not able to find branch " + environment + " for site " + site + ". Creating new branch", new Object[0]);
                }
                PersonIdent authorIdent = this.helper.getAuthorIdent(author);
                ZonedDateTime publishDate = ZonedDateTime.now(ZoneOffset.UTC);
                String tagName = publishDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HHmmssSSSX")) + "_published_on_" + publishDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HHmmssSSSX"));
                git.tag().setTagger(authorIdent).setName(tagName).setMessage(comment).call();
                git.close();
            }
            catch (Exception e) {
                logger.error("Error when publishing site " + site + " to environment " + environment, e, new Object[0]);
                throw new DeploymentException("Error when publishing site " + site + " to environment " + environment + " [commit ID = " + commitId + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(String site, String sandboxBranch, List<DeploymentItemTO> deploymentItems, String environment, String author, String comment) throws DeploymentException {
        if (CollectionUtils.isEmpty(deploymentItems)) {
            return;
        }
        Repository repo = this.helper.getRepository(site, GitRepositories.PUBLISHED);
        String commitId = "";
        String path = "";
        String sandboxBranchName = sandboxBranch;
        if (StringUtils.isEmpty((CharSequence)sandboxBranchName)) {
            sandboxBranchName = this.studioConfiguration.getProperty("studio.repo.siteSandboxBranch");
        }
        Repository repository = repo;
        synchronized (repository) {
            block32: {
                try (Git git = new Git(repo);){
                    String inProgressBranchName = environment + IN_PROGRESS_BRANCH_NAME_SUFIX;
                    logger.debug("Fetch from sandbox for site " + site, new Object[0]);
                    git.fetch().call();
                    logger.debug("Checkout published/master branch for site " + site, new Object[0]);
                    try {
                        Ref ref;
                        String currentBranch = repo.getBranch();
                        if (currentBranch.endsWith(IN_PROGRESS_BRANCH_NAME_SUFIX)) {
                            git.reset().setMode(ResetCommand.ResetType.HARD).call();
                        }
                        boolean createBranch = (ref = repo.exactRef("refs/heads/" + sandboxBranchName)) == null;
                        git.checkout().setName(sandboxBranchName).setCreateBranch(createBranch).call();
                        logger.debug("Delete in-progress branch, in case it was not cleaned up for site " + site, new Object[0]);
                        git.branchDelete().setBranchNames(new String[]{inProgressBranchName}).setForce(true).call();
                        git.pull().setRemote("origin").setRemoteBranchName(sandboxBranchName).setStrategy(MergeStrategy.THEIRS).call();
                    }
                    catch (RefNotFoundException e) {
                        logger.error("Failed to checkout published master and to pull content from sandbox for site " + site, (Exception)((Object)e), new Object[0]);
                        throw new DeploymentException("Failed to checkout published master and to pull content from sandbox for site " + site);
                    }
                    logger.debug("Checkout environment branch " + environment + " for site " + site, new Object[0]);
                    boolean newBranch = false;
                    try {
                        git.checkout().setName(environment).call();
                    }
                    catch (RefNotFoundException e) {
                        logger.info("Not able to find branch " + environment + " for site " + site + ". Creating new branch", new Object[0]);
                        newBranch = true;
                        git.checkout().setCreateBranch(true).setForce(true).setStartPoint(sandboxBranchName).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setName(environment).call();
                    }
                    if (newBranch) break block32;
                    try {
                        logger.debug("Create in-progress branch for site " + site, new Object[0]);
                        git.checkout().setCreateBranch(true).setForce(true).setStartPoint(environment).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setName(inProgressBranchName).call();
                    }
                    catch (GitAPIException e) {
                        logger.error("Failed to create in-progress published branch for site " + site, new Object[0]);
                    }
                    HashSet<String> deployedCommits = new HashSet<String>();
                    HashSet<String> deployedPackages = new HashSet<String>();
                    logger.debug("Checkout deployed files started.", new Object[0]);
                    AddCommand addCommand = git.add();
                    for (DeploymentItemTO deploymentItem : deploymentItems) {
                        commitId = deploymentItem.getCommitId();
                        path = this.helper.getGitPath(deploymentItem.getPath());
                        logger.debug("Checking out file " + path + " from commit id " + commitId + " for site " + site, new Object[0]);
                        ObjectId objCommitId = repo.resolve(commitId);
                        RevWalk rw = new RevWalk(repo);
                        RevCommit revCommit = rw.parseCommit((AnyObjectId)objCommitId);
                        CheckoutCommand checkout = git.checkout();
                        checkout.setStartPoint(commitId).addPath(path).call();
                        if (deploymentItem.isMove()) {
                            String oldPath = this.helper.getGitPath(deploymentItem.getOldPath());
                            git.rm().addFilepattern(oldPath).setCached(false).call();
                            this.cleanUpMoveFolders(git, oldPath);
                        }
                        if (deploymentItem.isDelete()) {
                            String deletePath = this.helper.getGitPath(deploymentItem.getPath());
                            git.rm().addFilepattern(deletePath).setCached(false).call();
                            Path parentToDelete = Paths.get(path, new String[0]).getParent();
                            this.deleteParentFolder(git, parentToDelete);
                        }
                        deployedCommits.add(commitId);
                        String packageId = deploymentItem.getPackageId();
                        if (StringUtils.isNotEmpty((CharSequence)packageId)) {
                            deployedPackages.add(deploymentItem.getPackageId());
                        }
                        addCommand.addFilepattern(path);
                    }
                    logger.debug("Checkout deployed files completed.", new Object[0]);
                    String commitMessage = this.studioConfiguration.getProperty("studio.repo.published.commitMessage");
                    logger.debug("Get Author Ident started.", new Object[0]);
                    PersonIdent authorIdent = this.helper.getAuthorIdent(author);
                    logger.debug("Get Author Ident completed.", new Object[0]);
                    logger.debug("Git add all published items started.", new Object[0]);
                    addCommand.call();
                    logger.debug("Git add all published items completed.", new Object[0]);
                    commitMessage = commitMessage.replace("{username}", author);
                    commitMessage = commitMessage.replace("{datetime}", ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HHmmssSSSX")));
                    commitMessage = commitMessage.replace("{source}", "UI");
                    commitMessage = commitMessage.replace("{message}", comment);
                    StringBuilder sb = new StringBuilder();
                    for (String string : deployedCommits) {
                        sb.append(string).append(" ");
                    }
                    StringBuilder sbPackage = new StringBuilder();
                    for (String p : deployedPackages) {
                        sbPackage.append(p).append(" ");
                    }
                    commitMessage = commitMessage.replace("{commit_id}", sb.toString().trim());
                    commitMessage = commitMessage.replace("{package_id}", sbPackage.toString().trim());
                    logger.debug("Git commit all published items started.", new Object[0]);
                    RevCommit revCommit = git.commit().setMessage(commitMessage).setAuthor(authorIdent).call();
                    logger.debug("Git commit all published items completed.", new Object[0]);
                    int commitTime = revCommit.getCommitTime();
                    ZonedDateTime tagDate2 = Instant.ofEpochSecond(commitTime).atZone(ZoneOffset.UTC);
                    ZonedDateTime publishDate = ZonedDateTime.now(ZoneOffset.UTC);
                    String tagName2 = tagDate2.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HHmmssSSSX")) + "_published_on_" + publishDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HHmmssSSSX"));
                    logger.debug("Get Author Ident started.", new Object[0]);
                    PersonIdent authorIdent2 = this.helper.getAuthorIdent(author);
                    logger.debug("Get Author Ident completed.", new Object[0]);
                    logger.debug("Git tag started.", new Object[0]);
                    git.tag().setTagger(authorIdent2).setName(tagName2).setMessage(commitMessage).call();
                    logger.debug("Git tag completed.", new Object[0]);
                    logger.debug("Checkout environment " + environment + " branch for site " + site, new Object[0]);
                    git.checkout().setName(environment).call();
                    Ref branchRef = repo.findRef(inProgressBranchName);
                    logger.debug("Merge in-progress branch into environment " + environment + " for site " + site, new Object[0]);
                    git.merge().setCommit(true).include(branchRef).call();
                    logger.debug("Delete in-progress branch (clean up) for site " + site, new Object[0]);
                    git.branchDelete().setBranchNames(new String[]{inProgressBranchName}).setForce(true).call();
                    git.close();
                }
                catch (Exception e) {
                    logger.error("Error when publishing site " + site + " to environment " + environment, e, new Object[0]);
                    throw new DeploymentException("Error when publishing site " + site + " to environment " + environment + " [commit ID = " + commitId + "]");
                }
            }
        }
    }

    private void cleanUpMoveFolders(Git git, String path) throws GitAPIException {
        Path parentToDelete = Paths.get(path, new String[0]).getParent();
        this.deleteParentFolder(git, parentToDelete);
        Path testDelete = Paths.get(git.getRepository().getDirectory().getParent(), parentToDelete.toString());
        File testDeleteFile = testDelete.toFile();
        if (!testDeleteFile.exists()) {
            this.cleanUpMoveFolders(git, parentToDelete.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RepoOperationTO> getOperations(String site, String commitIdFrom, String commitIdTo) {
        ArrayList<RepoOperationTO> operations = new ArrayList<RepoOperationTO>();
        Repository repository = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
        synchronized (repository) {
            block58: {
                try {
                    boolean fromEmptyRepo = StringUtils.isEmpty((CharSequence)commitIdFrom);
                    String firstCommitId = this.getRepoFirstCommitId(site);
                    if (fromEmptyRepo) {
                        commitIdFrom = firstCommitId;
                    }
                    Repository repo = this.helper.getRepository(site, GitRepositories.SANDBOX);
                    ObjectId objCommitIdFrom = repo.resolve(commitIdFrom);
                    ObjectId objCommitIdTo = repo.resolve(commitIdTo);
                    ObjectId objFirstCommitId = repo.resolve(firstCommitId);
                    boolean initialEqToCommit = StringUtils.equals((CharSequence)firstCommitId, (CharSequence)commitIdTo);
                    boolean initialEqFromCommit = StringUtils.equals((CharSequence)firstCommitId, (CharSequence)commitIdFrom);
                    try (Git git = new Git(repo);){
                        if (fromEmptyRepo) {
                            try (RevWalk walk = new RevWalk(repo);){
                                RevCommit firstCommit = walk.parseCommit((AnyObjectId)objFirstCommitId);
                                RevTree firstCommitTree = this.helper.getTreeForCommit(repo, firstCommit.getName());
                                try (ObjectReader reader = repo.newObjectReader();){
                                    CanonicalTreeParser firstCommitTreeParser = new CanonicalTreeParser();
                                    firstCommitTreeParser.reset();
                                    List diffEntries = git.diff().setOldTree((AbstractTreeIterator)firstCommitTreeParser).setNewTree(null).call();
                                    operations.addAll(this.processDiffEntry(diffEntries, firstCommit.getId(), firstCommit.getCommitterIdent().getName(), Instant.ofEpochSecond(firstCommit.getCommitTime()).atZone(ZoneOffset.UTC)));
                                }
                            }
                        }
                        if (objCommitIdFrom.equals((AnyObjectId)objCommitIdTo)) break block58;
                        Iterable commits = git.log().addRange((AnyObjectId)objCommitIdFrom, (AnyObjectId)objCommitIdTo).call();
                        ObjectId prevCommitId = objCommitIdFrom;
                        ObjectId nextCommitId = objCommitIdFrom;
                        String author = "";
                        Iterator iterator = commits.iterator();
                        ArrayList<RevCommit> revCommits = new ArrayList<RevCommit>();
                        while (iterator.hasNext()) {
                            RevCommit commit = (RevCommit)iterator.next();
                            revCommits.add(commit);
                        }
                        ReverseListIterator reverseIterator = new ReverseListIterator(revCommits);
                        while (reverseIterator.hasNext()) {
                            RevCommit commit = (RevCommit)reverseIterator.next();
                            nextCommitId = commit.getId();
                            author = commit.getCommitterIdent().getName();
                            RevTree prevTree = this.helper.getTreeForCommit(repo, prevCommitId.getName());
                            RevTree nextTree = this.helper.getTreeForCommit(repo, nextCommitId.getName());
                            ObjectReader reader = repo.newObjectReader();
                            Throwable throwable = null;
                            try {
                                CanonicalTreeParser prevCommitTreeParser = new CanonicalTreeParser();
                                CanonicalTreeParser nextCommitTreeParser = new CanonicalTreeParser();
                                prevCommitTreeParser.reset(reader, (AnyObjectId)prevTree.getId());
                                nextCommitTreeParser.reset(reader, (AnyObjectId)nextTree.getId());
                                List diffEntries = git.diff().setOldTree((AbstractTreeIterator)prevCommitTreeParser).setNewTree((AbstractTreeIterator)nextCommitTreeParser).call();
                                operations.addAll(this.processDiffEntry(diffEntries, nextCommitId, author, Instant.ofEpochSecond(commit.getCommitTime()).atZone(ZoneOffset.UTC)));
                                prevCommitId = nextCommitId;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (reader == null) continue;
                                if (throwable != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                reader.close();
                            }
                        }
                    }
                    catch (GitAPIException e) {
                        logger.error("Error getting operations for site " + site + " from commit ID: " + commitIdFrom + " to commit ID: " + commitIdTo, (Exception)((Object)e), new Object[0]);
                    }
                }
                catch (IOException e) {
                    logger.error("Error getting operations for site " + site + " from commit ID: " + commitIdFrom + " to commit ID: " + commitIdTo, (Exception)e, new Object[0]);
                }
            }
        }
        return operations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRepoLastCommitId(String site) {
        String toReturn = "";
        Repository repository = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
        synchronized (repository) {
            Repository repo = this.helper.getRepository(site, GitRepositories.SANDBOX);
            try {
                ObjectId commitId = repo.resolve("HEAD");
                toReturn = commitId.getName();
            }
            catch (IOException e) {
                logger.error("Error getting last commit ID for site " + site, (Exception)e, new Object[0]);
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRepoFirstCommitId(String site) {
        String toReturn = "";
        Repository repository = this.helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
        synchronized (repository) {
            Repository repo = this.helper.getRepository(site, GitRepositories.SANDBOX);
            try (RevWalk rw = new RevWalk(repo);){
                ObjectId head = repo.resolve("HEAD");
                RevCommit root = rw.parseCommit((AnyObjectId)head);
                rw.sort(RevSort.REVERSE);
                rw.markStart(root);
                RevCommit first = rw.next();
                toReturn = first.getName();
                logger.debug("getRepoFirstCommitId for site: " + site + " First commit ID: " + toReturn, new Object[0]);
            }
            catch (IOException e) {
                logger.error("Error getting first commit ID for site " + site, (Exception)e, new Object[0]);
            }
        }
        return toReturn;
    }

    private List<RepoOperationTO> processDiffEntry(List<DiffEntry> diffEntries, ObjectId commitId, String author, ZonedDateTime commitTime) {
        ArrayList<RepoOperationTO> toReturn = new ArrayList<RepoOperationTO>();
        for (DiffEntry diffEntry : diffEntries) {
            String pathNew = "/" + diffEntry.getNewPath();
            String pathOld = "/" + diffEntry.getOldPath();
            RepoOperationTO repoOperation = null;
            switch (7.$SwitchMap$org$eclipse$jgit$diff$DiffEntry$ChangeType[diffEntry.getChangeType().ordinal()]) {
                case 1: {
                    repoOperation = new RepoOperationTO(RepoOperation.CREATE, pathNew, commitTime, null, commitId.getName());
                    break;
                }
                case 2: {
                    repoOperation = new RepoOperationTO(RepoOperation.UPDATE, pathNew, commitTime, null, commitId.getName());
                    break;
                }
                case 3: {
                    repoOperation = new RepoOperationTO(RepoOperation.DELETE, pathOld, commitTime, null, commitId.getName());
                    break;
                }
                case 4: {
                    repoOperation = new RepoOperationTO(RepoOperation.MOVE, pathOld, commitTime, pathNew, commitId.getName());
                    break;
                }
                case 5: {
                    repoOperation = new RepoOperationTO(RepoOperation.COPY, pathNew, commitTime, null, commitId.getName());
                    break;
                }
                default: {
                    logger.error("Error: Unknown git operation " + diffEntry.getChangeType(), new Object[0]);
                }
            }
            if (repoOperation == null || repoOperation.getPath().endsWith(".keep")) continue;
            repoOperation.setAuthor(StringUtils.isEmpty((CharSequence)author) ? "N/A" : author);
            toReturn.add(repoOperation);
        }
        return toReturn;
    }

    public List<DeploymentSyncHistory> getDeploymentHistory(String site, String sandboxBranch, ZonedDateTime fromDate, ZonedDateTime toDate, DmFilterWrapper dmFilterWrapper, String filterType, int numberOfItems) {
        ArrayList<DeploymentSyncHistory> toRet = new ArrayList<DeploymentSyncHistory>();
        Repository publishedRepo = this.helper.getRepository(site, GitRepositories.PUBLISHED);
        int counter = 0;
        String sandboxBranchName = sandboxBranch;
        if (StringUtils.isEmpty((CharSequence)sandboxBranchName)) {
            sandboxBranchName = this.studioConfiguration.getProperty("studio.repo.siteSandboxBranch");
        }
        try (Git git = new Git(publishedRepo);){
            List environments = git.branchList().call();
            for (int i = 0; i < environments.size() && counter < numberOfItems; ++i) {
                Ref env = (Ref)environments.get(i);
                String environment = env.getName();
                if (environment.equals(sandboxBranchName) || environment.equals("refs/heads/" + sandboxBranchName)) continue;
                ArrayList<RevFilter> filters = new ArrayList<RevFilter>();
                filters.add(CommitTimeRevFilter.after((long)fromDate.toInstant().toEpochMilli()));
                filters.add(CommitTimeRevFilter.before((long)toDate.toInstant().toEpochMilli()));
                filters.add(NotRevFilter.create((RevFilter)MessageRevFilter.create((String)"Initial commit.")));
                Iterable branchLog = git.log().add((AnyObjectId)env.getObjectId()).setRevFilter(AndRevFilter.create(filters)).call();
                Iterator iterator = branchLog.iterator();
                while (iterator.hasNext() && counter < numberOfItems) {
                    RevCommit revCommit = (RevCommit)iterator.next();
                    List files = this.helper.getFilesInCommit(publishedRepo, revCommit);
                    for (int j = 0; j < files.size() && counter < numberOfItems; ++j) {
                        String file = (String)files.get(j);
                        Path path = Paths.get(file, new String[0]);
                        String fileName = path.getFileName().toString();
                        if (ArrayUtils.contains((Object[])GitContentRepositoryConstants.IGNORE_FILES, (Object)fileName) || !dmFilterWrapper.accept(site, file, filterType)) continue;
                        DeploymentSyncHistory dsh = new DeploymentSyncHistory();
                        dsh.setSite(site);
                        dsh.setPath(file);
                        dsh.setSyncDate(Instant.ofEpochSecond(revCommit.getCommitTime()).atZone(ZoneOffset.UTC));
                        dsh.setUser(revCommit.getAuthorIdent().getName());
                        dsh.setEnvironment(environment.replace("refs/heads/", ""));
                        toRet.add(dsh);
                        ++counter;
                    }
                }
            }
            git.close();
            toRet.sort((o1, o2) -> o2.getSyncDate().compareTo(o1.getSyncDate()));
        }
        catch (IOException | GitAPIException e1) {
            logger.error("Error while getting deployment history for site " + site, (Exception)e1, new Object[0]);
        }
        return toRet;
    }

    public ZonedDateTime getLastDeploymentDate(String site, String path) {
        ZonedDateTime toRet = null;
        Repository publishedRepo = this.helper.getRepository(site, GitRepositories.PUBLISHED);
        try (Git git = new Git(publishedRepo);){
            Iterable log = git.log().all().addPath(this.helper.getGitPath(path)).setMaxCount(1).call();
            Iterator iter = log.iterator();
            if (iter.hasNext()) {
                RevCommit commit = (RevCommit)iter.next();
                toRet = Instant.ofEpochMilli(1000L * (long)commit.getCommitTime()).atZone(ZoneOffset.UTC);
            }
            git.close();
        }
        catch (IOException | GitAPIException e) {
            logger.error("Error while getting last deployment date for site " + site + ", path " + path, (Exception)e, new Object[0]);
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getEditCommitIds(String site, String path, String commitIdFrom, String commitIdTo) {
        ArrayList<String> commitIds = new ArrayList<String>();
        Repository repository = this.helper.getRepository(site, GitRepositories.SANDBOX);
        synchronized (repository) {
            try {
                Repository repo = this.helper.getRepository(site, GitRepositories.SANDBOX);
                if (StringUtils.isEmpty((CharSequence)commitIdFrom)) {
                    commitIdFrom = this.getRepoFirstCommitId(site);
                }
                if (StringUtils.isEmpty((CharSequence)commitIdTo)) {
                    commitIdTo = this.getRepoLastCommitId(site);
                }
                ObjectId objCommitIdFrom = repo.resolve(commitIdFrom);
                ObjectId objCommitIdTo = repo.resolve(commitIdTo);
                try (Git git = new Git(repo);){
                    if (!objCommitIdFrom.equals((AnyObjectId)objCommitIdTo)) {
                        Iterable commits = git.log().addPath(this.helper.getGitPath(path)).addRange((AnyObjectId)objCommitIdFrom, (AnyObjectId)objCommitIdTo).call();
                        for (RevCommit commit : commits) {
                            commitIds.add(0, commit.getId().getName());
                        }
                    }
                }
                catch (GitAPIException e) {
                    logger.error("Error getting commit ids for site " + site + " and path " + path + " from commit ID: " + commitIdFrom + " to commit ID: " + commitIdTo, (Exception)((Object)e), new Object[0]);
                }
            }
            catch (IOException e) {
                logger.error("Error getting operations for site " + site + " and path " + path + " from commit ID: " + commitIdFrom + " to commit ID: " + commitIdTo, (Exception)e, new Object[0]);
            }
        }
        return commitIds;
    }

    public boolean commitIdExists(String site, String commitId) {
        boolean toRet = false;
        try (Repository repo = this.helper.getRepository(site, GitRepositories.SANDBOX);){
            RevCommit revCommit;
            ObjectId objCommitId = repo.resolve(commitId);
            if (objCommitId != null && (revCommit = repo.parseCommit((AnyObjectId)objCommitId)) != null) {
                toRet = true;
            }
        }
        catch (IOException e) {
            logger.info("Commit ID " + commitId + " does not exist in sandbox for site " + site, new Object[0]);
        }
        return toRet;
    }

    public GitLog getGitLog(String siteId, String commitId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", siteId);
        params.put("commitId", commitId);
        return this.gitLogMapper.getGitLog(params);
    }

    public void insertGitLog(String siteId, String commitId, int processed) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("siteId", siteId);
        params.put("commitId", commitId);
        params.put("processed", processed);
        try {
            this.gitLogMapper.insertGitLog(params);
        }
        catch (DuplicateKeyException e) {
            logger.debug("Failed to insert commit id: " + commitId + " for site: " + siteId + " into gitlog table, because it is duplicate entry. Marking it as not processed so it can be processed by sync database task.", new Object[0]);
            params = new HashMap();
            params.put("siteId", siteId);
            params.put("commitId", commitId);
            params.put("processed", 0);
            this.gitLogMapper.markGitLogProcessed(params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertFullGitLog(String siteId, int processed) {
        ArrayList<GitLog> gitLogs = new ArrayList<GitLog>();
        Repository repository = this.helper.getRepository(siteId, GitRepositories.SANDBOX);
        synchronized (repository) {
            Repository repo = this.helper.getRepository(siteId, GitRepositories.SANDBOX);
            try (Git git = new Git(repo);){
                Iterable logs = git.log().call();
                for (RevCommit rev : logs) {
                    GitLog gitLog = new GitLog();
                    gitLog.setCommitId(rev.getId().getName());
                    gitLog.setProcessed(processed);
                    gitLog.setSiteId(siteId);
                    gitLogs.add(gitLog);
                }
            }
            catch (GitAPIException e) {
                logger.error("Error getting full git log for site " + siteId, (Exception)((Object)e), new Object[0]);
            }
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("siteId", siteId);
        params.put("gitLogs", gitLogs);
        params.put("processed", 1);
        this.gitLogMapper.insertGitLogList(params);
    }

    public void markGitLogVerifiedProcessed(String siteId, String commitId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("siteId", siteId);
        params.put("commitId", commitId);
        params.put("processed", 1);
        this.gitLogMapper.markGitLogProcessed(params);
    }

    public void deleteGitLogForSite(String siteId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", siteId);
        this.gitLogMapper.deleteGitLogForSite(params);
    }

    public boolean createSiteCloneRemote(String siteId, String sandboxBranch, String remoteName, String remoteUrl, String remoteBranch, boolean singleBranch, String authenticationType, String remoteUsername, String remotePassword, String remoteToken, String remotePrivateKey) throws InvalidRemoteRepositoryException, InvalidRemoteRepositoryCredentialsException, RemoteRepositoryNotFoundException, InvalidRemoteUrlException, ServiceException {
        logger.debug("Creating site " + siteId + " as a clone of remote repository " + remoteName + " (" + remoteUrl + ").", new Object[0]);
        boolean toReturn = this.helper.createSiteCloneRemoteGitRepo(siteId, sandboxBranch, remoteName, remoteUrl, remoteBranch, singleBranch, authenticationType, remoteUsername, remotePassword, remoteToken, remotePrivateKey);
        if (toReturn) {
            try {
                this.insertRemoteToDb(siteId, remoteName, remoteUrl, authenticationType, remoteUsername, remotePassword, remoteToken, remotePrivateKey);
            }
            catch (CryptoException e) {
                throw new ServiceException((Throwable)e);
            }
            logger.debug("Update site name configuration variables for site " + siteId, new Object[0]);
            toReturn = this.helper.updateSitenameConfigVar(siteId);
            if (toReturn) {
                logger.debug("Perform initial commit for site " + siteId, new Object[0]);
                toReturn = this.helper.performInitialCommit(siteId, "Initial commit.", sandboxBranch);
            }
        } else {
            logger.error("Error while creating site " + siteId + " by cloning remote repository " + remoteName + " (" + remoteUrl + ").", new Object[0]);
        }
        return toReturn;
    }

    public boolean createSitePushToRemote(String siteId, String remoteName, String remoteUrl, String authenticationType, String remoteUsername, String remotePassword, String remoteToken, String remotePrivateKey) throws InvalidRemoteRepositoryException, InvalidRemoteRepositoryCredentialsException, RemoteRepositoryNotFoundException, RemoteRepositoryNotBareException, ServiceException {
        boolean toRet = true;
        try (Repository repo = this.helper.getRepository(siteId, GitRepositories.SANDBOX);){
            try (Git git = new Git(repo);){
                RemoteRefUpdate update;
                PushResult pushResult;
                Iterator remoteRefUpdateIterator;
                boolean pkauth = false;
                Path tempKey = Files.createTempFile(UUID.randomUUID().toString(), ".tmp", new FileAttribute[0]);
                PushCommand pushCommand = git.push();
                switch (authenticationType) {
                    case "none": {
                        logger.debug("No authentication", new Object[0]);
                        break;
                    }
                    case "basic": {
                        logger.debug("Basic authentication", new Object[0]);
                        pushCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(remoteUsername, remotePassword));
                        break;
                    }
                    case "token": {
                        logger.debug("Token based authentication", new Object[0]);
                        pushCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(remoteToken, ""));
                        break;
                    }
                    case "key": {
                        logger.debug("Private key authentication", new Object[0]);
                        tempKey.toFile().deleteOnExit();
                        pushCommand.setTransportConfigCallback((TransportConfigCallback)new /* Unavailable Anonymous Inner Class!! */);
                        pkauth = true;
                        break;
                    }
                    default: {
                        throw new ServiceException("Unsupported authentication type " + authenticationType);
                    }
                }
                logger.debug("Push site " + siteId + " to remote repository " + remoteName + "(" + remoteUrl + ")", new Object[0]);
                Iterable result = pushCommand.setPushAll().setRemote(remoteName).call();
                if (pkauth) {
                    Files.delete(tempKey);
                }
                logger.debug("Check push result to verify it was success", new Object[0]);
                Iterator resultIter = result.iterator();
                if (resultIter.hasNext() && (remoteRefUpdateIterator = (pushResult = (PushResult)resultIter.next()).getRemoteUpdates().iterator()).hasNext() && (update = (RemoteRefUpdate)remoteRefUpdateIterator.next()).getStatus().equals((Object)RemoteRefUpdate.Status.REJECTED_NONFASTFORWARD)) {
                    logger.error("Remote repository: " + remoteName + " (" + remoteUrl + ") is not bare repository", new Object[0]);
                    throw new RemoteRepositoryNotBareException("Remote repository: " + remoteName + " (" + remoteUrl + ") is not bare repository");
                }
            }
            catch (InvalidRemoteException e) {
                logger.error("Invalid remote repository: " + remoteName + " (" + remoteUrl + ")", (Exception)((Object)e), new Object[0]);
                throw new InvalidRemoteRepositoryException("Invalid remote repository: " + remoteName + " (" + remoteUrl + ")");
            }
            catch (TransportException e) {
                if (StringUtils.endsWithIgnoreCase((CharSequence)e.getMessage(), (CharSequence)"not authorized")) {
                    logger.error("Bad credentials or read only repository: " + remoteName + " (" + remoteUrl + ")", (Exception)((Object)e), new Object[0]);
                    throw new InvalidRemoteRepositoryCredentialsException("Bad credentials or read only repository: " + remoteName + " (" + remoteUrl + ") for username " + remoteUsername, (Throwable)e);
                }
                logger.error("Remote repository not found: " + remoteName + " (" + remoteUrl + ")", (Exception)((Object)e), new Object[0]);
                throw new RemoteRepositoryNotFoundException("Remote repository not found: " + remoteName + " (" + remoteUrl + ")");
            }
            catch (IOException | ServiceException e) {
                logger.error("Failed to push newly created site " + siteId + " to remote repository " + remoteUrl, (Exception)e, new Object[0]);
                throw new ServiceException(e);
            }
        }
        catch (GitAPIException e) {
            logger.error("Failed to push newly created site " + siteId + " to remote repository " + remoteUrl, (Exception)((Object)e), new Object[0]);
            toRet = false;
        }
        return toRet;
    }

    public boolean addRemote(String siteId, String remoteName, String remoteUrl, String authenticationType, String remoteUsername, String remotePassword, String remoteToken, String remotePrivateKey) throws InvalidRemoteUrlException, ServiceException {
        try {
            logger.debug("Add remote " + remoteName + " to the sandbox repo for the site " + siteId, new Object[0]);
            Repository repo = this.helper.getRepository(siteId, GitRepositories.SANDBOX);
            try (Git git = new Git(repo);){
                StoredConfig storedConfig = repo.getConfig();
                Set remotes = storedConfig.getSubsections("remote");
                if (remotes.contains(remoteName)) {
                    throw new RemoteAlreadyExistsException(remoteName);
                }
                RemoteAddCommand remoteAddCommand = git.remoteAdd();
                remoteAddCommand.setName(remoteName);
                remoteAddCommand.setUri(new URIish(remoteUrl));
                remoteAddCommand.call();
            }
            catch (URISyntaxException e) {
                logger.error("Remote URL is invalid " + remoteUrl, (Exception)e, new Object[0]);
                throw new InvalidRemoteUrlException();
            }
            catch (GitAPIException e) {
                logger.error("Error while adding remote " + remoteName + " (url: " + remoteUrl + ") for site " + siteId, (Exception)((Object)e), new Object[0]);
                throw new ServiceException("Error while adding remote " + remoteName + " (url: " + remoteUrl + ") for site " + siteId, (Exception)((Object)e));
            }
            this.insertRemoteToDb(siteId, remoteName, remoteUrl, authenticationType, remoteUsername, remotePassword, remoteToken, remotePrivateKey);
        }
        catch (CryptoException e) {
            throw new ServiceException((Throwable)e);
        }
        return true;
    }

    private void insertRemoteToDb(String siteId, String remoteName, String remoteUrl, String authenticationType, String remoteUsername, String remotePassword, String remoteToken, String remotePrivateKey) throws CryptoException {
        logger.debug("Inserting remote " + remoteName + " for site " + siteId + " into database.", new Object[0]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", siteId);
        params.put("remoteName", remoteName);
        params.put("remoteUrl", remoteUrl);
        params.put("authenticationType", authenticationType);
        params.put("remoteUsername", remoteUsername);
        if (StringUtils.isNotEmpty((CharSequence)remotePassword)) {
            logger.debug("Encrypt password before inserting to database", new Object[0]);
            String hashedPassword = this.encryptor.encrypt(remotePassword);
            params.put("remotePassword", hashedPassword);
        } else {
            params.put("remotePassword", remotePassword);
        }
        if (StringUtils.isNotEmpty((CharSequence)remoteToken)) {
            logger.debug("Encrypt token before inserting to database", new Object[0]);
            String hashedToken = this.encryptor.encrypt(remoteToken);
            params.put("remoteToken", hashedToken);
        } else {
            params.put("remoteToken", remoteToken);
        }
        if (StringUtils.isNotEmpty((CharSequence)remotePrivateKey)) {
            logger.debug("Encrypt private key before inserting to database", new Object[0]);
            String hashedPrivateKey = this.encryptor.encrypt(remotePrivateKey);
            params.put("remotePrivateKey", hashedPrivateKey);
        } else {
            params.put("remotePrivateKey", remotePrivateKey);
        }
        logger.debug("Insert site remote record into database", new Object[0]);
        this.remoteRepositoryMapper.insertRemoteRepository(params);
    }

    public boolean removeRemote(String siteId, String remoteName) {
        logger.debug("Remove remote " + remoteName + " from the sandbox repo for the site " + siteId, new Object[0]);
        Repository repo = this.helper.getRepository(siteId, GitRepositories.SANDBOX);
        try (Git git = new Git(repo);){
            RemoteRemoveCommand remoteRemoveCommand = git.remoteRemove();
            remoteRemoveCommand.setName(remoteName);
            remoteRemoveCommand.call();
        }
        catch (GitAPIException e) {
            logger.error("Failed to remove remote " + remoteName + " for site " + siteId, (Exception)((Object)e), new Object[0]);
            return false;
        }
        logger.debug("Remove remote record from database for remote " + remoteName + " and site " + siteId, new Object[0]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", siteId);
        params.put("remoteName", remoteName);
        this.remoteRepositoryMapper.deleteRemoteRepository(params);
        return true;
    }

    public void removeRemoteRepositoriesForSite(String siteId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", siteId);
        this.remoteRepositoryMapper.deleteRemoteRepositoriesForSite(params);
    }

    public List<RemoteRepositoryInfoTO> listRemote(String siteId, String sandboxBranch) throws ServiceException {
        ArrayList<RemoteRepositoryInfoTO> res = new ArrayList<RemoteRepositoryInfoTO>();
        try (Repository repo = this.helper.getRepository(siteId, GitRepositories.SANDBOX);){
            try (Git git = new Git(repo);){
                List resultRemotes = git.remoteList().call();
                if (CollectionUtils.isNotEmpty((Collection)resultRemotes)) {
                    block32: for (RemoteConfig conf : resultRemotes) {
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("siteId", siteId);
                        params.put("remoteName", conf.getName());
                        RemoteRepository remoteRepository = this.remoteRepositoryMapper.getRemoteRepository((Map)params);
                        switch (remoteRepository.getAuthenticationType()) {
                            case "none": {
                                logger.debug("No authentication", new Object[0]);
                                git.fetch().setRemote(conf.getName()).call();
                                continue block32;
                            }
                            case "basic": {
                                logger.debug("Basic authentication", new Object[0]);
                                String hashedPassword = remoteRepository.getRemotePassword();
                                String password = this.encryptor.decrypt(hashedPassword);
                                ((FetchCommand)git.fetch().setRemote(conf.getName()).setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(remoteRepository.getRemoteUsername(), password))).call();
                                continue block32;
                            }
                            case "token": {
                                logger.debug("Token based authentication", new Object[0]);
                                String hashedToken = remoteRepository.getRemoteToken();
                                String remoteToken = this.encryptor.decrypt(hashedToken);
                                ((FetchCommand)git.fetch().setRemote(conf.getName()).setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(remoteToken, ""))).call();
                                continue block32;
                            }
                            case "key": {
                                logger.debug("Private key authentication", new Object[0]);
                                Path tempKey = Files.createTempFile(UUID.randomUUID().toString(), ".tmp", new FileAttribute[0]);
                                String hashedPrivateKey = remoteRepository.getRemotePrivateKey();
                                String privateKey = this.encryptor.decrypt(hashedPrivateKey);
                                tempKey.toFile().deleteOnExit();
                                ((FetchCommand)git.fetch().setRemote(conf.getName()).setTransportConfigCallback((TransportConfigCallback)new /* Unavailable Anonymous Inner Class!! */)).call();
                                Files.delete(tempKey);
                                continue block32;
                            }
                        }
                        throw new ServiceException("Unsupported authentication type " + remoteRepository.getAuthenticationType());
                    }
                    List resultRemoteBranches = git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
                    HashMap remoteBranches = new HashMap();
                    for (Ref remoteBranchRef : resultRemoteBranches) {
                        String branchFullName = remoteBranchRef.getName().replace("refs/remotes/", "");
                        String remotePart = "";
                        String branchNamePart = "";
                        int slashIndex = branchFullName.indexOf("/");
                        if (slashIndex > 0) {
                            remotePart = branchFullName.substring(0, slashIndex);
                            branchNamePart = branchFullName.substring(slashIndex + 1);
                        }
                        if (!remoteBranches.containsKey(remotePart)) {
                            remoteBranches.put(remotePart, new ArrayList());
                        }
                        ((List)remoteBranches.get(remotePart)).add(branchNamePart);
                    }
                    String sandboxBranchName = sandboxBranch;
                    if (StringUtils.isEmpty((CharSequence)sandboxBranchName)) {
                        sandboxBranchName = this.studioConfiguration.getProperty("studio.repo.siteSandboxBranch");
                    }
                    for (RemoteConfig conf : resultRemotes) {
                        RemoteRepositoryInfoTO rri = new RemoteRepositoryInfoTO();
                        rri.setName(conf.getName());
                        ArrayList<String> branches = (ArrayList<String>)remoteBranches.get(rri.getName());
                        if (CollectionUtils.isEmpty((Collection)branches)) {
                            branches = new ArrayList<String>();
                            branches.add(sandboxBranchName);
                        }
                        rri.setBranches((List)branches);
                        StringBuilder sbUrl = new StringBuilder();
                        if (CollectionUtils.isNotEmpty((Collection)conf.getURIs())) {
                            for (int i = 0; i < conf.getURIs().size(); ++i) {
                                sbUrl.append(((URIish)conf.getURIs().get(i)).toString());
                                if (i >= conf.getURIs().size() - 1) continue;
                                sbUrl.append(":");
                            }
                        }
                        rri.setUrl(sbUrl.toString());
                        StringBuilder sbFetch = new StringBuilder();
                        if (CollectionUtils.isNotEmpty((Collection)conf.getFetchRefSpecs())) {
                            for (int i = 0; i < conf.getFetchRefSpecs().size(); ++i) {
                                sbFetch.append(((RefSpec)conf.getFetchRefSpecs().get(i)).toString());
                                if (i >= conf.getFetchRefSpecs().size() - 1) continue;
                                sbFetch.append(":");
                            }
                        }
                        rri.setFetch(sbFetch.toString());
                        StringBuilder sbPushUrl = new StringBuilder();
                        if (CollectionUtils.isNotEmpty((Collection)conf.getPushURIs())) {
                            for (int i = 0; i < conf.getPushURIs().size(); ++i) {
                                sbPushUrl.append(((URIish)conf.getPushURIs().get(i)).toString());
                                if (i >= conf.getPushURIs().size() - 1) continue;
                                sbPushUrl.append(":");
                            }
                        } else {
                            sbPushUrl.append(rri.getUrl());
                        }
                        rri.setPush_url(sbPushUrl.toString());
                        res.add(rri);
                    }
                }
            }
            catch (IOException | CryptoException | GitAPIException e) {
                logger.error("Error getting remote repositories for site " + siteId, (Exception)e, new Object[0]);
            }
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean pushToRemote(String siteId, String remoteName, String remoteBranch) throws ServiceException, InvalidRemoteUrlException {
        logger.debug("Get remote data from database for remote " + remoteName + " and site " + siteId, new Object[0]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", siteId);
        params.put("remoteName", remoteName);
        RemoteRepository remoteRepository = this.remoteRepositoryMapper.getRemoteRepository(params);
        logger.debug("Prepare push command.", new Object[0]);
        Repository repo = this.helper.getRepository(siteId, GitRepositories.SANDBOX);
        try (Git git = new Git(repo);){
            PushCommand pushCommand = git.push();
            logger.debug("Set remote " + remoteName, new Object[0]);
            pushCommand.setRemote(remoteRepository.getRemoteName());
            logger.debug("Set branch to be " + remoteBranch, new Object[0]);
            pushCommand.setRefSpecs(new RefSpec[]{new RefSpec(remoteBranch + ":" + remoteBranch)});
            switch (remoteRepository.getAuthenticationType()) {
                case "none": {
                    logger.debug("No authentication", new Object[0]);
                    pushCommand.call();
                    break;
                }
                case "basic": {
                    logger.debug("Basic authentication", new Object[0]);
                    String hashedPassword = remoteRepository.getRemotePassword();
                    String password = this.encryptor.decrypt(hashedPassword);
                    pushCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(remoteRepository.getRemoteUsername(), password));
                    pushCommand.call();
                    break;
                }
                case "token": {
                    logger.debug("Token based authentication", new Object[0]);
                    String hashedToken = remoteRepository.getRemoteToken();
                    String remoteToken = this.encryptor.decrypt(hashedToken);
                    pushCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(remoteToken, ""));
                    pushCommand.call();
                    break;
                }
                case "key": {
                    logger.debug("Private key authentication", new Object[0]);
                    Path tempKey = Files.createTempFile(UUID.randomUUID().toString(), ".tmp", new FileAttribute[0]);
                    String hashedPrivateKey = remoteRepository.getRemotePrivateKey();
                    String privateKey = this.encryptor.decrypt(hashedPrivateKey);
                    tempKey.toFile().deleteOnExit();
                    pushCommand.setTransportConfigCallback((TransportConfigCallback)new /* Unavailable Anonymous Inner Class!! */);
                    pushCommand.call();
                    Files.delete(tempKey);
                    break;
                }
                default: {
                    throw new ServiceException("Unsupported authentication type " + remoteRepository.getAuthenticationType());
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (InvalidRemoteException e) {
            logger.error("Remote is invalid " + remoteName, (Exception)((Object)e), new Object[0]);
            throw new InvalidRemoteUrlException();
        }
        catch (IOException | CryptoException | GitAPIException | JGitInternalException e) {
            logger.error("Error while pushing to remote " + remoteName + " branch " + remoteBranch + " for site " + siteId, (Exception)e, new Object[0]);
            throw new ServiceException("Error while pushing to remote " + remoteName + " branch " + remoteBranch + " for site " + siteId, (Exception)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean pullFromRemote(String siteId, String remoteName, String remoteBranch) throws ServiceException, InvalidRemoteUrlException {
        logger.debug("Get remote data from database for remote " + remoteName + " and site " + siteId, new Object[0]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", siteId);
        params.put("remoteName", remoteName);
        RemoteRepository remoteRepository = this.remoteRepositoryMapper.getRemoteRepository(params);
        logger.debug("Prepare pull command", new Object[0]);
        Repository repo = this.helper.getRepository(siteId, GitRepositories.SANDBOX);
        try (Git git = new Git(repo);){
            PullCommand pullCommand = git.pull();
            logger.debug("Set remote " + remoteName, new Object[0]);
            pullCommand.setRemote(remoteRepository.getRemoteName());
            logger.debug("Set branch to be " + remoteBranch, new Object[0]);
            pullCommand.setRemoteBranchName(remoteBranch);
            switch (remoteRepository.getAuthenticationType()) {
                case "none": {
                    logger.debug("No authentication", new Object[0]);
                    pullCommand.call();
                    break;
                }
                case "basic": {
                    logger.debug("Basic authentication", new Object[0]);
                    String hashedPassword = remoteRepository.getRemotePassword();
                    String password = this.encryptor.decrypt(hashedPassword);
                    pullCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(remoteRepository.getRemoteUsername(), password));
                    pullCommand.call();
                    break;
                }
                case "token": {
                    logger.debug("Token based authentication", new Object[0]);
                    String hashedToken = remoteRepository.getRemoteToken();
                    String token = this.encryptor.decrypt(hashedToken);
                    pullCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(token, ""));
                    pullCommand.call();
                    break;
                }
                case "key": {
                    logger.debug("Private key authentication", new Object[0]);
                    Path tempKey = Files.createTempFile(UUID.randomUUID().toString(), ".tmp", new FileAttribute[0]);
                    String hashedPrivateKey = remoteRepository.getRemotePrivateKey();
                    String privateKey = this.encryptor.decrypt(hashedPrivateKey);
                    tempKey.toFile().deleteOnExit();
                    pullCommand.setTransportConfigCallback((TransportConfigCallback)new /* Unavailable Anonymous Inner Class!! */);
                    pullCommand.call();
                    Files.delete(tempKey);
                    break;
                }
                default: {
                    throw new ServiceException("Unsupported authentication type " + remoteRepository.getAuthenticationType());
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (InvalidRemoteException e) {
            logger.error("Remote is invalid " + remoteName, (Exception)((Object)e), new Object[0]);
            throw new InvalidRemoteUrlException();
        }
        catch (GitAPIException e) {
            logger.error("Error while pulling from remote " + remoteName + " branch " + remoteBranch + " for site " + siteId, (Exception)((Object)e), new Object[0]);
            throw new ServiceException("Error while pulling from remote " + remoteName + " branch " + remoteBranch + " for site " + siteId, (Exception)((Object)e));
        }
        catch (IOException | CryptoException e) {
            throw new ServiceException(e);
        }
    }

    private SshSessionFactory getSshSessionFactory(String privateKey, Path tempKey) {
        try {
            Files.write(tempKey, privateKey.getBytes(), new OpenOption[0]);
            6 sshSessionFactory = new /* Unavailable Anonymous Inner Class!! */;
            return sshSessionFactory;
        }
        catch (IOException e) {
            logger.error("Failed to create private key for SSH connection.", (Exception)e, new Object[0]);
            return null;
        }
    }

    public boolean isFolder(String siteId, String path) {
        Path p = Paths.get(this.helper.buildRepoPath(GitRepositories.SANDBOX, siteId).toAbsolutePath().toString(), path);
        File file = p.toFile();
        return file.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStagingRepository(String siteId) throws ServiceException {
        Repository repo = this.helper.getRepository(siteId, GitRepositories.PUBLISHED);
        String stagingName = this.servicesConfig.getStagingEnvironment(siteId);
        String liveName = this.servicesConfig.getLiveEnvironment(siteId);
        Repository repository = repo;
        synchronized (repository) {
            try (Git git = new Git(repo);){
                logger.debug("Checkout live first becuase it is not allowed to delete checkedout branch", new Object[0]);
                git.checkout().setName(liveName).call();
                logger.debug("Delete staging branch in order to reset it for site: " + siteId, new Object[0]);
                git.branchDelete().setBranchNames(new String[]{stagingName}).setForce(true).call();
                logger.debug("Create new branch for staging with live HEAD as starting point", new Object[0]);
                git.branchCreate().setName(stagingName).setStartPoint(liveName).call();
            }
            catch (GitAPIException e) {
                logger.error("Error while reseting staging environment for site: " + siteId, new Object[0]);
                throw new ServiceException((Throwable)e);
            }
        }
    }

    public void reloadRepository(String siteId) {
        this.helper.sandboxes.remove(siteId);
        this.helper.getRepository(siteId, GitRepositories.SANDBOX);
    }

    public void setServletContext(ServletContext ctx) {
        this.ctx = ctx;
    }

    public SecurityProvider getSecurityProvider() {
        return this.securityProvider;
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    static /* synthetic */ SshSessionFactory access$000(GitContentRepository x0, String x1, Path x2) {
        return x0.getSshSessionFactory(x1, x2);
    }
}

