/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.repository.git;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.git.auth.BasicUsernamePasswordAuthConfigurator;
import org.craftercms.commons.git.auth.SshUsernamePasswordAuthConfigurator;
import org.craftercms.studio.api.v1.constant.GitRepositories;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryCredentialsException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.security.SecurityProvider;
import org.craftercms.studio.api.v1.util.StudioConfiguration;
import org.craftercms.studio.impl.v1.repository.git.GitContentRepositoryHelper;
import org.craftercms.studio.impl.v1.repository.git.TreeCopier;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;

public class GitContentRepositoryHelper {
    private static final Logger logger = LoggerFactory.getLogger(GitContentRepositoryHelper.class);
    protected Map<String, Repository> sandboxes = new HashMap();
    protected Map<String, Repository> published = new HashMap();
    protected Repository globalRepo = null;
    protected StudioConfiguration studioConfiguration;
    protected SecurityProvider securityProvider;
    protected ServicesConfig servicesConfig;

    GitContentRepositoryHelper(StudioConfiguration studioConfiguration, SecurityProvider securityProvider, ServicesConfig servicesConfig) {
        this.studioConfiguration = studioConfiguration;
        this.securityProvider = securityProvider;
        this.servicesConfig = servicesConfig;
    }

    public boolean buildGlobalRepo() throws IOException {
        boolean toReturn = false;
        Path siteRepoPath = this.buildRepoPath(GitRepositories.GLOBAL).resolve(".git");
        if (Files.exists(siteRepoPath, new LinkOption[0])) {
            this.globalRepo = this.openRepository(siteRepoPath);
            toReturn = true;
        }
        return toReturn;
    }

    public boolean buildSiteRepo(String site) {
        boolean toReturn = false;
        Path siteSandboxRepoPath = this.buildRepoPath(GitRepositories.SANDBOX, site).resolve(".git");
        Path sitePublishedRepoPath = this.buildRepoPath(GitRepositories.PUBLISHED, site).resolve(".git");
        try {
            if (Files.exists(siteSandboxRepoPath, new LinkOption[0])) {
                Repository sandboxRepo = this.openRepository(siteSandboxRepoPath);
                this.sandboxes.put(site, sandboxRepo);
                toReturn = true;
            }
        }
        catch (IOException e) {
            logger.error("Failed to create sandbox repo for site: " + site + " using path " + siteSandboxRepoPath.toString(), (Exception)e, new Object[0]);
        }
        try {
            if (toReturn && Files.exists(sitePublishedRepoPath, new LinkOption[0])) {
                Repository publishedRepo = this.openRepository(sitePublishedRepoPath);
                this.published.put(site, publishedRepo);
                toReturn = true;
            }
        }
        catch (IOException e) {
            logger.error("Failed to create published repo for site: " + site + " using path " + sitePublishedRepoPath.toString(), (Exception)e, new Object[0]);
        }
        return toReturn;
    }

    public Repository openRepository(Path repositoryPath) throws IOException {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(repositoryPath.toFile())).readEnvironment()).findGitDir()).build();
        return repository;
    }

    public String getGitPath(String path) {
        Path gitPath = Paths.get(path, new String[0]);
        gitPath = gitPath.normalize();
        try {
            gitPath = Paths.get("/", new String[0]).relativize(gitPath);
        }
        catch (IllegalArgumentException e) {
            logger.debug("Path: " + path + " is already relative path.", new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)gitPath.toString())) {
            return ".";
        }
        String toRet = gitPath.toString();
        toRet = FilenameUtils.separatorsToUnix((String)toRet);
        return toRet;
    }

    public Repository createGitRepository(Path path) {
        Repository toReturn;
        path = Paths.get(path.toAbsolutePath().toString(), ".git");
        try {
            toReturn = FileRepositoryBuilder.create((File)path.toFile());
            toReturn.create();
            toReturn = this.optimizeRepository(toReturn);
            try (Git git = new Git(toReturn);){
                git.commit().setAllowEmpty(true).setMessage("Create new repository.").call();
            }
            catch (GitAPIException e) {
                logger.error("Error while creating repository for site with path" + path.toString(), (Exception)((Object)e), new Object[0]);
                toReturn = null;
            }
        }
        catch (IOException e) {
            logger.error("Error while creating repository for site with path" + path.toString(), (Exception)e, new Object[0]);
            toReturn = null;
        }
        return toReturn;
    }

    private Repository optimizeRepository(Repository repo) throws IOException {
        StoredConfig config = repo.getConfig();
        config.setInt("core", null, "compression", 0);
        config.setString("core", null, "bigFileThreshold", "20m");
        config.setBoolean("core", null, "fileMode", false);
        config.save();
        return repo;
    }

    public Path buildRepoPath(GitRepositories repoType) {
        return this.buildRepoPath(repoType, "");
    }

    public Path buildRepoPath(GitRepositories repoType, String site) {
        Path path;
        switch (3.$SwitchMap$org$craftercms$studio$api$v1$constant$GitRepositories[repoType.ordinal()]) {
            case 1: {
                path = Paths.get(this.studioConfiguration.getProperty("studio.repo.basePath"), this.studioConfiguration.getProperty("studio.repo.sitesRepoBasePath"), site, this.studioConfiguration.getProperty("studio.repo.siteSandboxPath"));
                break;
            }
            case 2: {
                path = Paths.get(this.studioConfiguration.getProperty("studio.repo.basePath"), this.studioConfiguration.getProperty("studio.repo.sitesRepoBasePath"), site, this.studioConfiguration.getProperty("studio.repo.sitePublishedPath"));
                break;
            }
            case 3: {
                path = Paths.get(this.studioConfiguration.getProperty("studio.repo.basePath"), this.studioConfiguration.getProperty("studio.repo.globalRepoPath"));
                break;
            }
            default: {
                path = null;
            }
        }
        return path;
    }

    public boolean createSiteGitRepo(String site, String sandboxBranch) {
        boolean toReturn;
        Repository sandboxRepo = null;
        Path siteSandboxPath = this.buildRepoPath(GitRepositories.SANDBOX, site);
        sandboxRepo = this.createGitRepository(siteSandboxPath);
        boolean bl = toReturn = sandboxRepo != null;
        if (toReturn) {
            this.checkoutSandboxBranch(site, sandboxRepo, sandboxBranch);
            this.sandboxes.put(site, sandboxRepo);
        }
        return toReturn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkoutSandboxBranch(String site, Repository sandboxRepo, String sandboxBranch) {
        String sandboxBranchName = sandboxBranch;
        if (StringUtils.isEmpty((CharSequence)sandboxBranchName)) {
            sandboxBranchName = this.studioConfiguration.getProperty("studio.repo.siteSandboxBranch");
        }
        try (Git git = new Git(sandboxRepo);){
            if (!StringUtils.equals((CharSequence)sandboxRepo.getBranch(), (CharSequence)sandboxBranchName)) {
                List branchList = git.branchList().call();
                boolean createBranch = true;
                for (Ref branch : branchList) {
                    if (!StringUtils.equals((CharSequence)branch.getName(), (CharSequence)sandboxBranchName) && !StringUtils.equals((CharSequence)branch.getName(), (CharSequence)("refs/heads/" + sandboxBranchName))) continue;
                    createBranch = false;
                    break;
                }
                if (sandboxRepo.isBare() || sandboxRepo.resolve("HEAD") == null) {
                    git.commit().setAllowEmpty(true).setMessage("Create " + sandboxBranchName + " branch.").call();
                }
                git.checkout().setCreateBranch(createBranch).setName(sandboxBranchName).setForce(false).call();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException | GitAPIException e) {
            logger.error("Error checking out sandbox branch " + sandboxBranchName + " for site " + site, (Exception)e, new Object[0]);
            return false;
        }
    }

    public boolean createGlobalRepo() {
        boolean toReturn = false;
        Path globalConfigRepoPath = this.buildRepoPath(GitRepositories.GLOBAL).resolve(".git");
        if (!Files.exists(globalConfigRepoPath, new LinkOption[0])) {
            Path globalConfigPath = globalConfigRepoPath.getParent();
            try {
                Files.deleteIfExists(globalConfigPath);
                logger.info("Bootstrapping repository...", new Object[0]);
                Files.createDirectories(globalConfigPath, new FileAttribute[0]);
                this.globalRepo = this.createGitRepository(globalConfigPath);
                toReturn = true;
            }
            catch (IOException e) {
                logger.error("Bootstrapping repository failed", (Exception)e, new Object[0]);
            }
        } else {
            logger.info("Detected existing global repository, will not create new one.", new Object[0]);
            toReturn = false;
        }
        return toReturn;
    }

    public boolean copyContentFromBlueprint(String blueprint, String site) {
        boolean toReturn = true;
        Path siteRepoPath = this.buildRepoPath(GitRepositories.SANDBOX, site);
        Path blueprintPath = this.buildRepoPath(GitRepositories.GLOBAL).resolve(Paths.get(this.studioConfiguration.getProperty("studio.repo.blueprintsPath"), blueprint));
        EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        TreeCopier tc = new TreeCopier(blueprintPath, siteRepoPath);
        try {
            Files.walkFileTree(blueprintPath, opts, Integer.MAX_VALUE, (FileVisitor<? super Path>)tc);
        }
        catch (IOException err) {
            logger.error("Error copping files from blueprint", (Exception)err, new Object[0]);
            toReturn = false;
        }
        return toReturn;
    }

    public boolean deleteSiteGitRepo(String site) {
        boolean toReturn;
        Path siteSandboxPath = this.buildRepoPath(GitRepositories.SANDBOX, site);
        Path sitePath = siteSandboxPath.getParent();
        File siteFolder = sitePath.toFile();
        try {
            Repository sboxRepo = (Repository)this.sandboxes.get(site);
            sboxRepo.close();
            this.sandboxes.remove(site);
            RepositoryCache.close((Repository)sboxRepo);
            sboxRepo = null;
            Repository pubRepo = (Repository)this.published.get(site);
            pubRepo.close();
            this.published.remove(site);
            RepositoryCache.close((Repository)pubRepo);
            pubRepo = null;
            FileUtils.deleteDirectory((File)siteFolder);
            toReturn = true;
            logger.debug("Deleted site: " + site + " at path: " + sitePath, new Object[0]);
        }
        catch (IOException e) {
            logger.error("Failed to delete site: " + site + " at path: " + sitePath + " exception " + e.toString(), new Object[0]);
            toReturn = false;
        }
        return toReturn;
    }

    public boolean updateSitenameConfigVar(String site) {
        boolean toReturn = true;
        String siteConfigFolder = "/config/studio";
        if (!this.replaceSitenameVariable(site, Paths.get(this.buildRepoPath(GitRepositories.SANDBOX, site).toAbsolutePath().toString(), this.studioConfiguration.getProperty("studio.configuration.site.configBasePath"), this.studioConfiguration.getProperty("studio.configuration.site.generalConfigFileName")))) {
            toReturn = false;
        } else if (!this.replaceSitenameVariable(site, Paths.get(this.buildRepoPath(GitRepositories.SANDBOX, site).toAbsolutePath().toString(), this.studioConfiguration.getProperty("studio.configuration.site.configBasePath"), this.studioConfiguration.getProperty("studio.configuration.site.permissionMappingsFileName")))) {
            toReturn = false;
        } else if (!this.replaceSitenameVariable(site, Paths.get(this.buildRepoPath(GitRepositories.SANDBOX, site).toAbsolutePath().toString(), this.studioConfiguration.getProperty("studio.configuration.site.configBasePath"), this.studioConfiguration.getProperty("studio.configuration.site.roleMappingsFileName")))) {
            toReturn = false;
        }
        return toReturn;
    }

    protected boolean replaceSitenameVariable(String site, Path path) {
        boolean toReturn = false;
        Charset charset = StandardCharsets.UTF_8;
        String content = null;
        try {
            content = new String(Files.readAllBytes(path), charset);
            content = content.replaceAll("\\{siteName\\}", site);
            Files.write(path, content.getBytes(charset), new OpenOption[0]);
            toReturn = true;
        }
        catch (IOException e) {
            logger.error("Error replacing sitename variable inside configuration file " + path.toString() + " for site " + site, new Object[0]);
            toReturn = false;
        }
        return toReturn;
    }

    public boolean bulkImport(String site) {
        return false;
    }

    public boolean performInitialCommit(String site, String message, String sandboxBranch) {
        boolean toReturn = true;
        Repository repo = this.getRepository(site, GitRepositories.SANDBOX, sandboxBranch);
        try (Git git = new Git(repo);){
            Status status = git.status().call();
            if (status.hasUncommittedChanges() || !status.isClean()) {
                DirCache dirCache = git.add().addFilepattern(".").call();
                RevCommit revCommit = git.commit().setMessage(message).call();
            }
            this.checkoutSandboxBranch(site, repo, sandboxBranch);
            Path siteSandboxPath = this.buildRepoPath(GitRepositories.SANDBOX, site);
            Path sitePublishedPath = this.buildRepoPath(GitRepositories.PUBLISHED, site);
            try (Git publishedGit = Git.cloneRepository().setURI(sitePublishedPath.relativize(siteSandboxPath).toString()).setDirectory(sitePublishedPath.normalize().toAbsolutePath().toFile()).call();){
                Repository publishedRepo = publishedGit.getRepository();
                publishedRepo = this.optimizeRepository(publishedRepo);
                this.checkoutSandboxBranch(site, publishedRepo, sandboxBranch);
                publishedRepo.close();
                publishedGit.close();
            }
            catch (IOException | GitAPIException e) {
                logger.error("Error adding origin (sandbox) to published repository", (Exception)e, new Object[0]);
            }
            git.close();
        }
        catch (GitAPIException err) {
            logger.error("error creating initial commit for site:  " + site, (Exception)((Object)err), new Object[0]);
            toReturn = false;
        }
        return toReturn;
    }

    public Repository getRepository(String site, GitRepositories gitRepository) {
        Repository repo;
        logger.debug("getRepository invoked with site" + site + "Repository Type: " + gitRepository.toString(), new Object[0]);
        switch (3.$SwitchMap$org$craftercms$studio$api$v1$constant$GitRepositories[gitRepository.ordinal()]) {
            case 1: {
                repo = (Repository)this.sandboxes.get(site);
                if (repo != null) break;
                if (this.buildSiteRepo(site)) {
                    repo = (Repository)this.sandboxes.get(site);
                    break;
                }
                logger.error("error getting the sandbox repository for site: " + site, new Object[0]);
                break;
            }
            case 2: {
                repo = (Repository)this.published.get(site);
                if (repo != null) break;
                if (this.buildSiteRepo(site)) {
                    repo = (Repository)this.published.get(site);
                    break;
                }
                logger.error("error getting the published repository for site: " + site, new Object[0]);
                break;
            }
            case 3: {
                if (this.globalRepo == null) {
                    Path globalConfigRepoPath = this.buildRepoPath(GitRepositories.GLOBAL).resolve(".git");
                    try {
                        this.globalRepo = this.openRepository(globalConfigRepoPath);
                    }
                    catch (IOException e) {
                        logger.error("error getting the global repository.", (Exception)e, new Object[0]);
                    }
                }
                repo = this.globalRepo;
                break;
            }
            default: {
                repo = null;
            }
        }
        if (repo != null) {
            logger.debug("success in getting the repository for site: " + site, new Object[0]);
        } else {
            logger.debug("failure in getting the repository for site: " + site, new Object[0]);
        }
        return repo;
    }

    public Repository getRepository(String site, GitRepositories gitRepository, String sandboxBranch) {
        Repository repo;
        logger.debug("getRepository invoked with site" + site + "Repository Type: " + gitRepository.toString(), new Object[0]);
        switch (3.$SwitchMap$org$craftercms$studio$api$v1$constant$GitRepositories[gitRepository.ordinal()]) {
            case 1: {
                repo = (Repository)this.sandboxes.get(site);
                if (repo != null) break;
                if (this.buildSiteRepo(site)) {
                    repo = (Repository)this.sandboxes.get(site);
                    this.checkoutSandboxBranch(site, repo, sandboxBranch);
                    break;
                }
                logger.error("error getting the sandbox repository for site: " + site, new Object[0]);
                break;
            }
            case 2: {
                repo = (Repository)this.published.get(site);
                if (repo != null) break;
                if (this.buildSiteRepo(site)) {
                    repo = (Repository)this.published.get(site);
                    break;
                }
                logger.error("error getting the published repository for site: " + site, new Object[0]);
                break;
            }
            case 3: {
                if (this.globalRepo == null) {
                    Path globalConfigRepoPath = this.buildRepoPath(GitRepositories.GLOBAL).resolve(".git");
                    try {
                        this.globalRepo = this.openRepository(globalConfigRepoPath);
                    }
                    catch (IOException e) {
                        logger.error("error getting the global repository.", (Exception)e, new Object[0]);
                    }
                }
                repo = this.globalRepo;
                break;
            }
            default: {
                repo = null;
            }
        }
        if (repo != null) {
            logger.debug("success in getting the repository for site: " + site, new Object[0]);
        } else {
            logger.debug("failure in getting the repository for site: " + site, new Object[0]);
        }
        return repo;
    }

    public RevTree getTreeForLastCommit(Repository repository) throws AmbiguousObjectException, IncorrectObjectTypeException, IOException, MissingObjectException {
        ObjectId lastCommitId = repository.resolve("HEAD");
        try (RevWalk revWalk = new RevWalk(repository);){
            RevTree tree;
            RevCommit commit = revWalk.parseCommit((AnyObjectId)lastCommitId);
            RevTree revTree = tree = commit.getTree();
            return revTree;
        }
    }

    public RevTree getTreeForCommit(Repository repository, String commitId) throws IOException {
        ObjectId commitObjectId = repository.resolve(commitId);
        try (RevWalk revWalk = new RevWalk(repository);){
            RevTree tree;
            RevCommit commit = revWalk.parseCommit((AnyObjectId)commitObjectId);
            RevTree revTree = tree = commit.getTree();
            return revTree;
        }
    }

    public boolean writeFile(Repository repo, String site, String path, InputStream content) {
        boolean result;
        block34: {
            result = true;
            try {
                File file = new File(repo.getDirectory().getParent(), path);
                File folder = file.getParentFile();
                if (folder != null && !folder.exists()) {
                    folder.mkdirs();
                }
                if (!file.exists()) {
                    try {
                        if (!file.createNewFile()) {
                            logger.error("error creating file: site: " + site + " path: " + path, new Object[0]);
                            result = false;
                        }
                    }
                    catch (IOException e) {
                        logger.error("error creating file: site: " + site + " path: " + path, (Exception)e, new Object[0]);
                        result = false;
                    }
                }
                if (!result) break block34;
                try (FileChannel outChannel = new FileOutputStream(file.getPath()).getChannel();){
                    long count;
                    logger.debug("created the file output channel", new Object[0]);
                    ReadableByteChannel inChannel = Channels.newChannel(content);
                    logger.debug("created the file input channel", new Object[0]);
                    long amount = 0x100000L;
                    long offset = 0L;
                    while ((count = outChannel.transferFrom(inChannel, offset, amount)) > 0L) {
                        logger.debug("writing the bits: offset = " + offset + " count: " + count, new Object[0]);
                        offset += count;
                    }
                }
                try {
                    var9_12 = null;
                    try (Git git = new Git(repo);){
                        git.add().addFilepattern(this.getGitPath(path)).call();
                        git.close();
                        result = true;
                    }
                    catch (Throwable throwable) {
                        var9_12 = throwable;
                        throw throwable;
                    }
                }
                catch (GitAPIException e) {
                    logger.error("error adding file to git: site: " + site + " path: " + path, (Exception)((Object)e), new Object[0]);
                    result = false;
                }
            }
            catch (IOException e) {
                logger.error("error writing file: site: " + site + " path: " + path, (Exception)e, new Object[0]);
                result = false;
            }
        }
        return result;
    }

    public String commitFile(Repository repo, String site, String path, String comment, PersonIdent user) {
        String commitId = null;
        String gitPath = this.getGitPath(path);
        try (Git git = new Git(repo);){
            Status status = git.status().addPath(gitPath).call();
            if (status.hasUncommittedChanges() || !status.isClean()) {
                RevCommit commit = git.commit().setOnly(gitPath).setAuthor(user).setCommitter(user).setMessage(comment).call();
                commitId = commit.getName();
            }
            git.close();
        }
        catch (GitAPIException e) {
            logger.error("error adding and committing file to git: site: " + site + " path: " + path, (Exception)((Object)e), new Object[0]);
        }
        return commitId;
    }

    public PersonIdent getCurrentUserIdent() {
        String userName = this.securityProvider.getCurrentUser();
        return this.getAuthorIdent(userName);
    }

    public PersonIdent getAuthorIdent(String author) {
        Map currentUserProfile = this.securityProvider.getUserProfile(author);
        PersonIdent currentUserIdent = new PersonIdent(currentUserProfile.get("first_name").toString() + " " + currentUserProfile.get("last_name").toString(), currentUserProfile.get("email").toString());
        return currentUserIdent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFilesInCommit(Repository repository, RevCommit commit) {
        ArrayList<String> files;
        block33: {
            files = new ArrayList<String>();
            RevWalk rw = new RevWalk(repository);
            try (Git git = new Git(repository);){
                if (commit.getParentCount() <= 0) break block33;
                RevCommit parent = rw.parseCommit((AnyObjectId)commit.getParent(0).getId());
                ObjectId commitId = commit.getId();
                ObjectId parentCommitId = parent.getId();
                RevTree parentTree = this.getTreeForCommit(repository, parentCommitId.getName());
                RevTree commitTree = this.getTreeForCommit(repository, commitId.getName());
                try (ObjectReader reader = repository.newObjectReader();){
                    CanonicalTreeParser prevCommitTreeParser = new CanonicalTreeParser();
                    CanonicalTreeParser nextCommitTreeParser = new CanonicalTreeParser();
                    prevCommitTreeParser.reset(reader, (AnyObjectId)parentTree.getId());
                    nextCommitTreeParser.reset(reader, (AnyObjectId)commitTree.getId());
                    List diffEntries = git.diff().setOldTree((AbstractTreeIterator)prevCommitTreeParser).setNewTree((AbstractTreeIterator)nextCommitTreeParser).call();
                    for (DiffEntry diffEntry : diffEntries) {
                        if (diffEntry.getChangeType() == DiffEntry.ChangeType.DELETE) {
                            files.add("/" + diffEntry.getOldPath());
                            continue;
                        }
                        files.add("/" + diffEntry.getNewPath());
                    }
                }
                catch (IOException | GitAPIException e) {
                    logger.error("Error while getting list of files in commit " + commit.getId().getName(), new Object[0]);
                }
            }
            catch (IOException e) {
                logger.error("Error while getting list of files in commit " + commit.getId().getName(), new Object[0]);
            }
            finally {
                rw.dispose();
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createSiteCloneRemoteGitRepo(String siteId, String sandboxBranch, String remoteName, String remoteUrl, String remoteBranch, boolean singleBranch, String authenticationType, String remoteUsername, String remotePassword, String remoteToken, String remotePrivateKey) throws InvalidRemoteRepositoryException, InvalidRemoteRepositoryCredentialsException, RemoteRepositoryNotFoundException, ServiceException {
        boolean toRet = true;
        Path siteSandboxPath = this.buildRepoPath(GitRepositories.SANDBOX, siteId);
        File localPath = siteSandboxPath.toFile();
        localPath.delete();
        logger.debug("Add user credentials if provided", new Object[0]);
        logger.debug("Cloning from " + remoteUrl + " to " + localPath, new Object[0]);
        CloneCommand cloneCommand = Git.cloneRepository();
        try (Git cloneResult = null;){
            Path tempKey = Files.createTempFile(UUID.randomUUID().toString(), ".tmp", new FileAttribute[0]);
            switch (authenticationType) {
                case "none": {
                    logger.debug("No authentication", new Object[0]);
                    break;
                }
                case "basic": {
                    logger.debug("Basic authentication", new Object[0]);
                    cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(remoteUsername, remotePassword));
                    break;
                }
                case "token": {
                    logger.debug("Token based authentication", new Object[0]);
                    cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(remoteToken, ""));
                    break;
                }
                case "key": {
                    logger.debug("Private key authentication", new Object[0]);
                    tempKey.toFile().deleteOnExit();
                    cloneCommand.setTransportConfigCallback((TransportConfigCallback)new /* Unavailable Anonymous Inner Class!! */);
                    break;
                }
                default: {
                    throw new ServiceException("Unsupported authentication type " + authenticationType);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)remoteBranch)) {
                cloneCommand.setBranch(remoteBranch);
            }
            cloneResult = cloneCommand.setURI(remoteUrl).setDirectory(localPath).setRemote(remoteName).setCloneAllBranches(!singleBranch).call();
            Files.deleteIfExists(tempKey);
            Repository sandboxRepo = this.checkIfCloneWasOk(cloneResult, remoteName, remoteUrl);
            sandboxRepo = this.optimizeRepository(sandboxRepo);
            this.sandboxes.put(siteId, sandboxRepo);
        }
        return toRet;
    }

    private SshSessionFactory getSshSessionFactory(String remotePrivateKey, Path tempKey) {
        try {
            Files.write(tempKey, remotePrivateKey.getBytes(), new OpenOption[0]);
            2 sshSessionFactory = new /* Unavailable Anonymous Inner Class!! */;
            return sshSessionFactory;
        }
        catch (IOException e) {
            logger.error("Failed to create private key for SSH connection.", (Exception)e, new Object[0]);
            return null;
        }
    }

    private Repository checkIfCloneWasOk(Git cloneResult, String remoteName, String remoteUrl) throws InvalidRemoteRepositoryException {
        if (cloneResult == null) {
            String msg = "Remote Clone Error:: " + remoteName + " (" + remoteUrl + ")  cloneResult object null";
            logger.error(msg, new Object[0]);
            throw new InvalidRemoteRepositoryException(msg);
        }
        Repository repository = cloneResult.getRepository();
        if (repository == null) {
            String msg = "Remote Clone Error:: " + remoteName + " (" + remoteUrl + ")  sandboxRepo object null";
            logger.error(msg, new Object[0]);
            throw new InvalidRemoteRepositoryException(msg);
        }
        File repoDir = repository.getDirectory();
        if (!(repoDir.exists() && repoDir.isDirectory() && repoDir.canRead() && repoDir.canWrite())) {
            String msg = "Remote Clone Error::  " + repository.getDirectory() + " doesn't exist, is not a dir or user don't have RW permissions";
            logger.error(msg, new Object[0]);
            throw new InvalidRemoteRepositoryException(msg);
        }
        return repository;
    }

    private void configureTransportAuthenticaion(CloneCommand cloneCommand, String remotePassword, String remoteUsername, String remoteUrl) {
        if (!StringUtils.isEmpty((CharSequence)remoteUsername)) {
            if (StringUtils.isEmpty((CharSequence)remotePassword)) {
                logger.debug("Password field is empty while cloning from remote repository: " + remoteUrl, new Object[0]);
            }
            if (remoteUrl.toLowerCase().contains("ssh://")) {
                new SshUsernamePasswordAuthConfigurator(remotePassword).configureAuthentication((TransportCommand)cloneCommand);
            } else {
                new BasicUsernamePasswordAuthConfigurator(remoteUsername, remotePassword).configureAuthentication((TransportCommand)cloneCommand);
            }
        }
    }

    static /* synthetic */ SshSessionFactory access$000(GitContentRepositoryHelper x0, String x1, Path x2) {
        return x0.getSshSessionFactory(x1, x2);
    }
}

