/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.repository.git;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;

public class TreeCopier
implements FileVisitor<Path> {
    private static final Logger logger = LoggerFactory.getLogger(TreeCopier.class);
    private final Path source;
    private final Path target;

    TreeCopier(Path source, Path target) {
        this.source = source;
        this.target = target;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        CopyOption[] options = new CopyOption[]{};
        Path newdir = this.target.resolve(this.source.relativize(dir));
        try {
            Files.copy(dir, newdir, options);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            logger.error("Dir: " + dir.toString() + " NewDir: " + newdir.toString(), new Object[0]);
            logger.error("!!!!!!!!!!!!!!!!############# Exception is: ", (Exception)e, new Object[0]);
            logger.error("Unable to create: %s: %s%n", new Object[]{newdir, e});
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        CopyOption[] options = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        try {
            Files.copy(file, this.target.resolve(this.source.relativize(file)), options);
        }
        catch (IOException err) {
            logger.error("Unable to copy: " + this.source + " to " + this.target.resolve(this.source.relativize(file)), (Exception)err, new Object[0]);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        if (exc instanceof FileSystemLoopException) {
            logger.error("cycle detected: " + file, new Object[0]);
        } else {
            logger.error("Unable to copy: %s: %s%n", new Object[]{file, exc});
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }
}

