/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.repository.job;

import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.craftercms.studio.api.v1.dal.PublishRequestMapper;
import org.craftercms.studio.api.v1.job.CronJobContext;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v1.service.dependency.DependencyService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.util.StudioConfiguration;
import org.craftercms.studio.impl.v1.repository.job.RebuildRepositoryMetadata;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;

public class RebuildRepositoryMetadata {
    private static final Logger logger = LoggerFactory.getLogger(RebuildRepositoryMetadata.class);
    private static ReentrantLock taskLock = new ReentrantLock();
    @Autowired
    protected PublishRequestMapper publishRequestMapper;
    protected ObjectMetadataManager objectMetadataManager;
    protected ObjectStateService objectStateService;
    protected DependencyService dependencyService;
    protected ContentService contentService;
    protected SecurityService securityService;
    protected TaskExecutor taskExecutor;
    protected StudioConfiguration studioConfiguration;
    protected SiteService siteService;
    protected ContentRepository contentRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String site) {
        if (taskLock.tryLock()) {
            try {
                logger.debug("Starting Rebuild Repository Metadata Task.", new Object[0]);
                String ticket = this.securityService.getCurrentToken();
                CronJobContext securityContext = new CronJobContext(ticket, this.securityService.getCurrentUser());
                RebuildRepositoryMetadataTask task = new RebuildRepositoryMetadataTask(this, securityContext, site);
                this.taskExecutor.execute((Runnable)task);
            }
            finally {
                taskLock.unlock();
            }
        }
    }

    protected boolean cleanOldMetadata(String site) {
        logger.debug("Clean repository metadata for site " + site, new Object[0]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        try {
            logger.debug("Deleting dependencies for site " + site, new Object[0]);
            this.dependencyService.deleteSiteDependencies(site);
        }
        catch (Exception error) {
            logger.error("Failed to delete dependencies for site " + site, new Object[0]);
        }
        try {
            logger.debug("Deleting deployment queue for site " + site, new Object[0]);
            this.publishRequestMapper.deleteDeploymentDataForSite(params);
        }
        catch (Exception error) {
            logger.error("Failed to delete deployment queue for site " + site, new Object[0]);
        }
        try {
            logger.debug("Deleting content metadata for site " + site, new Object[0]);
            this.objectMetadataManager.deleteObjectMetadataForSite(site);
        }
        catch (Exception error) {
            logger.error("Failed to delete content metadata for site " + site, new Object[0]);
        }
        try {
            logger.debug("Deleting workflow states data for site " + site, new Object[0]);
            this.objectStateService.deleteObjectStatesForSite(site);
        }
        catch (Exception error) {
            logger.error("Failed to delete workflow states data for site " + site, new Object[0]);
        }
        try {
            logger.debug("Deleting git log data for site " + site, new Object[0]);
            this.contentRepository.deleteGitLogForSite(site);
        }
        catch (Exception error) {
            logger.error("Failed to delete git log data for site " + site, new Object[0]);
        }
        return true;
    }

    protected boolean rebuildMetadata(String site) {
        this.siteService.syncDatabaseWithRepo(site, null);
        return true;
    }

    public int getBatchSize() {
        int toReturn = Integer.parseInt(this.studioConfiguration.getProperty("studio.repo.rebuildMetadata.batchSize"));
        return toReturn;
    }

    public ObjectMetadataManager getObjectMetadataManager() {
        return this.objectMetadataManager;
    }

    public void setObjectMetadataManager(ObjectMetadataManager objectMetadataManager) {
        this.objectMetadataManager = objectMetadataManager;
    }

    public ObjectStateService getObjectStateService() {
        return this.objectStateService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }

    public DependencyService getDependencyService() {
        return this.dependencyService;
    }

    public void setDependencyService(DependencyService dependencyService) {
        this.dependencyService = dependencyService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

