/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.repository.job;

import java.util.concurrent.locks.ReentrantLock;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.impl.v1.repository.job.SyncDatabaseWithRepository;
import org.springframework.core.task.TaskExecutor;

public class SyncDatabaseWithRepository {
    private static final Logger logger = LoggerFactory.getLogger(SyncDatabaseWithRepository.class);
    private static ReentrantLock taskLock = new ReentrantLock();
    protected SecurityService securityService;
    protected TaskExecutor taskExecutor;
    protected SiteService siteService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String site, String lastDbCommitId) {
        if (taskLock.tryLock()) {
            try {
                logger.debug("Starting Sync Database With Repository Task.", new Object[0]);
                SyncDatabaseWithRepositoryTask task = new SyncDatabaseWithRepositoryTask(this, site, lastDbCommitId);
                this.taskExecutor.execute((Runnable)task);
            }
            finally {
                taskLock.unlock();
            }
        }
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

