/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.service.AbstractRegistrableService;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralLockServiceImpl
extends AbstractRegistrableService
implements GeneralLockService {
    private static final Logger logger = LoggerFactory.getLogger(GeneralLockServiceImpl.class);
    protected Map<String, ReentrantLock> nodeLocks = new HashMap();

    public void register() {
        this.getServicesManager().registerService(GeneralLockService.class, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ValidateParams
    public void lock(@ValidateStringParam(name="objectId") String objectId) {
        ReentrantLock nodeLock;
        if (logger.isDebugEnabled()) {
            logger.debug("[" + Thread.currentThread().getName() + "] Obtaining lock for id " + objectId);
        }
        GeneralLockServiceImpl generalLockServiceImpl = this;
        synchronized (generalLockServiceImpl) {
            if (this.nodeLocks.containsKey(objectId)) {
                nodeLock = (ReentrantLock)this.nodeLocks.get(objectId);
            } else {
                nodeLock = new ReentrantLock();
                this.nodeLocks.put(objectId, nodeLock);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[" + Thread.currentThread().getName() + "] Lock hold count " + nodeLock.getHoldCount() + " for id " + objectId + " (before lock)");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[" + Thread.currentThread().getName() + "] Lock: " + nodeLock.toString());
        }
        nodeLock.lock();
        if (logger.isDebugEnabled()) {
            logger.debug("[" + Thread.currentThread().getName() + "] Lock hold count " + nodeLock.getHoldCount() + " for id " + objectId + " (after lock)");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[" + Thread.currentThread().getName() + "] Locked all threads for id " + objectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ValidateParams
    public boolean tryLock(@ValidateStringParam(name="objectId") String objectId) {
        ReentrantLock nodeLock;
        if (logger.isDebugEnabled()) {
            logger.debug("[" + Thread.currentThread().getName() + "] Trying to get lock for id " + objectId);
        }
        GeneralLockServiceImpl generalLockServiceImpl = this;
        synchronized (generalLockServiceImpl) {
            if (this.nodeLocks.containsKey(objectId)) {
                nodeLock = (ReentrantLock)this.nodeLocks.get(objectId);
            } else {
                nodeLock = new ReentrantLock();
                this.nodeLocks.put(objectId, nodeLock);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[" + Thread.currentThread().getName() + "] Lock hold count " + nodeLock.getHoldCount() + " for id " + objectId + " (before tryLock)");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[" + Thread.currentThread().getName() + "] Lock: " + nodeLock.toString());
        }
        boolean toRet = nodeLock.tryLock();
        if (logger.isDebugEnabled()) {
            logger.debug("[" + Thread.currentThread().getName() + "] Lock hold count " + nodeLock.getHoldCount() + " for id " + objectId + " (after tryLock)");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[" + Thread.currentThread().getName() + "] Result for tryLock on id " + objectId + " : " + toRet);
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ValidateParams
    public void unlock(@ValidateStringParam(name="objectId") String objectId) {
        ReentrantLock nodeLock = null;
        if (logger.isDebugEnabled()) {
            logger.debug("[" + Thread.currentThread().getName() + "] Unlocking id " + objectId);
        }
        GeneralLockServiceImpl generalLockServiceImpl = this;
        synchronized (generalLockServiceImpl) {
            nodeLock = (ReentrantLock)this.nodeLocks.get(objectId);
        }
        if (nodeLock != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("[" + Thread.currentThread().getName() + "] Lock hold count " + nodeLock.getHoldCount() + " for id " + objectId + " (before unlock)");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("[" + Thread.currentThread().getName() + "] Lock: " + nodeLock.toString());
            }
            nodeLock.unlock();
            if (logger.isDebugEnabled()) {
                logger.debug("[" + Thread.currentThread().getName() + "] Lock hold count " + nodeLock.getHoldCount() + " for id " + objectId + " (after unlock)");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[" + Thread.currentThread().getName() + "] Finished unlocking id " + objectId);
        }
    }
}

