/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.activity;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.validation.annotations.param.ValidateIntegerParam;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateSecurePathParam;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.dal.AuditFeed;
import org.craftercms.studio.api.v1.dal.AuditFeedMapper;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.AbstractRegistrableService;
import org.craftercms.studio.api.v1.service.activity.ActivityService;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.deployment.DeploymentService;
import org.craftercms.studio.api.v1.service.objectstate.State;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.util.DebugUtils;
import org.craftercms.studio.api.v1.util.StudioConfiguration;
import org.springframework.beans.factory.annotation.Autowired;

public class ActivityServiceImpl
extends AbstractRegistrableService
implements ActivityService {
    private static final Logger logger = LoggerFactory.getLogger(ActivityServiceImpl.class);
    protected static final int MAX_LEN_USER_ID = 255;
    protected static final int MAX_LEN_SITE_ID = 255;
    protected static final int MAX_LEN_ACTIVITY_TYPE = 255;
    protected static final int MAX_LEN_ACTIVITY_DATA = 4000;
    protected static final int MAX_LEN_APP_TOOL_ID = 36;
    protected static final String ACTIVITY_PROP_ACTIVITY_SUMMARY = "activitySummary";
    protected static final String ACTIVITY_PROP_ID = "id";
    protected static final String ACTIVITY_PROP_POST_DATE = "postDate";
    protected static final String ACTIVITY_PROP_USER = "user";
    protected static final String ACTIVITY_PROP_FEEDUSER = "feedUserId";
    protected static final String ACTIVITY_PROP_CONTENTID = "contentId";
    protected static final String ACTIVITY_FEED_FORMAT = "json";
    @Autowired
    protected AuditFeedMapper auditFeedMapper;
    protected SiteService siteService;
    protected ContentService contentService;
    protected SecurityService securityService;
    protected StudioConfiguration studioConfiguration;
    protected DeploymentService deploymentService;

    public void register() {
        this.getServicesManager().registerService(ActivityService.class, (Object)this);
    }

    @ValidateParams
    public void postActivity(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="user") String user, @ValidateStringParam(name="contentId") String contentId, ActivityService.ActivityType activity, ActivityService.ActivitySource source, Map<String, String> extraInfo) {
        JSONObject activityPost = new JSONObject();
        activityPost.put((Object)ACTIVITY_PROP_USER, (Object)user);
        activityPost.put((Object)ACTIVITY_PROP_ID, (Object)contentId);
        if (extraInfo != null) {
            activityPost.putAll(extraInfo);
        }
        String contentType = null;
        if (extraInfo != null) {
            contentType = extraInfo.get("contentType");
        }
        this.postActivity(activity.toString(), source.toString(), site, null, activityPost.toString(), contentId, contentType, user);
    }

    private void postActivity(String activityType, String activitySource, String siteNetwork, String appTool, String activityData, String contentId, String contentType, String approver) {
        String currentUser = StringUtils.isEmpty((CharSequence)approver) ? this.securityService.getCurrentUser() : approver;
        try {
            if (siteNetwork == null) {
                siteNetwork = "";
            } else if (siteNetwork.length() > 255) {
                throw new ServiceException("Invalid site network - exceeds 255 chars: " + siteNetwork);
            }
            if (appTool == null) {
                appTool = "";
            } else if (appTool.length() > 36) {
                throw new ServiceException("Invalid app tool - exceeds 36 chars: " + appTool);
            }
            if (StringUtils.isEmpty((CharSequence)activityType)) {
                throw new ServiceException("Invalid activity type - activity type is empty");
            }
            if (activityType.length() > 255) {
                throw new ServiceException("Invalid activity type - exceeds 255 chars: " + activityType);
            }
            if (activityData == null) {
                activityData = "";
            } else if (activityType.length() > 4000) {
                throw new ServiceException("Invalid activity data - exceeds 4000 chars: " + activityData);
            }
            if (StringUtils.isEmpty((CharSequence)currentUser)) {
                throw new ServiceException("Invalid user - user is empty");
            }
            if (currentUser.length() > 255) {
                throw new ServiceException("Invalid user - exceeds 255 chars: " + currentUser);
            }
            currentUser = currentUser.toLowerCase();
            if (contentType == null) {
                contentType = "page";
            }
        }
        catch (ServiceException e) {
            logger.error("Error in getting feeds", (Exception)((Object)e), new Object[0]);
        }
        try {
            ZonedDateTime postDate = ZonedDateTime.now(ZoneOffset.UTC);
            AuditFeed activityPost = new AuditFeed();
            activityPost.setUserId(currentUser);
            activityPost.setSiteNetwork(siteNetwork);
            activityPost.setSummary(activityData);
            activityPost.setType(activityType);
            activityPost.setCreationDate(postDate);
            activityPost.setModifiedDate(postDate);
            activityPost.setSummaryFormat(ACTIVITY_FEED_FORMAT);
            activityPost.setContentId(contentId);
            activityPost.setContentType(contentType);
            activityPost.setSource(activitySource);
            try {
                activityPost.setCreationDate(ZonedDateTime.now(ZoneOffset.UTC));
                long postId = this.insertFeedEntry(activityPost);
                activityPost.setId(postId);
                logger.debug("Posted: " + activityPost, new Object[0]);
            }
            catch (Exception e) {
                throw new ServiceException("Failed to post activity: " + e, e);
            }
        }
        catch (ServiceException e) {
            logger.error("Error in posting feed", (Exception)((Object)e), new Object[0]);
        }
    }

    private long insertFeedEntry(AuditFeed activityFeed) {
        DebugUtils.addDebugStack((Logger)logger);
        logger.debug("Insert activity " + activityFeed.getContentId(), new Object[0]);
        Long id = this.auditFeedMapper.insertActivityFeed(activityFeed);
        return id != null ? id : -1L;
    }

    @ValidateParams
    public void renameContentId(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="oldUrl") String oldUrl, @ValidateSecurePathParam(name="newUrl") String newUrl) {
        DebugUtils.addDebugStack((Logger)logger);
        logger.debug("Rename " + oldUrl + " to " + newUrl, new Object[0]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("newPath", newUrl);
        params.put("site", site);
        params.put("oldPath", oldUrl);
        this.auditFeedMapper.renameContent(params);
    }

    @ValidateParams
    public List<ContentItemTO> getActivities(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="user") String user, @ValidateIntegerParam(name="num") int num, @ValidateStringParam(name="sort") String sort, boolean ascending, boolean excludeLive, @ValidateStringParam(name="filterType") String filterType) throws ServiceException {
        int startPos = 0;
        ArrayList<ContentItemTO> contentItems = new ArrayList<ContentItemTO>();
        boolean hasMoreItems = true;
        while (contentItems.size() < num && hasMoreItems) {
            int remainingItems = num - contentItems.size();
            hasMoreItems = this.getActivityFeeds(user, site, startPos, num, filterType, excludeLive, contentItems, remainingItems);
            startPos += num;
        }
        if (contentItems.size() > num) {
            return contentItems.subList(0, num);
        }
        return contentItems;
    }

    protected boolean getActivityFeeds(String user, String site, int startPos, int size, String filterType, boolean hideLiveItems, List<ContentItemTO> contentItems, int remainingItem) {
        ArrayList<String> activityFeedEntries = new ArrayList<String>();
        if (!this.getUserNamesAreCaseSensitive()) {
            user = user.toLowerCase();
        }
        List activityFeeds = null;
        activityFeeds = this.selectUserFeedEntries(user, ACTIVITY_FEED_FORMAT, site, startPos, size, filterType, hideLiveItems);
        for (AuditFeed activityFeed : activityFeeds) {
            activityFeedEntries.add(activityFeed.getJSONString());
        }
        boolean hasMoreItems = true;
        if (activityFeedEntries.size() < size) {
            hasMoreItems = false;
        }
        if (activityFeedEntries != null && activityFeedEntries.size() > 0) {
            for (int index = 0; index < activityFeedEntries.size() && remainingItem != 0; --remainingItem, ++index) {
                ZonedDateTime pubDate;
                JSONObject feedObject = JSONObject.fromObject(activityFeedEntries.get(index));
                String id = feedObject.containsKey((Object)ACTIVITY_PROP_CONTENTID) ? feedObject.getString(ACTIVITY_PROP_CONTENTID) : "";
                ContentItemTO item = this.createActivityItem(site, feedObject, id);
                item.published = true;
                item.setPublished(true);
                item.publishedDate = pubDate = this.deploymentService.getLastDeploymentDate(site, id);
                item.setPublishedDate(pubDate);
                contentItems.add(item);
            }
        }
        logger.debug("Total Item post live filter : " + contentItems.size() + " hasMoreItems : " + hasMoreItems, new Object[0]);
        return hasMoreItems;
    }

    protected ContentItemTO createActivityItem(String site, JSONObject feedObject, String id) {
        try {
            ContentItemTO item = this.contentService.getContentItem(site, id, 0);
            if (item == null || item.isDeleted()) {
                String activitySummary;
                JSONObject summaryObject;
                String modifier;
                item = this.contentService.createDummyDmContentItemForDeletedNode(site, id);
                String string = modifier = feedObject.containsKey((Object)ACTIVITY_PROP_FEEDUSER) ? feedObject.getString(ACTIVITY_PROP_FEEDUSER) : "";
                if (modifier != null && !modifier.isEmpty()) {
                    item.user = modifier;
                }
                if ((summaryObject = JSONObject.fromObject((Object)(activitySummary = feedObject.containsKey((Object)ACTIVITY_PROP_ACTIVITY_SUMMARY) ? feedObject.getString(ACTIVITY_PROP_ACTIVITY_SUMMARY) : ""))).containsKey((Object)"contentType")) {
                    String contentType;
                    item.contentType = contentType = (String)summaryObject.get("contentType");
                }
                if (summaryObject.containsKey((Object)"internalName")) {
                    String internalName;
                    item.internalName = internalName = (String)summaryObject.get("internalName");
                }
                if (summaryObject.containsKey((Object)"browserUri")) {
                    String browserUri;
                    item.browserUri = browserUri = (String)summaryObject.get("browserUri");
                }
                item.setLockOwner("");
            }
            String postDate = feedObject.containsKey((Object)ACTIVITY_PROP_POST_DATE) ? feedObject.getString(ACTIVITY_PROP_POST_DATE) : "";
            ZonedDateTime editedDate = ZonedDateTime.parse(postDate);
            item.eventDate = editedDate != null ? editedDate.withZoneSameInstant(ZoneOffset.UTC) : editedDate;
            return item;
        }
        catch (Exception e) {
            logger.error("Error fetching content item for [" + id + "]", new Object[]{e.getMessage()});
            return null;
        }
    }

    private List<AuditFeed> selectUserFeedEntries(String feedUserId, String format, String siteId, int startPos, int feedSize, String contentType, boolean hideLiveItems) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", feedUserId);
        params.put("summaryFormat", format);
        params.put("siteNetwork", siteId);
        params.put("startPos", startPos);
        params.put("feedSize", feedSize);
        params.put("activities", Arrays.asList(ActivityService.ActivityType.CREATED, ActivityService.ActivityType.DELETED, ActivityService.ActivityType.UPDATED, ActivityService.ActivityType.MOVED));
        if (StringUtils.isNotEmpty((CharSequence)contentType) && !contentType.toLowerCase().equals("all")) {
            params.put("contentType", contentType.toLowerCase());
        }
        if (hideLiveItems) {
            ArrayList<String> statesValues = new ArrayList<String>();
            for (State state : State.LIVE_STATES) {
                statesValues.add(state.name());
            }
            params.put("states", statesValues);
            return this.auditFeedMapper.selectUserFeedEntriesHideLive(params);
        }
        return this.auditFeedMapper.selectUserFeedEntries(params);
    }

    @ValidateParams
    public AuditFeed getDeletedActivity(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(ACTIVITY_PROP_CONTENTID, path);
        params.put("siteNetwork", site);
        String activityType = ActivityService.ActivityType.DELETED.toString();
        params.put("activityType", activityType);
        return this.auditFeedMapper.getDeletedActivity(params);
    }

    @ValidateParams
    public void deleteActivitiesForSite(@ValidateStringParam(name="site") String site) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        this.auditFeedMapper.deleteActivitiesForSite(params);
    }

    @ValidateParams
    public List<AuditFeed> getAuditLogForSite(@ValidateStringParam(name="site") String site, @ValidateIntegerParam(name="start") int start, @ValidateIntegerParam(name="number") int number, @ValidateStringParam(name="user") String user, List<String> actions) throws SiteNotFoundException {
        if (!this.siteService.exists(site)) {
            throw new SiteNotFoundException();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("start", start);
        params.put("number", number);
        if (StringUtils.isNotEmpty((CharSequence)user)) {
            params.put(ACTIVITY_PROP_USER, user);
        }
        if (CollectionUtils.isNotEmpty(actions)) {
            params.put("actions", actions);
        }
        return this.auditFeedMapper.getAuditLogForSite(params);
    }

    @ValidateParams
    public long getAuditLogForSiteTotal(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="user") String user, List<String> actions) throws SiteNotFoundException {
        if (!this.siteService.exists(site)) {
            throw new SiteNotFoundException();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        if (StringUtils.isNotEmpty((CharSequence)user)) {
            params.put(ACTIVITY_PROP_USER, user);
        }
        if (CollectionUtils.isNotEmpty(actions)) {
            params.put("actions", actions);
        }
        return this.auditFeedMapper.getAuditLogForSiteTotal(params);
    }

    public boolean getUserNamesAreCaseSensitive() {
        boolean toReturn = Boolean.parseBoolean(this.studioConfiguration.getProperty("studio.activity.user.name.caseSensitive"));
        return toReturn;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public DeploymentService getDeploymentService() {
        return this.deploymentService;
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }
}

