/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.asset.processing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.craftercms.studio.api.v1.asset.Asset;
import org.craftercms.studio.api.v1.asset.processing.AssetProcessingConfigReader;
import org.craftercms.studio.api.v1.asset.processing.AssetProcessorPipelineResolver;
import org.craftercms.studio.api.v1.exception.AssetProcessingException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.asset.processing.AssetProcessingService;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.springframework.beans.factory.annotation.Required;

public class AssetProcessingServiceImpl
implements AssetProcessingService {
    private static final Logger logger = LoggerFactory.getLogger(AssetProcessingServiceImpl.class);
    private String configPath;
    private ContentService contentService;
    private AssetProcessingConfigReader configReader;
    private AssetProcessorPipelineResolver pipelineResolver;

    @Required
    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    @Required
    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    @Required
    public void setConfigReader(AssetProcessingConfigReader configReader) {
        this.configReader = configReader;
    }

    @Required
    public void setPipelineResolver(AssetProcessorPipelineResolver pipelineResolver) {
        this.pipelineResolver = pipelineResolver;
    }

    /*
     * Exception decompiling
     */
    public Map<String, Object> processAsset(String site, String folder, String assetName, InputStream in, String isImage, String allowedWidth, String allowedHeight, String allowLessSize, String draft, String unlock, String systemAsset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Asset createAssetFromInputStream(String repoPath, InputStream in) throws AssetProcessingException {
        try {
            Path tmpFile = Files.createTempFile(FilenameUtils.getBaseName((String)repoPath), "." + FilenameUtils.getExtension((String)repoPath), new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(tmpFile, new OpenOption[0]);){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            return new Asset(repoPath, tmpFile);
        }
        catch (IOException e) {
            throw new AssetProcessingException("Unable to create temp file to hold input stream of " + repoPath, (Exception)e);
        }
    }

    private List<Map<String, Object>> writeOutputs(String site, Collection<Asset> outputs, String isImage, String allowedWidth, String allowedHeight, String allowLessSize, String draft, String unlock, String systemAsset) throws AssetProcessingException {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        for (Asset output : outputs) {
            try {
                InputStream in = Files.newInputStream(output.getFilePath(), new OpenOption[0]);
                Throwable throwable = null;
                try {
                    Map result = this.contentService.writeContentAsset(site, FilenameUtils.getFullPath((String)output.getRepoPath()), FilenameUtils.getName((String)output.getRepoPath()), in, isImage, allowedWidth, allowedHeight, allowLessSize, draft, unlock, systemAsset);
                    if (!MapUtils.isNotEmpty((Map)result)) continue;
                    if (result.containsKey("error")) {
                        throw new AssetProcessingException("Error writing output " + output, (Exception)result.get("error"));
                    }
                    results.add(result);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (IOException | ServiceException e) {
                throw new AssetProcessingException("Error writing output " + output, (Exception)e);
            }
        }
        return results;
    }
}

