/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.aws;

import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.craftercms.studio.api.v1.exception.AwsConfigurationException;
import org.craftercms.studio.api.v1.service.aws.AwsProfileManager;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.impl.v1.util.ConfigUtils;
import org.springframework.beans.factory.annotation.Required;

public class AwsProfileManagerImpl
implements AwsProfileManager {
    protected String basePath;
    protected String fileName;
    protected ContentService contentService;

    @Required
    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Required
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Required
    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    protected HierarchicalConfiguration getConfiguration(InputStream input) throws Exception {
        try {
            return ConfigUtils.readXmlConfiguration((InputStream)input);
        }
        catch (ConfigurationException e) {
            throw new Exception("Unable to read the AWS configuration", e);
        }
    }

    public HierarchicalConfiguration getProfile(String site, String profileId) throws AwsConfigurationException {
        try {
            InputStream content = this.contentService.getContent(site, this.basePath + "/" + this.fileName);
            HierarchicalConfiguration config = this.getConfiguration(content);
            List profiles = config.configurationsAt("profile");
            Optional<HierarchicalConfiguration> profile = profiles.stream().filter(profileItem -> profileId.equals(profileItem.getString("id"))).findFirst();
            return profile.orElseThrow(() -> new AwsConfigurationException("Profile not found: " + profileId));
        }
        catch (Exception e) {
            throw new AwsConfigurationException("Unable to retrieve profile", e);
        }
    }
}

