/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.box;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxConfig;
import com.box.sdk.BoxDeveloperEditionAPIConnection;
import com.box.sdk.EncryptionAlgorithm;
import com.box.sdk.JWTEncryptionPreferences;
import org.craftercms.studio.api.v1.box.BoxProfile;
import org.craftercms.studio.api.v1.box.BoxProfileReader;
import org.craftercms.studio.api.v1.exception.BoxException;
import org.craftercms.studio.api.v1.service.box.BoxService;
import org.springframework.beans.factory.annotation.Required;

public class BoxServiceImpl
implements BoxService {
    public static final long MIN_SIZE = 20000000L;
    protected BoxProfileReader profileReader;

    @Required
    public void setProfileReader(BoxProfileReader profileReader) {
        this.profileReader = profileReader;
    }

    protected BoxProfile getProfile(String site, String profileId) throws BoxException {
        return this.profileReader.getProfile(site, profileId);
    }

    protected BoxAPIConnection getConnection(BoxProfile profile) {
        JWTEncryptionPreferences jwtPrefs = new JWTEncryptionPreferences();
        jwtPrefs.setPublicKeyID(profile.getPublicKeyId());
        jwtPrefs.setPrivateKey(profile.getPrivateKey());
        jwtPrefs.setPrivateKeyPassword(profile.getPrivateKeyPassword());
        jwtPrefs.setEncryptionAlgorithm(EncryptionAlgorithm.RSA_SHA_256);
        BoxConfig config = new BoxConfig(profile.getClientId(), profile.getClientSecret(), profile.getEnterpriseId(), jwtPrefs);
        return BoxDeveloperEditionAPIConnection.getAppEnterpriseConnection((BoxConfig)config);
    }

    public String getAccessToken(String site, String profileId) throws BoxException {
        BoxProfile profile = this.getProfile(site, profileId);
        BoxAPIConnection api = this.getConnection(profile);
        return api.getAccessToken();
    }
}

