/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.clipboard;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateSecurePathParam;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.AbstractRegistrableService;
import org.craftercms.studio.api.v1.service.clipboard.ClipboardService;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.workflow.WorkflowService;

public class ClipboardServiceImpl
extends AbstractRegistrableService
implements ClipboardService {
    protected static final Logger logger = LoggerFactory.getLogger(ClipboardServiceImpl.class);
    protected ContentService contentService;
    protected WorkflowService workflowService;

    public void register() {
        this.getServicesManager().registerService(ClipboardService.class, (Object)this);
    }

    @ValidateParams
    public ClipboardService.ClipboardItem getItems(@ValidateStringParam(name="site") String site, HttpSession session) throws ServiceException {
        return this.getClipboardStore(site, session).getOps();
    }

    @ValidateParams
    public boolean cut(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, HttpSession session) throws ServiceException {
        ClipboardService.ClipboardItem clipItem = new ClipboardService.ClipboardItem(path, true);
        return this.clip(site, clipItem, true, session);
    }

    @ValidateParams
    public boolean copy(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, HttpSession session) throws ServiceException {
        ClipboardService.ClipboardItem clipItem = new ClipboardService.ClipboardItem(path, false);
        return this.clip(site, clipItem, false, session);
    }

    @ValidateParams
    public boolean copy(@ValidateStringParam(name="site") String site, ClipboardService.ClipboardItem clipItem, HttpSession session) throws ServiceException {
        return this.clip(site, clipItem, false, session);
    }

    @ValidateParams
    public Set<String> paste(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="destinationPath") String destinationPath, HttpSession session) throws ServiceException {
        HashSet<String> pastedItems = new HashSet<String>();
        ClipboardService.ClipboardItem clipOp = this.getItems(site, session);
        if (clipOp != null) {
            HashSet<ClipboardService.ClipboardItem> clipOps = new HashSet<ClipboardService.ClipboardItem>();
            clipOps.add(clipOp);
            this.pasteItems(site, destinationPath, clipOps, pastedItems);
        }
        return pastedItems;
    }

    protected void pasteItems(String site, String destinationPath, Set<ClipboardService.ClipboardItem> clipOps, Set<String> pastedItems) throws ServiceException {
        for (ClipboardService.ClipboardItem op : clipOps) {
            try {
                String newPath = null;
                boolean cut = op.isCut;
                if (cut) {
                    this.workflowService.cleanWorkflow(op.path, site, Collections.emptySet());
                    newPath = this.contentService.moveContent(site, op.path, destinationPath);
                } else {
                    newPath = this.contentService.copyContent(site, op.path, destinationPath);
                    this.pasteItems(site, newPath, op.children, pastedItems);
                }
                pastedItems.add(newPath);
            }
            catch (Exception err) {
                logger.error("Paste operation failed for item '{0}' to dest path `{1}', isCut: '{2}'", err, new Object[0]);
            }
        }
    }

    protected boolean clip(String site, ClipboardService.ClipboardItem item, boolean cut, HttpSession session) {
        ClipboardService.ClipboardStore store = this.getClipboardStore(site, session);
        store.clear();
        store.addOp(item);
        return true;
    }

    @ValidateParams
    public ClipboardService.ClipboardStore getClipboardStore(@ValidateStringParam(name="site") String site, HttpSession session) {
        ClipboardService.ClipboardStore clipboardStore = (ClipboardService.ClipboardStore)session.getAttribute(site + "-clipboard-condition");
        if (clipboardStore == null) {
            clipboardStore = new ClipboardService.ClipboardStore();
            session.setAttribute(site + "-clipboard-condition", (Object)clipboardStore);
        }
        return clipboardStore;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }
}

