/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.cmis;

import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.craftercms.commons.validation.annotations.param.ValidateIntegerParam;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateSecurePathParam;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.exception.CmisPathNotFoundException;
import org.craftercms.studio.api.v1.exception.CmisRepositoryNotFoundException;
import org.craftercms.studio.api.v1.exception.CmisTimeoutException;
import org.craftercms.studio.api.v1.exception.CmisUnavailableException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.exception.StudioPathNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.cmis.CmisService;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.to.CmisContentItemTO;
import org.craftercms.studio.api.v1.to.DataSourceRepositoryTO;
import org.craftercms.studio.api.v1.util.StudioConfiguration;
import org.dom4j.DocumentException;
import org.dom4j.Node;

public class CmisServiceImpl
implements CmisService {
    private static final Logger logger = LoggerFactory.getLogger(CmisServiceImpl.class);
    private static final String REPOSITORY_CONFIG_XPATH = "/cmis/repositories/repository[id='{cmisrepoid}']";
    private static final String CMIS_REPO_ID_VARIABLE = "{cmisrepoid}";
    private static final String ID_PROPERTY = "id";
    private static final String TYPE_PROPERTY = "type";
    private static final String URL_PROPERTY = "url";
    private static final String USERNAME_PROPERTY = "username";
    private static final String PASSWORD_PROPERTY = "password";
    private static final String BASE_PATH_PROPERTY = "base-path";
    private static final String DOWNLOAD_URL_REGEX_PROPERTY = "download-url-regex";
    private static final String USE_SSL_PROPERTY = "use-ssl";
    private static final String MIME_TYPE_FOLDER = "folder";
    private static final String CMIS_SEARCH_QUERY = "select * from cmis:document where IN_TREE('{folderId}') and cmis:name like '%{searchTerm}%'";
    private static final String CMIS_SEARCH_QUERY_FOLDER_ID_VARIABLE = "{folderId}";
    private static final String CMIS_SEARCH_QUERY_SEARCH_TERM_VARIABLE = "{searchTerm}";
    protected StudioConfiguration studioConfiguration;
    protected ContentService contentService;

    @ValidateParams
    public int listTotal(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="cmisRepo") String cmisRepo, @ValidateSecurePathParam(name="path") String path) throws CmisUnavailableException, CmisTimeoutException, CmisRepositoryNotFoundException {
        String contentPath;
        CmisObject cmisObject;
        Session session;
        int toRet = 0;
        DataSourceRepositoryTO repositoryConfig = this.getConfiguration(site, cmisRepo);
        if (repositoryConfig != null && (session = this.createCMISSession(repositoryConfig)) != null && (cmisObject = session.getObjectByPath(contentPath = Paths.get(repositoryConfig.getBasePath(), path).toString())) != null && BaseTypeId.CMIS_FOLDER.equals((Object)cmisObject.getBaseTypeId())) {
            Folder folder = (Folder)cmisObject;
            ItemIterable iterable = folder.getChildren();
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                ++toRet;
                iterator.next();
            }
        }
        return toRet;
    }

    @ValidateParams
    public List<CmisContentItemTO> list(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="cmisRepo") String cmisRepo, @ValidateSecurePathParam(name="path") String path, @ValidateIntegerParam(name="start") int start, @ValidateIntegerParam(name="number") int number) throws CmisUnavailableException, CmisTimeoutException, CmisRepositoryNotFoundException {
        String contentPath;
        CmisObject cmisObject;
        Session session;
        ArrayList<CmisContentItemTO> toRet = new ArrayList<CmisContentItemTO>();
        DataSourceRepositoryTO repositoryConfig = this.getConfiguration(site, cmisRepo);
        if (repositoryConfig != null && (session = this.createCMISSession(repositoryConfig)) != null && (cmisObject = session.getObjectByPath(contentPath = Paths.get(repositoryConfig.getBasePath(), path).toString())) != null && BaseTypeId.CMIS_FOLDER.equals((Object)cmisObject.getBaseTypeId())) {
            Folder folder = (Folder)cmisObject;
            ItemIterable iterable = folder.getChildren();
            Iterator iterator = iterable.iterator();
            int index = 0;
            int count = 0;
            while (iterator.hasNext()) {
                if (start <= index && count < number) {
                    CmisContentItemTO item = new CmisContentItemTO();
                    CmisObject cmisItem = (CmisObject)iterator.next();
                    item.setItem_name(cmisItem.getName());
                    if (BaseTypeId.CMIS_DOCUMENT.equals((Object)cmisItem.getBaseTypeId())) {
                        Document cmisDoc = (Document)cmisItem;
                        item.setItem_path((String)cmisDoc.getPaths().get(0));
                        item.setMime_type(cmisDoc.getContentStreamMimeType());
                        String contentId = cmisDoc.getId();
                        StringTokenizer st = new StringTokenizer(contentId, ";");
                        if (st.hasMoreTokens()) {
                            item.setItem_id(st.nextToken());
                        }
                        item.setSize(cmisDoc.getContentStreamLength());
                        toRet.add(item);
                    } else if (BaseTypeId.CMIS_FOLDER.equals((Object)cmisItem.getBaseTypeId())) {
                        Folder cmisFolder = (Folder)cmisItem;
                        item.setItem_id(cmisFolder.getId());
                        item.setItem_path(cmisFolder.getPath());
                        item.setMime_type(MIME_TYPE_FOLDER);
                        item.setSize(-1L);
                        toRet.add(item);
                    }
                    ++count;
                } else {
                    iterator.next();
                }
                ++index;
            }
        }
        return toRet;
    }

    private DataSourceRepositoryTO getConfiguration(String site, String cmisRepo) throws CmisRepositoryNotFoundException {
        String configPath = Paths.get(this.getConfigLocation(), this.getConfigFileName()).toString();
        org.dom4j.Document document = null;
        DataSourceRepositoryTO repositoryConfig = null;
        try {
            document = this.contentService.getContentAsDocument(site, configPath);
            Node node = document.selectSingleNode(REPOSITORY_CONFIG_XPATH.replace(CMIS_REPO_ID_VARIABLE, cmisRepo));
            if (node == null) {
                throw new CmisRepositoryNotFoundException();
            }
            repositoryConfig = new DataSourceRepositoryTO();
            repositoryConfig.setId(this.getPropertyValue(node, ID_PROPERTY));
            repositoryConfig.setType(this.getPropertyValue(node, TYPE_PROPERTY));
            repositoryConfig.setUrl(this.getPropertyValue(node, URL_PROPERTY));
            repositoryConfig.setUsername(this.getPropertyValue(node, USERNAME_PROPERTY));
            repositoryConfig.setPassword(this.getPropertyValue(node, PASSWORD_PROPERTY));
            repositoryConfig.setBasePath(this.getPropertyValue(node, BASE_PATH_PROPERTY));
            repositoryConfig.setDownloadUrlRegex(this.getPropertyValue(node, DOWNLOAD_URL_REGEX_PROPERTY));
            repositoryConfig.setUseSsl(Boolean.parseBoolean(this.getPropertyValue(node, USE_SSL_PROPERTY)));
        }
        catch (DocumentException e) {
            logger.error("Error while getting configuration for site: " + site + " cmis: " + cmisRepo + " (config path: " + configPath + ")", new Object[0]);
        }
        return repositoryConfig;
    }

    private String getPropertyValue(Node repositoryNode, String property) {
        Node propertyNode = repositoryNode.selectSingleNode(property);
        if (propertyNode != null) {
            return propertyNode.getStringValue();
        }
        return "";
    }

    private Session createCMISSession(DataSourceRepositoryTO config) throws CmisUnavailableException, CmisTimeoutException {
        if (config.isUseSsl()) {
            SSLContext sc = null;
            try {
                sc = this.getSSLContext();
                HostnameVerifier hv = (hostname, session) -> true;
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                HttpsURLConnection.setDefaultHostnameVerifier(hv);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                logger.error("Error initializing SSL context", (Exception)e, new Object[0]);
            }
        }
        SessionFactoryImpl sessionFactory = SessionFactoryImpl.newInstance();
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("org.apache.chemistry.opencmis.user", config.getUsername());
        parameter.put("org.apache.chemistry.opencmis.password", config.getPassword());
        parameter.put("org.apache.chemistry.opencmis.binding.atompub.url", config.getUrl());
        parameter.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
        parameter.put("org.apache.chemistry.opencmis.binding.cookies", "true");
        List repositories = new ArrayList();
        repositories = sessionFactory.getRepositories(parameter);
        Repository repository = (Repository)repositories.get(0);
        parameter.put("org.apache.chemistry.opencmis.session.repository.id", repository.getId());
        Session session2 = null;
        try {
            session2 = sessionFactory.createSession(parameter);
        }
        catch (CmisConnectionException e) {
            throw new CmisTimeoutException((Throwable)e);
        }
        catch (CmisBaseException e) {
            throw new CmisUnavailableException((Throwable)e);
        }
        return session2;
    }

    private SSLContext getSSLContext() throws KeyManagementException, NoSuchAlgorithmException {
        TrustManager[] trustAllCerts = new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        return sc;
    }

    @ValidateParams
    public long searchTotal(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="cmisRepo") String cmisRepo, @ValidateStringParam(name="searchTerm") String searchTerm, @ValidateSecurePathParam(name="path") String path) throws CmisUnavailableException, CmisTimeoutException, CmisRepositoryNotFoundException {
        String contentPath;
        CmisObject cmisObject;
        Session session;
        long toRet = 0L;
        DataSourceRepositoryTO repositoryConfig = this.getConfiguration(site, cmisRepo);
        if (repositoryConfig != null && (session = this.createCMISSession(repositoryConfig)) != null && (cmisObject = session.getObjectByPath(contentPath = Paths.get(repositoryConfig.getBasePath(), path).toString())) != null && BaseTypeId.CMIS_FOLDER.equals((Object)cmisObject.getBaseTypeId())) {
            String queryString = CMIS_SEARCH_QUERY.replace(CMIS_SEARCH_QUERY_FOLDER_ID_VARIABLE, cmisObject.getId()).replace(CMIS_SEARCH_QUERY_SEARCH_TERM_VARIABLE, searchTerm);
            ItemIterable result = session.query(queryString, false);
            toRet = result.getTotalNumItems();
        }
        return toRet;
    }

    @ValidateParams
    public List<CmisContentItemTO> search(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="cmisRepo") String cmisRepo, @ValidateStringParam(name="searchTerm") String searchTerm, @ValidateSecurePathParam(name="path") String path, @ValidateIntegerParam(name="start") int start, @ValidateIntegerParam(name="number") int number) throws CmisUnavailableException, CmisTimeoutException, CmisRepositoryNotFoundException {
        String contentPath;
        CmisObject cmisObject;
        Session session;
        ArrayList<CmisContentItemTO> toRet = new ArrayList<CmisContentItemTO>();
        DataSourceRepositoryTO repositoryConfig = this.getConfiguration(site, cmisRepo);
        if (repositoryConfig != null && (session = this.createCMISSession(repositoryConfig)) != null && (cmisObject = session.getObjectByPath(contentPath = Paths.get(repositoryConfig.getBasePath(), path).toString())) != null && BaseTypeId.CMIS_FOLDER.equals((Object)cmisObject.getBaseTypeId())) {
            String queryString = CMIS_SEARCH_QUERY.replace(CMIS_SEARCH_QUERY_FOLDER_ID_VARIABLE, cmisObject.getId()).replace(CMIS_SEARCH_QUERY_SEARCH_TERM_VARIABLE, searchTerm);
            ItemIterable result = session.query(queryString, false);
            result.skipTo((long)start);
            Iterator iterator = result.iterator();
            int count = 0;
            while (iterator.hasNext()) {
                if (count < number) {
                    CmisContentItemTO item = new CmisContentItemTO();
                    QueryResult qr = (QueryResult)iterator.next();
                    String contentId = qr.getPropertyById("cmis:objectId").getFirstValue().toString();
                    StringTokenizer st = new StringTokenizer(contentId, ";");
                    if (st.hasMoreTokens()) {
                        item.setItem_id(st.nextToken());
                    }
                    CmisObject qrObject = session.getObject(item.getItem_id());
                    Document cmisDoc = (Document)qrObject;
                    item.setItem_name(cmisDoc.getName());
                    item.setItem_path((String)cmisDoc.getPaths().get(0));
                    item.setMime_type(cmisDoc.getContentStreamMimeType());
                    item.setSize(cmisDoc.getContentStreamLength());
                    toRet.add(item);
                    ++count;
                    continue;
                }
                iterator.next();
            }
        }
        return toRet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ValidateParams
    public void cloneContent(@ValidateStringParam(name="siteId") String siteId, @ValidateStringParam(name="cmisRepoId") String cmisRepoId, @ValidateSecurePathParam(name="cmisPath") String cmisPath, @ValidateSecurePathParam(name="studioPath") String studioPath) throws CmisUnavailableException, CmisTimeoutException, CmisPathNotFoundException, ServiceException, StudioPathNotFoundException, CmisRepositoryNotFoundException {
        if (!this.contentService.contentExists(siteId, studioPath)) {
            throw new StudioPathNotFoundException();
        }
        ArrayList toRet = new ArrayList();
        DataSourceRepositoryTO repositoryConfig = this.getConfiguration(siteId, cmisRepoId);
        if (repositoryConfig == null) return;
        logger.debug("Create new CMIS session", new Object[0]);
        Session session = this.createCMISSession(repositoryConfig);
        if (session == null) throw new CmisUnauthorizedException();
        String contentPath = Paths.get(repositoryConfig.getBasePath(), cmisPath).toString();
        logger.debug("Find object for CMIS path: " + contentPath, new Object[0]);
        CmisObject cmisObject = session.getObjectByPath(contentPath);
        if (cmisObject == null) throw new CmisPathNotFoundException();
        if (BaseTypeId.CMIS_FOLDER.equals((Object)cmisObject.getBaseTypeId())) {
            throw new CmisPathNotFoundException();
        }
        if (!BaseTypeId.CMIS_DOCUMENT.equals((Object)cmisObject.getBaseTypeId())) return;
        Document cmisDoc = (Document)cmisObject;
        String fileName = cmisDoc.getName();
        String savePath = studioPath + "/" + fileName;
        ContentStream cs = cmisDoc.getContentStream();
        logger.debug("Save CMIS file to: " + savePath, new Object[0]);
        this.contentService.writeContent(siteId, savePath, cs.getStream());
    }

    private String getConfigLocation() {
        return this.studioConfiguration.getProperty("studio.configuration.site.dataSources.configBasePath");
    }

    private String getConfigFileName() {
        return this.studioConfiguration.getProperty("studio.configuration.site.dataSources.configFileName");
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }
}

