/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.configuration;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.configuration.SiteEnvironmentConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.to.EnvironmentConfigTO;
import org.craftercms.studio.api.v1.to.PublishingTargetTO;
import org.craftercms.studio.api.v1.util.StudioConfiguration;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;

public class SiteEnvironmentConfigImpl
implements SiteEnvironmentConfig {
    private static final Logger logger = LoggerFactory.getLogger(SiteEnvironmentConfigImpl.class);
    protected ServicesConfig servicesConfig;
    protected ContentService contentService;
    protected GeneralLockService generalLockService;
    protected StudioConfiguration studioConfiguration;

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public String getConfigPath() {
        return this.studioConfiguration.getProperty("studio.configuration.site.environment.configBasePath");
    }

    public String getConfigFileName() {
        return this.studioConfiguration.getProperty("studio.configuration.site.environment.configFileName");
    }

    @ValidateParams
    public EnvironmentConfigTO getEnvironmentConfig(@ValidateStringParam(name="site") String site) {
        return this.loadConfiguration(site);
    }

    @ValidateParams
    public String getPreviewServerUrl(@ValidateStringParam(name="site") String site) {
        String previewServerUrl;
        EnvironmentConfigTO config = this.getEnvironmentConfig(site);
        if (config != null && !StringUtils.isEmpty((CharSequence)(previewServerUrl = config.getPreviewServerUrl()))) {
            String webProject = this.servicesConfig.getWemProject(site);
            return previewServerUrl.replaceAll("\\$\\{webproject\\}", webProject);
        }
        return "";
    }

    @ValidateParams
    public String getLiveServerUrl(@ValidateStringParam(name="site") String site) {
        EnvironmentConfigTO config = this.getEnvironmentConfig(site);
        if (config != null) {
            return config.getLiveServerUrl();
        }
        return "";
    }

    @ValidateParams
    public String getAdminEmailAddress(@ValidateStringParam(name="site") String site) {
        EnvironmentConfigTO config = this.getEnvironmentConfig(site);
        if (config != null) {
            return config.getAdminEmailAddress();
        }
        return "";
    }

    @ValidateParams
    public String getAuthoringServerUrl(@ValidateStringParam(name="site") String site) {
        EnvironmentConfigTO config = this.getEnvironmentConfig(site);
        if (config != null) {
            return config.getAuthoringServerUrl();
        }
        return "";
    }

    protected EnvironmentConfigTO loadConfiguration(String key) {
        String configLocation = this.getConfigPath().replaceFirst("\\{site\\}", key).replaceFirst("\\{environment\\}", this.getEnvironment());
        configLocation = configLocation + "/" + this.getConfigFileName();
        EnvironmentConfigTO config = null;
        Document document = null;
        try {
            document = this.contentService.getContentAsDocument(key, configLocation);
        }
        catch (DocumentException e) {
            logger.error("Error reading environment configuration for site " + key + " from path " + configLocation, new Object[0]);
        }
        if (document != null) {
            Element root = document.getRootElement();
            config = new EnvironmentConfigTO();
            String previewServerUrl = root.valueOf("preview-server-url");
            config.setPreviewServerUrl(previewServerUrl);
            String openDropdown = root.valueOf("open-sidebar");
            config.setOpenDropdown(openDropdown != null ? Boolean.valueOf(openDropdown) : false);
            String authoringServerUrl = root.valueOf("authoring-server-url");
            config.setAuthoringServerUrl(authoringServerUrl);
            String liveServerUrl = root.valueOf("live-server-url");
            config.setLiveServerUrl(liveServerUrl);
            String adminEmailAddress = root.valueOf("admin-email-address");
            config.setAdminEmailAddress(adminEmailAddress);
            List publishingTargetsList = root.selectNodes("publishing-targets/target");
            for (Element element : publishingTargetsList) {
                String orderStr;
                PublishingTargetTO targetTO = new PublishingTargetTO();
                Node node = element.selectSingleNode("repo-branch-name");
                if (node != null) {
                    targetTO.setRepoBranchName(node.getText());
                }
                if ((node = element.selectSingleNode("display-label")) != null) {
                    targetTO.setDisplayLabel(node.getText());
                }
                if ((node = element.selectSingleNode("order")) != null && StringUtils.isNotEmpty((CharSequence)(orderStr = node.getText()))) {
                    try {
                        int orderVal = Integer.parseInt(orderStr);
                        targetTO.setOrder(orderVal);
                    }
                    catch (NumberFormatException exc) {
                        logger.info(String.format("Order not defined for publishing group (%s) config [path: %s]", targetTO.getDisplayLabel(), configLocation), new Object[0]);
                        logger.info(String.format("Default order value (%d) will be used for publishing group [%s]", targetTO.getOrder(), targetTO.getDisplayLabel()), new Object[0]);
                    }
                }
                config.getPublishingTargets().add(targetTO);
            }
            String previewDeploymentEndpoint = root.valueOf("preview-deployment-endpoint");
            config.setPreviewDeploymentEndpoint(previewDeploymentEndpoint);
            config.setLastUpdated(ZonedDateTime.now(ZoneOffset.UTC));
        }
        return config;
    }

    @ValidateParams
    public void reloadConfiguration(@ValidateStringParam(name="site") String site) {
        EnvironmentConfigTO config = this.loadConfiguration(site);
    }

    public String getEnvironment() {
        return this.studioConfiguration.getProperty("studio.configuration.site.environment");
    }

    @ValidateParams
    public boolean exists(@ValidateStringParam(name="site") String site) {
        EnvironmentConfigTO config = this.getEnvironmentConfig(site);
        return config != null;
    }

    @ValidateParams
    public String getPreviewDeploymentEndpoint(@ValidateStringParam(name="site") String site) {
        EnvironmentConfigTO config = this.getEnvironmentConfig(site);
        if (config != null) {
            return config.getPreviewDeploymentEndpoint();
        }
        return null;
    }

    @ValidateParams
    public List<PublishingTargetTO> getPublishingTargetsForSite(@ValidateStringParam(name="site") String site) {
        EnvironmentConfigTO config = this.getEnvironmentConfig(site);
        if (config != null) {
            return config.getPublishingTargets();
        }
        return new ArrayList<PublishingTargetTO>();
    }

    public GeneralLockService getGeneralLockService() {
        return this.generalLockService;
    }

    public void setGeneralLockService(GeneralLockService generalLockService) {
        this.generalLockService = generalLockService;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }
}

