/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.content;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateSecurePathParam;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.script.ScriptExecutor;
import org.craftercms.studio.api.v1.service.AbstractRegistrableService;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.DmContentLifeCycleService;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.util.StudioConfiguration;
import org.craftercms.studio.impl.v1.service.content.DmContentLifeCycleServiceImpl;
import org.craftercms.studio.impl.v1.util.spring.context.ApplicationContextProvider;

public class DmContentLifeCycleServiceImpl
extends AbstractRegistrableService
implements DmContentLifeCycleService {
    private static final Logger logger = LoggerFactory.getLogger(DmContentLifeCycleServiceImpl.class);
    protected Map<String, Object> _scriptObjects;
    protected ContentService contentService;
    protected SecurityService securityService;
    protected ScriptExecutor scriptExecutor;
    protected StudioConfiguration studioConfiguration;

    public String getScriptLocation() {
        return this.studioConfiguration.getProperty("studio.contentProcessor.contentLifeCycle.scriptLocation");
    }

    public Map<String, Object> getScriptObjects() {
        return this._scriptObjects;
    }

    public void setScriptObjects(Map<String, Object> scriptObjects) {
        this._scriptObjects = scriptObjects;
    }

    public void register() {
        this.getServicesManager().registerService(DmContentLifeCycleService.class, (Object)this);
    }

    @ValidateParams
    public void process(@ValidateStringParam(name="site") String site, @ValidateStringParam String user, @ValidateSecurePathParam String path, @ValidateStringParam(name="contenType") String contentType, DmContentLifeCycleService.ContentLifeCycleOperation operation, Map<String, String> params) {
        if (operation == null) {
            logger.warn("No lifecycle operation provided for " + site + ":" + path, new Object[0]);
            return;
        }
        if (StringUtils.isEmpty((CharSequence)contentType) || StringUtils.equals((CharSequence)contentType, (CharSequence)"unknown")) {
            logger.warn("Skipping content lifecycle script execution. no content type provided for " + site + ":" + path, new Object[0]);
            return;
        }
        String scriptPath = this.getScriptPath(site, contentType);
        if (!this.contentService.contentExists(site, scriptPath)) {
            logger.error("No script found at " + scriptPath + ", contentType: " + contentType, new Object[0]);
            return;
        }
        String script = this.contentService.getContentAsString(site, scriptPath);
        if (StringUtils.isNotEmpty((CharSequence)script)) {
            Map model = this.buildModel(site, user, path, contentType, operation.toString(), params);
            try {
                this.scriptExecutor.executeScriptString(script, model);
            }
            catch (Exception e) {
                logger.error("Error while executing content lifecycle script for " + site + ":" + path, e, new Object[0]);
            }
        }
    }

    protected String getScriptPath(String site, String contentType) {
        String location = this.getScriptLocation().replaceAll("\\{site\\}", site).replaceAll("\\{content\\-type\\}", contentType);
        return location;
    }

    protected Map<String, Object> buildModel(String site, String user, String path, String contentType, String operation, Map<String, String> params) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        for (String scriptObjectName : this._scriptObjects.keySet()) {
            model.put(scriptObjectName, this._scriptObjects.get(scriptObjectName));
        }
        model.put("site", site);
        model.put("path", path);
        user = StringUtils.isEmpty((CharSequence)user) ? this.securityService.getCurrentUser() : user;
        model.put("user", user);
        model.put("contentType", contentType);
        model.put("contentLifecycleOperation", operation);
        model.put("contentLoader", new XmlContentLoader(this));
        model.put("applicationContext", ApplicationContextProvider.getApplicationContext());
        if (params != null) {
            for (String key : params.keySet()) {
                model.put(key, params.get(key));
            }
        }
        return model;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public ScriptExecutor getScriptExecutor() {
        return this.scriptExecutor;
    }

    public void setScriptExecutor(ScriptExecutor scriptExecutor) {
        this.scriptExecutor = scriptExecutor;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

