/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.content;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateSecurePathParam;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.dal.ItemMetadata;
import org.craftercms.studio.api.v1.dal.ItemMetadataMapper;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;

public class ObjectMetadataManagerImpl
implements ObjectMetadataManager {
    private static final Logger logger = LoggerFactory.getLogger(ObjectMetadataManagerImpl.class);
    @Autowired
    protected ItemMetadataMapper itemMetadataMapper;

    @ValidateParams
    public void insertNewObjectMetadata(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        path = FilenameUtils.normalize((String)path, (boolean)true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        try {
            this.itemMetadataMapper.insertEntry(params);
        }
        catch (DuplicateKeyException e) {
            logger.debug("Failed to insert metadata for site: " + site + " and path: " + path + " into item_metadata table, because it is duplicate entry.", new Object[0]);
        }
    }

    @ValidateParams
    public void setObjectMetadata(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, Map<String, Object> properties) {
        path = FilenameUtils.normalize((String)path, (boolean)true);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("path", path);
        params.putAll(properties);
        this.itemMetadataMapper.setProperties(params);
    }

    @ValidateParams
    public void setObjectMetadataForCommitId(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="commitId") String commitId, Map<String, Object> properties) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("commitId", commitId);
        params.putAll(properties);
        this.itemMetadataMapper.setPropertiesForCommit(params);
    }

    public void updateObjectMetadata(ItemMetadata itemMetadata) {
        this.itemMetadataMapper.updateObjectMetadata(itemMetadata);
    }

    @ValidateParams
    public ItemMetadata getProperties(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        String cleanPath = FilenameUtils.normalize((String)path, (boolean)true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", cleanPath);
        return this.itemMetadataMapper.getProperties(params);
    }

    @ValidateParams
    public boolean metadataExist(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        path = FilenameUtils.normalize((String)path, (boolean)true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        int cnt = this.itemMetadataMapper.countEntries(params);
        if (cnt < 1) {
            return false;
        }
        return cnt <= 1;
    }

    @ValidateParams
    public boolean isRenamed(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        if (this.metadataExist(site, path = FilenameUtils.normalize((String)path, (boolean)true))) {
            ItemMetadata metadata = this.getProperties(site, path);
            return metadata.getRenamed() > 0;
        }
        return false;
    }

    @ValidateParams
    public String getOldPath(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        if (this.metadataExist(site, path = FilenameUtils.normalize((String)path, (boolean)true))) {
            ItemMetadata metadata = this.getProperties(site, path);
            return metadata.getOldUrl();
        }
        return "";
    }

    @ValidateParams
    public void lockContent(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, @ValidateStringParam(name="lockOwner") String lockOwner) {
        if (!this.metadataExist(site, path = FilenameUtils.normalize((String)path, (boolean)true))) {
            this.insertNewObjectMetadata(site, path);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        params.put("lockOwner", lockOwner);
        this.itemMetadataMapper.setLockOwner(params);
    }

    @ValidateParams
    public void unLockContent(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        if (!this.metadataExist(site, path = FilenameUtils.normalize((String)path, (boolean)true))) {
            this.insertNewObjectMetadata(site, path);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        params.put("lockOwner", null);
        this.itemMetadataMapper.setLockOwner(params);
    }

    @ValidateParams
    public void deleteObjectMetadataForSite(@ValidateStringParam(name="site") String site) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        this.itemMetadataMapper.deleteObjectMetadataForSite(params);
    }

    @ValidateParams
    public void deleteObjectMetadata(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        path = FilenameUtils.normalize((String)path, (boolean)true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        this.itemMetadataMapper.deleteEntry(params);
    }

    @ValidateParams
    public void deleteObjectMetadataForFolder(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        path = FilenameUtils.normalize((String)path, (boolean)true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path + "/%");
        this.itemMetadataMapper.deleteFolder(params);
    }

    @ValidateParams
    public void updateObjectPath(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="oldPath") String oldPath, @ValidateSecurePathParam(name="newPath") String newPath) {
        newPath = FilenameUtils.normalize((String)newPath, (boolean)true);
        oldPath = FilenameUtils.normalize((String)oldPath, (boolean)true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("oldPath", oldPath);
        params.put("newPath", newPath);
        this.itemMetadataMapper.updateObjectPath(params);
    }

    @ValidateParams
    public void clearRenamed(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        path = FilenameUtils.normalize((String)path, (boolean)true);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("renamed", false);
        params.put("oldUrl", "");
        this.setObjectMetadata(site, path, params);
    }

    @ValidateParams
    public void updateCommitId(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, @ValidateStringParam(name="commitId") String commitId) {
        path = FilenameUtils.normalize((String)path, (boolean)true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        params.put("commitId", commitId);
        this.itemMetadataMapper.updateCommitId(params);
    }

    @ValidateParams
    public boolean movedPathExists(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", site);
        params.put("path", path);
        return this.itemMetadataMapper.movedPathExists(params) > 0;
    }

    @ValidateParams
    public List<String> getSameCommitItems(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", site);
        params.put("path", path);
        return this.itemMetadataMapper.getSameCommitItems(params);
    }

    @ValidateParams
    public int countAllItems() {
        return this.itemMetadataMapper.countAllItems();
    }
}

