/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.dependency;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.service.dependency.DependencyDiffService;
import org.craftercms.studio.api.v1.service.dependency.DependencyService;

public class DependencyDiffServiceImpl
implements DependencyDiffService {
    protected DependencyService dependencyService;

    public DependencyService getDependencyService() {
        return this.dependencyService;
    }

    public void setDependencyService(DependencyService dependencyService) {
        this.dependencyService = dependencyService;
    }

    public DependencyDiffService.DiffResponse diff(DependencyDiffService.DiffRequest diffRequest) throws ServiceException {
        if (diffRequest == null) {
            throw new ServiceException("diffcontext cannot be null");
        }
        DependencyDiffService.DiffResponse response = new DependencyDiffService.DiffResponse();
        boolean recursive = diffRequest.isRecursive();
        String site = diffRequest.getSite();
        String sourcePath = diffRequest.getSourcePath();
        String destPath = diffRequest.getDestPath();
        if (StringUtils.isEmpty((String)destPath)) {
            destPath = sourcePath;
        }
        List sourceDependencies = new ArrayList();
        sourceDependencies = this.findDependencies(site, diffRequest.getSourceSandbox(), sourcePath, recursive, sourceDependencies);
        List destDependencies = new ArrayList();
        destDependencies = this.findDependencies(site, diffRequest.getDestSandbox(), destPath, recursive, destDependencies);
        for (String destDependency : destDependencies) {
            if (sourceDependencies.contains(destDependency)) continue;
            response.getRemovedDependencies().add(destDependency);
        }
        for (String sourceDependency : sourceDependencies) {
            if (destDependencies.contains(sourceDependency)) continue;
            response.getAddedDependencies().add(sourceDependency);
        }
        return response;
    }

    protected List<String> findDependencies(String site, String sandbox, String relativePath, boolean isRecursive, List<String> dependencies) throws ServiceException {
        Set dependenciesFromDoc = this.dependencyService.getItemDependencies(site, relativePath, 1);
        dependencies.addAll(dependenciesFromDoc);
        if (isRecursive) {
            for (String dependency : dependenciesFromDoc) {
                if (dependencies.contains(dependency)) continue;
                dependencies.addAll(this.findDependencies(site, sandbox, dependency, isRecursive, dependencies));
            }
        }
        return dependencies;
    }
}

