/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.dependency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.dal.DependencyEntity;
import org.craftercms.studio.api.v1.dal.DependencyMapper;
import org.craftercms.studio.api.v1.dal.ItemStateMapper;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v1.service.dependency.DependencyResolver;
import org.craftercms.studio.api.v1.service.dependency.DependencyService;
import org.craftercms.studio.api.v1.service.objectstate.State;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.to.CalculateDependenciesEntityTO;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.DeleteDependencyConfigTO;
import org.craftercms.studio.api.v1.util.StudioConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class DependencyServiceImpl
implements DependencyService {
    private static final Logger logger = LoggerFactory.getLogger(DependencyServiceImpl.class);
    @Autowired
    protected DependencyMapper dependencyMapper;
    @Autowired
    protected ItemStateMapper itemStateMapper;
    protected StudioConfiguration studioConfiguration;
    protected SiteService siteService;
    protected ContentService contentService;
    protected DependencyResolver dependencyResolver;
    protected PlatformTransactionManager transactionManager;
    protected ObjectMetadataManager objectMetadataManager;
    protected ContentRepository contentRepository;
    protected ServicesConfig servicesConfig;

    public Set<String> upsertDependencies(String site, String path) throws SiteNotFoundException, ContentNotFoundException, ServiceException {
        HashSet<String> toRet = new HashSet<String>();
        logger.debug("Resolving dependencies for content site: " + site + " path: " + path, new Object[0]);
        Map dependencies = this.dependencyResolver.resolve(site, path);
        ArrayList dependencyEntities = new ArrayList();
        if (dependencies != null) {
            logger.debug("Found " + dependencies.size() + " dependencies. Create entities to insert into database.", new Object[0]);
            for (String type : dependencies.keySet()) {
                dependencyEntities.addAll(this.createDependencyEntities(site, path, (Set)dependencies.get(type), type, toRet));
            }
            logger.debug("Preparing transaction for database updates.", new Object[0]);
            DefaultTransactionDefinition defaultTransactionDefinition = new DefaultTransactionDefinition();
            defaultTransactionDefinition.setName("upsertDependencies");
            logger.debug("Starting transaction.", new Object[0]);
            TransactionStatus txStatus = this.transactionManager.getTransaction((TransactionDefinition)defaultTransactionDefinition);
            try {
                logger.debug("Delete all source dependencies for site: " + site + " path: " + path, new Object[0]);
                this.deleteAllSourceDependencies(site, path);
                logger.debug("Insert all extracted dependencies entries for site: " + site + " path: " + path, new Object[0]);
                this.insertDependenciesIntoDatabase(dependencyEntities);
                logger.debug("Committing transaction.", new Object[0]);
                this.transactionManager.commit(txStatus);
            }
            catch (Exception e) {
                logger.debug("Rolling back transaction.", new Object[0]);
                this.transactionManager.rollback(txStatus);
                throw new ServiceException("Failed to upsert dependencies for site: " + site + " path: " + path, e);
            }
        }
        return toRet;
    }

    public Set<String> upsertDependencies(String site, List<String> paths) throws SiteNotFoundException, ContentNotFoundException, ServiceException {
        HashSet<String> toRet = new HashSet<String>();
        ArrayList dependencyEntities = new ArrayList();
        StringBuilder sbPaths = new StringBuilder();
        logger.debug("Resolving dependencies for list of paths.", new Object[0]);
        for (String path : paths) {
            sbPaths.append("\n").append(path);
            logger.debug("Resolving dependencies for content site: " + site + " path: " + path, new Object[0]);
            Map dependencies = this.dependencyResolver.resolve(site, path);
            if (dependencies == null) continue;
            logger.debug("Found " + dependencies.size() + " dependencies. Create entities to insert into database.", new Object[0]);
            for (String type : dependencies.keySet()) {
                dependencyEntities.addAll(this.createDependencyEntities(site, path, (Set)dependencies.get(type), type, toRet));
            }
        }
        logger.debug("Preparing transaction for database updates.", new Object[0]);
        DefaultTransactionDefinition defaultTransactionDefinition = new DefaultTransactionDefinition();
        defaultTransactionDefinition.setName("upsertDependencies");
        logger.debug("Starting transaction.", new Object[0]);
        TransactionStatus txStatus = this.transactionManager.getTransaction((TransactionDefinition)defaultTransactionDefinition);
        try {
            logger.debug("Delete all source dependencies for list of paths site: " + site, new Object[0]);
            for (String path : paths) {
                this.deleteAllSourceDependencies(site, path);
            }
            logger.debug("Insert all extracted dependencies entries lof list of paths for site: " + site, new Object[0]);
            this.insertDependenciesIntoDatabase(dependencyEntities);
            logger.debug("Committing transaction.", new Object[0]);
            this.transactionManager.commit(txStatus);
        }
        catch (Exception e) {
            logger.debug("Rolling back transaction.", new Object[0]);
            this.transactionManager.rollback(txStatus);
            throw new ServiceException("Failed to upsert dependencies for site: " + site + " paths: " + sbPaths.toString(), e);
        }
        return toRet;
    }

    private void deleteAllSourceDependencies(String site, String path) {
        logger.debug("Delete all source dependencies for site: " + site + " path: " + path, new Object[0]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        this.dependencyMapper.deleteAllSourceDependencies(params);
    }

    private List<DependencyEntity> createDependencyEntities(String site, String path, Set<String> dependencyPaths, String dependencyType, Set<String> extractedPaths) {
        logger.debug("Create dependency entity TO for site: " + site + " path: " + path, new Object[0]);
        ArrayList<DependencyEntity> dependencyEntities = new ArrayList<DependencyEntity>();
        if (dependencyPaths != null && dependencyPaths.size() > 0) {
            for (String file : dependencyPaths) {
                DependencyEntity dependencyObj = new DependencyEntity();
                dependencyObj.setSite(site);
                dependencyObj.setSourcePath(this.getCleanPath(path));
                dependencyObj.setTargetPath(this.getCleanPath(file));
                dependencyObj.setType(dependencyType);
                dependencyEntities.add(dependencyObj);
                extractedPaths.add(file);
            }
        }
        return dependencyEntities;
    }

    private String getCleanPath(String path) {
        return path.replaceAll("//", "/");
    }

    private void insertDependenciesIntoDatabase(List<DependencyEntity> dependencyEntities) {
        logger.debug("Insert list of dependency entities into database", new Object[0]);
        if (CollectionUtils.isNotEmpty(dependencyEntities)) {
            HashMap<String, List<DependencyEntity>> params = new HashMap<String, List<DependencyEntity>>();
            params.put("dependencies", dependencyEntities);
            this.dependencyMapper.insertList(params);
        }
    }

    public Set<String> getPublishingDependencies(String site, String path) throws SiteNotFoundException, ContentNotFoundException, ServiceException {
        logger.debug("Get publishing dependencies for site: " + site + " path:" + path, new Object[0]);
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(path);
        return this.getPublishingDependencies(site, paths);
    }

    public Set<String> getPublishingDependencies(String site, List<String> paths) throws SiteNotFoundException, ContentNotFoundException, ServiceException {
        HashSet<String> toRet = new HashSet<String>();
        HashSet<String> pathsParams = new HashSet<String>();
        logger.debug("Get all publishing dependencies", new Object[0]);
        pathsParams.addAll(paths);
        boolean exitCondition = false;
        do {
            List deps;
            exitCondition = !toRet.addAll(deps = this.getPublishingDependenciesForListFromDB(site, pathsParams));
            pathsParams.clear();
            pathsParams.addAll(deps);
        } while (!exitCondition);
        return toRet;
    }

    private List<String> getPublishingDependenciesForListFromDB(String site, Set<String> paths) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("paths", paths);
        params.put("regex", this.getItemSpecificDependenciesPatterns());
        Collection onlyEditStates = CollectionUtils.removeAll((Collection)State.CHANGE_SET_STATES, (Collection)State.NEW_STATES);
        params.put("editedStates", onlyEditStates);
        params.put("newStates", State.NEW_STATES);
        return this.dependencyMapper.getPublishingDependenciesForList(params);
    }

    public Set<String> getItemSpecificDependencies(String site, String path, int depth) throws SiteNotFoundException, ContentNotFoundException, ServiceException {
        if (!this.siteService.exists(site)) {
            throw new SiteNotFoundException();
        }
        if (!this.contentService.contentExists(site, path)) {
            throw new ContentNotFoundException();
        }
        HashSet<String> toRet = new HashSet<String>();
        HashSet<String> paths = new HashSet<String>();
        boolean exitCondition = false;
        paths.add(path);
        if (depth < 0) {
            do {
                List deps;
                exitCondition = !toRet.addAll(deps = this.getItemSpecificDependenciesFromDB(site, paths));
                paths.clear();
                paths.addAll(deps);
            } while (!exitCondition);
        } else {
            int d = depth;
            while (d-- > 0) {
                List deps = this.getItemSpecificDependenciesFromDB(site, paths);
                exitCondition = !toRet.addAll(deps);
                paths.clear();
                paths.addAll(deps);
                if (!exitCondition) continue;
                break;
            }
        }
        return toRet;
    }

    private List<String> getItemSpecificDependenciesFromDB(String site, Set<String> paths) {
        if (CollectionUtils.isEmpty(paths)) {
            return new ArrayList<String>();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("paths", paths);
        params.put("regex", this.getItemSpecificDependenciesPatterns());
        return this.dependencyMapper.getItemSpecificDependenciesForList(params);
    }

    public Set<String> getItemDependencies(String site, String path, int depth) throws SiteNotFoundException, ContentNotFoundException, ServiceException {
        if (!this.siteService.exists(site)) {
            throw new SiteNotFoundException();
        }
        if (!this.contentService.contentExists(site, path)) {
            throw new ContentNotFoundException();
        }
        logger.debug("Get dependency items for content " + path + " for site " + site, new Object[0]);
        HashSet<String> toRet = new HashSet<String>();
        HashSet<String> paths = new HashSet<String>();
        paths.add(path);
        if (depth < 0) {
            boolean exitCondition;
            do {
                List deps;
                exitCondition = !toRet.addAll(deps = this.getItemDependenciesFromDB(site, paths));
                paths.clear();
                paths.addAll(deps);
            } while (!exitCondition);
        } else {
            List deps;
            boolean exitCondition;
            int d = depth;
            while (d-- > 0 && !(exitCondition = !toRet.addAll(deps = this.getItemDependenciesFromDB(site, paths)))) {
            }
        }
        return toRet;
    }

    private List<String> getItemDependenciesFromDB(String site, Set<String> paths) {
        if (CollectionUtils.isEmpty(paths)) {
            return new ArrayList<String>();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("paths", paths);
        return this.dependencyMapper.getDependenciesForList(params);
    }

    public Set<String> getItemsDependingOn(String site, String path, int depth) throws SiteNotFoundException, ContentNotFoundException, ServiceException {
        if (!this.siteService.exists(site)) {
            throw new SiteNotFoundException();
        }
        if (!this.contentService.contentExists(site, path)) {
            throw new ContentNotFoundException();
        }
        logger.debug("Get items depending on content " + path + " for site " + site, new Object[0]);
        HashSet<String> toRet = new HashSet<String>();
        HashSet<String> paths = new HashSet<String>();
        paths.add(path);
        if (depth < 0) {
            do {
                List deps = this.getItemsDependingOnFromDB(site, paths);
                toRet.addAll(deps);
                paths.clear();
                paths.addAll(deps);
            } while (!CollectionUtils.isNotEmpty(paths));
        } else {
            int d = depth;
            while (d-- > 0) {
                List deps = this.getItemsDependingOnFromDB(site, paths);
                toRet.addAll(deps);
                paths.clear();
                paths.addAll(deps);
            }
        }
        return toRet;
    }

    private List<String> getItemsDependingOnFromDB(String site, Set<String> paths) {
        if (CollectionUtils.isEmpty(paths)) {
            return new ArrayList<String>();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("paths", paths);
        return this.dependencyMapper.getItemsDependingOn(params);
    }

    public Set<String> moveDependencies(String site, String oldPath, String newPath) throws SiteNotFoundException, ContentNotFoundException, ServiceException {
        if (!this.siteService.exists(site)) {
            throw new SiteNotFoundException();
        }
        if (!this.contentService.contentExists(site, newPath)) {
            throw new ContentNotFoundException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", site);
        params.put("oldPath", oldPath);
        params.put("newPath", newPath);
        this.dependencyMapper.moveDependency(params);
        return this.getItemDependencies(site, newPath, 1);
    }

    public void deleteItemDependencies(String site, String path) throws SiteNotFoundException, ContentNotFoundException, ServiceException {
        if (!this.siteService.exists(site)) {
            throw new SiteNotFoundException();
        }
        logger.debug("Delete dependencies for content site: " + site + " path: " + path, new Object[0]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        this.dependencyMapper.deleteDependenciesForSiteAndPath(params);
    }

    public void deleteSiteDependencies(String site) throws ServiceException {
        logger.debug("Delete all dependencies for site: " + site, new Object[0]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        this.dependencyMapper.deleteDependenciesForSite(params);
    }

    public Set<String> getDeleteDependencies(String site, String path) throws SiteNotFoundException, ContentNotFoundException, ServiceException {
        if (!this.siteService.exists(site)) {
            throw new SiteNotFoundException();
        }
        if (!this.contentService.contentExists(site, path)) {
            throw new ContentNotFoundException();
        }
        logger.debug("Get delete dependencies for content - site " + site + " path " + path, new Object[0]);
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(path);
        HashSet processedPaths = new HashSet();
        return this.getDeleteDependenciesInternal(site, paths, processedPaths);
    }

    public Set<String> getDeleteDependencies(String site, List<String> paths) throws SiteNotFoundException, ContentNotFoundException, ServiceException {
        if (!this.siteService.exists(site)) {
            throw new SiteNotFoundException();
        }
        StringBuilder sbPaths = new StringBuilder();
        for (String path : paths) {
            if (!this.contentService.contentExists(site, path)) {
                throw new ContentNotFoundException();
            }
            sbPaths.append("\n").append(path);
        }
        logger.debug("Gete delete dependencies for content - site: " + site + " paths: " + sbPaths.toString(), new Object[0]);
        HashSet processedPaths = new HashSet();
        return this.getDeleteDependenciesInternal(site, paths, processedPaths);
    }

    private Set<String> getDeleteDependenciesInternal(String site, List<String> paths, Set<String> processedPaths) {
        HashSet<String> toRet = new HashSet<String>();
        logger.debug("Get all children from subtree", new Object[0]);
        Set children = this.getAllChildrenRecursively(site, paths);
        toRet.addAll(children);
        logger.debug("Get dependencies from DB for all paths in subtree(s) and filter them by item specific and content type", new Object[0]);
        HashSet<String> depsSource = new HashSet<String>();
        depsSource.addAll(paths);
        depsSource.addAll(children);
        Set dependencies = this.getContentTypeFilteredDeleteDependencies(site, depsSource);
        toRet.addAll(dependencies);
        List itemSpecificcDeps = this.getItemSpecificDependenciesFromDB(site, depsSource);
        toRet.addAll(itemSpecificcDeps);
        boolean doItAgain = false;
        logger.debug("Repeat process for newly collected dependencies that have not been processed yet", new Object[0]);
        doItAgain = doItAgain || processedPaths.addAll(children);
        doItAgain = doItAgain || processedPaths.addAll(dependencies);
        boolean bl = doItAgain = doItAgain || processedPaths.addAll(itemSpecificcDeps);
        if (doItAgain) {
            ArrayList pathsToProcess = new ArrayList();
            pathsToProcess.addAll(children);
            pathsToProcess.addAll(dependencies);
            toRet.addAll(this.getDeleteDependenciesInternal(site, pathsToProcess, processedPaths));
        }
        logger.debug("Return collected set of dependencies", new Object[0]);
        return toRet;
    }

    private Set<String> getContentTypeFilteredDeleteDependencies(String site, Set<String> paths) {
        HashSet<String> toRet = new HashSet<String>();
        List deps = this.getItemDependenciesFromDB(site, paths);
        block0: for (String dep : deps) {
            ContentItemTO item = this.contentService.getContentItem(site, dep, 0);
            List deleteDependencyConfigList = this.servicesConfig.getDeleteDependencyPatterns(site, item.getContentType());
            if (!CollectionUtils.isNotEmpty((Collection)deleteDependencyConfigList)) continue;
            for (DeleteDependencyConfigTO deleteDependencyConfig : deleteDependencyConfigList) {
                if (!dep.matches(deleteDependencyConfig.getPattern())) continue;
                toRet.add(dep);
                continue block0;
            }
        }
        return toRet;
    }

    private Set<String> getAllChildrenRecursively(String site, List<String> paths) {
        logger.debug("Get all content from subtree(s) for list of pats", new Object[0]);
        HashSet<String> toRet = new HashSet<String>();
        for (String path : paths) {
            logger.debug("Get children from repository for content at site " + site + " path " + path, new Object[0]);
            RepositoryItem[] children = this.contentRepository.getContentChildren(site, path);
            if (children == null) continue;
            ArrayList<String> childrenPaths = new ArrayList<String>();
            for (RepositoryItem child : children) {
                String childPath = child.path + "/" + child.name;
                childrenPaths.add(childPath);
            }
            logger.debug("Adding all collected children paths", new Object[0]);
            toRet.addAll(childrenPaths);
            toRet.addAll(this.getAllChildrenRecursively(site, childrenPaths));
        }
        return toRet;
    }

    protected List<String> getItemSpecificDependenciesPatterns() {
        StringTokenizer st = new StringTokenizer(this.studioConfiguration.getProperty("studio.configuration.dependency.itemSpecificPatterns"), ",");
        ArrayList<String> itemSpecificDependenciesPatterns = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            itemSpecificDependenciesPatterns.add(st.nextToken().trim());
        }
        return itemSpecificDependenciesPatterns;
    }

    public Map<String, List<CalculateDependenciesEntityTO>> calculateDependencies(String site, List<String> paths) throws ServiceException {
        HashMap<String, List<CalculateDependenciesEntityTO>> toRet = new HashMap<String, List<CalculateDependenciesEntityTO>>();
        ArrayList<CalculateDependenciesEntityTO> entities = new ArrayList<CalculateDependenciesEntityTO>();
        Map deps = this.calculatePublishingDependencies(site, paths);
        HashMap temp = new HashMap();
        for (String string : paths) {
            temp.put(string, new ArrayList());
        }
        for (Map.Entry entry : deps.entrySet()) {
            if (entry.getKey() == entry.getValue()) continue;
            List ds = (List)temp.get(entry.getValue());
            ds.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        for (Map.Entry entry : temp.entrySet()) {
            CalculateDependenciesEntityTO calculateDependenciesEntityTO = new CalculateDependenciesEntityTO();
            calculateDependenciesEntityTO.setItem((String)entry.getKey());
            calculateDependenciesEntityTO.setDependencies((List)entry.getValue());
            entities.add(calculateDependenciesEntityTO);
        }
        toRet.put("entities", entities);
        return toRet;
    }

    public Set<String> calculateDependenciesPaths(String site, List<String> paths) throws ServiceException {
        Map dependencies = this.calculatePublishingDependencies(site, paths);
        return dependencies.keySet();
    }

    private Map<String, String> calculatePublishingDependencies(String site, List<String> paths) throws SiteNotFoundException, ContentNotFoundException, ServiceException {
        HashSet toRet = new HashSet();
        HashSet<String> pathsParams = new HashSet<String>();
        logger.debug("Get all publishing dependencies", new Object[0]);
        pathsParams.addAll(paths);
        Set mandatoryParents = this.getMandatoryParentsForPublishing(site, paths);
        boolean exitCondition = false;
        HashMap<String, String> ancestors = new HashMap<String, String>();
        for (String p : paths) {
            ancestors.put(p, p);
        }
        block1: for (String p : mandatoryParents) {
            String prefix = p.replace("/index.xml", "");
            for (String p2 : paths) {
                if (!p2.startsWith(prefix)) continue;
                ancestors.put(p, p2);
                continue block1;
            }
        }
        do {
            List deps = this.calculatePublishingDependenciesForListFromDB(site, pathsParams);
            ArrayList<String> targetPaths = new ArrayList<String>();
            for (Map d : deps) {
                String srcPath = (String)d.get("source_path");
                String targetPath = (String)d.get("target_path");
                if (!ancestors.keySet().contains(targetPath) && !StringUtils.equals((CharSequence)targetPath, (CharSequence)((CharSequence)ancestors.get(srcPath)))) {
                    ancestors.put(targetPath, (String)ancestors.get(srcPath));
                }
                targetPaths.add(targetPath);
            }
            exitCondition = !toRet.addAll(targetPaths);
            pathsParams.clear();
            pathsParams.addAll(targetPaths);
        } while (!exitCondition);
        return ancestors;
    }

    private Set<String> getMandatoryParentsForPublishing(String site, List<String> paths) {
        Set possibleParents = this.calculatePossibleParents(paths);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("possibleParents", possibleParents);
        Collection onlyEditStates = CollectionUtils.removeAll((Collection)State.CHANGE_SET_STATES, (Collection)State.NEW_STATES);
        params.put("editedStates", onlyEditStates);
        params.put("newStates", State.NEW_STATES);
        List result = this.itemStateMapper.getMandatoryParentsForPublishing(params);
        HashSet<String> toRet = new HashSet<String>();
        toRet.addAll(result);
        return toRet;
    }

    private Set<String> calculatePossibleParents(List<String> paths) {
        HashSet<String> possibleParents = new HashSet<String>();
        for (String path : paths) {
            StringTokenizer stPath = new StringTokenizer(path.replace("/index.xml", ""), "/");
            StringBuilder candidate = new StringBuilder("/");
            if (stPath.countTokens() <= 0) continue;
            do {
                String token = stPath.nextToken();
                if (!stPath.hasMoreTokens()) continue;
                candidate.append(token).append("/");
                possibleParents.add(candidate.toString() + "index.xml");
            } while (stPath.hasMoreTokens());
        }
        return possibleParents;
    }

    private List<Map<String, String>> calculatePublishingDependenciesForListFromDB(String site, Set<String> paths) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("paths", paths);
        params.put("regex", this.getItemSpecificDependenciesPatterns());
        Collection onlyEditStates = CollectionUtils.removeAll((Collection)State.CHANGE_SET_STATES, (Collection)State.NEW_STATES);
        params.put("editedStates", onlyEditStates);
        params.put("newStates", State.NEW_STATES);
        return this.dependencyMapper.calculatePublishingDependenciesForList(params);
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public DependencyResolver getDependencyResolver() {
        return this.dependencyResolver;
    }

    public void setDependencyResolver(DependencyResolver dependencyResolver) {
        this.dependencyResolver = dependencyResolver;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public ObjectMetadataManager getObjectMetadataManager() {
        return this.objectMetadataManager;
    }

    public void setObjectMetadataManager(ObjectMetadataManager objectMetadataManager) {
        this.objectMetadataManager = objectMetadataManager;
    }

    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }
}

