/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.dependency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.dependency.DependencyResolver;
import org.craftercms.studio.api.v1.to.DependencyResolverConfigTO;
import org.craftercms.studio.api.v1.util.StudioConfiguration;
import org.craftercms.studio.impl.v1.util.ContentUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class RegexDependencyResolver
implements DependencyResolver {
    private static final Logger logger = LoggerFactory.getLogger(RegexDependencyResolver.class);
    protected ContentService contentService;
    protected StudioConfiguration studioConfiguration;

    public Map<String, Set<String>> resolve(String site, String path) {
        Map<String, Set<String>> toRet = new HashMap<String, Set<String>>();
        try {
            logger.debug("Get dependency resolver configuration for site " + site, new Object[0]);
            DependencyResolverConfigTO config = this.getConfiguration(site);
            if (config != null) {
                logger.debug("Determine item type of content for site: " + site + ", path: " + path, new Object[0]);
                DependencyResolverConfigTO.ItemType itemType = this.getItemTypeResolverConfig(site, path, config);
                if (itemType != null) {
                    String content = this.contentService.getContentAsString(site, path);
                    if (content != null) {
                        Map dependencyTypes = itemType.getDependencyTypes();
                        logger.debug("Get dependencies of content for site: " + site + ", path: " + path, new Object[0]);
                        toRet = this.getDependencies(site, path, content, dependencyTypes);
                    } else {
                        logger.error("Failed to extract dependencies. Content was empty/null found for site: " + site + ", path: " + path, new Object[0]);
                    }
                } else {
                    logger.debug("No dependency extraction required for site: " + site + ", path: " + path, new Object[0]);
                }
            } else {
                String configLocation = this.getConfigLocation(site);
                logger.error("Failed to load Dependency Resolver configuration. Verify that configuration exists and it is valid XML file: " + configLocation, new Object[0]);
            }
        }
        catch (Exception exc) {
            logger.error("Unexcpected error resolving dependencies for site: " + site + " path: " + path, new Object[0]);
        }
        return toRet;
    }

    private DependencyResolverConfigTO getConfiguration(String site) {
        DependencyResolverConfigTO config = null;
        logger.debug("Get configuration location for site " + site, new Object[0]);
        String configLocation = this.getConfigLocation(site);
        Document document = null;
        try {
            logger.debug("Load configuration as xml document from " + configLocation, new Object[0]);
            document = this.contentService.getContentAsDocument(site, configLocation);
        }
        catch (DocumentException e) {
            logger.error("Failed to load dependency resolver configuration from location: " + configLocation, (Exception)((Object)e), new Object[0]);
        }
        if (document != null) {
            Element root = document.getRootElement();
            config = new DependencyResolverConfigTO();
            Element itemTypesEl = root.element("item-types");
            if (itemTypesEl != null) {
                logger.debug("Load configuration accoridng to XML structure", new Object[0]);
                HashMap<String, DependencyResolverConfigTO.ItemType> itemTypes = new HashMap<String, DependencyResolverConfigTO.ItemType>();
                Iterator iterItemTypes = itemTypesEl.elementIterator("item-type");
                logger.debug("Populate item types", new Object[0]);
                while (iterItemTypes.hasNext()) {
                    DependencyResolverConfigTO.ItemType itemType = new DependencyResolverConfigTO.ItemType();
                    ArrayList<String> itemTypeIncludes = new ArrayList<String>();
                    HashMap<String, DependencyResolverConfigTO.DependencyType> dependencyTypes = new HashMap<String, DependencyResolverConfigTO.DependencyType>();
                    Element itemTypeEl = (Element)iterItemTypes.next();
                    String typeName = itemTypeEl.valueOf("name");
                    Element includesIT = itemTypeEl.element("includes");
                    Iterator iterPathPatterns = includesIT.elementIterator("path-pattern");
                    while (iterPathPatterns.hasNext()) {
                        Element pathPattern = (Element)iterPathPatterns.next();
                        String pathPatternValue = pathPattern.getStringValue();
                        itemTypeIncludes.add(pathPatternValue);
                    }
                    itemType.setIncludes(itemTypeIncludes);
                    Element dependencyTypesEl = itemTypeEl.element("dependency-types");
                    Iterator iterDependencyTypes = dependencyTypesEl.elementIterator("dependency-type");
                    logger.debug("Populate dependency types for " + typeName, new Object[0]);
                    while (iterDependencyTypes.hasNext()) {
                        Element dependencyTypeEl = (Element)iterDependencyTypes.next();
                        DependencyResolverConfigTO.DependencyType dependencyType = new DependencyResolverConfigTO.DependencyType();
                        ArrayList<DependencyResolverConfigTO.DependencyExtractionPattern> patterns = new ArrayList<DependencyResolverConfigTO.DependencyExtractionPattern>();
                        String dependencyTypeName = dependencyTypeEl.valueOf("name");
                        dependencyType.setName(dependencyTypeName);
                        Element dependencyTypeIncludesEl = dependencyTypeEl.element("includes");
                        Iterator iterDependencyTypeIncludes = dependencyTypeIncludesEl.elementIterator("pattern");
                        while (iterDependencyTypeIncludes.hasNext()) {
                            DependencyResolverConfigTO.DependencyExtractionPattern pattern = new DependencyResolverConfigTO.DependencyExtractionPattern();
                            ArrayList<DependencyResolverConfigTO.DependencyExtractionTransform> transforms = new ArrayList<DependencyResolverConfigTO.DependencyExtractionTransform>();
                            Element patternEl = (Element)iterDependencyTypeIncludes.next();
                            Element findRegexEl = patternEl.element("find-regex");
                            pattern.setFindRegex(findRegexEl.getStringValue());
                            Element transformsEl = patternEl.element("transforms");
                            if (transformsEl != null) {
                                Iterator iterTransformEl = transformsEl.elementIterator("transform");
                                while (iterTransformEl.hasNext()) {
                                    Element transformEl = (Element)iterTransformEl.next();
                                    DependencyResolverConfigTO.DependencyExtractionTransform transform = new DependencyResolverConfigTO.DependencyExtractionTransform();
                                    Element matchEl = transformEl.element("match");
                                    Element replaceEl = transformEl.element("replace");
                                    transform.setMatch(matchEl.getStringValue());
                                    transform.setReplace(replaceEl.getStringValue());
                                    transforms.add(transform);
                                }
                            }
                            pattern.setTransforms(transforms);
                            patterns.add(pattern);
                        }
                        dependencyType.setIncludes(patterns);
                        dependencyTypes.put(dependencyTypeName, dependencyType);
                    }
                    itemType.setDependencyTypes(dependencyTypes);
                    itemTypes.put(typeName, itemType);
                }
                config.setItemTypes(itemTypes);
            }
        } else {
            logger.warn("Dependency resolver XML configuration for site " + site + " does not exist at " + configLocation, new Object[0]);
        }
        return config;
    }

    private DependencyResolverConfigTO.ItemType getItemTypeResolverConfig(String site, String path, DependencyResolverConfigTO config) {
        logger.debug("Loop through all item types to match path against include patterns", new Object[0]);
        Map itemTypes = config.getItemTypes();
        DependencyResolverConfigTO.ItemType itemType = null;
        if (itemTypes != null) {
            for (Map.Entry entry : itemTypes.entrySet()) {
                DependencyResolverConfigTO.ItemType it = (DependencyResolverConfigTO.ItemType)entry.getValue();
                List includes = it.getIncludes();
                if (!ContentUtils.matchesPatterns((String)path, (List)includes)) continue;
                itemType = it;
                break;
            }
        }
        return itemType;
    }

    private Map<String, Set<String>> getDependencies(String site, String path, String content, Map<String, DependencyResolverConfigTO.DependencyType> dependencyTypes) {
        HashMap<String, Set<String>> toRet = new HashMap<String, Set<String>>();
        logger.debug("Loop through all dependency types", new Object[0]);
        for (Map.Entry<String, DependencyResolverConfigTO.DependencyType> dependencyTypeEntry : dependencyTypes.entrySet()) {
            HashSet<String> extractedPaths = new HashSet<String>();
            DependencyResolverConfigTO.DependencyType dependencyType = dependencyTypeEntry.getValue();
            List extractionPatterns = dependencyType.getIncludes();
            logger.debug("Loop through all extraction patterns for " + dependencyTypeEntry.getKey(), new Object[0]);
            for (DependencyResolverConfigTO.DependencyExtractionPattern extractionPattern : extractionPatterns) {
                Pattern pattern = Pattern.compile(extractionPattern.getFindRegex());
                Matcher matcher = pattern.matcher(content);
                logger.debug("Matching content against regular expression " + extractionPattern.getFindRegex(), new Object[0]);
                while (matcher.find()) {
                    String matchedPath = matcher.group();
                    logger.debug("Matched path: " + matchedPath + ". Apply transformations", new Object[0]);
                    if (CollectionUtils.isNotEmpty((Collection)extractionPattern.getTransforms())) {
                        for (DependencyResolverConfigTO.DependencyExtractionTransform transform : extractionPattern.getTransforms()) {
                            Pattern find = Pattern.compile(transform.getMatch());
                            Matcher replaceMatcher = find.matcher(matchedPath);
                            matchedPath = replaceMatcher.replaceAll(transform.getReplace());
                        }
                    }
                    if (this.contentService.contentExists(site, matchedPath)) {
                        logger.debug("Content exists for matched path " + matchedPath + ". Adding to the result set", new Object[0]);
                        extractedPaths.add(matchedPath);
                        continue;
                    }
                    String message = "Found reference to " + matchedPath + " in content at " + path + " but content does not exist in referenced path for site " + site + ".\nRegular expression for extracting dependencies matched string, and after applying transformation rules to get value for dependency path, that dependency path was not found in site repository as a content.";
                    logger.debug(message, new Object[0]);
                }
            }
            toRet.put(dependencyType.getName(), extractedPaths);
        }
        return toRet;
    }

    private String getConfigLocation(String site) {
        String configLocation = this.getConfigPath().replaceFirst("\\{site\\}", site);
        configLocation = configLocation + "/" + this.getConfigFileName();
        return configLocation;
    }

    public String getConfigPath() {
        return this.studioConfiguration.getProperty("studio.configuration.site.dependencyResolver.configBasePath");
    }

    public String getConfigFileName() {
        return this.studioConfiguration.getProperty("studio.configuration.site.dependencyResolver.configFileName");
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }
}

