/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.deployment;

import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.sf.json.JSONObject;
import org.apache.commons.collections.FastArrayList;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.validation.annotations.param.ValidateIntegerParam;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateSecurePathParam;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.dal.AuditFeed;
import org.craftercms.studio.api.v1.dal.DeploymentSyncHistory;
import org.craftercms.studio.api.v1.dal.ItemMetadata;
import org.craftercms.studio.api.v1.dal.PublishRequest;
import org.craftercms.studio.api.v1.dal.PublishRequestMapper;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.deployment.Deployer;
import org.craftercms.studio.api.v1.ebus.PreviewEventContext;
import org.craftercms.studio.api.v1.exception.CommitNotFoundException;
import org.craftercms.studio.api.v1.exception.EnvironmentNotFoundException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.security.AuthenticationException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v1.service.activity.ActivityService;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v1.service.dependency.DependencyService;
import org.craftercms.studio.api.v1.service.deployment.CopyToEnvironmentItem;
import org.craftercms.studio.api.v1.service.deployment.DeploymentException;
import org.craftercms.studio.api.v1.service.deployment.DeploymentHistoryProvider;
import org.craftercms.studio.api.v1.service.deployment.DeploymentService;
import org.craftercms.studio.api.v1.service.deployment.DmPublishService;
import org.craftercms.studio.api.v1.service.event.EventService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.service.objectstate.State;
import org.craftercms.studio.api.v1.service.objectstate.TransitionEvent;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.DmDeploymentTaskTO;
import org.craftercms.studio.api.v1.to.PublishStatus;
import org.craftercms.studio.api.v1.to.PublishingChannelTO;
import org.craftercms.studio.api.v1.to.PublishingTargetTO;
import org.craftercms.studio.api.v1.to.RepoOperationTO;
import org.craftercms.studio.api.v1.util.DmContentItemComparator;
import org.craftercms.studio.api.v1.util.StudioConfiguration;
import org.craftercms.studio.api.v1.util.filter.DmFilterWrapper;
import org.craftercms.studio.api.v2.service.notification.NotificationService;
import org.craftercms.studio.impl.v1.service.deployment.DeploymentServiceImpl;
import org.craftercms.studio.impl.v1.service.deployment.job.DeployContentToEnvironmentStore;
import org.craftercms.studio.impl.v1.util.ContentUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DeploymentServiceImpl
implements DeploymentService {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentServiceImpl.class);
    private static int CTED_AUTOINCREMENT = 0;
    protected ServicesConfig servicesConfig;
    protected ContentService contentService;
    protected ActivityService activityService;
    protected DependencyService dependencyService;
    protected DmFilterWrapper dmFilterWrapper;
    protected SiteService siteService;
    protected ObjectStateService objectStateService;
    protected ObjectMetadataManager objectMetadataManager;
    protected ContentRepository contentRepository;
    protected DmPublishService dmPublishService;
    protected SecurityService securityService;
    protected EventService eventService;
    protected DeployContentToEnvironmentStore deployContentToEnvironmentStoreJob;
    protected NotificationService notificationService;
    protected DeploymentHistoryProvider deploymentHistoryProvider;
    protected StudioConfiguration studioConfiguration;
    @Autowired
    protected PublishRequestMapper publishRequestMapper;

    @ValidateParams
    public void deploy(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="environment") String environment, List<String> paths, ZonedDateTime scheduledDate, @ValidateStringParam(name="approver") String approver, @ValidateStringParam(name="submissionComment") String submissionComment, boolean scheduleDateNow) throws DeploymentException {
        if (scheduledDate != null && scheduledDate.isAfter(ZonedDateTime.now(ZoneOffset.UTC))) {
            this.objectStateService.transitionBulk(site, paths, TransitionEvent.SUBMIT_WITHOUT_WORKFLOW_SCHEDULED, State.NEW_SUBMITTED_NO_WF_SCHEDULED);
        }
        ArrayList<String> newPaths = new ArrayList<String>();
        ArrayList<String> updatedPaths = new ArrayList<String>();
        ArrayList<String> movedPaths = new ArrayList<String>();
        HashMap<String, ArrayList<String>> groupedPaths = new HashMap<String, ArrayList<String>>();
        for (String string : paths) {
            boolean isFolder = this.contentRepository.isFolder(site, string);
            if (isFolder) {
                logger.debug("Content item at path " + string + " for site " + site + " is folder and will not be added to publishing queue.", new Object[0]);
                continue;
            }
            if (this.objectStateService.isNew(site, string)) {
                newPaths.add(string);
                continue;
            }
            if (this.objectMetadataManager.isRenamed(site, string)) {
                movedPaths.add(string);
                continue;
            }
            updatedPaths.add(string);
        }
        groupedPaths.put("NEW", newPaths);
        groupedPaths.put("MOVE", movedPaths);
        groupedPaths.put("UPDATE", updatedPaths);
        environment = this.resolveEnvironment(site, environment);
        List items = this.createItems(site, environment, groupedPaths, scheduledDate, approver, submissionComment);
        for (PublishRequest item : items) {
            this.publishRequestMapper.insertItemForDeployment(item);
        }
        this.objectStateService.setSystemProcessingBulk(site, paths, false);
        try {
            this.sendContentApprovalEmail(items, scheduleDateNow);
        }
        catch (Exception exception) {
            logger.error("Error sending approval notification ", exception, new Object[0]);
        }
        String string = this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.queued");
        try {
            this.siteService.updatePublishingStatusMessage(site, string);
        }
        catch (SiteNotFoundException e) {
            logger.error("Error updating publishing status for site " + site, new Object[0]);
        }
    }

    private String resolveEnvironment(String site, String environment) {
        String toRet = environment;
        List publishingTargets = this.siteService.getPublishingTargetsForSite(site);
        for (PublishingTargetTO target : publishingTargets) {
            if (!target.getDisplayLabel().equals(environment)) continue;
            toRet = target.getRepoBranchName();
            break;
        }
        return toRet;
    }

    protected void sendContentApprovalEmail(List<PublishRequest> itemList, boolean scheduleDateNow) {
        for (PublishRequest listItem : itemList) {
            ItemMetadata itemMetadata = this.objectMetadataManager.getProperties(listItem.getSite(), listItem.getPath());
            if (itemMetadata == null || itemMetadata.getSendEmail() != 1) continue;
            this.notificationService.notifyContentApproval(listItem.getSite(), itemMetadata.getSubmittedBy(), this.getPathRelativeToSite(itemList), listItem.getUser(), scheduleDateNow ? null : listItem.getScheduledDate(), Locale.ENGLISH);
            break;
        }
    }

    private List<String> getPathRelativeToSite(List<PublishRequest> itemList) {
        ArrayList<String> paths = new ArrayList<String>(itemList.size());
        for (PublishRequest copyToEnvironment : itemList) {
            paths.add(copyToEnvironment.getPath());
        }
        return paths;
    }

    private List<PublishRequest> createItems(String site, String environment, Map<String, List<String>> paths, ZonedDateTime scheduledDate, String approver, String submissionComment) {
        ArrayList<PublishRequest> newItems = new ArrayList<PublishRequest>();
        String packageId = UUID.randomUUID().toString();
        HashMap<String, String> params = null;
        for (String action : paths.keySet()) {
            for (String path : paths.get(action)) {
                String commitId;
                PublishRequest item = new PublishRequest();
                ItemMetadata metadata = this.objectMetadataManager.getProperties(site, path);
                if (metadata == null) continue;
                params = new HashMap<String, String>();
                params.put("site_id", site);
                params.put("environment", environment);
                params.put("state", "READY_FOR_LIVE");
                params.put("path", path);
                params.put("commitId", metadata.getCommitId());
                if (this.publishRequestMapper.checkItemQueued(params) > 0) {
                    logger.info("Path " + path + " with commit ID " + metadata.getCommitId() + " already has queued publishing request for environment " + environment + " of site " + site + ". Adding another publishing request is skipped.", new Object[0]);
                    continue;
                }
                item.setId((long)(++CTED_AUTOINCREMENT));
                item.setSite(site);
                item.setEnvironment(environment);
                item.setPath(path);
                item.setScheduledDate(scheduledDate);
                item.setState("READY_FOR_LIVE");
                item.setAction(action);
                if (metadata.getRenamed() > 0) {
                    String oldPath = metadata.getOldUrl();
                    item.setOldPath(oldPath);
                }
                if (StringUtils.isNotEmpty((CharSequence)(commitId = metadata.getCommitId()))) {
                    item.setCommitId(commitId);
                } else {
                    item.setCommitId(this.contentRepository.getRepoLastCommitId(site));
                }
                String contentTypeClass = this.contentService.getContentTypeClass(site, path);
                item.setContentTypeClass(contentTypeClass);
                item.setUser(approver);
                item.setSubmissionComment(submissionComment);
                item.setPackageId(packageId);
                newItems.add(item);
            }
        }
        return newItems;
    }

    @ValidateParams
    public void delete(@ValidateStringParam(name="site") String site, List<String> paths, @ValidateStringParam(name="approver") String approver, ZonedDateTime scheduledDate) throws DeploymentException {
        if (scheduledDate != null && scheduledDate.isAfter(ZonedDateTime.now(ZoneOffset.UTC))) {
            this.objectStateService.transitionBulk(site, paths, TransitionEvent.DELETE, State.NEW_DELETED);
        }
        Set environments = this.getAllPublishingEnvironments(site);
        for (String environment : environments) {
            List items = this.createDeleteItems(site, environment, paths, approver, scheduledDate);
            for (PublishRequest item : items) {
                this.publishRequestMapper.insertItemForDeployment(item);
            }
        }
        this.objectStateService.setSystemProcessingBulk(site, paths, false);
        String statusMessage = this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.queued");
        try {
            this.siteService.updatePublishingStatusMessage(site, statusMessage);
        }
        catch (SiteNotFoundException e) {
            logger.error("Error updating publishing status for site " + site, new Object[0]);
        }
    }

    protected Set<String> getAllPublishingEnvironments(String site) {
        List publishingTargets = this.siteService.getPublishingTargetsForSite(site);
        HashSet<String> environments = new HashSet<String>();
        if (publishingTargets != null && publishingTargets.size() > 0) {
            for (PublishingTargetTO target : publishingTargets) {
                if (!StringUtils.isNotEmpty((CharSequence)target.getRepoBranchName())) continue;
                environments.add(target.getRepoBranchName());
            }
        }
        return environments;
    }

    private List<PublishRequest> createDeleteItems(String site, String environment, List<String> paths, String approver, ZonedDateTime scheduledDate) {
        ArrayList<PublishRequest> newItems = new ArrayList<PublishRequest>(paths.size());
        String packageId = UUID.randomUUID().toString();
        for (String path : paths) {
            if (!this.contentService.contentExists(site, path)) continue;
            ContentItemTO contentItem = this.contentService.getContentItem(site, path, 0);
            if (!contentItem.isFolder()) {
                String lastRepoCommitId;
                PublishRequest item = new PublishRequest();
                ItemMetadata metadata = this.objectMetadataManager.getProperties(site, path);
                item.setId((long)(++CTED_AUTOINCREMENT));
                item.setSite(site);
                item.setEnvironment(environment);
                item.setPath(path);
                item.setScheduledDate(scheduledDate);
                item.setState("READY_FOR_LIVE");
                item.setAction("DELETE");
                if (metadata != null) {
                    String commitId;
                    if (metadata.getRenamed() > 0) {
                        String oldPath = metadata.getOldUrl();
                        item.setOldPath(oldPath);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(commitId = metadata.getCommitId()))) {
                        item.setCommitId(commitId);
                    } else {
                        item.setCommitId(this.contentRepository.getRepoLastCommitId(site));
                    }
                }
                String contentTypeClass = this.contentService.getContentTypeClass(site, path);
                item.setContentTypeClass(contentTypeClass);
                item.setUser(approver);
                item.setPackageId(packageId);
                newItems.add(item);
                if (this.contentService.contentExists(site, path)) {
                    this.contentService.deleteContent(site, path, approver);
                    if (path.endsWith("/index.xml")) {
                        this.deleteFolder(site, path.replace("/index.xml", ""), approver);
                    }
                }
                if (!StringUtils.isNotEmpty((CharSequence)(lastRepoCommitId = this.contentRepository.getRepoLastCommitId(site)))) continue;
                item.setCommitId(lastRepoCommitId);
                continue;
            }
            RepositoryItem[] children = this.contentRepository.getContentChildren(site, path);
            ArrayList<String> childPaths = new ArrayList<String>();
            for (RepositoryItem child : children) {
                childPaths.add(child.path + "/" + child.name);
            }
            newItems.addAll(this.createDeleteItems(site, environment, childPaths, approver, scheduledDate));
            this.deleteFolder(site, path, approver);
        }
        return newItems;
    }

    private void deleteFolder(String site, String path, String user) {
        String folderPath = path.replace("/index.xml", "");
        if (this.contentService.contentExists(site, path)) {
            RepositoryItem[] children = this.contentRepository.getContentChildren(site, path);
            if (children.length < 1) {
                if (path.endsWith("/index.xml")) {
                    this.contentService.deleteContent(site, path, true, user);
                    this.objectStateService.deleteObjectStatesForFolder(site, folderPath);
                    this.objectMetadataManager.deleteObjectMetadataForFolder(site, folderPath);
                    String parentPath = ContentUtils.getParentUrl((String)path);
                    this.deleteFolder(site, parentPath, user);
                } else {
                    this.contentService.deleteContent(site, path, true, user);
                    this.objectStateService.deleteObjectStatesForFolder(site, folderPath);
                    this.objectMetadataManager.deleteObjectMetadataForFolder(site, folderPath);
                }
            }
        } else {
            this.objectStateService.deleteObjectStatesForFolder(site, folderPath);
            this.objectMetadataManager.deleteObjectMetadataForFolder(site, folderPath);
        }
    }

    @ValidateParams
    public void deleteDeploymentDataForSite(@ValidateStringParam(name="site") String site) {
        this.signalWorkersToStop();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        this.publishRequestMapper.deleteDeploymentDataForSite(params);
        this.signalWorkersToContinue();
    }

    private void signalWorkersToContinue() {
        DeployContentToEnvironmentStore.signalToStop((boolean)false);
    }

    private void signalWorkersToStop() {
        DeployContentToEnvironmentStore.signalToStop((boolean)true);
        while (DeployContentToEnvironmentStore.isRunning()) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                logger.info("Interrupted while waiting to stop workers", new Object[]{e});
            }
        }
    }

    @ValidateParams
    public List<PublishRequest> getScheduledItems(@ValidateStringParam(name="site") String site) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("state", "READY_FOR_LIVE");
        params.put("now", ZonedDateTime.now(ZoneOffset.UTC));
        return this.publishRequestMapper.getScheduledItems(params);
    }

    @ValidateParams
    public void cancelWorkflow(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) throws DeploymentException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("path", path);
        params.put("state", CopyToEnvironmentItem.State.READY_FOR_LIVE);
        params.put("canceledState", CopyToEnvironmentItem.State.CANCELED);
        params.put("now", ZonedDateTime.now(ZoneOffset.UTC));
        this.publishRequestMapper.cancelWorkflow(params);
    }

    @ValidateParams
    public void cancelWorkflowBulk(@ValidateStringParam(name="site") String site, Set<String> paths) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("paths", paths);
        params.put("state", CopyToEnvironmentItem.State.READY_FOR_LIVE);
        params.put("canceledState", CopyToEnvironmentItem.State.CANCELED);
        params.put("now", ZonedDateTime.now(ZoneOffset.UTC));
        this.publishRequestMapper.cancelWorkflowBulk(params);
    }

    @ValidateParams
    public List<DmDeploymentTaskTO> getDeploymentHistory(@ValidateStringParam(name="site") String site, @ValidateIntegerParam(name="daysFromToday") int daysFromToday, @ValidateIntegerParam(name="numberOfItems") int numberOfItems, @ValidateStringParam(name="sort") String sort, boolean ascending, @ValidateStringParam(name="filterType") String filterType) throws SiteNotFoundException {
        ZonedDateTime toDate = ZonedDateTime.now(ZoneOffset.UTC);
        ZonedDateTime fromDate = toDate.minusDays(daysFromToday);
        SiteFeed siteFeed = this.siteService.getSite(site);
        List deployReports = this.deploymentHistoryProvider.getDeploymentHistory(site, siteFeed.getSandboxBranch(), fromDate, toDate, this.dmFilterWrapper, filterType, numberOfItems);
        ArrayList<DmDeploymentTaskTO> tasks = new ArrayList<DmDeploymentTaskTO>();
        if (deployReports != null) {
            int count = 0;
            String timezone = this.servicesConfig.getDefaultTimezone(site);
            HashMap processedItems = new HashMap();
            for (int index = 0; index < deployReports.size() && count < numberOfItems; ++index) {
                ContentItemTO deployedItem;
                DeploymentSyncHistory entry = (DeploymentSyncHistory)deployReports.get(index);
                String env = entry.getEnvironment();
                if (!processedItems.containsKey(env)) {
                    processedItems.put(env, new HashSet());
                }
                if (((Set)processedItems.get(env)).contains(entry.getPath()) || (deployedItem = this.getDeployedItem(entry.getSite(), entry.getPath())) == null) continue;
                deployedItem.eventDate = entry.getSyncDate();
                deployedItem.endpoint = entry.getTarget();
                deployedItem.setUser(entry.getUser());
                deployedItem.setEndpoint(entry.getEnvironment());
                String deployedLabel = entry.getSyncDate().format(DateTimeFormatter.ofPattern("MM/dd"));
                if (tasks.size() > 0) {
                    DmDeploymentTaskTO lastTask = (DmDeploymentTaskTO)tasks.get(tasks.size() - 1);
                    String lastDeployedLabel = lastTask.getInternalName();
                    if (lastDeployedLabel.equals(deployedLabel)) {
                        lastTask.setNumOfChildren(lastTask.getNumOfChildren() + 1);
                        lastTask.getChildren().add(deployedItem);
                    } else {
                        tasks.add(this.createDeploymentTask(deployedLabel, deployedItem));
                    }
                } else {
                    tasks.add(this.createDeploymentTask(deployedLabel, deployedItem));
                }
                ((Set)processedItems.get(env)).add(entry.getPath());
            }
        }
        return tasks;
    }

    protected DmDeploymentTaskTO createDeploymentTask(String deployedLabel, ContentItemTO item) {
        DmDeploymentTaskTO task = new DmDeploymentTaskTO();
        task.setInternalName(deployedLabel);
        ArrayList<ContentItemTO> taskItems = task.getChildren();
        if (taskItems == null) {
            taskItems = new ArrayList<ContentItemTO>();
            task.setChildren(taskItems);
        }
        taskItems.add(item);
        task.setNumOfChildren(taskItems.size());
        return task;
    }

    protected ContentItemTO getDeployedItem(String site, String path) {
        ContentItemTO item = null;
        if (!this.contentService.contentExists(site, path)) {
            item = this.contentService.createDummyDmContentItemForDeletedNode(site, path);
            AuditFeed activity = this.activityService.getDeletedActivity(site, path);
            if (activity != null) {
                JSONObject summaryObject = JSONObject.fromObject((Object)activity.getSummary());
                if (summaryObject.containsKey((Object)"content-type")) {
                    String contentType;
                    item.contentType = contentType = (String)summaryObject.get("content-type");
                }
                if (summaryObject.containsKey((Object)"internalName")) {
                    String internalName;
                    item.internalName = internalName = (String)summaryObject.get("internalName");
                }
                if (summaryObject.containsKey((Object)"browserUri")) {
                    String browserUri;
                    item.browserUri = browserUri = (String)summaryObject.get("browserUri");
                }
            }
            item.setLockOwner("");
        } else {
            item = this.contentService.getContentItem(site, path, 0);
        }
        return item;
    }

    @ValidateParams
    public List<ContentItemTO> getScheduledItems(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="sort") String sort, boolean ascending, @ValidateStringParam(name="subSort") String subSort, boolean subAscending, @ValidateStringParam(name="filterType") String filterType) throws ServiceException {
        if (StringUtils.isEmpty((CharSequence)sort)) {
            sort = "eventDate";
        }
        DmContentItemComparator comparator = new DmContentItemComparator(sort, ascending, true, true);
        DmContentItemComparator subComparator = new DmContentItemComparator(subSort, subAscending, true, true);
        List items = null;
        items = this.getScheduledItems(site, comparator, subComparator, filterType);
        return items;
    }

    protected List<ContentItemTO> getScheduledItems(String site, DmContentItemComparator comparator, DmContentItemComparator subComparator, String filterType) {
        FastArrayList results = new FastArrayList();
        List displayPatterns = this.servicesConfig.getDisplayInWidgetPathPatterns(site);
        List deploying = this.getScheduledItems(site);
        SimpleDateFormat format = new SimpleDateFormat("MM/dd hh:mma");
        ArrayList scheduledItems = new ArrayList();
        for (PublishRequest deploymentItem : deploying) {
            Set permissions = this.securityService.getUserPermissions(site, deploymentItem.getPath(), this.securityService.getCurrentUser(), Collections.emptyList());
            if (!permissions.contains("publish")) continue;
            this.addScheduledItem(site, deploymentItem.getEnvironment(), deploymentItem.getScheduledDate(), format, deploymentItem.getPath(), deploymentItem.getPackageId(), (List)results, comparator, subComparator, displayPatterns, filterType);
        }
        return results;
    }

    protected void addScheduledItem(String site, String environment, ZonedDateTime launchDate, SimpleDateFormat format, String path, String packageId, List<ContentItemTO> scheduledItems, DmContentItemComparator comparator, DmContentItemComparator subComparator, List<String> displayPatterns, String filterType) {
        try {
            this.addToScheduledDateList(site, environment, launchDate, format, path, packageId, scheduledItems, comparator, subComparator, displayPatterns, filterType);
            if (!path.endsWith("/index.xml") && !path.endsWith(".xml")) {
                path = path + "/" + "index.xml";
            }
        }
        catch (ServiceException e) {
            logger.error("failed to read site " + site + " path " + path + ". " + e.getMessage(), new Object[0]);
        }
    }

    protected void addToScheduledDateList(String site, String environment, ZonedDateTime launchDate, SimpleDateFormat format, String path, String packageId, List<ContentItemTO> scheduledItems, DmContentItemComparator comparator, DmContentItemComparator subComparator, List<String> displayPatterns, String filterType) throws ServiceException {
        ContentItemTO itemToAdd;
        String timeZone = this.servicesConfig.getDefaultTimezone(site);
        String dateLabel = launchDate.format(DateTimeFormatter.ofPattern(format.toPattern()));
        if (ContentUtils.matchesPatterns((String)path, displayPatterns) && this.dmFilterWrapper.accept(site, itemToAdd = this.contentService.getContentItem(site, path, 0), filterType)) {
            itemToAdd.scheduledDate = launchDate;
            itemToAdd.environment = environment;
            itemToAdd.packageId = packageId;
            boolean found = false;
            for (int index = 0; index < scheduledItems.size(); ++index) {
                ContentItemTO currDateItem = scheduledItems.get(index);
                if (currDateItem.name.equals(dateLabel)) {
                    currDateItem.addChild(itemToAdd, subComparator, false);
                    found = true;
                    break;
                }
                if (itemToAdd.scheduledDate.compareTo(currDateItem.scheduledDate) >= 0) continue;
                ContentItemTO dateItem = this.createDateItem(dateLabel, itemToAdd, comparator, timeZone);
                scheduledItems.add(index, dateItem);
                found = true;
                break;
            }
            if (!found) {
                ContentItemTO dateItem = this.createDateItem(dateLabel, itemToAdd, comparator, timeZone);
                scheduledItems.add(dateItem);
            }
        }
    }

    protected ContentItemTO createDateItem(String name, ContentItemTO itemToAdd, DmContentItemComparator comparator, String timeZone) {
        ContentItemTO dateItem = new ContentItemTO();
        dateItem.name = name;
        dateItem.internalName = name;
        dateItem.eventDate = itemToAdd.scheduledDate;
        dateItem.scheduledDate = itemToAdd.scheduledDate;
        dateItem.timezone = timeZone;
        dateItem.addChild(itemToAdd, comparator, false);
        return dateItem;
    }

    @ValidateParams
    public Map<String, List<PublishingChannelTO>> getAvailablePublishingChannelGroups(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        List channelsTO = !this.servicesConfig.isStagingEnvironmentEnabled(site) ? this.getAvailablePublishingChannelGroupsForSite(site, path) : this.getPublishedEnvironments(site);
        ArrayList<PublishingChannelTO> publishChannels = new ArrayList<PublishingChannelTO>();
        ArrayList<PublishingChannelTO> updateStatusChannels = new ArrayList<PublishingChannelTO>();
        for (PublishingChannelTO channelTO : channelsTO) {
            if (channelTO.isPublish()) {
                publishChannels.add(channelTO);
            }
            if (!channelTO.isUpdateStatus()) continue;
            updateStatusChannels.add(channelTO);
        }
        HashMap<String, List<PublishingChannelTO>> result = new HashMap<String, List<PublishingChannelTO>>();
        result.put("availablePublishChannels", publishChannels);
        result.put("availableUpdateStatusChannels", updateStatusChannels);
        return result;
    }

    protected List<PublishingChannelTO> getPublishedEnvironments(String site) {
        ArrayList<PublishingChannelTO> channelTOs = new ArrayList<PublishingChannelTO>();
        Set environments = this.getAllPublishedEnvironments(site);
        for (String ch : environments) {
            PublishingChannelTO chTO = new PublishingChannelTO();
            chTO.setName(ch);
            chTO.setPublish(true);
            chTO.setUpdateStatus(false);
            channelTOs.add(chTO);
        }
        return channelTOs;
    }

    protected Set<String> getAllPublishedEnvironments(String site) {
        HashSet<String> publishedEnvironments = new HashSet<String>();
        publishedEnvironments.add(this.servicesConfig.getLiveEnvironment(site));
        publishedEnvironments.add(this.servicesConfig.getStagingEnvironment(site));
        return publishedEnvironments;
    }

    protected List<PublishingChannelTO> getAvailablePublishingChannelGroupsForSite(String site, String path) {
        ArrayList<PublishingChannelTO> channelTOs = new ArrayList<PublishingChannelTO>();
        List channels = this.getPublishingChannels(site);
        for (String ch : channels) {
            PublishingChannelTO chTO = new PublishingChannelTO();
            chTO.setName(ch);
            chTO.setPublish(true);
            chTO.setUpdateStatus(false);
            channelTOs.add(chTO);
        }
        return channelTOs;
    }

    protected List<String> getPublishingChannels(String site) {
        ArrayList<String> channels = new ArrayList<String>();
        List publishingTargets = this.siteService.getPublishingTargetsForSite(site);
        Collections.sort(publishingTargets, new /* Unavailable Anonymous Inner Class!! */);
        for (PublishingTargetTO target : publishingTargets) {
            channels.add(target.getDisplayLabel());
        }
        return channels;
    }

    @ValidateParams
    public void syncAllContentToPreview(@ValidateStringParam(name="site") String site, boolean waitTillDone) throws ServiceException {
        PreviewEventContext context = new PreviewEventContext(waitTillDone);
        context.setSite(site);
        this.eventService.publish("studio.event.previewSync", new Object[]{context});
    }

    protected void syncFolder(String site, String path, Deployer deployer) {
        RepositoryItem[] children;
        for (RepositoryItem item : children = this.contentRepository.getContentChildren(site, path)) {
            if (item.isFolder) {
                this.syncFolder(site, item.path + "/" + item.name, deployer);
                continue;
            }
            deployer.deployFile(site, item.path + "/" + item.name);
        }
    }

    @ValidateParams
    public void bulkGoLive(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="environment") String environment, @ValidateSecurePathParam(name="path") String path) throws ServiceException {
        this.dmPublishService.bulkGoLive(site, environment, path);
    }

    @ValidateParams
    public PublishStatus getPublishStatus(@ValidateStringParam(name="site") String site) throws SiteNotFoundException {
        return this.siteService.getPublishStatus(site);
    }

    @ValidateParams
    public ZonedDateTime getLastDeploymentDate(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        return this.deploymentHistoryProvider.getLastDeploymentDate(site, path);
    }

    @ValidateParams
    public boolean enablePublishing(@ValidateStringParam(name="site") String site, boolean enabled) throws SiteNotFoundException, AuthenticationException {
        if (!this.siteService.exists(site)) {
            throw new SiteNotFoundException();
        }
        if (!this.securityService.isSiteAdmin(this.securityService.getCurrentUser(), site)) {
            throw new AuthenticationException();
        }
        boolean toRet = this.siteService.enablePublishing(site, enabled);
        String message = "";
        message = enabled ? this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.started.user") : this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.stopped.user");
        message = message.replace("{username}", this.securityService.getCurrentUser()).replace("{datetime}", ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssX")));
        this.siteService.updatePublishingStatusMessage(site, message);
        return toRet;
    }

    @ValidateParams
    public void publishCommits(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="environment") String environment, List<String> commitIds, @ValidateStringParam(name="comment") String comment) throws SiteNotFoundException, EnvironmentNotFoundException, CommitNotFoundException {
        Set environments;
        if (!this.siteService.exists(site)) {
            throw new SiteNotFoundException();
        }
        environment = this.resolveEnvironment(site, environment);
        Set set = environments = this.servicesConfig.isStagingEnvironmentEnabled(site) ? this.getAllPublishedEnvironments(site) : this.getAllPublishingEnvironments(site);
        if (!environments.contains(environment)) {
            throw new EnvironmentNotFoundException();
        }
        if (!this.checkCommitIds(site, commitIds)) {
            throw new CommitNotFoundException();
        }
        logger.debug("Creating publish request items for queue for site " + site + " environment " + environment, new Object[0]);
        List publishRequests = this.createCommitItems(site, environment, commitIds, ZonedDateTime.now(ZoneOffset.UTC), this.securityService.getCurrentUser(), comment);
        logger.debug("Insert publish request items to the queue", new Object[0]);
        for (PublishRequest request : publishRequests) {
            this.publishRequestMapper.insertItemForDeployment(request);
        }
        logger.debug("Completed adding commits to publishing queue", new Object[0]);
    }

    private boolean checkCommitIds(String site, List<String> commitIds) {
        boolean toRet = true;
        for (String commitId : commitIds) {
            toRet = toRet && this.contentRepository.commitIdExists(site, commitId);
        }
        return toRet;
    }

    private List<PublishRequest> createCommitItems(String site, String environment, List<String> commitIds, ZonedDateTime scheduledDate, String approver, String comment) {
        ArrayList<PublishRequest> newItems = new ArrayList<PublishRequest>(commitIds.size());
        String packageId = UUID.randomUUID().toString();
        logger.debug("Get repository operations for each commit id and create publish request items", new Object[0]);
        for (String commitId : commitIds) {
            logger.debug("Get repository operations for commit " + commitId, new Object[0]);
            List operations = this.contentRepository.getOperations(site, commitId + "~1", commitId);
            block7: for (RepoOperationTO op : operations) {
                logger.debug("Creating publish request item: ", new Object[0]);
                PublishRequest item = new PublishRequest();
                item.setId((long)(++CTED_AUTOINCREMENT));
                item.setSite(site);
                item.setEnvironment(environment);
                item.setScheduledDate(scheduledDate);
                item.setState("READY_FOR_LIVE");
                item.setCommitId(commitId);
                item.setUser(approver);
                item.setPackageId(packageId);
                item.setSubmissionComment(comment);
                switch (2.$SwitchMap$org$craftercms$studio$api$v1$constant$RepoOperation[op.getOperation().ordinal()]) {
                    case 1: 
                    case 2: {
                        item.setPath(op.getPath());
                        item.setAction("NEW");
                        item.setContentTypeClass(this.contentService.getContentTypeClass(site, op.getPath()));
                        break;
                    }
                    case 3: {
                        item.setPath(op.getPath());
                        item.setAction("UPDATE");
                        item.setContentTypeClass(this.contentService.getContentTypeClass(site, op.getPath()));
                        break;
                    }
                    case 4: {
                        item.setPath(op.getPath());
                        item.setAction("DELETE");
                        item.setContentTypeClass(this.contentService.getContentTypeClass(site, op.getPath()));
                        break;
                    }
                    case 5: {
                        item.setPath(op.getMoveToPath());
                        item.setOldPath(op.getPath());
                        item.setAction("MOVE");
                        item.setContentTypeClass(this.contentService.getContentTypeClass(site, op.getPath()));
                        break;
                    }
                    default: {
                        logger.error("Error: Unknown repo operation for site " + site + " operation: " + op.getOperation(), new Object[0]);
                        continue block7;
                    }
                }
                logger.debug("\tPath: " + item.getPath() + " operation: " + item.getAction(), new Object[0]);
                newItems.add(item);
            }
        }
        logger.debug("Created " + newItems.size() + " publish request items for queue", new Object[0]);
        return newItems;
    }

    public void publishItems(String site, String environment, ZonedDateTime schedule, List<String> paths, String submissionComment) throws ServiceException, DeploymentException {
        if (!this.siteService.exists(site)) {
            throw new SiteNotFoundException();
        }
        Set environements = this.getAllPublishingEnvironments(site);
        if (!environements.contains(environment)) {
            throw new EnvironmentNotFoundException();
        }
        Set dependencies = this.dependencyService.calculateDependenciesPaths(site, paths);
        HashSet<String> allPaths = new HashSet<String>();
        allPaths.addAll(paths);
        allPaths.addAll(dependencies);
        this.cancelWorkflowBulk(site, allPaths);
        ArrayList<String> asList = new ArrayList<String>();
        asList.addAll(allPaths);
        String approver = this.securityService.getCurrentUser();
        boolean scheduledDateIsNow = false;
        if (schedule == null) {
            scheduledDateIsNow = true;
            schedule = ZonedDateTime.now(ZoneOffset.UTC);
        }
        this.deploy(site, environment, asList, schedule, approver, submissionComment, scheduledDateIsNow);
    }

    public void resetStagingEnvironment(String siteId) throws ServiceException {
        if (!this.siteService.exists(siteId)) {
            throw new SiteNotFoundException(siteId);
        }
        this.contentRepository.resetStagingRepository(siteId);
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public void setDependencyService(DependencyService dependencyService) {
        this.dependencyService = dependencyService;
    }

    public void setDmFilterWrapper(DmFilterWrapper dmFilterWrapper) {
        this.dmFilterWrapper = dmFilterWrapper;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public ObjectStateService getObjectStateService() {
        return this.objectStateService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }

    public ObjectMetadataManager getObjectMetadataManager() {
        return this.objectMetadataManager;
    }

    public void setObjectMetadataManager(ObjectMetadataManager objectMetadataManager) {
        this.objectMetadataManager = objectMetadataManager;
    }

    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public DmPublishService getDmPublishService() {
        return this.dmPublishService;
    }

    public void setDmPublishService(DmPublishService dmPublishService) {
        this.dmPublishService = dmPublishService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public DeployContentToEnvironmentStore getDeployContentToEnvironmentStoreJob() {
        return this.deployContentToEnvironmentStoreJob;
    }

    public void setDeployContentToEnvironmentStoreJob(DeployContentToEnvironmentStore deployContentToEnvironmentStoreJob) {
        this.deployContentToEnvironmentStoreJob = deployContentToEnvironmentStoreJob;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public EventService getEventService() {
        return this.eventService;
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public DeploymentHistoryProvider getDeploymentHistoryProvider() {
        return this.deploymentHistoryProvider;
    }

    public void setDeploymentHistoryProvider(DeploymentHistoryProvider deploymentHistoryProvider) {
        this.deploymentHistoryProvider = deploymentHistoryProvider;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }
}

