/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.deployment.job;

import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.dal.PublishRequest;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.activity.ActivityService;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.deployment.DeploymentException;
import org.craftercms.studio.api.v1.service.deployment.PublishingManager;
import org.craftercms.studio.api.v1.service.event.EventService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.to.DeploymentItemTO;
import org.craftercms.studio.api.v1.to.PublishingTargetTO;
import org.craftercms.studio.api.v1.util.StudioConfiguration;
import org.craftercms.studio.api.v2.service.notification.NotificationService;
import org.craftercms.studio.impl.v1.job.RepositoryJob;

/*
 * Exception performing whole class analysis ignored.
 */
public class DeployContentToEnvironmentStore
extends RepositoryJob {
    private static final Logger logger = LoggerFactory.getLogger(DeployContentToEnvironmentStore.class);
    protected static final ReentrantLock singleWorkerLock = new ReentrantLock();
    private static boolean stopSignaled = false;
    private static boolean running = false;
    protected PublishingManager publishingManager;
    protected ContentRepository contentRepository;
    protected SiteService siteService;
    protected NotificationService notificationService;
    protected GeneralLockService generalLockService;
    protected EventService eventService;
    protected StudioConfiguration studioConfiguration;
    protected ActivityService activityService;
    protected ServicesConfig servicesConfig;

    public static synchronized void signalToStop(boolean toStop) {
        stopSignaled = toStop;
    }

    public static synchronized boolean isRunning() {
        return running;
    }

    public static synchronized void setRunning(boolean isRunning) {
        running = isRunning;
    }

    public void execute() {
        if (this.isMasterPublishingNode() && !stopSignaled) {
            DeployContentToEnvironmentStore.setRunning((boolean)true);
            if (singleWorkerLock.tryLock()) {
                try {
                    this.processJobs();
                }
                catch (Throwable err) {
                    logger.error("unable to execute job", new Object[]{err});
                }
                finally {
                    singleWorkerLock.unlock();
                }
            }
            DeployContentToEnvironmentStore.setRunning((boolean)false);
        }
    }

    public void processJobs() {
        block18: {
            try {
                Set siteNames = this.siteService.getAllAvailableSites();
                if (siteNames == null || siteNames.size() <= 0) break block18;
                for (String site : siteNames) {
                    try {
                        this.syncRepository(site);
                    }
                    catch (Exception e) {
                        logger.error("Failed to sync database from repository for site " + site, e, new Object[0]);
                        this.siteService.enablePublishing(site, false);
                    }
                    if (this.siteService.isPublishingEnabled(site)) {
                        if (!this.publishingManager.isPublishingBlocked(site)) {
                            String statusMessage = "";
                            try {
                                Set environments = this.getAllPublishingEnvironments(site);
                                for (String environment : environments) {
                                    logger.debug("Processing content ready for deployment for site \"{0}\"", new Object[]{site});
                                    List itemsToDeploy = this.publishingManager.getItemsReadyForDeployment(site, environment);
                                    if (itemsToDeploy == null || itemsToDeploy.size() <= 0) continue;
                                    logger.info("Starting publishing on environment " + environment + " for site " + site, new Object[0]);
                                    logger.debug("Site \"{0}\" has {1} items ready for deployment", new Object[]{site, itemsToDeploy.size()});
                                    String author = ((PublishRequest)itemsToDeploy.get(0)).getUser();
                                    StringBuilder sbComment = new StringBuilder();
                                    ArrayList completeDeploymentItemList = new ArrayList();
                                    HashSet processedPaths = new HashSet();
                                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
                                    String messagePath = "";
                                    String currentPackageId = "";
                                    try {
                                        logger.debug("Mark items as processing for site \"{0}\"", new Object[]{site});
                                        HashSet<String> packageIds = new HashSet<String>();
                                        for (PublishRequest item : itemsToDeploy) {
                                            this.processPublishingRequest(site, environment, item, completeDeploymentItemList, processedPaths);
                                            if (!StringUtils.equals((CharSequence)currentPackageId, (CharSequence)item.getPackageId())) {
                                                currentPackageId = item.getPackageId();
                                                statusMessage = this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.publishing");
                                                statusMessage = statusMessage.replace("{package_id}", currentPackageId).replace("{datetime}", ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern(sdf.toPattern())));
                                                this.siteService.updatePublishingStatusMessage(site, statusMessage);
                                            }
                                            if (!packageIds.add(item.getPackageId())) continue;
                                            sbComment.append(item.getSubmissionComment()).append("\n");
                                        }
                                        this.deploy(site, environment, completeDeploymentItemList, author, sbComment.toString());
                                        StringBuilder sbPackIds = new StringBuilder("Package(s): ");
                                        for (String packageId : packageIds) {
                                            sbPackIds.append(packageId).append(";");
                                        }
                                        this.generateWorkflowActivity(site, sbPackIds.toString(), author, ActivityService.ActivityType.PUBLISHED);
                                        this.publishingManager.markItemsCompleted(site, environment, itemsToDeploy);
                                        logger.debug("Mark deployment completed for processed items for site \"{0}\"", new Object[]{site});
                                        logger.info("Finished publishing environment " + environment + " for site " + site, new Object[0]);
                                        if (this.publishingManager.isPublishingQueueEmpty(site)) {
                                            statusMessage = this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.idle");
                                            statusMessage = statusMessage.replace("{package_id}", currentPackageId).replace("{datetime}", ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern(sdf.toPattern()))).replace("{package_size}", Integer.toString(itemsToDeploy.size()));
                                        } else {
                                            statusMessage = this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.queued");
                                        }
                                        this.siteService.updatePublishingStatusMessage(site, statusMessage);
                                    }
                                    catch (DeploymentException err) {
                                        logger.error("Error while executing deployment to environment store for site \"{0}\", number of items \"{1}\"", (Exception)((Object)err), new Object[]{site, itemsToDeploy.size()});
                                        this.publishingManager.markItemsReady(site, environment, itemsToDeploy);
                                        this.siteService.enablePublishing(site, false);
                                        statusMessage = this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.stopped.error");
                                        statusMessage = statusMessage.replace("{item_path}", messagePath).replace("{datetime}", ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern(sdf.toPattern())));
                                        this.siteService.updatePublishingStatusMessage(site, statusMessage);
                                        throw err;
                                    }
                                    catch (Exception err) {
                                        logger.error("Unexpected error while executing deployment to environment store for site \"{0}\", number of items \"{1}\"", err, new Object[]{site, itemsToDeploy.size()});
                                        this.publishingManager.markItemsReady(site, environment, itemsToDeploy);
                                        this.siteService.enablePublishing(site, false);
                                        statusMessage = this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.stopped.error");
                                        statusMessage = statusMessage.replace("{item_path}", messagePath).replace("{datetime}", ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern(sdf.toPattern())));
                                        this.siteService.updatePublishingStatusMessage(site, statusMessage);
                                        throw err;
                                    }
                                }
                                continue;
                            }
                            catch (Exception err) {
                                logger.error("Error while executing deployment to environment store for site: " + site, err, new Object[0]);
                                this.notificationService.notifyDeploymentError(site, (Throwable)err);
                                logger.info("Continue executing deployment for other sites.", new Object[0]);
                                continue;
                            }
                        }
                        logger.info("Publishing is blocked for site " + site, new Object[0]);
                        continue;
                    }
                    logger.info("Publishing is disabled for site " + site, new Object[0]);
                }
            }
            catch (Exception err) {
                logger.error("Error while executing deployment to environment store", err, new Object[0]);
                this.notificationService.notifyDeploymentError("UNKNOWN", (Throwable)err);
            }
        }
    }

    protected void generateWorkflowActivity(String site, String path, String username, ActivityService.ActivityType activityType) {
        HashMap<String, String> extraInfo = new HashMap<String, String>();
        extraInfo.put("contentType", "user");
        this.activityService.postActivity(site, username, path, activityType, ActivityService.ActivitySource.API, extraInfo);
    }

    private void processPublishingRequest(String site, String environment, PublishRequest item, List<DeploymentItemTO> completeDeploymentItemList, Set<String> processedPaths) throws ServiceException, DeploymentException {
        ArrayList missingDependencies = new ArrayList();
        HashSet missingDependenciesPaths = new HashSet();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
        String messagePath = item.getPath();
        String statusMessage = this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.busy");
        statusMessage = statusMessage.replace("{item_path}", messagePath).replace("{datetime}", ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern(sdf.toPattern())));
        this.siteService.updatePublishingStatusMessage(site, statusMessage);
        this.publishingManager.markItemsProcessing(site, environment, Arrays.asList(item));
        try {
            ArrayList<Object> deploymentItemList = new ArrayList<Object>();
            logger.debug("Processing [{0}] content item for site \"{1}\"", new Object[]{item.getPath(), site});
            DeploymentItemTO deploymentItem = this.publishingManager.processItem(item);
            if (deploymentItem != null) {
                deploymentItemList.add(deploymentItem);
            }
            logger.debug("Processing COMPLETE [{0}] content item for site \"{1}\"", new Object[]{item.getPath(), site});
            if (this.isMandatoryDependenciesCheckEnabled()) {
                logger.debug("Processing Mandatory Deps [{0}] content item for site \"{1}\"", new Object[]{item.getPath(), site});
                missingDependencies.addAll(this.publishingManager.processMandatoryDependencies(item, processedPaths, missingDependenciesPaths));
                logger.debug("Processing Mandatory Dependencies COMPLETE [{0}] content item for site \"{1}\"", new Object[]{item.getPath(), site});
            }
            deploymentItemList.addAll(missingDependencies);
            completeDeploymentItemList.addAll(deploymentItemList);
        }
        catch (DeploymentException err) {
            logger.error("Error while executing deployment to environment store for site \"{0}\",", (Exception)((Object)err), new Object[]{site});
            this.publishingManager.markItemsReady(site, environment, Arrays.asList(item));
            this.siteService.enablePublishing(site, false);
            statusMessage = this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.stopped.error");
            statusMessage = statusMessage.replace("{item_path}", messagePath).replace("{datetime}", ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern(sdf.toPattern())));
            this.siteService.updatePublishingStatusMessage(site, statusMessage);
            throw err;
        }
        catch (Exception err) {
            logger.error("Unexpected error while executing deployment to environment store for site \"{0}\", ", err, new Object[]{site});
            this.publishingManager.markItemsReady(site, environment, Arrays.asList(item));
            this.siteService.enablePublishing(site, false);
            statusMessage = this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.stopped.error");
            statusMessage = statusMessage.replace("{item_path}", messagePath).replace("{datetime}", ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern(sdf.toPattern())));
            this.siteService.updatePublishingStatusMessage(site, statusMessage);
            throw err;
        }
    }

    private void deploy(String site, String environment, List<DeploymentItemTO> items, String author, String comment) throws DeploymentException, SiteNotFoundException {
        String liveEnvironment;
        logger.debug("Deploying " + items.size() + " item(s)", new Object[0]);
        SiteFeed siteFeed = this.siteService.getSite(site);
        if (this.servicesConfig.isStagingEnvironmentEnabled(site) && StringUtils.equals((CharSequence)(liveEnvironment = this.servicesConfig.getLiveEnvironment(site)), (CharSequence)environment)) {
            String stagingEnvironment = this.servicesConfig.getStagingEnvironment(site);
            this.contentRepository.publish(site, siteFeed.getSandboxBranch(), items, stagingEnvironment, author, comment);
        }
        this.contentRepository.publish(site, siteFeed.getSandboxBranch(), items, environment, author, comment);
    }

    private Set<String> getAllPublishingEnvironments(String site) {
        HashSet<String> environments = new HashSet<String>();
        if (this.servicesConfig.isStagingEnvironmentEnabled(site)) {
            environments.add(this.servicesConfig.getLiveEnvironment(site));
            environments.add(this.servicesConfig.getStagingEnvironment(site));
        } else {
            List publishingTargets = this.siteService.getPublishingTargetsForSite(site);
            if (publishingTargets != null && publishingTargets.size() > 0) {
                for (PublishingTargetTO target : publishingTargets) {
                    if (!StringUtils.isNotEmpty((CharSequence)target.getRepoBranchName())) continue;
                    environments.add(target.getRepoBranchName());
                }
            }
        }
        return environments;
    }

    private void syncRepository(String site) throws SiteNotFoundException {
        logger.debug("Getting last verified commit for site: " + site, new Object[0]);
        SiteFeed siteFeed = this.siteService.getSite(site);
        String lastProcessedCommit = siteFeed.getLastVerifiedGitlogCommitId();
        if (StringUtils.isNotEmpty((CharSequence)lastProcessedCommit)) {
            logger.debug("Syncing database with repository for site " + site + " from last processed commit " + lastProcessedCommit, new Object[0]);
            this.siteService.syncDatabaseWithRepo(site, lastProcessedCommit);
        } else {
            logger.debug("Syncing database with repository for site " + site + " from initial commit", new Object[0]);
            this.siteService.syncDatabaseWithRepo(site, this.contentRepository.getRepoFirstCommitId(site));
        }
    }

    public boolean isMasterPublishingNode() {
        boolean toReturn = Boolean.parseBoolean(this.studioConfiguration.getProperty("studio.job.deployment.masterPublishingNode"));
        return toReturn;
    }

    public boolean isMandatoryDependenciesCheckEnabled() {
        boolean toReturn = Boolean.parseBoolean(this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.mandatoryDependenciesCheckEnabled"));
        return toReturn;
    }

    public int getProcessingChunkSize() {
        int toReturn = Integer.parseInt(this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.processingChunkSize"));
        return toReturn;
    }

    public PublishingManager getPublishingManager() {
        return this.publishingManager;
    }

    public void setPublishingManager(PublishingManager publishingManager) {
        this.publishingManager = publishingManager;
    }

    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public GeneralLockService getGeneralLockService() {
        return this.generalLockService;
    }

    public void setGeneralLockService(GeneralLockService generalLockService) {
        this.generalLockService = generalLockService;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public EventService getEventService() {
        return this.eventService;
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public ActivityService getActivityService() {
        return this.activityService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }
}

