/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.search;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.search.SearchService;
import org.craftercms.studio.api.v1.util.StudioConfiguration;

public class SearchServiceImpl
implements SearchService {
    private static final Logger logger = LoggerFactory.getLogger(SearchServiceImpl.class);
    protected StudioConfiguration studioConfiguration;
    protected CloseableHttpClient httpClient;

    public SearchServiceImpl() {
        RequestConfig requestConfig = RequestConfig.custom().setExpectContinueEnabled(true).build();
        this.httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).setDefaultRequestConfig(requestConfig).build();
    }

    @ValidateParams
    public void createIndex(@ValidateStringParam(name="siteId") String siteId) throws ServiceException {
        logger.info("Creating search index for site:" + siteId, new Object[0]);
        String requestUrl = this.studioConfiguration.getProperty("studio.preview.search.createUrl");
        HttpPost postRequest = new HttpPost(requestUrl);
        String rqBody = "{ \"id\" : \"" + siteId + "\" }";
        StringEntity requestEntity = null;
        requestEntity = new StringEntity(rqBody, ContentType.APPLICATION_JSON);
        postRequest.setEntity((HttpEntity)requestEntity);
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)postRequest);
            if (response.getStatusLine().getStatusCode() != 201) {
                throw new ServiceException("Error while creating search index for site " + siteId + ". Request URL: " + requestUrl + ". Request Body: " + rqBody + ". Response: " + IOUtils.toString((InputStream)response.getEntity().getContent()));
            }
        }
        catch (IOException e) {
            logger.error("Error while creating search index for site " + siteId, (Exception)e, new Object[0]);
            throw new ServiceException("Error while creating search index for site " + siteId, (Exception)e);
        }
        finally {
            postRequest.releaseConnection();
        }
    }

    @ValidateParams
    public void deleteIndex(@ValidateStringParam(name="siteId") String siteId) throws ServiceException {
        logger.debug("Deleting search index for site:" + siteId, new Object[0]);
        String requestUrl = this.studioConfiguration.getProperty("studio.preview.search.deleteUrl");
        requestUrl = requestUrl.replaceAll("\\{siteName\\}", siteId);
        logger.debug("Deleting search index for site:" + siteId + "URL: " + requestUrl, new Object[0]);
        HttpPost postRequest = new HttpPost(requestUrl);
        String rqBody = "{ \"delete_mode\": \"ALL_DATA_AND_CONFIG\" }";
        StringEntity requestEntity = null;
        logger.debug("Deleting search index for site:" + siteId + " using URL: " + requestUrl + " with body: " + rqBody, new Object[0]);
        requestEntity = new StringEntity(rqBody, ContentType.APPLICATION_JSON);
        postRequest.setEntity((HttpEntity)requestEntity);
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)postRequest);
            if (response.getStatusLine().getStatusCode() != 204) {
                throw new ServiceException("Error while deleting search index for site " + siteId + ". Request URL: " + requestUrl + ". Request Body: " + rqBody + ". Response: " + IOUtils.toString((InputStream)response.getEntity().getContent()));
            }
            logger.info("Deleted search index for site:" + siteId + ". HTTP Status Code: " + response.getStatusLine().getStatusCode(), new Object[0]);
        }
        catch (IOException e) {
            logger.error("Error while deleting search index for site " + siteId, (Exception)e, new Object[0]);
            throw new ServiceException("Error while deleting search index for site " + siteId, (Exception)e);
        }
        finally {
            postRequest.releaseConnection();
        }
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }
}

