/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.security;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.entitlements.exception.EntitlementException;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.studio.api.v1.dal.Group;
import org.craftercms.studio.api.v1.dal.User;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.security.AuthenticationSystemException;
import org.craftercms.studio.api.v1.exception.security.BadCredentialsException;
import org.craftercms.studio.api.v1.exception.security.GroupAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.GroupNotFoundException;
import org.craftercms.studio.api.v1.exception.security.UserAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.activity.ActivityService;
import org.craftercms.studio.impl.v1.service.security.DbWithLdapExtensionSecurityProvider;

public class AuthenticationHeadersSecurityProvider
extends DbWithLdapExtensionSecurityProvider {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationHeadersSecurityProvider.class);

    /*
     * Unable to fully structure code
     */
    public String authenticate(String username, String password) throws BadCredentialsException, AuthenticationSystemException, EntitlementException {
        if (this.isAuthenticationHeadersEnabled()) {
            AuthenticationHeadersSecurityProvider.logger.debug("Authenticating user using authentication headers.", new Object[0]);
            requestContext = RequestContext.getCurrent();
            if (requestContext != null) {
                request = requestContext.getRequest();
                securekeyHeader = request.getHeader(this.studioConfiguration.getProperty("studio.authentication.headers.secureKeyHeaderName"));
                secureKey = this.studioConfiguration.getProperty("studio.authentication.headers.secureKeyHeaderValue");
                AuthenticationHeadersSecurityProvider.logger.debug("Verifying authentication header secure key.", new Object[0]);
                if (StringUtils.equals((CharSequence)securekeyHeader, (CharSequence)secureKey)) {
                    usernameHeader = request.getHeader(this.studioConfiguration.getProperty("studio.authentication.headers.username"));
                    firstName = request.getHeader(this.studioConfiguration.getProperty("studio.authentication.headers.firstName"));
                    lastName = request.getHeader(this.studioConfiguration.getProperty("studio.authentication.headers.lastName"));
                    email = request.getHeader(this.studioConfiguration.getProperty("studio.authentication.headers.email"));
                    groups = request.getHeader(this.studioConfiguration.getProperty("studio.authentication.headers.groups"));
                    if (this.userExists(usernameHeader)) {
                        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{firstName, lastName, email})) {
                            AuthenticationHeadersSecurityProvider.logger.debug("If user already exists in studio DB, update details.", new Object[0]);
                            try {
                                success = this.updateUserInternal(usernameHeader, firstName, lastName, email);
                                if (!success) ** GOTO lbl44
                                activityType = ActivityService.ActivityType.UPDATED;
                                extraInfo = new HashMap<K, V>();
                                extraInfo.put("contentType", "user");
                                this.activityService.postActivity(this.getSystemSite(), usernameHeader, usernameHeader, activityType, ActivityService.ActivitySource.API, extraInfo);
                            }
                            catch (UserNotFoundException e) {
                                AuthenticationHeadersSecurityProvider.logger.error("Error updating user " + username + " with data from authentication headers", (Exception)e, new Object[0]);
                                throw new AuthenticationSystemException("Error updating user " + username + " with data from external authentication provider", (Throwable)e);
                            }
                        }
                    } else {
                        AuthenticationHeadersSecurityProvider.logger.debug("User does not exist in studio db. Adding user " + usernameHeader, new Object[0]);
                        try {
                            success = this.createUser(usernameHeader, password, firstName, lastName, email, true);
                            if (success) {
                                activityType = ActivityService.ActivityType.CREATED;
                                extraInfo = new HashMap<String, String>();
                                extraInfo.put("contentType", "user");
                                this.activityService.postActivity(this.getSystemSite(), usernameHeader, usernameHeader, activityType, ActivityService.ActivitySource.API, extraInfo);
                            }
                        }
                        catch (UserAlreadyExistsException e) {
                            AuthenticationHeadersSecurityProvider.logger.error("Error adding user " + username + " from authentication headers", (Exception)e, new Object[0]);
                            throw new AuthenticationSystemException("Error adding user " + username + " from external authentication provider", (Throwable)e);
                        }
                    }
lbl44:
                    // 4 sources

                    user = new User();
                    user.setUsername(usernameHeader);
                    user.setFirstname(firstName);
                    user.setLastname(lastName);
                    user.setEmail(email);
                    user.setGroups(new ArrayList<E>());
                    AuthenticationHeadersSecurityProvider.logger.debug("Update user groups in database.", new Object[0]);
                    if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{groups}) && (groupsArray = groups.split(",")).length % 2 == 0) {
                        for (i = 0; i < groupsArray.length; i += 2) {
                            siteId = groupsArray[i];
                            params = new HashMap<String, String>();
                            params.put("siteId", siteId);
                            siteFeed = this.siteFeedMapper.getSite(params);
                            if (siteFeed == null) continue;
                            g = new Group();
                            g.setName(groupsArray[i + 1]);
                            g.setExternallyManaged(1);
                            g.setDescription("Externally managed group");
                            g.setSiteId(siteFeed.getId());
                            g.setSite(siteFeed.getSiteId());
                            user.getGroups().add(g);
                            try {
                                this.upsertUserGroup(siteId, g.getName(), usernameHeader);
                                continue;
                            }
                            catch (SiteNotFoundException | GroupAlreadyExistsException | GroupNotFoundException | UserAlreadyExistsException | UserNotFoundException e) {
                                AuthenticationHeadersSecurityProvider.logger.error("Failed to upsert user groups data from authentication headers, site ID: " + siteId + " group: " + g.getName() + " username: " + usernameHeader, (Exception)e, new Object[0]);
                            }
                        }
                    }
                    token = this.createToken(user);
                    this.storeSessionTicket(token);
                    this.storeSessionUsername(username);
                    return token;
                }
            }
            AuthenticationHeadersSecurityProvider.logger.debug("Unable to authenticate user using authentication headers. Switching to other security provider(s).", new Object[0]);
            return super.authenticate(username, password);
        }
        AuthenticationHeadersSecurityProvider.logger.debug("Authentication using headers disabled. Switching to other security provider(s).", new Object[0]);
        return super.authenticate(username, password);
    }

    protected boolean isAuthenticationHeadersEnabled() {
        String enabledString = this.studioConfiguration.getProperty("studio.authentication.headers.enabled");
        return Boolean.parseBoolean(enabledString);
    }
}

