/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.crypto.CryptoUtils;
import org.craftercms.commons.entitlements.exception.EntitlementException;
import org.craftercms.commons.entitlements.model.EntitlementType;
import org.craftercms.commons.entitlements.model.Module;
import org.craftercms.commons.entitlements.validator.EntitlementValidator;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.studio.api.v1.dal.Group;
import org.craftercms.studio.api.v1.dal.GroupPerSiteResult;
import org.craftercms.studio.api.v1.dal.GroupResult;
import org.craftercms.studio.api.v1.dal.SecurityMapper;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.dal.SiteFeedMapper;
import org.craftercms.studio.api.v1.dal.User;
import org.craftercms.studio.api.v1.dal.UserProfileResult;
import org.craftercms.studio.api.v1.ebus.RepositoryEventContext;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.security.AuthenticationSystemException;
import org.craftercms.studio.api.v1.exception.security.BadCredentialsException;
import org.craftercms.studio.api.v1.exception.security.GroupAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.GroupNotFoundException;
import org.craftercms.studio.api.v1.exception.security.PasswordDoesNotMatchException;
import org.craftercms.studio.api.v1.exception.security.UserAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.UserExternallyManagedException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.job.CronJobContext;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.security.SecurityProvider;
import org.craftercms.studio.api.v1.util.StudioConfiguration;
import org.craftercms.studio.impl.v1.util.SessionTokenUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;

public class DbSecurityProvider
implements SecurityProvider {
    private static Logger logger = LoggerFactory.getLogger(DbSecurityProvider.class);
    @Autowired
    protected SecurityMapper securityMapper;
    @Autowired
    protected SiteFeedMapper siteFeedMapper;
    @Autowired
    protected EntitlementValidator entitlementValidator;
    protected StudioConfiguration studioConfiguration;

    public Set<String> getUserGroups(String user) {
        HashSet<String> userGroups = new HashSet<String>();
        List groups = this.securityMapper.getUserGroups(user);
        for (Group g : groups) {
            userGroups.add(g.getName());
        }
        return userGroups;
    }

    public Set<String> getUserGroupsPerSite(String user, String site) {
        HashSet<String> userGroups = new HashSet<String>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", user);
        params.put("siteId", site);
        List groups = this.securityMapper.getUserGroupsPerSite(params);
        for (Group g : groups) {
            userGroups.add(g.getName());
        }
        return userGroups;
    }

    public String getCurrentUser() {
        String username = null;
        RequestContext context = RequestContext.getCurrent();
        if (context != null) {
            HttpSession httpSession = context.getRequest().getSession();
            username = (String)httpSession.getAttribute("studio_user");
        } else {
            CronJobContext cronJobContext = CronJobContext.getCurrent();
            if (cronJobContext != null) {
                username = cronJobContext.getCurrentUser();
            } else {
                RepositoryEventContext repositoryEventContext = RepositoryEventContext.getCurrent();
                if (repositoryEventContext != null) {
                    username = repositoryEventContext.getCurrentUser();
                }
            }
        }
        return username;
    }

    public Map<String, Object> getUserProfile(String user) {
        List resultSet = this.securityMapper.getUserDetails(user);
        Map<String, Object> userProfile = new HashMap<String, Object>();
        List parsedRS = this.parseUserResultSet(resultSet);
        if (parsedRS != null && !parsedRS.isEmpty()) {
            userProfile = (Map)parsedRS.get(0);
        }
        return userProfile;
    }

    public List<Map<String, Object>> getAllUsers(int start, int number) {
        List resultSet = new ArrayList();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("start", start);
        params.put("number", number);
        List usernames = this.securityMapper.getAllUsersQuery(params);
        if (usernames != null && !usernames.isEmpty()) {
            params = new HashMap();
            params.put("usernames", usernames);
            resultSet = this.securityMapper.getAllUsersData(params);
        }
        return this.parseUserResultSet(resultSet);
    }

    public int getAllUsersTotal() {
        return this.securityMapper.getAllUsersQueryTotal(Collections.emptyMap());
    }

    private List<Map<String, Object>> parseUserResultSet(List<UserProfileResult> usersResultSet) {
        ArrayList<Map<String, Object>> toRet = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> userProfile = new HashMap<String, Object>();
        if (usersResultSet != null && !usersResultSet.isEmpty()) {
            String lastSite = null;
            String lastUser = null;
            ArrayList sites = new ArrayList();
            HashMap site = null;
            ArrayList<HashMap<String, String>> groups = null;
            for (UserProfileResult row : usersResultSet) {
                String siteId;
                String username = row.getUsername();
                if (!username.equals(lastUser)) {
                    if (userProfile != null && !userProfile.isEmpty()) {
                        if (site != null) {
                            if (groups != null) {
                                site.put("groups", new ArrayList(groups));
                            }
                            sites.add(site);
                        }
                        userProfile.put("sites", new ArrayList(sites));
                        toRet.add(userProfile);
                    }
                    userProfile = new HashMap();
                    userProfile.put("username", username);
                    userProfile.put("first_name", row.getFirstName());
                    userProfile.put("last_name", row.getLastName());
                    userProfile.put("email", row.getEmail());
                    userProfile.put("externally_managed", row.getExternallyManaged() > 0);
                    sites = new ArrayList();
                    groups = new ArrayList();
                    site = null;
                    lastSite = null;
                }
                if (StringUtils.isNotEmpty((CharSequence)(siteId = row.getSiteId()))) {
                    if (!siteId.equals(lastSite)) {
                        if (site != null) {
                            if (groups != null) {
                                site.put("groups", new ArrayList(groups));
                            }
                            sites.add(site);
                        }
                        site = new HashMap();
                        site.put("site_id", siteId);
                        site.put("site_name", row.getSiteName());
                        groups = new ArrayList<HashMap<String, String>>();
                    }
                    HashMap<String, String> group = new HashMap<String, String>();
                    group.put("group_name", row.getGroupName());
                    groups.add(group);
                    lastSite = siteId;
                }
                lastUser = username;
            }
            if (site != null) {
                if (groups != null) {
                    site.put("groups", new ArrayList(groups));
                }
                sites.add(site);
            }
            userProfile.put("sites", new ArrayList(sites));
            toRet.add(userProfile);
        }
        return toRet;
    }

    public List<Map<String, Object>> getUsersPerSite(String site, int start, int number) throws SiteNotFoundException {
        ArrayList<Map<String, Object>> toRet = new ArrayList<Map<String, Object>>();
        if (this.siteFeedMapper.exists(site) <= 0) {
            throw new SiteNotFoundException();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("siteId", site);
        params.put("start", start);
        params.put("number", number);
        List usernames = this.securityMapper.getUsersPerSiteQuery(params);
        if (usernames != null && !usernames.isEmpty()) {
            params = new HashMap();
            params.put("siteId", site);
            params.put("usernames", usernames);
            List resultSet = this.securityMapper.getUsersPerSiteData(params);
            HashMap<String, Object> userProfile = new HashMap<String, Object>();
            if (resultSet != null && !resultSet.isEmpty()) {
                String lastUser = null;
                ArrayList sites = new ArrayList();
                ArrayList<HashMap<String, String>> groups = null;
                for (UserProfileResult row : resultSet) {
                    String username = row.getUsername();
                    if (!username.equals(lastUser)) {
                        if (userProfile != null && !userProfile.isEmpty()) {
                            if (groups != null) {
                                userProfile.put("groups", groups);
                            }
                            toRet.add(userProfile);
                        }
                        userProfile = new HashMap();
                        userProfile.put("username", username);
                        userProfile.put("first_name", row.getFirstName());
                        userProfile.put("last_name", row.getLastName());
                        userProfile.put("email", row.getEmail());
                        userProfile.put("externally_managed", row.getExternallyManaged() > 0);
                        groups = new ArrayList<HashMap<String, String>>();
                    }
                    HashMap<String, String> group = new HashMap<String, String>();
                    group.put("group_name", row.getGroupName());
                    groups.add(group);
                    lastUser = username;
                }
                if (groups != null) {
                    userProfile.put("groups", groups);
                }
                toRet.add(userProfile);
            }
        }
        return toRet;
    }

    public int getUsersPerSiteTotal(String site) throws SiteNotFoundException {
        ArrayList toRet = new ArrayList();
        if (this.siteFeedMapper.exists(site) <= 0) {
            throw new SiteNotFoundException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", site);
        return this.securityMapper.getUsersPerSiteQueryTotal(params);
    }

    public String authenticate(String username, String password) throws BadCredentialsException, AuthenticationSystemException, EntitlementException {
        User user = this.securityMapper.getUser(username);
        if (user != null && user.isEnabled() && CryptoUtils.matchPassword((String)user.getPassword(), (String)password)) {
            String token = this.createToken(user);
            this.storeSessionTicket(token);
            this.storeSessionUsername(username);
            return token;
        }
        throw new BadCredentialsException();
    }

    protected String createToken(User user) {
        int timeout = Integer.parseInt(this.studioConfiguration.getProperty("studio.security.sessionTimeout"));
        String token = SessionTokenUtils.createToken((String)user.getUsername(), (int)timeout);
        return token;
    }

    protected void storeSessionTicket(String ticket) {
        RequestContext context = RequestContext.getCurrent();
        if (context != null) {
            HttpSession httpSession = context.getRequest().getSession();
            httpSession.setAttribute("studioSessionToken", (Object)ticket);
        }
    }

    protected void storeSessionUsername(String username) {
        RequestContext context = RequestContext.getCurrent();
        if (context != null) {
            HttpSession httpSession = context.getRequest().getSession();
            httpSession.setAttribute("studio_user", (Object)username);
        }
    }

    public boolean validateTicket(String ticket) {
        if (ticket == null) {
            ticket = this.getCurrentToken();
        }
        boolean valid = false;
        if (StringUtils.isNotEmpty((CharSequence)ticket)) {
            valid = true;
        }
        return valid;
    }

    public void addUserGroup(String groupName) {
    }

    public void addUserGroup(String parentGroup, String groupName) {
    }

    public String getCurrentToken() {
        String ticket;
        RequestContext context = RequestContext.getCurrent();
        if (context != null) {
            HttpSession httpSession = context.getRequest().getSession();
            ticket = (String)httpSession.getAttribute("studioSessionToken");
        } else {
            ticket = this.getJobOrEventTicket();
        }
        if (ticket == null) {
            ticket = "NOTICKET";
        }
        return ticket;
    }

    protected String getJobOrEventTicket() {
        String ticket = null;
        CronJobContext cronJobContext = CronJobContext.getCurrent();
        if (cronJobContext != null) {
            ticket = cronJobContext.getAuthenticationToken();
        } else {
            RepositoryEventContext repositoryEventContext = RepositoryEventContext.getCurrent();
            if (repositoryEventContext != null) {
                ticket = repositoryEventContext.getAuthenticationToken();
            }
        }
        return ticket;
    }

    public boolean groupExists(String siteId, String groupName) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("groupName", groupName);
        params.put("siteId", siteId);
        Integer result = this.securityMapper.groupExists(params);
        return result > 0;
    }

    public boolean userExists(String username) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", username);
        Integer result = this.securityMapper.userExists(params);
        return result > 0;
    }

    public boolean userExistsInGroup(String siteId, String groupName, String username) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("groupName", groupName);
        params.put("siteId", siteId);
        params.put("username", username);
        Integer result = this.securityMapper.userExistsInGroup(params);
        return result > 0;
    }

    public boolean addUserToGroup(String siteId, String groupName, String user) throws UserAlreadyExistsException, UserNotFoundException, GroupNotFoundException, SiteNotFoundException {
        if (this.siteFeedMapper.exists(siteId) <= 0) {
            throw new SiteNotFoundException();
        }
        if (!this.groupExists(siteId, groupName)) {
            throw new GroupNotFoundException();
        }
        if (!this.userExists(user)) {
            throw new UserNotFoundException();
        }
        if (this.userExistsInGroup(siteId, groupName, user)) {
            throw new UserAlreadyExistsException();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("groupName", groupName);
        params.put("siteId", siteId);
        Group group = this.securityMapper.getGroupObject(params);
        params = new HashMap();
        params.put("username", user);
        params.put("groupId", group.getId());
        this.securityMapper.addUserToGroup(params);
        return true;
    }

    public boolean removeUserFromGroup(String siteId, String groupName, String user) throws UserNotFoundException, GroupNotFoundException, SiteNotFoundException {
        if (this.siteFeedMapper.exists(siteId) <= 0) {
            throw new SiteNotFoundException();
        }
        if (!this.groupExists(siteId, groupName)) {
            throw new GroupNotFoundException();
        }
        if (!this.userExists(user) || !this.userExistsInGroup(siteId, groupName, user)) {
            throw new UserNotFoundException();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("groupName", groupName);
        params.put("siteId", siteId);
        Group group = this.securityMapper.getGroupObject(params);
        params = new HashMap();
        params.put("username", user);
        params.put("groupId", group.getId());
        this.securityMapper.removeUserFromGroup(params);
        return true;
    }

    public boolean logout() {
        this.storeSessionTicket(null);
        this.storeSessionUsername(null);
        return true;
    }

    public void addContentWritePermission(String path, String group) {
    }

    public void addConfigWritePermission(String path, String group) {
    }

    public boolean createUser(String username, String password, String firstName, String lastName, String email, boolean externallyManaged) throws UserAlreadyExistsException, EntitlementException {
        if (this.userExists(username)) {
            logger.error("Not able to create user " + username + ", already exists.", new Object[0]);
            throw new UserAlreadyExistsException("User already exists.");
        }
        long start = 0L;
        if (logger.getLevel().equals("debug")) {
            start = System.currentTimeMillis();
            logger.debug("Starting entitlement validation", new Object[0]);
        }
        this.entitlementValidator.validateEntitlement(Module.STUDIO, EntitlementType.USER, this.getAllUsersTotal(), 1);
        if (logger.getLevel().equals("debug")) {
            logger.debug("Validation completed, duration : {0} ms", new Object[]{System.currentTimeMillis() - start});
        }
        String hashedPassword = CryptoUtils.hashPassword((String)password);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("username", username);
        params.put("password", hashedPassword);
        params.put("firstname", firstName);
        params.put("lastname", lastName);
        params.put("email", email);
        params.put("externallyManaged", externallyManaged ? 1 : 0);
        try {
            this.securityMapper.createUser(params);
        }
        catch (DuplicateKeyException e) {
            logger.error("Error creating user " + username, (Exception)((Object)e), new Object[0]);
            throw new UserAlreadyExistsException("User already exists.", (Throwable)e);
        }
        return true;
    }

    public boolean deleteUser(String username) throws UserNotFoundException {
        if (!this.userExists(username)) {
            throw new UserNotFoundException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", username);
        this.securityMapper.deleteUser(params);
        return true;
    }

    public boolean updateUser(String username, String firstName, String lastName, String email) throws UserNotFoundException, UserExternallyManagedException {
        if (!this.userExists(username)) {
            throw new UserNotFoundException();
        }
        User user = this.securityMapper.getUser(username);
        if (user.getExternallyManaged() > 0) {
            throw new UserExternallyManagedException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", username);
        params.put("firstname", firstName);
        params.put("lastname", lastName);
        params.put("email", email);
        this.securityMapper.updateUser(params);
        return true;
    }

    public boolean enableUser(String username, boolean enabled) throws UserNotFoundException, UserExternallyManagedException {
        if (!this.userExists(username)) {
            throw new UserNotFoundException();
        }
        User user = this.securityMapper.getUser(username);
        if (user.getExternallyManaged() > 0) {
            throw new UserExternallyManagedException();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("username", username);
        params.put("enabled", enabled ? 1 : 0);
        this.securityMapper.enableUser(params);
        return true;
    }

    public Map<String, Object> getUserStatus(String user) throws UserNotFoundException {
        if (!this.userExists(user)) {
            throw new UserNotFoundException();
        }
        User u = this.securityMapper.getUser(user);
        HashMap<String, Object> userStatus = new HashMap<String, Object>();
        if (u != null) {
            userStatus.put("username", u.getUsername());
            userStatus.put("enabled", u.isEnabled());
        }
        return userStatus;
    }

    public boolean createGroup(String groupName, String description, String siteId, boolean externallyManaged) throws GroupAlreadyExistsException, SiteNotFoundException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("siteId", siteId);
        SiteFeed site = this.siteFeedMapper.getSite(params);
        if (site != null) {
            params = new HashMap();
            params.put("name", groupName);
            params.put("description", description);
            params.put("siteId", site.getId());
            params.put("externallyManaged", externallyManaged ? 1 : 0);
            try {
                this.securityMapper.createGroup(params);
            }
            catch (DuplicateKeyException e) {
                logger.error("Error creating group " + groupName, (Exception)((Object)e), new Object[0]);
                throw new GroupAlreadyExistsException("Group already exists.", (Throwable)e);
            }
            return true;
        }
        throw new SiteNotFoundException();
    }

    public Map<String, Object> getGroup(String site, String group) throws GroupNotFoundException, SiteNotFoundException {
        if (this.siteFeedMapper.exists(site) <= 0) {
            throw new SiteNotFoundException();
        }
        if (!this.groupExists(site, group)) {
            throw new GroupNotFoundException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("groupName", group);
        params.put("siteId", site);
        return this.securityMapper.getGroup(params);
    }

    public List<Map<String, Object>> getAllGroups(int start, int number) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("start", start);
        params.put("number", number);
        List groupIds = this.securityMapper.getAllGroupsQuery(params);
        List resultSet = new ArrayList();
        if (groupIds != null && !groupIds.isEmpty()) {
            params = new HashMap();
            params.put("groupids", groupIds);
            resultSet = this.securityMapper.getAllGroupsData(params);
        }
        return this.parseGroupResultSet(resultSet);
    }

    private List<Map<String, Object>> parseGroupResultSet(List<GroupResult> resultSet) {
        ArrayList<Map<String, Object>> toRet = new ArrayList<Map<String, Object>>();
        if (resultSet != null && !resultSet.isEmpty()) {
            String lastSite = null;
            HashMap site = null;
            ArrayList<HashMap<String, String>> groups = null;
            for (GroupResult row : resultSet) {
                String siteId = row.getSiteId();
                if (!siteId.equals(lastSite)) {
                    if (site != null) {
                        if (groups != null) {
                            site.put("groups", groups);
                        }
                        toRet.add(site);
                    }
                    site = new HashMap();
                    site.put("site_id", siteId);
                    groups = new ArrayList<HashMap<String, String>>();
                }
                HashMap<String, String> group = new HashMap<String, String>();
                group.put("group_name", row.getGroupName());
                group.put("description", row.getGroupDescription());
                groups.add(group);
                lastSite = siteId;
            }
            if (site != null) {
                if (groups != null) {
                    site.put("groups", groups);
                }
                toRet.add(site);
            }
        }
        return toRet;
    }

    public List<Map<String, Object>> getGroupsPerSite(String site, int start, int number) throws SiteNotFoundException {
        if (this.siteFeedMapper.exists(site) <= 0) {
            throw new SiteNotFoundException();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("start", start);
        params.put("number", number);
        List groupIds = this.securityMapper.getGroupsPerSiteQuery(params);
        List resultSet = new ArrayList();
        if (groupIds != null && !groupIds.isEmpty()) {
            params = new HashMap();
            params.put("site", site);
            params.put("groupids", groupIds);
            resultSet = this.securityMapper.getGroupsPerSiteData(params);
        }
        return this.parseGroupsPerSiteResultSet(resultSet);
    }

    public int getGroupsPerSiteTotal(String site) throws SiteNotFoundException {
        if (this.siteFeedMapper.exists(site) <= 0) {
            throw new SiteNotFoundException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        return this.securityMapper.getGroupsPerSiteQueryTotal(params);
    }

    private List<Map<String, Object>> parseGroupsPerSiteResultSet(List<GroupPerSiteResult> resultSet) {
        ArrayList<Map<String, Object>> toRet = new ArrayList<Map<String, Object>>();
        if (resultSet != null && !resultSet.isEmpty()) {
            String lastGroup = null;
            HashMap group = null;
            ArrayList<HashMap<String, Object>> users = null;
            for (GroupPerSiteResult row : resultSet) {
                String groupName = row.getGroupName();
                if (!groupName.equals(lastGroup)) {
                    if (group != null) {
                        if (users != null) {
                            group.put("users", users);
                        }
                        toRet.add(group);
                    }
                    group = new HashMap();
                    group.put("group_name", groupName);
                    group.put("description", row.getGroupDescription());
                    users = new ArrayList<HashMap<String, Object>>();
                }
                if (StringUtils.isNotEmpty((CharSequence)row.getUsername())) {
                    HashMap<String, Object> user = new HashMap<String, Object>();
                    user.put("username", row.getUsername());
                    user.put("first_name", row.getFirstName());
                    user.put("last_name", row.getLastName());
                    user.put("email", row.getEmail());
                    user.put("externally_managed", row.getExternallyManaged() > 0);
                    users.add(user);
                }
                lastGroup = groupName;
            }
            if (group != null) {
                if (users != null) {
                    group.put("users", users);
                }
                toRet.add(group);
            }
        }
        return toRet;
    }

    public List<Map<String, Object>> getUsersPerGroup(String site, String group, int start, int number) throws GroupNotFoundException, SiteNotFoundException {
        if (this.siteFeedMapper.exists(site) <= 0) {
            throw new SiteNotFoundException();
        }
        if (!this.groupExists(site, group)) {
            throw new GroupNotFoundException();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("siteId", site);
        params.put("groupName", group);
        params.put("start", start);
        params.put("number", number);
        List resultSet = this.securityMapper.getUsersPerGroup(params);
        ArrayList<Map<String, Object>> toRet = new ArrayList<Map<String, Object>>();
        if (resultSet != null && !resultSet.isEmpty()) {
            for (User u : resultSet) {
                HashMap<String, Object> userProfile = new HashMap<String, Object>();
                userProfile.put("username", u.getUsername());
                userProfile.put("first_name", u.getFirstname());
                userProfile.put("last_name", u.getLastname());
                userProfile.put("email", u.getEmail());
                userProfile.put("externally_managed", u.getExternallyManaged() > 0);
                toRet.add(userProfile);
            }
        }
        return toRet;
    }

    public int getUsersPerGroupTotal(String site, String group) throws GroupNotFoundException, SiteNotFoundException {
        if (this.siteFeedMapper.exists(site) <= 0) {
            throw new SiteNotFoundException();
        }
        if (!this.groupExists(site, group)) {
            throw new GroupNotFoundException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", site);
        params.put("groupName", group);
        return this.securityMapper.getUsersPerGroupTotal(params);
    }

    public boolean updateGroup(String siteId, String groupName, String description) throws GroupNotFoundException, SiteNotFoundException {
        if (this.siteFeedMapper.exists(siteId) <= 0) {
            throw new SiteNotFoundException();
        }
        if (!this.groupExists(siteId, groupName)) {
            throw new GroupNotFoundException();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("siteId", siteId);
        SiteFeed site = this.siteFeedMapper.getSite(params);
        params = new HashMap();
        params.put("groupName", groupName);
        params.put("siteId", site.getId());
        params.put("description", description);
        this.securityMapper.updateGroup(params);
        return true;
    }

    public boolean deleteGroup(String siteId, String groupName) throws GroupNotFoundException, SiteNotFoundException {
        if (this.siteFeedMapper.exists(siteId) <= 0) {
            throw new SiteNotFoundException();
        }
        if (!this.groupExists(siteId, groupName)) {
            throw new GroupNotFoundException();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("siteId", siteId);
        SiteFeed site = this.siteFeedMapper.getSite(params);
        params = new HashMap();
        params.put("groupName", groupName);
        params.put("siteId", site.getId());
        this.securityMapper.deleteGroup(params);
        return true;
    }

    public boolean changePassword(String username, String current, String newPassword) throws PasswordDoesNotMatchException, UserExternallyManagedException {
        User user = this.securityMapper.getUser(username);
        if (user.getExternallyManaged() > 0) {
            throw new UserExternallyManagedException();
        }
        if (CryptoUtils.matchPassword((String)user.getPassword(), (String)current)) {
            String hashedPassword = CryptoUtils.hashPassword((String)newPassword);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("username", username);
            params.put("password", hashedPassword);
            this.securityMapper.setUserPassword(params);
            return true;
        }
        throw new PasswordDoesNotMatchException();
    }

    public boolean setUserPassword(String username, String newPassword) throws UserNotFoundException, UserExternallyManagedException {
        if (!this.userExists(username)) {
            throw new UserNotFoundException();
        }
        User user = this.securityMapper.getUser(username);
        if (user.getExternallyManaged() > 0) {
            throw new UserExternallyManagedException();
        }
        String hashedPassword = CryptoUtils.hashPassword((String)newPassword);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", username);
        params.put("password", hashedPassword);
        this.securityMapper.setUserPassword(params);
        return true;
    }

    public boolean isSystemUser(String username) throws UserNotFoundException {
        if (!this.userExists(username)) {
            throw new UserNotFoundException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", username);
        int result = this.securityMapper.isSystemUser(params);
        return result > 0;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }
}

