/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.security;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.entitlements.exception.EntitlementException;
import org.craftercms.studio.api.v1.dal.Group;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.dal.User;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.security.AuthenticationSystemException;
import org.craftercms.studio.api.v1.exception.security.BadCredentialsException;
import org.craftercms.studio.api.v1.exception.security.GroupAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.GroupNotFoundException;
import org.craftercms.studio.api.v1.exception.security.UserAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.activity.ActivityService;
import org.craftercms.studio.impl.v1.service.security.DbSecurityProvider;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.ldap.AuthenticationException;
import org.springframework.ldap.CommunicationException;
import org.springframework.ldap.core.AuthenticatedLdapEntryContextMapper;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;

public class DbWithLdapExtensionSecurityProvider
extends DbSecurityProvider {
    private static final Logger logger = LoggerFactory.getLogger(DbWithLdapExtensionSecurityProvider.class);
    protected LdapTemplate ldapTemplate;
    protected ActivityService activityService;

    /*
     * Unable to fully structure code
     */
    public String authenticate(String username, String password) throws BadCredentialsException, AuthenticationSystemException, EntitlementException {
        mapper = new /* Unavailable Anonymous Inner Class!! */;
        ldapQuery = LdapQueryBuilder.query().where(this.studioConfiguration.getProperty("studio.security.ldap.userAttribute.username")).is(username);
        try {
            user = (User)this.ldapTemplate.authenticate((LdapQuery)ldapQuery, password, (AuthenticatedLdapEntryContextMapper)mapper);
        }
        catch (EmptyResultDataAccessException e) {
            DbWithLdapExtensionSecurityProvider.logger.info("User " + username + " not found with external security provider. Trying to authenticate against studio database", new Object[0]);
            return super.authenticate(username, password);
        }
        catch (CommunicationException e) {
            DbWithLdapExtensionSecurityProvider.logger.info("Failed to connect with external security provider. Trying to authenticate against studio database", new Object[0]);
            return super.authenticate(username, password);
        }
        catch (AuthenticationException e) {
            DbWithLdapExtensionSecurityProvider.logger.error("Authentication failed with the LDAP system", (Exception)e, new Object[0]);
            throw new BadCredentialsException();
        }
        catch (Exception e) {
            DbWithLdapExtensionSecurityProvider.logger.error("Authentication failed with the LDAP system", e, new Object[0]);
            throw new AuthenticationSystemException("Authentication failed with the LDAP system", (Throwable)e);
        }
        if (user != null) {
            if (super.userExists(username)) {
                try {
                    success = this.updateUserInternal(user.getUsername(), user.getFirstname(), user.getLastname(), user.getEmail());
                    if (!success) ** GOTO lbl44
                    activityType = ActivityService.ActivityType.UPDATED;
                    extraInfo = new HashMap<String, String>();
                    extraInfo.put("contentType", "user");
                    this.activityService.postActivity(this.getSystemSite(), user.getUsername(), user.getUsername(), activityType, ActivityService.ActivitySource.API, extraInfo);
                }
                catch (UserNotFoundException e) {
                    DbWithLdapExtensionSecurityProvider.logger.error("Error updating user " + username + " with data from external authentication provider", (Exception)e, new Object[0]);
                    throw new AuthenticationSystemException("Error updating user " + username + " with data from external authentication provider", (Throwable)e);
                }
            } else {
                try {
                    success = this.createUser(user.getUsername(), password, user.getFirstname(), user.getLastname(), user.getEmail(), true);
                    if (success) {
                        activityType = ActivityService.ActivityType.CREATED;
                        extraInfo = new HashMap<K, V>();
                        extraInfo.put("contentType", "user");
                        this.activityService.postActivity(this.getSystemSite(), user.getUsername(), user.getUsername(), activityType, ActivityService.ActivitySource.API, extraInfo);
                    }
                }
                catch (UserAlreadyExistsException e) {
                    DbWithLdapExtensionSecurityProvider.logger.error("Error adding user " + username + " from external authentication provider", (Exception)e, new Object[0]);
                    throw new AuthenticationSystemException("Error adding user " + username + " from external authentication provider", (Throwable)e);
                }
            }
lbl44:
            // 5 sources

            for (Group group : user.getGroups()) {
                try {
                    this.upsertUserGroup(group.getSite(), group.getName(), user.getUsername());
                }
                catch (SiteNotFoundException | GroupAlreadyExistsException | GroupNotFoundException | UserAlreadyExistsException | UserNotFoundException e) {
                    DbWithLdapExtensionSecurityProvider.logger.error("Failed to upsert user groups data from LDAP", (Exception)e, new Object[0]);
                }
            }
            token = this.createToken(user);
            this.storeSessionTicket(token);
            this.storeSessionUsername(username);
            return token;
        }
        DbWithLdapExtensionSecurityProvider.logger.error("Failed to retrieve LDAP user details", new Object[0]);
        throw new AuthenticationSystemException("Failed to retrieve LDAP user details");
    }

    private String extractGroupNameFromAttributeValue(String groupAttributeValue) {
        Pattern pattern = Pattern.compile(this.studioConfiguration.getProperty("studio.security.ldap.userAttribute.groupName.regex"));
        Matcher matcher = pattern.matcher(groupAttributeValue);
        if (matcher.matches()) {
            int index = Integer.parseInt(this.studioConfiguration.getProperty("studio.security.ldap.userAttribute.groupName.matchIndex"));
            return matcher.group(index);
        }
        return "";
    }

    private String[] extractSiteIdAndGroupNameFromAttributeValue(String siteIdAttributeValue) {
        Pattern pattern = Pattern.compile(this.studioConfiguration.getProperty("studio.security.ldap.userAttribute.siteId.regex"));
        Matcher matcher = pattern.matcher(siteIdAttributeValue);
        if (matcher.matches()) {
            int siteIdIndex = Integer.parseInt(this.studioConfiguration.getProperty("studio.security.ldap.userAttribute.siteId.matchIndex"));
            int groupNameIndex = Integer.parseInt(this.studioConfiguration.getProperty("studio.security.ldap.userAttribute.siteId.groupName.matchIndex"));
            String siteName = matcher.group(siteIdIndex);
            String groupName = null;
            if (groupNameIndex <= matcher.groupCount()) {
                groupName = matcher.group(groupNameIndex);
            }
            if (groupName != null) {
                return new String[]{siteName, groupName};
            }
            return new String[]{siteName};
        }
        return new String[0];
    }

    private void extractGroupsFromAttribute(User user, String groupNameAttribName, Attribute groupNameAttrib, SiteFeed siteFeed) throws NamingException {
        if (groupNameAttrib != null && groupNameAttrib.size() > 0) {
            NamingEnumeration<?> groupAttribValues = groupNameAttrib.getAll();
            while (groupAttribValues.hasMore()) {
                String groupName;
                Object groupNameObj = groupAttribValues.next();
                if (groupNameObj == null || !StringUtils.isNotEmpty((CharSequence)(groupName = this.extractGroupNameFromAttributeValue(groupNameObj.toString())))) continue;
                this.addGroupToUser(user, groupName, siteFeed);
            }
        } else {
            logger.debug("No LDAP attribute " + groupNameAttribName + " found for username " + user.getUsername(), new Object[0]);
        }
    }

    private void addGroupToUser(User user, String groupName, SiteFeed siteFeed) {
        Group group = new Group();
        group.setName(groupName);
        group.setExternallyManaged(1);
        group.setDescription("Externally managed group");
        group.setSiteId(siteFeed.getId());
        group.setSite(siteFeed.getSiteId());
        user.getGroups().add(group);
    }

    protected boolean updateUserInternal(String username, String firstName, String lastName, String email) throws UserNotFoundException {
        if (!this.userExists(username)) {
            throw new UserNotFoundException();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("username", username);
        params.put("firstname", firstName);
        params.put("lastname", lastName);
        params.put("email", email);
        params.put("externallyManaged", 1);
        this.securityMapper.updateUser(params);
        return true;
    }

    protected boolean upsertUserGroup(String siteId, String groupName, String username) throws GroupAlreadyExistsException, SiteNotFoundException, UserNotFoundException, UserAlreadyExistsException, GroupNotFoundException {
        boolean success;
        if (!this.groupExists(siteId, groupName)) {
            this.createGroup(groupName, "Externally managed group", siteId, true);
        }
        if (!this.userExistsInGroup(siteId, groupName, username) && (success = this.addUserToGroup(siteId, groupName, username))) {
            ActivityService.ActivityType activityType = ActivityService.ActivityType.ADD_USER_TO_GROUP;
            HashMap<String, String> extraInfo = new HashMap<String, String>();
            extraInfo.put("contentType", "user");
            this.activityService.postActivity(siteId, "LDAP", username + " > " + groupName, activityType, ActivityService.ActivitySource.API, extraInfo);
        }
        return true;
    }

    public String getSystemSite() {
        return this.studioConfiguration.getProperty("studio.configuration.global.systemSite");
    }

    public LdapTemplate getLdapTemplate() {
        return this.ldapTemplate;
    }

    public void setLdapTemplate(LdapTemplate ldapTemplate) {
        this.ldapTemplate = ldapTemplate;
    }

    public ActivityService getActivityService() {
        return this.activityService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ String[] access$100(DbWithLdapExtensionSecurityProvider x0, String x1) {
        return x0.extractSiteIdAndGroupNameFromAttributeValue(x1);
    }

    static /* synthetic */ void access$200(DbWithLdapExtensionSecurityProvider x0, User x1, String x2, SiteFeed x3) {
        x0.addGroupToUser(x1, x2, x3);
    }

    static /* synthetic */ void access$300(DbWithLdapExtensionSecurityProvider x0, User x1, String x2, Attribute x3, SiteFeed x4) throws NamingException {
        x0.extractGroupsFromAttribute(x1, x2, x3, x4);
    }
}

