/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.craftercms.commons.entitlements.exception.EntitlementException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.security.AuthenticationSystemException;
import org.craftercms.studio.api.v1.exception.security.BadCredentialsException;
import org.craftercms.studio.api.v1.exception.security.GroupAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.GroupNotFoundException;
import org.craftercms.studio.api.v1.exception.security.PasswordDoesNotMatchException;
import org.craftercms.studio.api.v1.exception.security.UserAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.UserExternallyManagedException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.security.SecurityProvider;
import org.craftercms.studio.api.v1.util.StudioConfiguration;

public class MappedSecurityProvider
implements SecurityProvider {
    private static final Logger logger = LoggerFactory.getLogger(MappedSecurityProvider.class);
    private Map<String, SecurityProvider> providerMap = new HashMap();
    protected StudioConfiguration studioConfiguration;

    public Map<String, SecurityProvider> getProviderMap() {
        return this.providerMap;
    }

    public void setProviderMap(Map<String, SecurityProvider> map) {
        this.providerMap = map;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public String getProviderType() {
        return this.studioConfiguration.getProperty("studio.security.type");
    }

    public void registerSecurityProvider(String type, SecurityProvider provider) {
        logger.debug("Registering Security Provider: ({0}) with class: '{1}'", new Object[]{type, "" + provider});
        this.providerMap.put(type, provider);
    }

    protected SecurityProvider lookupProvider(String key) {
        SecurityProvider provider = (SecurityProvider)this.providerMap.get(key);
        if (provider == null) {
            throw new RuntimeException("provider type '" + key + "' not found.  Check server config.");
        }
        return provider;
    }

    public Set<String> getUserGroups(String user) {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.getUserGroups(user);
    }

    public Set<String> getUserGroupsPerSite(String user, String site) {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.getUserGroupsPerSite(user, site);
    }

    public String getCurrentUser() {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.getCurrentUser();
    }

    public Map<String, Object> getUserProfile(String user) {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.getUserProfile(user);
    }

    public String authenticate(String username, String password) throws BadCredentialsException, AuthenticationSystemException, EntitlementException {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.authenticate(username, password);
    }

    public boolean validateTicket(String ticket) {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.validateTicket(ticket);
    }

    public void addUserGroup(String groupName) {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        provider.addUserGroup(groupName);
    }

    public void addUserGroup(String parentGroup, String groupName) {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        provider.addUserGroup(parentGroup, groupName);
    }

    public String getCurrentToken() {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.getCurrentToken();
    }

    public boolean groupExists(String siteId, String groupName) {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.groupExists(siteId, groupName);
    }

    public boolean userExists(String username) {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.userExists(username);
    }

    public boolean userExistsInGroup(String siteId, String groupName, String username) {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.userExistsInGroup(siteId, groupName, username);
    }

    public boolean addUserToGroup(String siteId, String groupName, String user) throws UserNotFoundException, UserAlreadyExistsException, GroupNotFoundException, SiteNotFoundException {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.addUserToGroup(siteId, groupName, user);
    }

    public boolean logout() {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.logout();
    }

    public void addContentWritePermission(String path, String group) {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        provider.addContentWritePermission(path, group);
    }

    public void addConfigWritePermission(String path, String group) {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        provider.addContentWritePermission(path, group);
    }

    public boolean createUser(String username, String password, String firstName, String lastName, String email, boolean externallyManaged) throws UserAlreadyExistsException, EntitlementException {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.createUser(username, password, firstName, lastName, email, externallyManaged);
    }

    public boolean deleteUser(String username) throws UserNotFoundException {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.deleteUser(username);
    }

    public boolean updateUser(String username, String firstName, String lastName, String email) throws UserNotFoundException, UserExternallyManagedException {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.updateUser(username, firstName, lastName, email);
    }

    public boolean enableUser(String username, boolean enabled) throws UserNotFoundException, UserExternallyManagedException {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.enableUser(username, enabled);
    }

    public Map<String, Object> getUserStatus(String username) throws UserNotFoundException {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.getUserStatus(username);
    }

    public boolean createGroup(String groupName, String description, String siteId, boolean exterenallyManaged) throws GroupAlreadyExistsException, SiteNotFoundException {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.createGroup(groupName, description, siteId, exterenallyManaged);
    }

    public List<Map<String, Object>> getAllUsers(int start, int number) {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.getAllUsers(start, number);
    }

    public int getAllUsersTotal() {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.getAllUsersTotal();
    }

    public List<Map<String, Object>> getUsersPerSite(String site, int start, int number) throws SiteNotFoundException {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.getUsersPerSite(site, start, number);
    }

    public int getUsersPerSiteTotal(String site) throws SiteNotFoundException {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.getUsersPerSiteTotal(site);
    }

    public Map<String, Object> getGroup(String site, String group) throws GroupNotFoundException, SiteNotFoundException {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.getGroup(site, group);
    }

    public List<Map<String, Object>> getAllGroups(int start, int number) {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.getAllGroups(start, number);
    }

    public List<Map<String, Object>> getGroupsPerSite(String site, int start, int number) throws SiteNotFoundException {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.getGroupsPerSite(site, start, number);
    }

    public int getGroupsPerSiteTotal(String site) throws SiteNotFoundException {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.getGroupsPerSiteTotal(site);
    }

    public List<Map<String, Object>> getUsersPerGroup(String site, String group, int start, int number) throws GroupNotFoundException, SiteNotFoundException {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.getUsersPerGroup(site, group, start, number);
    }

    public int getUsersPerGroupTotal(String site, String group) throws GroupNotFoundException, SiteNotFoundException {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.getUsersPerGroupTotal(site, group);
    }

    public boolean updateGroup(String siteId, String groupName, String description) throws GroupNotFoundException, SiteNotFoundException {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.updateGroup(siteId, groupName, description);
    }

    public boolean deleteGroup(String siteId, String groupName) throws GroupNotFoundException, SiteNotFoundException {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.deleteGroup(siteId, groupName);
    }

    public boolean removeUserFromGroup(String siteId, String groupName, String user) throws UserNotFoundException, GroupNotFoundException, SiteNotFoundException {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.removeUserFromGroup(siteId, groupName, user);
    }

    public boolean changePassword(String username, String current, String newPassword) throws PasswordDoesNotMatchException, UserExternallyManagedException {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.changePassword(username, current, newPassword);
    }

    public boolean setUserPassword(String username, String newPassword) throws UserNotFoundException, UserExternallyManagedException {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.setUserPassword(username, newPassword);
    }

    public boolean isSystemUser(String username) throws UserNotFoundException {
        SecurityProvider provider = this.lookupProvider(this.getProviderType());
        return provider.isSystemUser(username);
    }
}

