/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.security;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.entitlements.exception.EntitlementException;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.commons.validation.annotations.param.ValidateIntegerParam;
import org.craftercms.commons.validation.annotations.param.ValidateNoTagsParam;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateSecurePathParam;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.security.AuthenticationSystemException;
import org.craftercms.studio.api.v1.exception.security.BadCredentialsException;
import org.craftercms.studio.api.v1.exception.security.DeleteUserNotAllowedException;
import org.craftercms.studio.api.v1.exception.security.GroupAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.GroupNotFoundException;
import org.craftercms.studio.api.v1.exception.security.PasswordDoesNotMatchException;
import org.craftercms.studio.api.v1.exception.security.UserAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.UserExternallyManagedException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.activity.ActivityService;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.ContentTypeService;
import org.craftercms.studio.api.v1.service.security.SecurityProvider;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.security.UserDetailsManager;
import org.craftercms.studio.api.v1.to.ContentTypeConfigTO;
import org.craftercms.studio.api.v1.to.PermissionsConfigTO;
import org.craftercms.studio.api.v1.util.StudioConfiguration;
import org.craftercms.studio.impl.v1.util.SessionTokenUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfig;

public class SecurityServiceImpl
implements SecurityService {
    private static final Logger logger = LoggerFactory.getLogger(SecurityServiceImpl.class);
    protected SecurityProvider securityProvider;
    protected ContentTypeService contentTypeService;
    protected ActivityService activityService;
    protected ContentService contentService;
    protected GeneralLockService generalLockService;
    protected StudioConfiguration studioConfiguration;
    protected JavaMailSender emailService;
    protected JavaMailSender emailServiceNoAuth;
    protected UserDetailsManager userDetailsManager;
    protected ObjectFactory<FreeMarkerConfig> freeMarkerConfig;

    @ValidateParams
    public String authenticate(@ValidateStringParam(name="username") String username, @ValidateStringParam(name="password") String password) throws BadCredentialsException, AuthenticationSystemException, EntitlementException {
        String toRet = this.securityProvider.authenticate(username, password);
        if (StringUtils.isNotEmpty((CharSequence)toRet)) {
            RequestContext requestContext = RequestContext.getCurrent();
            HttpServletRequest httpServletRequest = requestContext.getRequest();
            String ipAddress = httpServletRequest.getRemoteAddr();
            ActivityService.ActivityType activityType = ActivityService.ActivityType.LOGIN;
            HashMap<String, String> extraInfo = new HashMap<String, String>();
            extraInfo.put("contentType", "user");
            this.activityService.postActivity(this.getSystemSite(), username, ipAddress, activityType, ActivityService.ActivitySource.API, extraInfo);
            logger.info("User " + username + " logged in from IP: " + ipAddress, new Object[0]);
        }
        return toRet;
    }

    @ValidateParams
    public boolean validateTicket(@ValidateStringParam(name="token") String token) {
        return this.securityProvider.validateTicket(token);
    }

    public String getCurrentUser() {
        return this.securityProvider.getCurrentUser();
    }

    public String getCurrentToken() {
        return this.securityProvider.getCurrentToken();
    }

    @ValidateParams
    public Map<String, Object> getUserProfile(@ValidateStringParam(name="user") String user) {
        Map toRet = this.securityProvider.getUserProfile(user);
        if (toRet != null && !toRet.isEmpty()) {
            String authenticationType = this.studioConfiguration.getProperty("studio.security.type");
            toRet.put("authentication_type", authenticationType);
        }
        return toRet;
    }

    @ValidateParams
    public Set<String> getUserPermissions(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, @ValidateStringParam(name="user") String user, List<String> groups) {
        HashSet roles;
        Set<String> permissions = new HashSet<String>();
        if (StringUtils.isNotEmpty((CharSequence)site)) {
            PermissionsConfigTO rolesConfig = this.loadConfiguration(site, this.getRoleMappingsFileName());
            PermissionsConfigTO permissionsConfig = this.loadConfiguration(site, this.getPermissionsFileName());
            roles = new HashSet();
            this.addUserRoles(roles, site, user);
            this.addGroupRoles(roles, site, groups, rolesConfig);
            permissions = this.populateUserPermissions(site, path, roles, permissionsConfig);
            if (path.indexOf("/site") == 0) {
                try {
                    ContentTypeConfigTO config = this.contentTypeService.getContentTypeForContent(site, path);
                    boolean isAllowed = this.contentTypeService.isUserAllowed(roles, config);
                    if (!isAllowed) {
                        logger.debug("The user is not allowed to access " + site + ":" + path + ". adding permission: " + "not allowed", new Object[0]);
                        permissions.add("not allowed");
                        return permissions;
                    }
                }
                catch (ServiceException e) {
                    logger.debug("Error while getting the content type of " + path + ". skipping user role checking on the content.", new Object[0]);
                }
            }
        }
        PermissionsConfigTO globalRolesConfig = this.loadGlobalRolesConfiguration();
        PermissionsConfigTO globalPermissionsConfig = this.loadGlobalPermissionsConfiguration();
        roles = new HashSet();
        this.addGlobalUserRoles(user, roles, globalRolesConfig);
        this.addGlobalGroupRoles(roles, groups, globalRolesConfig);
        permissions.addAll(this.populateUserGlobalPermissions(path, roles, globalPermissionsConfig));
        return permissions;
    }

    protected void addGlobalUserRoles(String user, Set<String> roles, PermissionsConfigTO rolesConfig) {
        Set groups = this.securityProvider.getUserGroupsPerSite(user, this.studioConfiguration.getProperty("studio.configuration.global.systemSite"));
        if (rolesConfig != null && groups != null) {
            Map rolesMap = rolesConfig.getRoles();
            for (String group : groups) {
                String groupName = group.replaceFirst("GROUP_", "");
                List userRoles = (List)rolesMap.get(groupName);
                if (roles == null || userRoles == null) continue;
                roles.addAll(userRoles);
            }
        }
    }

    protected void addGlobalGroupRoles(Set<String> roles, List<String> groups, PermissionsConfigTO rolesConfig) {
        if (groups != null) {
            Map rolesMap = rolesConfig.getRoles();
            for (String group : groups) {
                List groupRoles = (List)rolesMap.get(group);
                if (groupRoles == null) continue;
                logger.debug("Adding roles by group " + group + ": " + roles, new Object[0]);
                roles.addAll(groupRoles);
            }
        }
    }

    protected Set<String> populateUserGlobalPermissions(String path, Set<String> roles, PermissionsConfigTO permissionsConfig) {
        HashSet<String> permissions = new HashSet<String>();
        if (roles != null && !roles.isEmpty()) {
            for (String role : roles) {
                Map permissionsMap = permissionsConfig.getPermissions();
                Map siteRoles = (Map)permissionsMap.get("###GLOBAL###");
                if (siteRoles == null || siteRoles.isEmpty()) {
                    siteRoles = (Map)permissionsMap.get("*");
                }
                if (siteRoles != null && !siteRoles.isEmpty()) {
                    List ruleNodes = (List)siteRoles.get(role);
                    if (ruleNodes == null || ruleNodes.isEmpty()) {
                        ruleNodes = (List)siteRoles.get("*");
                    }
                    if (ruleNodes != null && !ruleNodes.isEmpty()) {
                        for (Node ruleNode : ruleNodes) {
                            String regex = ruleNode.valueOf("@regex");
                            if (!path.matches(regex)) continue;
                            logger.debug("Global permissions found by matching " + regex + " for " + role, new Object[0]);
                            List permissionNodes = ruleNode.selectNodes("allowed-permissions/permission");
                            for (Node permissionNode : permissionNodes) {
                                String permission = permissionNode.getText().toLowerCase();
                                logger.debug("adding global permissions " + permission + " to " + path + " for " + role, new Object[0]);
                                permissions.add(permission);
                            }
                        }
                        continue;
                    }
                    logger.debug("No default role is set. adding default permission: read", new Object[0]);
                    permissions.add("read");
                    continue;
                }
                logger.debug("No default site is set. adding default permission: read", new Object[0]);
                permissions.add("read");
            }
        } else {
            logger.debug("No user or group matching found. adding default permission: read", new Object[0]);
            permissions.add("read");
        }
        return permissions;
    }

    protected String getPermissionsKey(String site, String filename) {
        return new StringBuffer(site).append(":").append(filename).toString();
    }

    protected void addUserRoles(Set<String> roles, String site, String user) {
        if (!StringUtils.isEmpty((CharSequence)user)) {
            Set userRoles = this.getUserRoles(site, user);
            logger.debug("Adding roles by user: " + userRoles, new Object[0]);
            roles.addAll(userRoles);
        }
    }

    @ValidateParams
    public Set<String> getUserRoles(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="user") String user) {
        Set groups = this.securityProvider.getUserGroupsPerSite(user, site);
        if (groups != null && groups.size() > 0) {
            logger.debug("Groups for " + user + " in " + site + ": " + groups, new Object[0]);
            PermissionsConfigTO rolesConfig = this.loadConfiguration(site, this.getRoleMappingsFileName());
            HashSet<String> userRoles = new HashSet<String>();
            if (rolesConfig != null) {
                Map rolesMap = rolesConfig.getRoles();
                for (String group : groups) {
                    String groupName = group.replaceFirst("GROUP_", "");
                    List roles = (List)rolesMap.get(groupName);
                    if (roles == null) continue;
                    userRoles.addAll(roles);
                }
            }
            return userRoles;
        }
        logger.debug("No groups found for " + user + " in " + site, new Object[0]);
        return new HashSet<String>(0);
    }

    protected void addGroupRoles(Set<String> roles, String site, List<String> groups, PermissionsConfigTO rolesConfig) {
        if (groups != null) {
            Map rolesMap = rolesConfig.getRoles();
            for (String group : groups) {
                List groupRoles = (List)rolesMap.get(group);
                if (groupRoles == null) continue;
                logger.debug("Adding roles by group " + group + ": " + roles, new Object[0]);
                roles.addAll(groupRoles);
            }
        }
    }

    protected Set<String> populateUserPermissions(String site, String path, Set<String> roles, PermissionsConfigTO permissionsConfig) {
        HashSet<String> permissions = new HashSet<String>();
        if (roles != null && !roles.isEmpty()) {
            for (String role : roles) {
                Map permissionsMap = permissionsConfig.getPermissions();
                Map siteRoles = (Map)permissionsMap.get(site);
                if (siteRoles == null || siteRoles.isEmpty()) {
                    siteRoles = (Map)permissionsMap.get("*");
                }
                if (siteRoles != null && !siteRoles.isEmpty()) {
                    List ruleNodes = (List)siteRoles.get(role);
                    if (ruleNodes == null || ruleNodes.isEmpty()) {
                        ruleNodes = (List)siteRoles.get("*");
                    }
                    if (ruleNodes != null && !ruleNodes.isEmpty()) {
                        for (Node ruleNode : ruleNodes) {
                            String regex = ruleNode.valueOf("@regex");
                            if (!path.matches(regex)) continue;
                            logger.debug("Permissions found by matching " + regex + " for " + role + " in " + site, new Object[0]);
                            List permissionNodes = ruleNode.selectNodes("allowed-permissions/permission");
                            for (Node permissionNode : permissionNodes) {
                                String permission = permissionNode.getText().toLowerCase();
                                logger.debug("adding permissions " + permission + " to " + path + " for " + role + " in " + site, new Object[0]);
                                permissions.add(permission);
                            }
                        }
                        continue;
                    }
                    logger.debug("No default role is set. adding default permission: read", new Object[0]);
                    permissions.add("read");
                    continue;
                }
                logger.debug("No default site is set. adding default permission: read", new Object[0]);
                permissions.add("read");
            }
        } else {
            logger.debug("No user or group matching found. adding default permission: read", new Object[0]);
            permissions.add("read");
        }
        return permissions;
    }

    protected PermissionsConfigTO loadConfiguration(String site, String filename) {
        String siteConfigPath = this.getConfigPath().replaceFirst("\\{site\\}", site);
        String siteConfigFullPath = siteConfigPath + "/" + filename;
        Document document = null;
        PermissionsConfigTO config = null;
        try {
            document = this.contentService.getContentAsDocument(site, siteConfigFullPath);
        }
        catch (DocumentException e) {
            logger.error("Permission mapping not found for " + site + ":" + filename, new Object[0]);
        }
        if (document != null) {
            config = new PermissionsConfigTO();
            config.setMapping(document);
            Element root = document.getRootElement();
            this.loadRoles(root, config);
            this.loadPermissions(site, root, config);
            config.setKey(site + ":" + filename);
            config.setLastUpdated(ZonedDateTime.now(ZoneOffset.UTC));
        } else {
            logger.error("Permission mapping not found for " + site + ":" + filename, new Object[0]);
        }
        return config;
    }

    protected void loadRoles(Element root, PermissionsConfigTO config) {
        if (root.getName().equals("role-mappings")) {
            Map rolesMap = new HashMap();
            List userNodes = root.selectNodes("users/user");
            rolesMap = this.getRoles(userNodes, rolesMap);
            List groupNodes = root.selectNodes("groups/group");
            rolesMap = this.getRoles(groupNodes, rolesMap);
            config.setRoles(rolesMap);
        }
    }

    protected Map<String, List<String>> getRoles(List<Node> nodes, Map<String, List<String>> rolesMap) {
        for (Node node : nodes) {
            String name = node.valueOf("@name");
            if (StringUtils.isEmpty((CharSequence)name)) continue;
            List roleNodes = node.selectNodes("role");
            ArrayList<String> roles = new ArrayList<String>();
            for (Node roleNode : roleNodes) {
                roles.add(roleNode.getText());
            }
            rolesMap.put(name, roles);
        }
        return rolesMap;
    }

    protected void loadPermissions(String siteId, Element root, PermissionsConfigTO config) {
        if (root.getName().equals("permissions")) {
            HashMap permissionsMap = new HashMap();
            Element permissionsRoot = root;
            Element siteNode = (Element)permissionsRoot.selectSingleNode("site");
            if (siteNode != null) {
                permissionsRoot = siteNode;
            }
            List roleNodes = permissionsRoot.selectNodes("role");
            HashMap<String, List> rules = new HashMap<String, List>();
            for (Node roleNode : roleNodes) {
                String roleName = roleNode.valueOf("@name");
                List ruleNodes = roleNode.selectNodes("rule");
                rules.put(roleName, ruleNodes);
            }
            permissionsMap.put(siteId, rules);
            config.setPermissions(permissionsMap);
        }
    }

    @ValidateParams
    public void addUserGroup(@ValidateStringParam(name="groupName") String groupName) {
        this.securityProvider.addUserGroup(groupName);
    }

    @ValidateParams
    public void addUserGroup(@ValidateStringParam(name="parentGroup") String parentGroup, @ValidateStringParam(name="groupName") String groupName) {
        this.securityProvider.addUserGroup(parentGroup, groupName);
    }

    protected PermissionsConfigTO loadGlobalPermissionsConfiguration() {
        String globalPermissionsConfigPath = this.getGlobalConfigPath() + "/" + this.getGlobalPermissionsFileName();
        Document document = null;
        PermissionsConfigTO config = null;
        try {
            document = this.contentService.getContentAsDocument("", globalPermissionsConfigPath);
        }
        catch (DocumentException e) {
            logger.error("Global permission mapping not found (path: {0})", new Object[]{globalPermissionsConfigPath});
        }
        if (document != null) {
            config = new PermissionsConfigTO();
            config.setMapping(document);
            Element root = document.getRootElement();
            this.loadPermissions("###GLOBAL###", root, config);
            String globalPermissionsKey = "###GLOBAL###:" + this.getGlobalPermissionsFileName();
            config.setKey(globalPermissionsKey);
            config.setLastUpdated(ZonedDateTime.now(ZoneOffset.UTC));
        } else {
            logger.error("Global permission mapping not found (path: {0})", new Object[]{globalPermissionsConfigPath});
        }
        return config;
    }

    protected PermissionsConfigTO loadGlobalRolesConfiguration() {
        String globalRolesConfigPath = this.getGlobalConfigPath() + "/" + this.getGlobalRoleMappingsFileName();
        Document document = null;
        PermissionsConfigTO config = null;
        try {
            document = this.contentService.getContentAsDocument("", globalRolesConfigPath);
        }
        catch (DocumentException e) {
            logger.error("Global roles mapping not found (path: {0})", new Object[]{globalRolesConfigPath});
        }
        if (document != null) {
            config = new PermissionsConfigTO();
            config.setMapping(document);
            Element root = document.getRootElement();
            this.loadRoles(root, config);
            String globalRolesKey = "###GLOBAL###:" + this.getGlobalRoleMappingsFileName();
            config.setKey(globalRolesKey);
            config.setLastUpdated(ZonedDateTime.now(ZoneOffset.UTC));
        } else {
            logger.error("Global roles mapping not found (path: {0})", new Object[]{globalRolesConfigPath});
        }
        return config;
    }

    @ValidateParams
    public void reloadConfiguration(@ValidateStringParam(name="site") String site) {
        PermissionsConfigTO permissionsConfigTO = this.loadConfiguration(site, this.getPermissionsFileName());
        PermissionsConfigTO rolesConfigTO = this.loadConfiguration(site, this.getRoleMappingsFileName());
    }

    public void reloadGlobalConfiguration() {
        PermissionsConfigTO permissionsConfigTO = this.loadGlobalPermissionsConfiguration();
        PermissionsConfigTO rolesConfigTO = this.loadGlobalRolesConfiguration();
    }

    public boolean logout() {
        String username = this.getCurrentUser();
        boolean toRet = this.securityProvider.logout();
        RequestContext context = RequestContext.getCurrent();
        if (context != null) {
            HttpServletRequest httpServletRequest = context.getRequest();
            String ipAddress = httpServletRequest.getRemoteAddr();
            HttpSession httpSession = httpServletRequest.getSession();
            httpSession.removeAttribute("studioSessionToken");
            httpSession.invalidate();
            ActivityService.ActivityType activityType = ActivityService.ActivityType.LOGOUT;
            HashMap<String, String> extraInfo = new HashMap<String, String>();
            extraInfo.put("contentType", "user");
            this.activityService.postActivity(this.getSystemSite(), username, ipAddress, activityType, ActivityService.ActivitySource.API, extraInfo);
            logger.info("User " + username + " logged out from IP: " + ipAddress, new Object[0]);
        }
        return toRet;
    }

    @ValidateParams
    public boolean createUser(@ValidateNoTagsParam(name="username") String username, @ValidateStringParam(name="password") String password, @ValidateNoTagsParam(name="firstName") String firstName, @ValidateNoTagsParam(name="lastName") String lastName, @ValidateNoTagsParam(name="email") String email) throws UserAlreadyExistsException, EntitlementException {
        boolean toRet = this.securityProvider.createUser(username, password, firstName, lastName, email, false);
        if (toRet) {
            ActivityService.ActivityType activityType = ActivityService.ActivityType.CREATED;
            String user = this.getCurrentUser();
            HashMap<String, String> extraInfo = new HashMap<String, String>();
            extraInfo.put("contentType", "user");
            this.activityService.postActivity(this.getSystemSite(), user, username, activityType, ActivityService.ActivitySource.API, extraInfo);
        }
        return toRet;
    }

    @ValidateParams
    public boolean deleteUser(@ValidateStringParam(name="username") String username) throws UserNotFoundException, DeleteUserNotAllowedException {
        if (!this.isDeleteUserAllowed(username)) {
            throw new DeleteUserNotAllowedException();
        }
        boolean toRet = this.securityProvider.deleteUser(username);
        if (toRet) {
            ActivityService.ActivityType activityType = ActivityService.ActivityType.DELETED;
            String user = this.getCurrentUser();
            HashMap<String, String> extraInfo = new HashMap<String, String>();
            extraInfo.put("contentType", "user");
            this.activityService.postActivity(this.getSystemSite(), user, username, activityType, ActivityService.ActivitySource.API, extraInfo);
        }
        return toRet;
    }

    private boolean isDeleteUserAllowed(String username) throws UserNotFoundException {
        boolean toRet = true;
        if (toRet) {
            boolean bl = toRet = !StringUtils.equals((CharSequence)username, (CharSequence)this.getCurrentUser());
        }
        if (toRet) {
            boolean bl = toRet = !this.securityProvider.isSystemUser(username);
        }
        if (toRet) {
            toRet = !this.isAdmin(username);
        }
        return toRet;
    }

    @ValidateParams
    public boolean updateUser(@ValidateStringParam(name="username") String username, @ValidateNoTagsParam(name="firstName") String firstName, @ValidateNoTagsParam(name="lastName") String lastName, @ValidateNoTagsParam(name="email") String email) throws UserNotFoundException, UserExternallyManagedException {
        boolean toRet = this.securityProvider.updateUser(username, firstName, lastName, email);
        if (toRet) {
            ActivityService.ActivityType activityType = ActivityService.ActivityType.UPDATED;
            String user = this.getCurrentUser();
            HashMap<String, String> extraInfo = new HashMap<String, String>();
            extraInfo.put("contentType", "user");
            this.activityService.postActivity(this.getSystemSite(), user, username, activityType, ActivityService.ActivitySource.API, extraInfo);
        }
        return toRet;
    }

    @ValidateParams
    public boolean enableUser(@ValidateStringParam(name="username") String username, boolean enabled) throws UserNotFoundException, UserExternallyManagedException {
        return this.securityProvider.enableUser(username, enabled);
    }

    @ValidateParams
    public Map<String, Object> getUserStatus(@ValidateStringParam(name="username") String username) throws UserNotFoundException {
        return this.securityProvider.getUserStatus(username);
    }

    @ValidateParams
    public List<Map<String, Object>> getAllUsers(@ValidateIntegerParam(name="start") int start, @ValidateIntegerParam(name="number") int number) {
        return this.securityProvider.getAllUsers(start, number);
    }

    public int getAllUsersTotal() {
        return this.securityProvider.getAllUsersTotal();
    }

    @ValidateParams
    public List<Map<String, Object>> getUsersPerSite(@ValidateStringParam(name="site") String site, @ValidateIntegerParam(name="start") int start, @ValidateIntegerParam(name="number") int number) throws SiteNotFoundException {
        return this.securityProvider.getUsersPerSite(site, start, number);
    }

    @ValidateParams
    public int getUsersPerSiteTotal(@ValidateStringParam(name="site") String site) throws SiteNotFoundException {
        return this.securityProvider.getUsersPerSiteTotal(site);
    }

    @ValidateParams
    public boolean createGroup(@ValidateNoTagsParam(name="groupName") String groupName, @ValidateNoTagsParam(name="description") String description, @ValidateStringParam(name="siteId") String siteId) throws GroupAlreadyExistsException, SiteNotFoundException {
        return this.securityProvider.createGroup(groupName, description, siteId, false);
    }

    @ValidateParams
    public Map<String, Object> getGroup(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="group") String group) throws GroupNotFoundException, SiteNotFoundException {
        return this.securityProvider.getGroup(site, group);
    }

    @ValidateParams
    public List<Map<String, Object>> getAllGroups(@ValidateIntegerParam(name="start") int start, @ValidateIntegerParam(name="number") int number) {
        return this.securityProvider.getAllGroups(start, number);
    }

    @ValidateParams
    public List<Map<String, Object>> getGroupsPerSite(@ValidateStringParam(name="site") String site, @ValidateIntegerParam(name="start") int start, @ValidateIntegerParam(name="number") int number) throws SiteNotFoundException {
        return this.securityProvider.getGroupsPerSite(site, start, number);
    }

    @ValidateParams
    public int getGroupsPerSiteTotal(@ValidateStringParam(name="site") String site) throws SiteNotFoundException {
        return this.securityProvider.getGroupsPerSiteTotal(site);
    }

    @ValidateParams
    public List<Map<String, Object>> getUsersPerGroup(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="group") String group, @ValidateIntegerParam(name="start") int start, @ValidateIntegerParam(name="number") int number) throws GroupNotFoundException, SiteNotFoundException {
        return this.securityProvider.getUsersPerGroup(site, group, start, number);
    }

    @ValidateParams
    public int getUsersPerGroupTotal(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="group") String group) throws GroupNotFoundException, SiteNotFoundException {
        return this.securityProvider.getUsersPerGroupTotal(site, group);
    }

    @ValidateParams
    public boolean updateGroup(@ValidateStringParam(name="siteId") String siteId, @ValidateNoTagsParam(name="groupName") String groupName, @ValidateNoTagsParam(name="description") String description) throws GroupNotFoundException, SiteNotFoundException {
        return this.securityProvider.updateGroup(siteId, groupName, description);
    }

    @ValidateParams
    public boolean deleteGroup(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="group") String group) throws GroupNotFoundException, SiteNotFoundException {
        return this.securityProvider.deleteGroup(site, group);
    }

    @ValidateParams
    public boolean addUserToGroup(@ValidateStringParam(name="siteId") String siteId, @ValidateStringParam(name="groupName") String groupName, @ValidateStringParam(name="username") String username) throws UserAlreadyExistsException, UserNotFoundException, GroupNotFoundException, SiteNotFoundException {
        boolean toRet = this.securityProvider.addUserToGroup(siteId, groupName, username);
        if (toRet) {
            ActivityService.ActivityType activityType = ActivityService.ActivityType.ADD_USER_TO_GROUP;
            String user = this.getCurrentUser();
            HashMap<String, String> extraInfo = new HashMap<String, String>();
            extraInfo.put("contentType", "user");
            this.activityService.postActivity(siteId, user, username + " > " + groupName, activityType, ActivityService.ActivitySource.API, extraInfo);
        }
        return toRet;
    }

    @ValidateParams
    public boolean removeUserFromGroup(@ValidateStringParam(name="siteId") String siteId, @ValidateStringParam(name="groupName") String groupName, @ValidateStringParam(name="username") String username) throws UserNotFoundException, GroupNotFoundException, SiteNotFoundException {
        boolean toRet = this.securityProvider.removeUserFromGroup(siteId, groupName, username);
        if (toRet) {
            ActivityService.ActivityType activityType = ActivityService.ActivityType.REMOVE_USER_FROM_GROUP;
            String user = this.getCurrentUser();
            HashMap<String, String> extraInfo = new HashMap<String, String>();
            extraInfo.put("contentType", "user");
            this.activityService.postActivity(siteId, user, username + " X " + groupName, activityType, ActivityService.ActivitySource.API, extraInfo);
        }
        return toRet;
    }

    @ValidateParams
    public Map<String, Object> forgotPassword(@ValidateStringParam(name="username") String username) throws ServiceException, UserNotFoundException, UserExternallyManagedException {
        logger.debug("Getting user profile for " + username, new Object[0]);
        Map userProfile = this.securityProvider.getUserProfile(username);
        boolean success = false;
        String message = "";
        if (userProfile == null || userProfile.isEmpty()) {
            logger.info("User profile not found for " + username, new Object[0]);
            throw new UserNotFoundException();
        }
        if (Boolean.parseBoolean(userProfile.get("externally_managed").toString())) {
            throw new UserExternallyManagedException();
        }
        if (userProfile.get("email") != null) {
            String email = userProfile.get("email").toString();
            logger.debug("Creating security token for forgot password", new Object[0]);
            long timestamp = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(Long.parseLong(this.studioConfiguration.getProperty("studio.security.forgotPassword.token.timeout")));
            String salt = this.studioConfiguration.getProperty("studio.security.cipher.salt");
            String token = username + "|" + timestamp + "|" + salt;
            String hashedToken = this.encryptToken(token);
            logger.debug("Sending forgot password email to " + email, new Object[0]);
            try {
                this.sendForgotPasswordEmail(email, hashedToken);
            }
            catch (TemplateException | IOException | MessagingException e) {
                throw new ServiceException("Error while sending forgot password email", (Exception)e);
            }
        } else {
            logger.info("User " + username + " does not have assigned email with account", new Object[0]);
            throw new ServiceException("User " + username + " does not have assigned email with account");
        }
        success = true;
        message = "OK";
        HashMap<String, Object> toRet = new HashMap<String, Object>();
        toRet.put("success", success);
        toRet.put("message", message);
        return toRet;
    }

    @ValidateParams
    public boolean validateToken(@ValidateStringParam(name="token") String token) throws UserNotFoundException, UserExternallyManagedException {
        StringTokenizer tokenElements;
        boolean toRet = false;
        String decryptedToken = this.decryptToken(token);
        if (StringUtils.isNotEmpty((CharSequence)decryptedToken) && (tokenElements = new StringTokenizer(decryptedToken, "|")).countTokens() == 3) {
            String username = tokenElements.nextToken();
            Map userProfile = this.securityProvider.getUserProfile(username);
            if (userProfile == null || userProfile.isEmpty()) {
                logger.info("User profile not found for " + username, new Object[0]);
                throw new UserNotFoundException();
            }
            if (Boolean.parseBoolean(userProfile.get("externally_managed").toString())) {
                throw new UserExternallyManagedException();
            }
            long tokenTimestamp = Long.parseLong(tokenElements.nextToken());
            toRet = tokenTimestamp >= System.currentTimeMillis();
        }
        return toRet;
    }

    private String encryptToken(String token) {
        try {
            SecretKeySpec key = new SecretKeySpec(this.studioConfiguration.getProperty("studio.security.cipher.key").getBytes(), this.studioConfiguration.getProperty("studio.security.cipher.type"));
            Cipher cipher = Cipher.getInstance(this.studioConfiguration.getProperty("studio.security.cipher.algorithm"));
            byte[] tokenBytes = token.getBytes(StandardCharsets.UTF_8);
            cipher.init(1, (Key)key, new IvParameterSpec(key.getEncoded()));
            byte[] encrypted = cipher.doFinal(tokenBytes);
            return Base64.getEncoder().encodeToString(encrypted);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            logger.error("Error while encrypting forgot password token", (Exception)e, new Object[0]);
            return null;
        }
    }

    private String decryptToken(String token) {
        try {
            SecretKeySpec key = new SecretKeySpec(this.studioConfiguration.getProperty("studio.security.cipher.key").getBytes(), this.studioConfiguration.getProperty("studio.security.cipher.type"));
            Cipher cipher = Cipher.getInstance(this.studioConfiguration.getProperty("studio.security.cipher.algorithm"));
            byte[] tokenBytes = Base64.getDecoder().decode(token.getBytes(StandardCharsets.UTF_8));
            cipher.init(2, (Key)key, new IvParameterSpec(key.getEncoded()));
            byte[] decrypted = cipher.doFinal(tokenBytes);
            return new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            logger.error("Error while decrypting forgot password token", e, new Object[0]);
            return null;
        }
    }

    private void sendForgotPasswordEmail(String emailAddress, String token) throws MessagingException, IOException, TemplateException {
        try {
            Template emailTemplate = ((FreeMarkerConfig)this.freeMarkerConfig.getObject()).getConfiguration().getTemplate(this.studioConfiguration.getProperty("studio.security.forgotPassword.email.template"));
            StringWriter out = new StringWriter();
            HashMap<String, String> model = new HashMap<String, String>();
            RequestContext context = RequestContext.getCurrent();
            HttpServletRequest request = context.getRequest();
            String authoringUrl = request.getRequestURL().toString().replace(request.getPathInfo(), "");
            String serviceUrl = this.studioConfiguration.getProperty("studio.security.resetPassword.serviceUrl");
            model.put("authoringUrl", authoringUrl);
            model.put("serviceUrl", serviceUrl);
            model.put("token", token);
            if (emailTemplate != null) {
                emailTemplate.process(model, (Writer)out);
            }
            MimeMessage mimeMessage = this.emailService.createMimeMessage();
            MimeMessageHelper messageHelper = new MimeMessageHelper(mimeMessage);
            messageHelper.setFrom(this.getDefaultFromAddress());
            messageHelper.setTo(emailAddress);
            messageHelper.setSubject(this.studioConfiguration.getProperty("studio.security.forgotPassword.message.subject"));
            messageHelper.setText(((Object)out).toString(), true);
            logger.info("Sending password recovery message to " + emailAddress, new Object[0]);
            if (this.isAuthenticatedSMTP()) {
                this.emailService.send(mimeMessage);
            } else {
                this.emailServiceNoAuth.send(mimeMessage);
            }
            logger.info("Password recovery message successfully sent to " + emailAddress, new Object[0]);
        }
        catch (TemplateException | IOException | MessagingException e) {
            logger.error("Failed to send password recovery message to " + emailAddress, (Exception)e, new Object[0]);
            throw e;
        }
    }

    @ValidateParams
    public boolean changePassword(@ValidateStringParam(name="username") String username, @ValidateStringParam(name="current") String current, @ValidateStringParam(name="newPassword") String newPassword) throws PasswordDoesNotMatchException, UserExternallyManagedException {
        return this.securityProvider.changePassword(username, current, newPassword);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ValidateParams
    public Map<String, Object> setUserPassword(@ValidateStringParam(name="token") String token, @ValidateStringParam(name="newPassword") String newPassword) throws UserNotFoundException, UserExternallyManagedException {
        HashMap<String, Object> toRet = new HashMap<String, Object>();
        toRet.put("username", "");
        toRet.put("success", false);
        if (!this.validateToken(token)) return toRet;
        String username = this.getUsernameFromToken(token);
        if (!StringUtils.isNotEmpty((CharSequence)username)) throw new UserNotFoundException("User not found");
        toRet.put("username", username);
        Map userStatus = this.securityProvider.getUserStatus(username);
        if (userStatus == null || userStatus.isEmpty()) throw new UserNotFoundException("User not found");
        boolean enabled = (Boolean)userStatus.get("enabled");
        if (!enabled) return toRet;
        toRet.put("success", this.securityProvider.setUserPassword(username, newPassword));
        return toRet;
    }

    private String getUsernameFromToken(String token) {
        StringTokenizer tokenElements;
        String toRet = "";
        String decryptedToken = this.decryptToken(token);
        if (StringUtils.isNotEmpty((CharSequence)decryptedToken) && (tokenElements = new StringTokenizer(decryptedToken, "|")).countTokens() == 3) {
            toRet = tokenElements.nextToken();
        }
        return toRet;
    }

    @ValidateParams
    public boolean resetPassword(@ValidateStringParam(name="username") String username, @ValidateStringParam(name="newPassword") String newPassword) throws UserNotFoundException, UserExternallyManagedException {
        String currentUser = this.getCurrentUser();
        if (this.isAdmin(currentUser)) {
            return this.securityProvider.setUserPassword(username, newPassword);
        }
        return false;
    }

    private boolean isAdmin(String username) {
        Set userGroups = this.securityProvider.getUserGroups(username);
        boolean toRet = false;
        if (CollectionUtils.isNotEmpty((Collection)userGroups)) {
            for (String group : userGroups) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)group, (CharSequence)this.studioConfiguration.getProperty("studio.security.global.adminGroup"))) continue;
                toRet = true;
                break;
            }
        }
        return toRet;
    }

    @ValidateParams
    public boolean isSiteAdmin(@ValidateStringParam(name="username") String username, String site) {
        Set userGroups = this.securityProvider.getUserGroupsPerSite(username, site);
        boolean toRet = false;
        if (CollectionUtils.isNotEmpty((Collection)userGroups)) {
            for (String group : userGroups) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)group, (CharSequence)this.studioConfiguration.getProperty("studio.configuration.site.defaultAdminGroup"))) continue;
                toRet = true;
                break;
            }
        }
        return toRet;
    }

    @ValidateParams
    public boolean userExists(@ValidateStringParam(name="username") String username) {
        return this.securityProvider.userExists(username);
    }

    public boolean validateSession(HttpServletRequest request) {
        UserDetails userDetails;
        HttpSession httpSession = request.getSession();
        String authToken = (String)httpSession.getAttribute("studioSessionToken");
        String userName = this.securityProvider.getCurrentUser();
        if (userName != null && SessionTokenUtils.validateToken((String)authToken, (String)(userDetails = this.userDetailsManager.loadUserByUsername(userName)).getUsername())) {
            return true;
        }
        httpSession.removeAttribute("studioSessionToken");
        httpSession.invalidate();
        return false;
    }

    public String getConfigPath() {
        return this.studioConfiguration.getProperty("studio.configuration.site.configBasePath");
    }

    public String getRoleMappingsFileName() {
        return this.studioConfiguration.getProperty("studio.configuration.site.roleMappingsFileName");
    }

    public String getPermissionsFileName() {
        return this.studioConfiguration.getProperty("studio.configuration.site.permissionMappingsFileName");
    }

    public String getGlobalConfigPath() {
        return this.studioConfiguration.getProperty("studio.configuration.global.configBasePath");
    }

    public String getGlobalRoleMappingsFileName() {
        return this.studioConfiguration.getProperty("studio.configuration.global.roleMappingFileName");
    }

    public String getGlobalPermissionsFileName() {
        return this.studioConfiguration.getProperty("studio.configuration.global.permissionMappingFileName");
    }

    public int getSessionTimeout() {
        int toReturn = Integer.parseInt(this.studioConfiguration.getProperty("studio.security.sessionTimeout"));
        return toReturn;
    }

    public boolean isAuthenticatedSMTP() {
        boolean toReturn = Boolean.parseBoolean(this.studioConfiguration.getProperty("studio.mail.smtp.auth"));
        return toReturn;
    }

    public String getDefaultFromAddress() {
        return this.studioConfiguration.getProperty("studio.mail.from.default");
    }

    public String getSystemSite() {
        return this.studioConfiguration.getProperty("studio.configuration.global.systemSite");
    }

    public SecurityProvider getSecurityProvider() {
        return this.securityProvider;
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    public ContentTypeService getContentTypeService() {
        return this.contentTypeService;
    }

    public void setContentTypeService(ContentTypeService contentTypeService) {
        this.contentTypeService = contentTypeService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public GeneralLockService getGeneralLockService() {
        return this.generalLockService;
    }

    public void setGeneralLockService(GeneralLockService generalLockService) {
        this.generalLockService = generalLockService;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public JavaMailSender getEmailService() {
        return this.emailService;
    }

    public void setEmailService(JavaMailSender emailService) {
        this.emailService = emailService;
    }

    public JavaMailSender getEmailServiceNoAuth() {
        return this.emailServiceNoAuth;
    }

    public void setEmailServiceNoAuth(JavaMailSender emailServiceNoAuth) {
        this.emailServiceNoAuth = emailServiceNoAuth;
    }

    public UserDetailsManager getUserDetailsManager() {
        return this.userDetailsManager;
    }

    public void setUserDetailsManager(UserDetailsManager userDetailsManager) {
        this.userDetailsManager = userDetailsManager;
    }

    public ObjectFactory<FreeMarkerConfig> getFreeMarkerConfig() {
        return this.freeMarkerConfig;
    }

    public void setFreeMarkerConfig(ObjectFactory<FreeMarkerConfig> freeMarkerConfig) {
        this.freeMarkerConfig = freeMarkerConfig;
    }

    public ActivityService getActivityService() {
        return this.activityService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }
}

