/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.site;

import java.io.IOException;
import java.io.InputStream;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.craftercms.commons.entitlements.exception.EntitlementException;
import org.craftercms.commons.entitlements.model.EntitlementType;
import org.craftercms.commons.entitlements.model.Module;
import org.craftercms.commons.entitlements.validator.EntitlementValidator;
import org.craftercms.commons.validation.annotations.param.ValidateIntegerParam;
import org.craftercms.commons.validation.annotations.param.ValidateNoTagsParam;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateSecurePathParam;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.dal.GitLog;
import org.craftercms.studio.api.v1.dal.ItemState;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.dal.SiteFeedMapper;
import org.craftercms.studio.api.v1.deployment.PreviewDeployer;
import org.craftercms.studio.api.v1.ebus.PreviewEventContext;
import org.craftercms.studio.api.v1.exception.BlueprintNotFoundException;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.exception.PreviewDeployerUnreachableException;
import org.craftercms.studio.api.v1.exception.SearchUnreachableException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.exception.SiteAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.SiteCreationException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryCredentialsException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteUrlException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotBareException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotFoundException;
import org.craftercms.studio.api.v1.exception.security.GroupAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.activity.ActivityService;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.configuration.SiteEnvironmentConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.ContentTypeService;
import org.craftercms.studio.api.v1.service.content.DmPageNavigationOrderService;
import org.craftercms.studio.api.v1.service.content.ImportService;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v1.service.dependency.DependencyService;
import org.craftercms.studio.api.v1.service.deployment.DeploymentService;
import org.craftercms.studio.api.v1.service.event.EventService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.service.objectstate.State;
import org.craftercms.studio.api.v1.service.objectstate.TransitionEvent;
import org.craftercms.studio.api.v1.service.search.SearchService;
import org.craftercms.studio.api.v1.service.security.SecurityProvider;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteConfigNotFoundException;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.to.EnvironmentConfigTO;
import org.craftercms.studio.api.v1.to.PublishStatus;
import org.craftercms.studio.api.v1.to.PublishingTargetTO;
import org.craftercms.studio.api.v1.to.RemoteRepositoryInfoTO;
import org.craftercms.studio.api.v1.to.RepoOperationTO;
import org.craftercms.studio.api.v1.to.SiteBlueprintTO;
import org.craftercms.studio.api.v1.to.SiteTO;
import org.craftercms.studio.api.v1.util.StudioConfiguration;
import org.craftercms.studio.api.v2.service.notification.NotificationService;
import org.craftercms.studio.impl.v1.repository.job.RebuildRepositoryMetadata;
import org.craftercms.studio.impl.v1.repository.job.SyncDatabaseWithRepository;
import org.craftercms.studio.impl.v1.service.site.SiteServiceDAL;
import org.craftercms.studio.impl.v1.service.site.SiteServiceImpl;
import org.craftercms.studio.impl.v1.util.ContentUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.SAXException;

public class SiteServiceImpl
implements SiteService {
    private static final Logger logger = LoggerFactory.getLogger(SiteServiceImpl.class);
    protected PreviewDeployer previewDeployer;
    protected SiteServiceDAL _siteServiceDAL;
    protected ServicesConfig servicesConfig;
    protected ContentService contentService;
    protected SiteEnvironmentConfig environmentConfig;
    protected ContentRepository contentRepository;
    protected ObjectStateService objectStateService;
    protected DependencyService dependencyService;
    protected SecurityService securityService;
    protected ActivityService activityService;
    protected DeploymentService deploymentService;
    protected ObjectMetadataManager objectMetadataManager;
    protected DmPageNavigationOrderService dmPageNavigationOrderService;
    protected ContentTypeService contentTypeService;
    protected SecurityProvider securityProvider;
    protected ImportService importService;
    protected NotificationService notificationService;
    protected GeneralLockService generalLockService;
    protected RebuildRepositoryMetadata rebuildRepositoryMetadata;
    protected SyncDatabaseWithRepository syncDatabaseWithRepository;
    protected EventService eventService;
    protected StudioConfiguration studioConfiguration;
    @Autowired
    protected SiteFeedMapper siteFeedMapper;
    protected SearchService searchService;
    protected EntitlementValidator entitlementValidator;

    @ValidateParams
    public boolean writeConfiguration(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, InputStream content) throws ServiceException {
        ActivityService.ActivityType activityType = ActivityService.ActivityType.UPDATED;
        if (!this.contentRepository.contentExists(site, path)) {
            activityType = ActivityService.ActivityType.CREATED;
        }
        String commitId = this.contentRepository.writeContent(site, path, content);
        this.contentRepository.reloadRepository(site);
        PreviewEventContext context = new PreviewEventContext();
        context.setSite(site);
        this.eventService.publish("studio.event.previewSync", new Object[]{context});
        String user = this.securityService.getCurrentUser();
        HashMap<String, String> extraInfo = new HashMap<String, String>();
        if (StringUtils.startsWith((CharSequence)path, (CharSequence)this.contentTypeService.getConfigPath())) {
            extraInfo.put("contentType", "content type");
        } else {
            extraInfo.put("contentType", "configuration");
        }
        this.activityService.postActivity(site, user, path, activityType, ActivityService.ActivitySource.API, extraInfo);
        this.objectStateService.transition(site, path, TransitionEvent.SAVE);
        if (!this.objectMetadataManager.metadataExist(site, path)) {
            this.objectMetadataManager.insertNewObjectMetadata(site, path);
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("name", FilenameUtils.getName((String)path));
        properties.put("modified", ZonedDateTime.now(ZoneOffset.UTC));
        properties.put("modifier", user);
        this.objectMetadataManager.setObjectMetadata(site, path, properties);
        if (commitId != null) {
            this.objectMetadataManager.updateCommitId(site, path, commitId);
            this.contentRepository.insertGitLog(site, commitId, 1);
        }
        boolean toRet = StringUtils.isEmpty((CharSequence)commitId);
        return toRet;
    }

    @ValidateParams
    public boolean writeConfiguration(@ValidateSecurePathParam(name="path") String path, InputStream content) throws ServiceException {
        String commitId = this.contentRepository.writeContent("", path, content);
        boolean toReturn = StringUtils.isEmpty((CharSequence)commitId);
        return toReturn;
    }

    @ValidateParams
    public Map<String, Object> getConfiguration(@ValidateSecurePathParam(name="path") String path) {
        return null;
    }

    @ValidateParams
    public Document getSiteConfiguration(@ValidateStringParam(name="site") String site) throws SiteConfigNotFoundException {
        return this._siteServiceDAL.getSiteConfiguration(site);
    }

    @ValidateParams
    public Map<String, Object> getConfiguration(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, boolean applyEnv) {
        String configPath = StringUtils.isEmpty((CharSequence)site) ? this.getGlobalConfigRoot() + path : (applyEnv ? this.getEnvironmentConfigPath().replaceAll("\\{site\\}", site).replaceAll("\\{environment\\}", this.getEnvironment()) + path : this.getSitesConfigPath() + path);
        String configContent = this.contentService.getContentAsString(site, configPath);
        Map toRet = null;
        if (configContent != null) {
            configContent = configContent.replaceAll("\\n([\\s]+)?+", "");
            configContent = configContent.replaceAll("<!--(.*?)-->", "");
            toRet = this.convertNodesFromXml(configContent);
        }
        return toRet;
    }

    private Map<String, Object> convertNodesFromXml(String xml) {
        try {
            Document document = DocumentHelper.parseText((String)xml);
            return this.createMap(document.getRootElement());
        }
        catch (DocumentException e) {
            logger.error("Error reading xml string:\n" + xml, new Object[0]);
            return null;
        }
    }

    private Map<String, Object> createMap(Element element) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int size = element.nodeCount();
        for (int i = 0; i < size; ++i) {
            Node currentNode = element.node(i);
            if (!(currentNode instanceof Element)) continue;
            Element currentElement = (Element)currentNode;
            String key = currentElement.getName();
            Object toAdd = null;
            toAdd = currentElement.isTextOnly() ? currentElement.getStringValue() : this.createMap(currentElement);
            if (map.containsKey(key)) {
                Object value = map.get(key);
                List<Object> listOfValues = new ArrayList();
                if (value instanceof List) {
                    listOfValues = (List)value;
                } else {
                    listOfValues.add(value);
                }
                listOfValues.add(toAdd);
                map.put(key, listOfValues);
                continue;
            }
            map.put(key, toAdd);
        }
        return map;
    }

    protected void loadSiteEnvironmentConfig(String site, SiteTO siteConfig) {
        logger.debug("Loading site environment configuration for " + site + "; Environemnt: " + this.getEnvironment(), new Object[0]);
        EnvironmentConfigTO environmentConfigTO = this.environmentConfig.getEnvironmentConfig(site);
        if (environmentConfigTO == null) {
            logger.error("Environment configuration for site " + site + " does not exist.", new Object[0]);
            return;
        }
        siteConfig.setLiveUrl(environmentConfigTO.getLiveServerUrl());
        siteConfig.setAuthoringUrl(environmentConfigTO.getAuthoringServerUrl());
        siteConfig.setPreviewUrl(environmentConfigTO.getPreviewServerUrl());
        siteConfig.setAdminEmail(environmentConfigTO.getAdminEmailAddress());
        siteConfig.setOpenSiteDropdown(environmentConfigTO.getOpenDropdown());
    }

    @ValidateParams
    public List<PublishingTargetTO> getPublishingTargetsForSite(@ValidateStringParam(name="site") String site) {
        return this.environmentConfig.getPublishingTargetsForSite(site);
    }

    public Set<String> getAllAvailableSites() {
        List sites = this.siteFeedMapper.getSites();
        HashSet<String> toRet = new HashSet<String>();
        for (SiteFeed site : sites) {
            toRet.add(site.getSiteId());
        }
        return toRet;
    }

    public int countSites() {
        return this.siteFeedMapper.countSites();
    }

    @ValidateParams
    public void createSiteFromBlueprint(@ValidateStringParam(name="blueprintName") String blueprintName, @ValidateNoTagsParam(name="siteName") String siteName, @ValidateStringParam(name="siteId") String siteId, @ValidateStringParam(name="sandboxBranch") String sandboxBranch, @ValidateNoTagsParam(name="desc") String desc) throws SiteAlreadyExistsException, SiteCreationException, PreviewDeployerUnreachableException, SearchUnreachableException, BlueprintNotFoundException {
        if (this.exists(siteId)) {
            throw new SiteAlreadyExistsException();
        }
        if (!this.contentService.contentExists("", this.studioConfiguration.getProperty("studio.repo.blueprintsPath") + "/" + blueprintName)) {
            throw new BlueprintNotFoundException();
        }
        try {
            long start = 0L;
            if (logger.getLevel().equals("debug")) {
                start = System.currentTimeMillis();
                logger.debug("Starting entitlement validation", new Object[0]);
            }
            this.entitlementValidator.validateEntitlement(Module.STUDIO, EntitlementType.SITE, this.countSites(), 1);
            if (logger.getLevel().equals("debug")) {
                logger.debug("Validation completed, duration : {0} ms", new Object[]{System.currentTimeMillis() - start});
            }
        }
        catch (EntitlementException e) {
            throw new SiteCreationException("Unable to complete request due to entitlement limits. Please contact your system administrator.", (Exception)((Object)e));
        }
        boolean success = true;
        try {
            this.searchService.createIndex(siteId);
        }
        catch (ServiceException e) {
            success = false;
            logger.error("Error while creating site: " + siteName + " ID: " + siteId + " from blueprint: " + blueprintName + ". Is the Search running and configured correctly in Studio?", (Exception)((Object)e), new Object[0]);
            throw new SearchUnreachableException("Error while creating site: " + siteName + " ID: " + siteId + " from blueprint: " + blueprintName + ". Is the Search running and configured correctly in Studio?");
        }
        if (success) {
            try {
                success = this.previewDeployer.createTarget(siteId);
            }
            catch (Exception e) {
                success = false;
                logger.error("Error while creating site: " + siteName + " ID: " + siteId + " from blueprint: " + blueprintName + ". Is the Preview Deployer running and configured correctly in Studio?", e, new Object[0]);
            }
            if (!success) {
                logger.error("Error while creating site: " + siteName + " ID: " + siteId + " from blueprint: " + blueprintName + ". Is the Preview Deployer running and configured correctly in Studio?", new Object[0]);
                try {
                    this.searchService.deleteIndex(siteId);
                }
                catch (ServiceException e) {
                    logger.error("Error while rolling back/deleting site: " + siteName + " ID: " + siteId + " from blueprint: " + blueprintName + ". This means the site search index (core) is still present, but the site is not successfully created.", (Exception)((Object)e), new Object[0]);
                }
                throw new PreviewDeployerUnreachableException("Error while creating site: " + siteName + " ID: " + siteId + " from blueprint: " + blueprintName + ". Is the Preview Deployer running and configured correctly in Studio?");
            }
        }
        if (success) {
            try {
                success = this.createSiteFromBlueprintGit(blueprintName, siteName, siteId, sandboxBranch, desc);
                String lastCommitId = this.contentRepository.getRepoLastCommitId(siteId);
                this.createObjectStatesforNewSite(siteId);
                this.createObjectMetadataforNewSite(siteId, lastCommitId);
                this.extractDependenciesForNewSite(siteId);
                List publishingTargets = this.getPublishingTargetsForSite(siteId);
                if (publishingTargets != null && publishingTargets.size() > 0) {
                    for (PublishingTargetTO target : publishingTargets) {
                        if (!StringUtils.isNotEmpty((CharSequence)target.getRepoBranchName())) continue;
                        this.contentRepository.initialPublish(siteId, sandboxBranch, target.getRepoBranchName(), this.securityProvider.getCurrentUser(), "Create site.");
                    }
                }
                this.objectStateService.setStateForSiteContent(siteId, State.EXISTING_UNEDITED_UNLOCKED);
                SiteFeed siteFeed = new SiteFeed();
                siteFeed.setName(siteName);
                siteFeed.setSiteId(siteId);
                siteFeed.setDescription(desc);
                siteFeed.setLastCommitId(lastCommitId);
                siteFeed.setPublishingStatusMessage(this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.default"));
                siteFeed.setSandboxBranch(sandboxBranch);
                this.siteFeedMapper.createSite(siteFeed);
                this.insertCreateSiteAuditLog(siteId);
                this.contentRepository.insertGitLog(siteId, lastCommitId, 1);
                this.addDefaultGroupsForNewSite(siteId);
                this.securityService.addUserToGroup(siteId, this.getDefaultAdminGroup(), this.securityService.getCurrentUser());
                this.reloadSiteConfiguration(siteId);
            }
            catch (Exception e) {
                success = false;
                logger.error("Error while creating site: " + siteName + " ID: " + siteId + " from blueprint: " + blueprintName + ". Rolling back.", e, new Object[0]);
                boolean deleted = this.previewDeployer.deleteTarget(siteId);
                if (!deleted) {
                    logger.error("Error while rolling back/deleting site: " + siteName + " ID: " + siteId + " from blueprint: " + blueprintName + ". This means the site's preview deployer target is still present, but the site is not successfully created.", new Object[0]);
                }
                try {
                    this.searchService.deleteIndex(siteId);
                }
                catch (ServiceException ex) {
                    logger.error("Error while rolling back/deleting site: " + siteName + " ID: " + siteId + " from blueprint: " + blueprintName + ". This means the site search index (core) is still present, but the site is not successfully created.", (Exception)((Object)ex), new Object[0]);
                }
                throw new SiteCreationException("Error while creating site: " + siteName + " ID: " + siteId + " from blueprint: " + blueprintName + ". Rolling back.");
            }
        }
        if (success) {
            try {
                this.deploymentService.syncAllContentToPreview(siteId, true);
            }
            catch (ServiceException e) {
                logger.error("Error while syncing site: " + siteName + " ID: " + siteId + " to preview. Site was successfully created otherwise. Ignoring.", (Exception)((Object)e), new Object[0]);
                throw new SiteCreationException("Error while syncing site: " + siteName + " ID: " + siteId + " to preview. Site was successfully created, but it won't be preview-able until the Preview Deployer is reachable.");
            }
        } else {
            throw new SiteCreationException("Error while creating site: " + siteName + " ID: " + siteId + ".");
        }
    }

    private void insertCreateSiteAuditLog(String siteId) {
        ActivityService.ActivityType activityType = ActivityService.ActivityType.CREATE_SITE;
        String user = this.securityProvider.getCurrentUser();
        HashMap<String, String> extraInfo = new HashMap<String, String>();
        extraInfo.put("contentType", "site");
        this.activityService.postActivity(this.studioConfiguration.getProperty("studio.configuration.global.systemSite"), user, siteId, activityType, ActivityService.ActivitySource.API, extraInfo);
    }

    protected boolean createSiteFromBlueprintGit(String blueprintName, String siteName, String siteId, String sandboxBranch, String desc) throws Exception {
        boolean success = true;
        this.contentRepository.createSiteFromBlueprint(blueprintName, siteId, sandboxBranch);
        String siteConfigFolder = "/config/studio";
        this.replaceFileContentGit(siteId, siteConfigFolder + "/" + "site-config.xml", "SITENAME", siteId);
        return success;
    }

    protected void replaceFileContentGit(String site, String path, String find, String replace) throws Exception {
        InputStream content = this.contentRepository.getContent(site, path);
        String contentAsString = IOUtils.toString((InputStream)content);
        contentAsString = contentAsString.replaceAll(find, replace);
        InputStream contentToWrite = IOUtils.toInputStream((String)contentAsString);
        this.contentRepository.writeContent(site, path, contentToWrite);
    }

    protected void replaceFileContent(String path, String find, String replace) throws Exception {
        InputStream content = this.contentRepository.getContent("", path);
        String contentAsString = IOUtils.toString((InputStream)content);
        contentAsString = contentAsString.replaceAll(find, replace);
        InputStream contentToWrite = IOUtils.toInputStream((String)contentAsString);
        this.contentRepository.writeContent("", path, contentToWrite);
    }

    protected void createObjectStatesforNewSite(String site) {
        this.createObjectStateNewSiteObjectFolder(site, "/");
    }

    protected void createObjectStateNewSiteObjectFolder(String site, String path) {
        RepositoryItem[] children;
        for (RepositoryItem child : children = this.contentRepository.getContentChildren(site, path)) {
            if (child.isFolder) {
                this.createObjectStateNewSiteObjectFolder(site, child.path + "/" + child.name);
                continue;
            }
            this.objectStateService.insertNewEntry(site, child.path + "/" + child.name);
        }
    }

    protected void createObjectMetadataforNewSite(String site, String lastCommitId) {
        this.createObjectMetadataNewSiteObjectFolder(site, "/", lastCommitId);
    }

    protected void createObjectMetadataNewSiteObjectFolder(String site, String path, String lastCommitId) {
        RepositoryItem[] children;
        for (RepositoryItem child : children = this.contentRepository.getContentChildren(site, path)) {
            if (child.isFolder) {
                this.createObjectMetadataNewSiteObjectFolder(site, child.path + "/" + child.name, lastCommitId);
                continue;
            }
            this.objectMetadataManager.insertNewObjectMetadata(site, child.path + "/" + child.name);
            this.objectMetadataManager.updateCommitId(site, child.path + "/" + child.name, lastCommitId);
        }
    }

    protected void extractDependenciesForNewSite(String site) {
        HashMap globalDeps = new HashMap();
        this.extractDependenciesItemForNewSite(site, "/", globalDeps);
    }

    private void extractDependenciesItemForNewSite(String site, String fullPath, Map<String, Set<String>> globalDeps) {
        RepositoryItem[] children;
        for (RepositoryItem child : children = this.contentRepository.getContentChildren(site, fullPath)) {
            if (child.isFolder) {
                this.extractDependenciesItemForNewSite(site, child.path + "/" + child.name, globalDeps);
                continue;
            }
            String childPath = child.path + "/" + child.name;
            if (childPath.endsWith(".xml")) {
                try {
                    this.dependencyService.upsertDependencies(site, childPath);
                }
                catch (ContentNotFoundException e) {
                    logger.error("Failed to extract dependencies for document: site " + site + " path " + childPath, (Exception)((Object)e), new Object[0]);
                }
                catch (ServiceException e) {
                    logger.error("Failed to extract dependencies for document: site " + site + " path " + childPath, (Exception)((Object)e), new Object[0]);
                }
                continue;
            }
            boolean isCss = childPath.endsWith(".css");
            boolean isJs = childPath.endsWith(".js");
            List templatePatterns = this.servicesConfig.getRenderingTemplatePatterns(site);
            boolean isTemplate = false;
            for (String templatePattern : templatePatterns) {
                Pattern pattern = Pattern.compile(templatePattern);
                Matcher matcher = pattern.matcher(childPath);
                if (!matcher.matches()) continue;
                isTemplate = true;
                break;
            }
            try {
                if (!isCss && !isJs && !isTemplate) continue;
                this.dependencyService.upsertDependencies(site, childPath);
            }
            catch (ServiceException e) {
                logger.error("Failed to extract dependencies for: site " + site + " path " + childPath, (Exception)((Object)e), new Object[0]);
            }
        }
    }

    private void addDefaultGroupsForNewSite(String siteId) {
        List defaultGroups = this.getDefaultGroups();
        for (String group : defaultGroups) {
            String description = group + " site default group";
            try {
                this.securityService.createGroup(group, description, siteId);
            }
            catch (SiteNotFoundException e) {
                logger.warn("Default group: " + group + " not created. Site " + siteId + "is not found.", new Object[]{e});
            }
            catch (GroupAlreadyExistsException e) {
                logger.warn("Default group: " + group + " not created. It already exists for site " + siteId + ".", new Object[]{e});
            }
        }
    }

    @ValidateParams
    public void createSiteWithRemoteOption(@ValidateStringParam(name="siteId") String siteId, @ValidateStringParam(name="sandboxBranch") String sandboxBranch, @ValidateNoTagsParam(name="description") String description, String blueprintName, @ValidateStringParam(name="remoteName") String remoteName, @ValidateStringParam(name="remoteUrl") String remoteUrl, String remoteBranch, boolean singleBranch, String authenticationType, String remoteUsername, String remotePassword, String remoteToken, String remotePrivateKey, @ValidateStringParam(name="createOption") String createOption) throws ServiceException, InvalidRemoteRepositoryException, InvalidRemoteRepositoryCredentialsException, RemoteRepositoryNotFoundException, RemoteRepositoryNotBareException, InvalidRemoteUrlException {
        if (this.exists(siteId)) {
            throw new SiteAlreadyExistsException();
        }
        try {
            long start = 0L;
            if (logger.getLevel().equals("debug")) {
                start = System.currentTimeMillis();
                logger.debug("Starting entitlement validation", new Object[0]);
            }
            this.entitlementValidator.validateEntitlement(Module.STUDIO, EntitlementType.SITE, this.countSites(), 1);
            if (logger.getLevel().equals("debug")) {
                logger.debug("Validation completed, duration : {0} ms", new Object[]{System.currentTimeMillis() - start});
            }
        }
        catch (EntitlementException e) {
            throw new SiteCreationException("Unable to complete request due to entitlement limits. Please contact your system administrator.", (Exception)((Object)e));
        }
        switch (createOption) {
            case "clone": {
                logger.debug("Clone from remote repository create option selected", new Object[0]);
                this.createSiteCloneRemote(siteId, sandboxBranch, description, remoteName, remoteUrl, remoteBranch, singleBranch, authenticationType, remoteUsername, remotePassword, remoteToken, remotePrivateKey);
                break;
            }
            case "push": {
                logger.debug("Push to remote repository create option selected", new Object[0]);
                this.createSitePushToRemote(siteId, sandboxBranch, description, blueprintName, remoteName, remoteUrl, remoteBranch, authenticationType, remoteUsername, remotePassword, remoteToken, remotePrivateKey);
                break;
            }
            default: {
                logger.error("Invalid create option for create site using remote repository: " + createOption + "\nAvailable options: [" + "clone" + ", " + "push" + "]", new Object[0]);
            }
        }
    }

    private void createSiteCloneRemote(String siteId, String sandboxBranch, String description, String remoteName, String remoteUrl, String remoteBranch, boolean singleBranch, String authenticationType, String remoteUsername, String remotePassword, String remoteToken, String remotePrivateKey) throws ServiceException, InvalidRemoteRepositoryException, InvalidRemoteRepositoryCredentialsException, RemoteRepositoryNotFoundException, InvalidRemoteUrlException {
        boolean success = true;
        try {
            logger.debug("Creating search index for site " + siteId, new Object[0]);
            this.searchService.createIndex(siteId);
        }
        catch (ServiceException e) {
            success = false;
            logger.error("Error while creating site: " + siteId + " ID: " + siteId + " as clone from remote repository: " + remoteName + " (" + remoteUrl + "). Is the Search running and configured correctly in Studio?", (Exception)((Object)e), new Object[0]);
            throw new SearchUnreachableException("Error while creating site: " + siteId + " ID: " + siteId + " as clone from remote repository: " + remoteName + " (" + remoteUrl + "). Is the Search running and configured correctly in Studio?");
        }
        if (success) {
            try {
                logger.debug("Creating preview deployer target for site " + siteId, new Object[0]);
                success = this.previewDeployer.createTarget(siteId);
            }
            catch (Exception e) {
                success = false;
                logger.error("Error while creating site: " + siteId + " ID: " + siteId + " as clone from remote repository: " + remoteName + " (" + remoteUrl + "). Is the Preview Deployer running and configured correctly in Studio?", e, new Object[0]);
            }
            if (!success) {
                logger.error("Error while creating site: " + siteId + " ID: " + siteId + " as clone from remote repository: " + remoteName + " (" + remoteUrl + "). Is the Preview Deployer running and configured correctly in Studio?", new Object[0]);
                try {
                    this.searchService.deleteIndex(siteId);
                }
                catch (ServiceException e) {
                    logger.error("Error while rolling back/deleting site: " + siteId + " ID: " + siteId + " as clone from remote repository: " + remoteName + " (" + remoteUrl + "). This means the site search index (core) is still present, but the site is not successfully created.", (Exception)((Object)e), new Object[0]);
                }
                throw new PreviewDeployerUnreachableException("Error while creating site: " + siteId + " ID: " + siteId + " as clone from remote repository: " + remoteName + " (" + remoteUrl + "). Is the Preview Deployer running and configured correctly in Studio?");
            }
        }
        if (success) {
            try {
                logger.debug("Creating site " + siteId + " by cloning remote repository " + remoteName + " (" + remoteUrl + ")", new Object[0]);
                this.contentRepository.createSiteCloneRemote(siteId, sandboxBranch, remoteName, remoteUrl, remoteBranch, singleBranch, authenticationType, remoteUsername, remotePassword, remoteToken, remotePrivateKey);
            }
            catch (ServiceException | InvalidRemoteRepositoryCredentialsException | InvalidRemoteRepositoryException | InvalidRemoteUrlException | RemoteRepositoryNotFoundException e) {
                this.contentRepository.deleteSite(siteId);
                boolean deleted = this.previewDeployer.deleteTarget(siteId);
                if (!deleted) {
                    logger.error("Error while rolling back/deleting site: " + siteId + " ID: " + siteId + " as clone from remote repository: " + remoteName + " (" + remoteUrl + "). This means the site's preview deployer target is still present, but the site is not successfully created.", new Object[0]);
                }
                try {
                    this.searchService.deleteIndex(siteId);
                }
                catch (ServiceException ex) {
                    logger.error("Error while rolling back/deleting site: " + siteId + " ID: " + siteId + " as clone from remote repository: " + remoteName + " (" + remoteUrl + "). This means the site search index (core) is still present, but the site is not successfully created.", (Exception)((Object)ex), new Object[0]);
                }
                logger.error("Error while creating site: " + siteId + " ID: " + siteId + " as clone from remote repository: " + remoteName + " (" + remoteUrl + "). Rolling back.", (Exception)e, new Object[0]);
                throw e;
            }
        }
        if (success) {
            try {
                String lastCommitId = this.contentRepository.getRepoLastCommitId(siteId);
                logger.debug("Adding item states to database for site " + siteId, new Object[0]);
                this.createObjectStatesforNewSite(siteId);
                logger.debug("Adding item metadata to database for site " + siteId, new Object[0]);
                this.createObjectMetadataforNewSite(siteId, lastCommitId);
                logger.debug("Adding item dependencies to database for site " + siteId, new Object[0]);
                this.extractDependenciesForNewSite(siteId);
                logger.debug("Executing initial deployement for site " + siteId, new Object[0]);
                List publishingTargets = this.getPublishingTargetsForSite(siteId);
                if (publishingTargets != null && publishingTargets.size() > 0) {
                    for (PublishingTargetTO target : publishingTargets) {
                        if (!StringUtils.isNotEmpty((CharSequence)target.getRepoBranchName())) continue;
                        this.contentRepository.initialPublish(siteId, sandboxBranch, target.getRepoBranchName(), this.securityProvider.getCurrentUser(), "Create site.");
                    }
                }
                this.objectStateService.setStateForSiteContent(siteId, State.EXISTING_UNEDITED_UNLOCKED);
                logger.debug("Adding git log to database for site " + siteId, new Object[0]);
                this.contentRepository.insertFullGitLog(siteId, 1);
                logger.debug("Adding site record to database for site " + siteId, new Object[0]);
                SiteFeed siteFeed = new SiteFeed();
                siteFeed.setName(siteId);
                siteFeed.setSiteId(siteId);
                siteFeed.setDescription(description);
                siteFeed.setLastCommitId(lastCommitId);
                siteFeed.setPublishingStatusMessage(this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.default"));
                siteFeed.setSandboxBranch(sandboxBranch);
                this.siteFeedMapper.createSite(siteFeed);
                this.insertCreateSiteAuditLog(siteId);
                logger.debug("Adding default groups for site " + siteId, new Object[0]);
                this.addDefaultGroupsForNewSite(siteId);
                this.securityService.addUserToGroup(siteId, this.getDefaultAdminGroup(), this.securityService.getCurrentUser());
                logger.debug("Loading configuration for site " + siteId, new Object[0]);
                this.reloadSiteConfiguration(siteId);
            }
            catch (Exception e) {
                success = false;
                logger.error("Error while creating site: " + siteId + " ID: " + siteId + " as clone from remote repository: " + remoteName + " (" + remoteUrl + "). Rolling back.", e, new Object[0]);
                this.deleteSite(siteId);
                throw new SiteCreationException("Error while creating site: " + siteId + " ID: " + siteId + " as clone from remote repository: " + remoteName + " (" + remoteUrl + "). Rolling back.");
            }
        }
    }

    private void createSitePushToRemote(String siteId, String sandboxBranch, String description, String blueprintName, String remoteName, String remoteUrl, String remoteBranch, String authenticationType, String remoteUsername, String remotePassword, String remoteToken, String remotePrivateKey) throws ServiceException, InvalidRemoteRepositoryCredentialsException, InvalidRemoteRepositoryException, RemoteRepositoryNotFoundException, RemoteRepositoryNotBareException, InvalidRemoteUrlException {
        if (this.exists(siteId)) {
            throw new SiteAlreadyExistsException();
        }
        if (!this.contentService.contentExists("", this.studioConfiguration.getProperty("studio.repo.blueprintsPath") + "/" + blueprintName)) {
            throw new BlueprintNotFoundException();
        }
        boolean success = true;
        try {
            logger.debug("Creating search index for site " + siteId, new Object[0]);
            this.searchService.createIndex(siteId);
        }
        catch (ServiceException e) {
            success = false;
            logger.error("Error while creating site: " + siteId + " ID: " + siteId + " from blueprint: " + blueprintName + ". Is the Search running and configured correctly in Studio?", (Exception)((Object)e), new Object[0]);
            throw new SearchUnreachableException("Error while creating site: " + siteId + " ID: " + siteId + " from blueprint: " + blueprintName + ". Is the Search running and configured correctly in Studio?");
        }
        if (success) {
            try {
                logger.debug("Creating preview deployer target for site " + siteId, new Object[0]);
                success = this.previewDeployer.createTarget(siteId);
            }
            catch (Exception e) {
                success = false;
                logger.error("Error while creating site: " + siteId + " ID: " + siteId + " from blueprint: " + blueprintName + ". Is the Preview Deployer running and configured correctly in Studio?", e, new Object[0]);
            }
            if (!success) {
                logger.error("Error while creating site: " + siteId + " ID: " + siteId + " from blueprint: " + blueprintName + ". Is the Preview Deployer running and configured correctly in Studio?", new Object[0]);
                try {
                    this.searchService.deleteIndex(siteId);
                }
                catch (ServiceException e) {
                    logger.error("Error while rolling back/deleting site: " + siteId + " ID: " + siteId + " from blueprint: " + blueprintName + ". This means the site search index (core) is still present, but the site is not successfully created.", (Exception)((Object)e), new Object[0]);
                }
                throw new PreviewDeployerUnreachableException("Error while creating site: " + siteId + " ID: " + siteId + " from blueprint: " + blueprintName + ". Is the Preview Deployer running and configured correctly in Studio?");
            }
        }
        if (success) {
            try {
                logger.debug("Creating site " + siteId + " from blueprint " + blueprintName, new Object[0]);
                success = this.createSiteFromBlueprintGit(blueprintName, siteId, siteId, sandboxBranch, description);
            }
            catch (Exception e) {
                success = false;
                logger.error("Error while creating site: " + siteId + " ID: " + siteId + " from blueprint: " + blueprintName + ". Rolling back.", e, new Object[0]);
                boolean deleted = this.previewDeployer.deleteTarget(siteId);
                if (!deleted) {
                    logger.error("Error while rolling back/deleting site: " + siteId + " ID: " + siteId + " from blueprint: " + blueprintName + ". This means the site's preview deployer target is still present, but the site is not successfully created.", new Object[0]);
                }
                try {
                    this.searchService.deleteIndex(siteId);
                }
                catch (ServiceException ex) {
                    logger.error("Error while rolling back/deleting site: " + siteId + " ID: " + siteId + " from blueprint: " + blueprintName + ". This means the site search index (core) is still present, but the site is not successfully created.", (Exception)((Object)ex), new Object[0]);
                }
                throw new SiteCreationException("Error while creating site: " + siteId + " ID: " + siteId + " from blueprint: " + blueprintName + ". Rolling back.");
            }
            if (success) {
                try {
                    logger.debug("Pushing site " + siteId + " to remote repository " + remoteName + " (" + remoteUrl + ")", new Object[0]);
                    this.contentRepository.addRemote(siteId, remoteName, remoteUrl, authenticationType, remoteUsername, remotePassword, remoteToken, remotePrivateKey);
                    this.insertAddRemoteAuditLog(siteId, remoteName);
                    this.contentRepository.createSitePushToRemote(siteId, remoteName, remoteUrl, authenticationType, remoteUsername, remotePassword, remoteToken, remotePrivateKey);
                }
                catch (ServiceException | InvalidRemoteRepositoryCredentialsException | InvalidRemoteRepositoryException | InvalidRemoteUrlException | RemoteRepositoryNotBareException | RemoteRepositoryNotFoundException e) {
                    success = false;
                    logger.error("Error while creating site: " + siteId + " ID: " + siteId + " from blueprint: " + blueprintName + ". Rolling back.", (Exception)e, new Object[0]);
                    this.contentRepository.removeRemote(siteId, remoteName);
                    this.contentRepository.deleteSite(siteId);
                    boolean deleted = this.previewDeployer.deleteTarget(siteId);
                    if (!deleted) {
                        logger.error("Error while rolling back/deleting site: " + siteId + " ID: " + siteId + " from blueprint: " + blueprintName + ". This means the site's preview deployer target is still present, but the site is not successfully created.", new Object[0]);
                    }
                    try {
                        this.searchService.deleteIndex(siteId);
                    }
                    catch (ServiceException ex) {
                        logger.error("Error while rolling back/deleting site: " + siteId + " ID: " + siteId + " from blueprint: " + blueprintName + ". This means the site search index (core) is still present, but the site is not successfully created.", (Exception)((Object)ex), new Object[0]);
                    }
                    throw e;
                }
            }
            try {
                String lastCommitId = this.contentRepository.getRepoLastCommitId(siteId);
                logger.debug("Adding item states to database for site " + siteId, new Object[0]);
                this.createObjectStatesforNewSite(siteId);
                logger.debug("Adding item metadata to database for site " + siteId, new Object[0]);
                this.createObjectMetadataforNewSite(siteId, lastCommitId);
                logger.debug("Adding item dependencies to database for site " + siteId, new Object[0]);
                this.extractDependenciesForNewSite(siteId);
                logger.debug("Executing initial deployement for site " + siteId, new Object[0]);
                List publishingTargets = this.getPublishingTargetsForSite(siteId);
                if (publishingTargets != null && publishingTargets.size() > 0) {
                    for (PublishingTargetTO target : publishingTargets) {
                        if (!StringUtils.isNotEmpty((CharSequence)target.getRepoBranchName())) continue;
                        this.contentRepository.initialPublish(siteId, sandboxBranch, target.getRepoBranchName(), this.securityProvider.getCurrentUser(), "Create site.");
                    }
                }
                this.objectStateService.setStateForSiteContent(siteId, State.EXISTING_UNEDITED_UNLOCKED);
                logger.debug("Adding site record to database for site " + siteId, new Object[0]);
                SiteFeed siteFeed = new SiteFeed();
                siteFeed.setName(siteId);
                siteFeed.setSiteId(siteId);
                siteFeed.setDescription(description);
                siteFeed.setLastCommitId(lastCommitId);
                siteFeed.setPublishingStatusMessage(this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.default"));
                siteFeed.setSandboxBranch(sandboxBranch);
                this.siteFeedMapper.createSite(siteFeed);
                this.insertCreateSiteAuditLog(siteId);
                logger.debug("Adding git log to database for site " + siteId, new Object[0]);
                this.contentRepository.insertGitLog(siteId, lastCommitId, 1);
                logger.debug("Adding default groups for site " + siteId, new Object[0]);
                this.addDefaultGroupsForNewSite(siteId);
                this.securityService.addUserToGroup(siteId, this.getDefaultAdminGroup(), this.securityService.getCurrentUser());
                logger.debug("Loading configuration for site " + siteId, new Object[0]);
                this.reloadSiteConfiguration(siteId);
            }
            catch (Exception e) {
                success = false;
                logger.error("Error while creating site: " + siteId + " ID: " + siteId + " from blueprint: " + blueprintName + ". Rolling back.", e, new Object[0]);
                this.deleteSite(siteId);
                boolean deleted = this.previewDeployer.deleteTarget(siteId);
                if (!deleted) {
                    logger.error("Error while rolling back/deleting site: " + siteId + " ID: " + siteId + " from blueprint: " + blueprintName + ". This means the site's preview deployer target is still present, but the site is not successfully created.", new Object[0]);
                }
                try {
                    this.searchService.deleteIndex(siteId);
                }
                catch (ServiceException ex) {
                    logger.error("Error while rolling back/deleting site: " + siteId + " ID: " + siteId + " from blueprint: " + blueprintName + ". This means the site search index (core) is still present, but the site is not successfully created.", (Exception)((Object)ex), new Object[0]);
                }
                throw new SiteCreationException("Error while creating site: " + siteId + " ID: " + siteId + " from blueprint: " + blueprintName + ". Rolling back.");
            }
        }
        if (success) {
            try {
                this.deploymentService.syncAllContentToPreview(siteId, true);
            }
            catch (ServiceException e) {
                logger.error("Error while syncing site: " + siteId + " ID: " + siteId + " to preview. Site was successfully created otherwise. Ignoring.", (Exception)((Object)e), new Object[0]);
                throw new SiteCreationException("Error while syncing site: " + siteId + " ID: " + siteId + " to preview. Site was successfully created, but it won't be preview-able until the Preview Deployer is reachable.");
            }
        } else {
            throw new SiteCreationException("Error while creating site: " + siteId + " ID: " + siteId + ".");
        }
    }

    @ValidateParams
    public boolean deleteSite(@ValidateStringParam(name="siteId") String siteId) {
        boolean success = true;
        logger.debug("Deleting site:" + siteId, new Object[0]);
        try {
            this.enablePublishing(siteId, false);
        }
        catch (SiteNotFoundException e) {
            success = false;
            logger.error("Failed to stop publishing for site:" + siteId, (Exception)((Object)e), new Object[0]);
        }
        try {
            logger.debug("Deleting search index", new Object[0]);
            this.searchService.deleteIndex(siteId);
        }
        catch (Exception e) {
            success = false;
            logger.error("Failed to delete search index for site:" + siteId, e, new Object[0]);
        }
        try {
            logger.debug("Deleting preview deployer", new Object[0]);
            this.previewDeployer.deleteTarget(siteId);
        }
        catch (Exception e) {
            success = false;
            logger.error("Failed to delete the preview deployer target for site:" + siteId, e, new Object[0]);
        }
        try {
            success = success && this.destroySitePreviewContext(siteId);
        }
        catch (Exception e) {
            success = false;
            logger.error("Failed to destroy the preview context for site:" + siteId, e, new Object[0]);
        }
        try {
            logger.debug("Deleting repo", new Object[0]);
            this.contentRepository.deleteSite(siteId);
        }
        catch (Exception e) {
            success = false;
            logger.error("Failed to delete the repository for site:" + siteId, e, new Object[0]);
        }
        try {
            logger.debug("Deleting database records", new Object[0]);
            this.siteFeedMapper.deleteSite(siteId);
            this.activityService.deleteActivitiesForSite(siteId);
            this.dependencyService.deleteSiteDependencies(siteId);
            this.deploymentService.deleteDeploymentDataForSite(siteId);
            this.objectStateService.deleteObjectStatesForSite(siteId);
            this.objectMetadataManager.deleteObjectMetadataForSite(siteId);
            this.dmPageNavigationOrderService.deleteSequencesForSite(siteId);
            this.contentRepository.deleteGitLogForSite(siteId);
            this.contentRepository.removeRemoteRepositoriesForSite(siteId);
            this.insertDeleteSiteAuditLog(siteId);
        }
        catch (Exception e) {
            success = false;
            logger.error("Failed to delete the database for site:" + siteId, e, new Object[0]);
        }
        return success;
    }

    private void insertDeleteSiteAuditLog(String siteId) {
        ActivityService.ActivityType activityType = ActivityService.ActivityType.DELETE_SITE;
        String user = this.securityProvider.getCurrentUser();
        HashMap<String, String> extraInfo = new HashMap<String, String>();
        extraInfo.put("contentType", "site");
        this.activityService.postActivity(this.studioConfiguration.getProperty("studio.configuration.global.systemSite"), user, siteId, activityType, ActivityService.ActivitySource.API, extraInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean destroySitePreviewContext(String site) {
        boolean toReturn = true;
        String requestUrl = this.getDestroySitePreviewContextUrl(site);
        HttpGet getRequest = new HttpGet(requestUrl);
        RequestConfig requestConfig = RequestConfig.custom().setExpectContinueEnabled(true).build();
        getRequest.setConfig(requestConfig);
        CloseableHttpClient client = HttpClientBuilder.create().build();
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)getRequest);
            if (response.getStatusLine().getStatusCode() != 200) {
                toReturn = false;
            }
        }
        catch (IOException e) {
            logger.error("Error while sending destroy preview context request for site " + site, (Exception)e, new Object[0]);
            toReturn = false;
        }
        finally {
            getRequest.releaseConnection();
        }
        return toReturn;
    }

    private String getDestroySitePreviewContextUrl(String site) {
        StringBuilder sb = new StringBuilder(this.studioConfiguration.getProperty("studio.preview.engineUrl"));
        sb.append(this.studioConfiguration.getProperty("studio.configuration.site.preview.destroy.sontext.url"));
        String url = sb.toString();
        url = url.replaceAll("\\{siteName\\}", site);
        return url;
    }

    public SiteBlueprintTO[] getAvailableBlueprints() {
        RepositoryItem[] blueprintsFolders = this.contentRepository.getContentChildren("", this.studioConfiguration.getProperty("studio.repo.blueprintsPath"));
        ArrayList<SiteBlueprintTO> blueprints = new ArrayList<SiteBlueprintTO>();
        boolean idx = false;
        for (RepositoryItem folder : blueprintsFolders) {
            if (!folder.isFolder) continue;
            SiteBlueprintTO blueprintTO = new SiteBlueprintTO();
            blueprintTO.id = folder.name;
            blueprintTO.label = StringUtils.capitalize((String)folder.name);
            blueprintTO.description = "";
            blueprintTO.screenshots = null;
            blueprints.add(blueprintTO);
        }
        return blueprints.toArray(new SiteBlueprintTO[blueprints.size()]);
    }

    @ValidateParams
    public String getPreviewServerUrl(@ValidateStringParam(name="site") String site) {
        return this.environmentConfig.getPreviewServerUrl(site);
    }

    @ValidateParams
    public String getLiveServerUrl(@ValidateStringParam(name="site") String site) {
        return this.environmentConfig.getLiveServerUrl(site);
    }

    @ValidateParams
    public String getAuthoringServerUrl(@ValidateStringParam(name="site") String site) {
        return this.environmentConfig.getAuthoringServerUrl(site);
    }

    @ValidateParams
    public String getAdminEmailAddress(@ValidateStringParam(name="site") String site) {
        return this.environmentConfig.getAdminEmailAddress(site);
    }

    public void reloadSiteConfigurations() {
        this.reloadGlobalConfiguration();
        Set sites = this.getAllAvailableSites();
    }

    @ValidateParams
    public void reloadSiteConfiguration(@ValidateStringParam(name="site") String site) {
        this.reloadSiteConfiguration(site, true);
    }

    public void reloadSiteConfiguration(String site, boolean triggerEvent) {
        SiteTO siteConfig = new SiteTO();
        siteConfig.setSite(site);
        siteConfig.setEnvironment(this.getEnvironment());
        this.servicesConfig.reloadConfiguration(site);
        this.environmentConfig.reloadConfiguration(site);
        this.loadSiteEnvironmentConfig(site, siteConfig);
        this.notificationService.reloadConfiguration(site);
        this.securityService.reloadConfiguration(site);
        this.contentTypeService.reloadConfiguration(site);
    }

    public void reloadGlobalConfiguration() {
        this.securityService.reloadGlobalConfiguration();
    }

    @ValidateParams
    public void syncRepository(@ValidateStringParam(name="site") String site) throws SiteNotFoundException {
        if (!this.exists(site)) {
            throw new SiteNotFoundException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", site);
        String lastDbCommitId = this.siteFeedMapper.getLastCommitId(params);
        if (lastDbCommitId != null) {
            this.syncDatabaseWithRepository.execute(site, lastDbCommitId);
        } else {
            this.rebuildDatabase(site);
        }
    }

    @ValidateParams
    public void rebuildDatabase(@ValidateStringParam(name="site") String site) {
        this.rebuildRepositoryMetadata.execute(site);
    }

    @ValidateParams
    public void updateLastCommitId(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="commitId") String commitId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", site);
        params.put("lastCommitId", commitId);
        this.siteFeedMapper.updateLastCommitId(params);
    }

    private void updateLastVerifiedGitlogCommitId(String site, String commitId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", site);
        params.put("commitId", commitId);
        this.siteFeedMapper.updateLastVerifiedGitlogCommitId(params);
    }

    @ValidateParams
    public boolean syncDatabaseWithRepo(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="fromCommitId") String fromCommitId) {
        boolean toReturn = true;
        List repoOperations = this.contentRepository.getOperations(site, fromCommitId, this.contentRepository.getRepoLastCommitId(site));
        if (CollectionUtils.isEmpty((Collection)repoOperations)) {
            logger.debug("Database is up to date with repository for site: " + site, new Object[0]);
            this.contentRepository.markGitLogVerifiedProcessed(site, fromCommitId);
            return toReturn;
        }
        logger.info("Syncing database with repository for site: " + site + " fromCommitId = " + (StringUtils.isEmpty((CharSequence)fromCommitId) ? "Empty repo" : fromCommitId), new Object[0]);
        logger.debug("Operations to sync: ", new Object[0]);
        for (RepoOperationTO repoOperation : repoOperations) {
            logger.debug("\tOperation: " + repoOperation.getOperation().toString() + " " + repoOperation.getPath(), new Object[0]);
        }
        boolean diverged = false;
        GitLog current = null;
        block11: for (RepoOperationTO repoOperation : repoOperations) {
            boolean gitLogProcessed = false;
            logger.debug("Verifying repo opertation " + repoOperation.getOperation().toString() + " " + repoOperation.getPath(), new Object[0]);
            logger.debug("Get Git Log from database for commit id " + repoOperation.getCommitId(), new Object[0]);
            GitLog gitLog = this.contentRepository.getGitLog(site, repoOperation.getCommitId());
            if (gitLog != null) {
                diverged = diverged || gitLog.getProcessed() < 1;
            } else {
                logger.debug("Git Log does not exist in database for commit id " + repoOperation.getCommitId(), new Object[0]);
                logger.debug("Inserting Git Log for commit id " + repoOperation.getCommitId() + " and site " + site, new Object[0]);
                this.contentRepository.insertGitLog(site, repoOperation.getCommitId(), 0);
                logger.debug("Repository diverged from database. All repository operations onwards need to be processed", new Object[0]);
                diverged = true;
                gitLogProcessed = false;
                gitLog = this.contentRepository.getGitLog(site, repoOperation.getCommitId());
            }
            if (current == null) {
                current = gitLog;
            } else if (!current.getCommitId().equals(gitLog.getCommitId())) {
                this.contentRepository.markGitLogVerifiedProcessed(site, current.getCommitId());
                current = gitLog;
            }
            if (!diverged) continue;
            HashMap<String, String> activityInfo = new HashMap<String, String>();
            switch (1.$SwitchMap$org$craftercms$studio$api$v1$constant$RepoOperation[repoOperation.getOperation().ordinal()]) {
                case 1: 
                case 2: {
                    ItemState state = this.objectStateService.getObjectState(site, repoOperation.getPath(), false);
                    if (state == null) {
                        logger.debug("Insert item state for site: " + site + " path: " + repoOperation.getPath(), new Object[0]);
                        this.objectStateService.insertNewEntry(site, repoOperation.getPath());
                    } else {
                        logger.debug("Set item state for site: " + site + " path: " + repoOperation.getPath(), new Object[0]);
                        this.objectStateService.transition(site, repoOperation.getPath(), TransitionEvent.SAVE);
                    }
                    logger.debug("Set item metadata for site: " + site + " path: " + repoOperation.getPath(), new Object[0]);
                    if (!this.objectMetadataManager.metadataExist(site, repoOperation.getPath())) {
                        this.objectMetadataManager.insertNewObjectMetadata(site, repoOperation.getPath());
                    }
                    HashMap<String, Object> properties = new HashMap();
                    properties.put("site", site);
                    properties.put("path", repoOperation.getPath());
                    properties.put("modifier", repoOperation.getAuthor());
                    properties.put("modified", repoOperation.getDateTime());
                    properties.put("commitId", repoOperation.getCommitId());
                    this.objectMetadataManager.setObjectMetadata(site, repoOperation.getMoveToPath(), properties);
                    logger.debug("Extract dependencies for site: " + site + " path: " + repoOperation.getPath(), new Object[0]);
                    toReturn = toReturn && this.extractDependenciesForItem(site, repoOperation.getPath());
                    String contentClass = this.contentService.getContentTypeClass(site, repoOperation.getPath());
                    if (repoOperation.getPath().endsWith(".xml")) {
                        activityInfo.put("contentType", contentClass);
                    }
                    logger.debug("Insert audit log for site: " + site + " path: " + repoOperation.getPath(), new Object[0]);
                    this.activityService.postActivity(site, repoOperation.getAuthor(), repoOperation.getPath(), ActivityService.ActivityType.CREATED, ActivityService.ActivitySource.REPOSITORY, activityInfo);
                    continue block11;
                }
                case 3: {
                    logger.debug("Set item state for site: " + site + " path: " + repoOperation.getPath(), new Object[0]);
                    this.objectStateService.getObjectState(site, repoOperation.getPath());
                    this.objectStateService.transition(site, repoOperation.getPath(), TransitionEvent.SAVE);
                    logger.debug("Set item metadata for site: " + site + " path: " + repoOperation.getPath(), new Object[0]);
                    if (!this.objectMetadataManager.metadataExist(site, repoOperation.getPath())) {
                        this.objectMetadataManager.insertNewObjectMetadata(site, repoOperation.getPath());
                    }
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    properties.put("site", site);
                    properties.put("path", repoOperation.getPath());
                    properties.put("modifier", repoOperation.getAuthor());
                    properties.put("modified", repoOperation.getDateTime());
                    properties.put("commitId", repoOperation.getCommitId());
                    this.objectMetadataManager.setObjectMetadata(site, repoOperation.getMoveToPath(), properties);
                    logger.debug("Extract dependencies for site: " + site + " path: " + repoOperation.getPath(), new Object[0]);
                    toReturn = toReturn && this.extractDependenciesForItem(site, repoOperation.getPath());
                    String contentClass = this.contentService.getContentTypeClass(site, repoOperation.getPath());
                    if (repoOperation.getPath().endsWith(".xml")) {
                        activityInfo.put("contentType", contentClass);
                    }
                    logger.debug("Insert audit log for site: " + site + " path: " + repoOperation.getPath(), new Object[0]);
                    this.activityService.postActivity(site, repoOperation.getAuthor(), repoOperation.getPath(), ActivityService.ActivityType.UPDATED, ActivityService.ActivitySource.REPOSITORY, activityInfo);
                    continue block11;
                }
                case 4: {
                    logger.debug("Delete item state for site: " + site + " path: " + repoOperation.getPath(), new Object[0]);
                    this.objectStateService.deleteObjectStateForPath(site, repoOperation.getPath());
                    logger.debug("Delete item metadata for site: " + site + " path: " + repoOperation.getPath(), new Object[0]);
                    this.objectMetadataManager.deleteObjectMetadata(site, repoOperation.getPath());
                    logger.debug("Extract dependencies for site: " + site + " path: " + repoOperation.getPath(), new Object[0]);
                    try {
                        this.dependencyService.deleteItemDependencies(site, repoOperation.getPath());
                    }
                    catch (ServiceException e) {
                        logger.error("Error deleting dependencies for site " + site + " file: " + repoOperation.getPath(), (Exception)((Object)e), new Object[0]);
                    }
                    String contentClass = this.contentService.getContentTypeClass(site, repoOperation.getPath());
                    if (repoOperation.getPath().endsWith(".xml")) {
                        activityInfo.put("contentType", contentClass);
                    }
                    logger.debug("Insert audit log for site: " + site + " path: " + repoOperation.getPath(), new Object[0]);
                    this.activityService.postActivity(site, repoOperation.getAuthor(), repoOperation.getPath(), ActivityService.ActivityType.DELETED, ActivityService.ActivitySource.REPOSITORY, activityInfo);
                    continue block11;
                }
                case 5: {
                    HashMap<String, Object> properties;
                    ItemState stateRename = this.objectStateService.getObjectState(site, repoOperation.getPath(), false);
                    logger.debug("Set item state for site: " + site + " path: " + repoOperation.getMoveToPath(), new Object[0]);
                    if (stateRename == null) {
                        this.objectStateService.getObjectState(site, repoOperation.getMoveToPath());
                        this.objectStateService.transition(site, repoOperation.getMoveToPath(), TransitionEvent.SAVE);
                    } else {
                        this.objectStateService.updateObjectPath(site, repoOperation.getPath(), repoOperation.getMoveToPath());
                        this.objectStateService.transition(site, repoOperation.getMoveToPath(), TransitionEvent.SAVE);
                    }
                    logger.debug("Set item metadata for site: " + site + " path: " + repoOperation.getMoveToPath(), new Object[0]);
                    if (!this.objectMetadataManager.metadataExist(site, repoOperation.getPath())) {
                        if (!this.objectMetadataManager.metadataExist(site, repoOperation.getMoveToPath())) {
                            this.objectMetadataManager.insertNewObjectMetadata(site, repoOperation.getMoveToPath());
                        } else if (!this.objectMetadataManager.isRenamed(site, repoOperation.getMoveToPath())) {
                            properties = new HashMap();
                            properties.put("site", site);
                            properties.put("path", repoOperation.getMoveToPath());
                            properties.put("renamed", 1);
                            properties.put("oldUrl", repoOperation.getPath());
                            properties.put("commitId", repoOperation.getCommitId());
                            properties.put("modifier", repoOperation.getAuthor());
                            properties.put("modified", repoOperation.getDateTime());
                            this.objectMetadataManager.setObjectMetadata(site, repoOperation.getMoveToPath(), properties);
                        }
                    } else if (!this.objectMetadataManager.metadataExist(site, repoOperation.getMoveToPath())) {
                        this.objectMetadataManager.updateObjectPath(site, repoOperation.getPath(), repoOperation.getMoveToPath());
                        properties = new HashMap();
                        properties.put("site", site);
                        properties.put("path", repoOperation.getMoveToPath());
                        properties.put("renamed", 1);
                        properties.put("oldUrl", repoOperation.getPath());
                        properties.put("commitId", repoOperation.getCommitId());
                        properties.put("modifier", repoOperation.getAuthor());
                        this.objectMetadataManager.setObjectMetadata(site, repoOperation.getMoveToPath(), properties);
                    } else {
                        if (!this.objectMetadataManager.isRenamed(site, repoOperation.getMoveToPath())) {
                            properties = new HashMap();
                            properties.put("site", site);
                            properties.put("path", repoOperation.getMoveToPath());
                            properties.put("renamed", 1);
                            properties.put("oldUrl", repoOperation.getPath());
                            properties.put("commitId", repoOperation.getCommitId());
                            properties.put("modifier", repoOperation.getAuthor());
                            this.objectMetadataManager.setObjectMetadata(site, repoOperation.getMoveToPath(), properties);
                        }
                        this.objectMetadataManager.deleteObjectMetadata(site, repoOperation.getPath());
                    }
                    logger.debug("Extract dependencies for site: " + site + " path: " + repoOperation.getPath(), new Object[0]);
                    toReturn = toReturn && this.extractDependenciesForItem(site, repoOperation.getMoveToPath());
                    String contentClass = this.contentService.getContentTypeClass(site, repoOperation.getMoveToPath());
                    if (repoOperation.getMoveToPath().endsWith(".xml")) {
                        activityInfo.put("contentType", contentClass);
                    }
                    logger.debug("Insert audit log for site: " + site + " path: " + repoOperation.getMoveToPath(), new Object[0]);
                    this.activityService.postActivity(site, repoOperation.getAuthor(), repoOperation.getMoveToPath(), ActivityService.ActivityType.UPDATED, ActivityService.ActivitySource.REPOSITORY, activityInfo);
                    continue block11;
                }
            }
            logger.error("Error: Unknown repo operation for site " + site + " operation: " + repoOperation.getOperation(), new Object[0]);
            toReturn = false;
        }
        if (current != null) {
            this.contentRepository.markGitLogVerifiedProcessed(site, current.getCommitId());
            this.updateLastVerifiedGitlogCommitId(site, current.getCommitId());
        }
        logger.debug("Done syncing operations with a result of: " + toReturn, new Object[0]);
        logger.debug("Syncing database lastCommitId for site: " + site, new Object[0]);
        String lastCommitId = this.contentRepository.getRepoLastCommitId(site);
        logger.debug("Update last commit id " + lastCommitId + " for site " + site, new Object[0]);
        this.updateLastCommitId(site, lastCommitId);
        try {
            logger.debug("Sync preview for site " + site, new Object[0]);
            this.deploymentService.syncAllContentToPreview(site, false);
        }
        catch (ServiceException e) {
            logger.error("Error synchronizing preview with repository for site: " + site, (Exception)((Object)e), new Object[0]);
        }
        logger.info("Done syncing database with repository for site: " + site + " fromCommitId = " + (StringUtils.isEmpty((CharSequence)fromCommitId) ? "Empty repo" : fromCommitId) + " with a final result of: " + toReturn, new Object[0]);
        logger.info("Last commit ID for site: " + site + " is " + lastCommitId, new Object[0]);
        if (!toReturn) {
            logger.error("Some operations failed to sync to database for site: " + site + " see previous error logs", new Object[0]);
        }
        return toReturn;
    }

    protected boolean extractDependenciesForItem(String site, String path) {
        boolean toReturn;
        block6: {
            toReturn = true;
            try {
                if (path.endsWith(".xml")) {
                    SAXReader saxReader = new SAXReader();
                    try {
                        saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                        saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                        saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    }
                    catch (SAXException ex) {
                        logger.error("Unable to turn off external entity loading, This could be a security risk.", (Exception)ex, new Object[0]);
                    }
                    this.dependencyService.upsertDependencies(site, path);
                    break block6;
                }
                boolean isCss = path.endsWith(".css");
                boolean isJs = path.endsWith(".js");
                boolean isTemplate = ContentUtils.matchesPatterns((String)path, (List)this.servicesConfig.getRenderingTemplatePatterns(site));
                if (isCss || isJs || isTemplate) {
                    this.dependencyService.upsertDependencies(site, path);
                }
            }
            catch (ServiceException e) {
                logger.error("Error extracting dependencies for site " + site + " file: " + path, (Exception)((Object)e), new Object[0]);
                toReturn = false;
            }
        }
        return toReturn;
    }

    @ValidateParams
    public boolean exists(@ValidateStringParam(name="site") String site) {
        return this.siteFeedMapper.exists(site) > 0;
    }

    @ValidateParams
    public int getSitesPerUserTotal(@ValidateStringParam(name="username") String username) throws UserNotFoundException {
        if (this.securityService.userExists(username)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("username", username);
            return this.siteFeedMapper.getSitesPerUserQueryTotal(params);
        }
        throw new UserNotFoundException();
    }

    @ValidateParams
    public List<SiteFeed> getSitesPerUser(@ValidateStringParam(name="username") String username, @ValidateIntegerParam(name="start") int start, @ValidateIntegerParam(name="number") int number) throws UserNotFoundException {
        if (this.securityService.userExists(username)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("username", username);
            params.put("start", start);
            params.put("number", number);
            List siteIds = this.siteFeedMapper.getSitesPerUserQuery(params);
            List<Object> toRet = new ArrayList<SiteFeed>();
            if (siteIds != null && !siteIds.isEmpty()) {
                params = new HashMap();
                params.put("siteids", siteIds);
                toRet = this.siteFeedMapper.getSitesPerUserData(params);
            }
            return toRet;
        }
        throw new UserNotFoundException();
    }

    @ValidateParams
    public SiteFeed getSite(@ValidateStringParam(name="siteId") String siteId) throws SiteNotFoundException {
        if (this.exists(siteId)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("siteId", siteId);
            return this.siteFeedMapper.getSite(params);
        }
        throw new SiteNotFoundException();
    }

    @ValidateParams
    public boolean isPublishingEnabled(@ValidateStringParam(name="siteId") String siteId) {
        try {
            SiteFeed siteFeed = this.getSite(siteId);
            return siteFeed.getPublishingEnabled() > 0;
        }
        catch (SiteNotFoundException e) {
            logger.debug("Site " + siteId + " not found. Publishing disabled", new Object[0]);
            return false;
        }
    }

    @ValidateParams
    public boolean enablePublishing(@ValidateStringParam(name="siteId") String siteId, boolean enabled) throws SiteNotFoundException {
        if (this.exists(siteId)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("siteId", siteId);
            params.put("enabled", enabled ? 1 : 0);
            this.siteFeedMapper.enablePublishing(params);
            return true;
        }
        throw new SiteNotFoundException();
    }

    @ValidateParams
    public boolean updatePublishingStatusMessage(@ValidateStringParam(name="siteId") String siteId, @ValidateStringParam(name="message") String message) throws SiteNotFoundException {
        if (this.exists(siteId)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("siteId", siteId);
            params.put("message", message);
            this.siteFeedMapper.updatePublishingStatusMessage(params);
            return true;
        }
        throw new SiteNotFoundException();
    }

    @ValidateParams
    public PublishStatus getPublishStatus(@ValidateStringParam(name="site") String site) throws SiteNotFoundException {
        SiteFeed siteFeed = this.getSite(site);
        String psm = siteFeed.getPublishingStatusMessage();
        PublishStatus ps = new PublishStatus();
        if (StringUtils.isNotEmpty((CharSequence)psm)) {
            StringTokenizer tokenizer = new StringTokenizer(psm, "|");
            if (tokenizer.countTokens() > 1) {
                ps.setStatus(tokenizer.nextToken());
                ps.setMessage(tokenizer.nextToken());
            } else {
                ps.setMessage(psm);
            }
        } else {
            psm = this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.default");
            StringTokenizer tokenizer = new StringTokenizer(psm, "|");
            if (tokenizer.countTokens() > 1) {
                ps.setStatus(tokenizer.nextToken());
                ps.setMessage(tokenizer.nextToken());
            } else {
                ps.setMessage(psm);
            }
        }
        return ps;
    }

    public boolean addRemote(String siteId, String remoteName, String remoteUrl, String authenticationType, String remoteUsername, String remotePassword, String remoteToken, String remotePrivateKey) throws InvalidRemoteUrlException, ServiceException {
        if (!this.exists(siteId)) {
            throw new SiteNotFoundException();
        }
        boolean toRet = this.contentRepository.addRemote(siteId, remoteName, remoteUrl, authenticationType, remoteUsername, remotePassword, remoteToken, remotePrivateKey);
        this.insertAddRemoteAuditLog(siteId, remoteName);
        return toRet;
    }

    private void insertAddRemoteAuditLog(String siteId, String remoteName) {
        ActivityService.ActivityType activityType = ActivityService.ActivityType.ADD_REMOTE;
        String user = this.securityProvider.getCurrentUser();
        HashMap<String, String> extraInfo = new HashMap<String, String>();
        extraInfo.put("contentType", "remoteRepository");
        this.activityService.postActivity(siteId, user, remoteName, activityType, ActivityService.ActivitySource.API, extraInfo);
    }

    public boolean removeRemote(String siteId, String remoteName) throws SiteNotFoundException {
        if (!this.exists(siteId)) {
            throw new SiteNotFoundException();
        }
        boolean toRet = this.contentRepository.removeRemote(siteId, remoteName);
        this.insertRemoveRemoteAuditLog(siteId, remoteName);
        return toRet;
    }

    private void insertRemoveRemoteAuditLog(String siteId, String remoteName) {
        ActivityService.ActivityType activityType = ActivityService.ActivityType.REMOVE_REMOTE;
        String user = this.securityProvider.getCurrentUser();
        HashMap<String, String> extraInfo = new HashMap<String, String>();
        extraInfo.put("contentType", "remoteRepository");
        this.activityService.postActivity(siteId, user, remoteName, activityType, ActivityService.ActivitySource.API, extraInfo);
    }

    public List<RemoteRepositoryInfoTO> listRemote(String siteId) throws ServiceException {
        if (!this.exists(siteId)) {
            throw new SiteNotFoundException();
        }
        SiteFeed siteFeed = this.getSite(siteId);
        return this.contentRepository.listRemote(siteId, siteFeed.getSandboxBranch());
    }

    public String getGlobalConfigRoot() {
        return this.studioConfiguration.getProperty("studio.configuration.global.configBasePath");
    }

    public String getSitesConfigPath() {
        return this.studioConfiguration.getProperty("studio.configuration.site.configBasePath");
    }

    public String getEnvironment() {
        return this.studioConfiguration.getProperty("studio.configuration.site.environment");
    }

    public String getEnvironmentConfigPath() {
        return this.studioConfiguration.getProperty("studio.configuration.site.environment.configBasePath");
    }

    public List<String> getDefaultGroups() {
        return Arrays.asList(this.studioConfiguration.getProperty("studio.configuration.site.defaultGroups").split(","));
    }

    public String getDefaultAdminGroup() {
        return this.studioConfiguration.getProperty("studio.configuration.site.defaultAdminGroup");
    }

    public SiteServiceDAL getSiteService() {
        return this._siteServiceDAL;
    }

    public void setSiteServiceDAL(SiteServiceDAL service) {
        this._siteServiceDAL = service;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public SiteEnvironmentConfig getEnvironmentConfig() {
        return this.environmentConfig;
    }

    public void setEnvironmentConfig(SiteEnvironmentConfig environmentConfig) {
        this.environmentConfig = environmentConfig;
    }

    public ContentRepository getContenetRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(ContentRepository repo) {
        this.contentRepository = repo;
    }

    public ObjectStateService getObjectStateService() {
        return this.objectStateService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }

    public DependencyService getDependencyService() {
        return this.dependencyService;
    }

    public void setDependencyService(DependencyService dependencyService) {
        this.dependencyService = dependencyService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public ActivityService getActivityService() {
        return this.activityService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public DeploymentService getDeploymentService() {
        return this.deploymentService;
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public ObjectMetadataManager getObjectMetadataManager() {
        return this.objectMetadataManager;
    }

    public void setObjectMetadataManager(ObjectMetadataManager objectMetadataManager) {
        this.objectMetadataManager = objectMetadataManager;
    }

    public DmPageNavigationOrderService getDmPageNavigationOrderService() {
        return this.dmPageNavigationOrderService;
    }

    public void setDmPageNavigationOrderService(DmPageNavigationOrderService dmPageNavigationOrderService) {
        this.dmPageNavigationOrderService = dmPageNavigationOrderService;
    }

    public ContentTypeService getContentTypeService() {
        return this.contentTypeService;
    }

    public void setContentTypeService(ContentTypeService contentTypeService) {
        this.contentTypeService = contentTypeService;
    }

    public SecurityProvider getSecurityProvider() {
        return this.securityProvider;
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    public ImportService getImportService() {
        return this.importService;
    }

    public void setImportService(ImportService importService) {
        this.importService = importService;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public GeneralLockService getGeneralLockService() {
        return this.generalLockService;
    }

    public void setGeneralLockService(GeneralLockService generalLockService) {
        this.generalLockService = generalLockService;
    }

    public RebuildRepositoryMetadata getRebuildRepositoryMetadata() {
        return this.rebuildRepositoryMetadata;
    }

    public void setRebuildRepositoryMetadata(RebuildRepositoryMetadata rebuildRepositoryMetadata) {
        this.rebuildRepositoryMetadata = rebuildRepositoryMetadata;
    }

    public SyncDatabaseWithRepository getSyncDatabaseWithRepository() {
        return this.syncDatabaseWithRepository;
    }

    public void setSyncDatabaseWithRepository(SyncDatabaseWithRepository syncDatabaseWithRepository) {
        this.syncDatabaseWithRepository = syncDatabaseWithRepository;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public EventService getEventService() {
        return this.eventService;
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public PreviewDeployer getPreviewDeployer() {
        return this.previewDeployer;
    }

    public void setPreviewDeployer(PreviewDeployer previewDeployer) {
        this.previewDeployer = previewDeployer;
    }

    public void setEntitlementValidator(EntitlementValidator entitlementValidator) {
        this.entitlementValidator = entitlementValidator;
    }
}

