/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.webdav;

import com.github.sardine.Sardine;
import com.github.sardine.SardineFactory;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.exception.WebDavException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.webdav.WebDavService;
import org.craftercms.studio.api.v1.webdav.WebDavItem;
import org.craftercms.studio.api.v1.webdav.WebDavProfile;
import org.craftercms.studio.api.v1.webdav.WebDavProfileReader;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.MimeType;
import org.springframework.web.util.UriUtils;

public class WebDavServiceImpl
implements WebDavService {
    private static final Logger logger = LoggerFactory.getLogger(WebDavServiceImpl.class);
    public static final String PROPERTY_DISPLAY_NAME = "displayname";
    public static final String PROPERTY_CONTENT_TYPE = "getcontenttype";
    public static final String PROPERTY_RESOURCE_TYPE = "resourcetype";
    public static final String FILTER_ALL_ITEMS = "item";
    protected WebDavProfileReader profileReader;
    protected Charset charset = Charset.defaultCharset();
    protected Set<QName> properties = new HashSet();

    public WebDavServiceImpl() {
        this.properties.add(new QName("DAV:", PROPERTY_DISPLAY_NAME, "d"));
        this.properties.add(new QName("DAV:", PROPERTY_CONTENT_TYPE, "d"));
        this.properties.add(new QName("DAV:", PROPERTY_RESOURCE_TYPE, "d"));
    }

    @Required
    public void setProfileReader(WebDavProfileReader profileReader) {
        this.profileReader = profileReader;
    }

    public List<WebDavItem> list(@ValidateStringParam(name="site_id") String site, @ValidateStringParam(name="profile") String profileId, @ValidateStringParam(name="path") String path, @ValidateStringParam(name="type") String type) throws WebDavException {
        WebDavProfile profile = this.profileReader.getProfile(site, profileId);
        String finalPath = profile.getBaseUrl();
        Sardine sardine = SardineFactory.begin((String)profile.getUsername(), (String)profile.getPassword());
        try {
            MimeType filterType = StringUtils.isEmpty((String)type) || type.equals(FILTER_ALL_ITEMS) ? MimeType.valueOf((String)"*/*") : new MimeType(type);
            if (StringUtils.isNotEmpty((String)path)) {
                String[] tokens;
                for (String token : tokens = path.split("\\/")) {
                    finalPath = finalPath + "/" + UriUtils.encode((String)token, (String)this.charset.name());
                }
            }
            if (!finalPath.endsWith("/")) {
                finalPath = finalPath + "/";
            }
            logger.debug("Listing resources at {0}", new Object[]{finalPath});
            List resources = sardine.propfind(finalPath, 1, this.properties);
            logger.debug("Found {0} resources", new Object[]{resources.size()});
            return resources.stream().filter(r -> r.isDirectory() || filterType.includes(MimeType.valueOf((String)r.getContentType()))).map(r -> new WebDavItem(r.getDisplayName(), profile.getBaseUrl() + r.getPath(), r.isDirectory())).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new WebDavException("Error listing resources", e);
        }
    }

    public String upload(@ValidateStringParam(name="site_id") String site, @ValidateStringParam(name="profile") String profileId, @ValidateStringParam(name="path") String path, @ValidateStringParam(name="filename") String filename, InputStream content) throws WebDavException {
        WebDavProfile profile = this.profileReader.getProfile(site, profileId);
        String uploadUrl = profile.getBaseUrl();
        try {
            if (StringUtils.isNotEmpty((String)path)) {
                uploadUrl = uploadUrl + (path.startsWith("/") ? path : "/" + path);
            }
            String fileUrl = uploadUrl + "/" + UriUtils.encode((String)filename, (String)this.charset.name());
            logger.debug("Starting upload of file {0}", new Object[]{filename});
            logger.debug("Uploading file to {0}", new Object[]{fileUrl});
            Sardine sardine = SardineFactory.begin((String)profile.getUsername(), (String)profile.getPassword());
            try {
                logger.debug("Creating upload folder {0}", new Object[]{uploadUrl});
                sardine.createDirectory(uploadUrl);
            }
            catch (Exception e) {
                logger.debug("Upload folder already exists", new Object[0]);
            }
            sardine.put(fileUrl, content);
            logger.debug("Upload complete", new Object[0]);
            return fileUrl;
        }
        catch (Exception e) {
            throw new WebDavException("Error uploading file", e);
        }
    }
}

