/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.workflow;

import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateSecurePathParam;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.dal.ItemMetadata;
import org.craftercms.studio.api.v1.dal.ItemState;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.activity.ActivityService;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v1.service.dependency.DependencyRules;
import org.craftercms.studio.api.v1.service.dependency.DependencyService;
import org.craftercms.studio.api.v1.service.deployment.DeploymentException;
import org.craftercms.studio.api.v1.service.deployment.DeploymentService;
import org.craftercms.studio.api.v1.service.deployment.DmPublishService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.service.objectstate.State;
import org.craftercms.studio.api.v1.service.objectstate.TransitionEvent;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.service.workflow.WorkflowService;
import org.craftercms.studio.api.v1.service.workflow.context.GoLiveContext;
import org.craftercms.studio.api.v1.service.workflow.context.MultiChannelPublishingContext;
import org.craftercms.studio.api.v1.service.workflow.context.RequestContext;
import org.craftercms.studio.api.v1.service.workflow.context.RequestContextBuilder;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.DmDependencyTO;
import org.craftercms.studio.api.v1.to.DmError;
import org.craftercms.studio.api.v1.to.DmFolderConfigTO;
import org.craftercms.studio.api.v1.to.GoLiveDeleteCandidates;
import org.craftercms.studio.api.v1.to.GoLiveQueue;
import org.craftercms.studio.api.v1.to.GoLiveQueueChildFilter;
import org.craftercms.studio.api.v1.to.ResultTO;
import org.craftercms.studio.api.v1.util.DmContentItemComparator;
import org.craftercms.studio.api.v1.util.StudioConfiguration;
import org.craftercms.studio.api.v1.util.filter.DmFilterWrapper;
import org.craftercms.studio.api.v2.service.notification.NotificationMessageType;
import org.craftercms.studio.api.v2.service.notification.NotificationService;
import org.craftercms.studio.impl.v1.service.workflow.WorkflowProcessor;
import org.craftercms.studio.impl.v1.service.workflow.WorkflowServiceImpl;
import org.craftercms.studio.impl.v1.service.workflow.operation.PreGoLiveOperation;
import org.craftercms.studio.impl.v1.service.workflow.operation.PreScheduleDeleteOperation;
import org.craftercms.studio.impl.v1.service.workflow.operation.PreScheduleOperation;
import org.craftercms.studio.impl.v1.service.workflow.operation.PreSubmitDeleteOperation;
import org.craftercms.studio.impl.v1.service.workflow.operation.SubmitLifeCycleOperation;
import org.craftercms.studio.impl.v1.util.ContentFormatUtils;
import org.craftercms.studio.impl.v1.util.ContentUtils;
import org.craftercms.studio.impl.v1.util.GoLiveQueueOrganizer;

public class WorkflowServiceImpl
implements WorkflowService {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowServiceImpl.class);
    protected String JSON_KEY_ITEMS = "items";
    protected String JSON_KEY_SCHEDULED_DATE = "scheduledDate";
    protected String JSON_KEY_IS_NOW = "now";
    protected String JSON_KEY_PUBLISH_CHANNEL = "publishChannel";
    protected String JSON_KEY_STATUS_SET = "status";
    protected String JSON_KEY_STATUS_MESSAGE = "message";
    protected String JSON_KEY_SUBMISSION_COMMENT = "submissionComment";
    protected String JSON_KEY_URI = "uri";
    protected String JSON_KEY_DELETED = "deleted";
    protected String JSON_KEY_SUBMITTED_FOR_DELETION = "submittedForDeletion";
    protected String JSON_KEY_SUBMITTED = "submitted";
    protected String JSON_KEY_IN_PROGRESS = "inProgress";
    protected String JSON_KEY_IN_REFERENCE = "reference";
    protected String JSON_KEY_COMPONENTS = "components";
    protected String JSON_KEY_DOCUMENTS = "documents";
    protected String JSON_KEY_ASSETS = "assets";
    protected String JSON_KEY_RENDERING_TEMPLATES = "renderingTemplates";
    protected String JSON_KEY_DELETED_ITEMS = "deletedItems";
    protected String JSON_KEY_CHILDREN = "children";
    protected String JSON_KEY_SEND_EMAIL = "sendEmail";
    protected String JSON_KEY_USER = "user";
    protected String JSON_KEY_REASON = "reason";
    protected String JSON_KEY_ENVIRONMENT = "environment";
    public static final String COMPLETE_SUBMIT_TO_GO_LIVE_MSG = "submitToGoLive";
    protected ServicesConfig servicesConfig;
    protected DeploymentService deploymentService;
    protected ContentService contentService;
    protected DmFilterWrapper dmFilterWrapper;
    protected DependencyService dependencyService;
    protected ObjectStateService objectStateService;
    protected DmPublishService dmPublishService;
    protected GeneralLockService generalLockService;
    protected SecurityService securityService;
    protected SiteService siteService;
    protected WorkflowProcessor workflowProcessor;
    protected ObjectMetadataManager objectMetadataManager;
    protected NotificationService notificationService;
    protected StudioConfiguration studioConfiguration;
    protected ActivityService activityService;

    @ValidateParams
    public ResultTO submitToGoLive(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="username") String username, String request) throws ServiceException {
        return this.submitForApproval(site, username, request, false);
    }

    protected ResultTO submitForApproval(String site, String submittedBy, String request, boolean delete) throws ServiceException {
        RequestContext requestContext = RequestContextBuilder.buildSubmitContext((String)site, (String)submittedBy);
        ResultTO result = new ResultTO();
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
            JSONObject requestObject = JSONObject.fromObject((Object)request);
            JSONArray items = requestObject.getJSONArray(this.JSON_KEY_ITEMS);
            int length = items.size();
            if (length > 0) {
                for (int index = 0; index < length; ++index) {
                    this.objectStateService.setSystemProcessing(site, items.optString(index), true);
                }
            }
            boolean isNow = requestObject.containsKey((Object)this.JSON_KEY_IS_NOW) ? requestObject.getBoolean(this.JSON_KEY_IS_NOW) : false;
            ZonedDateTime scheduledDate = null;
            if (!isNow) {
                scheduledDate = requestObject.containsKey((Object)this.JSON_KEY_SCHEDULED_DATE) ? this.getScheduledDate(site, format, requestObject.getString(this.JSON_KEY_SCHEDULED_DATE)) : null;
            }
            boolean sendEmail = requestObject.containsKey((Object)this.JSON_KEY_SEND_EMAIL) ? requestObject.getBoolean(this.JSON_KEY_SEND_EMAIL) : false;
            String environment = requestObject != null && requestObject.containsKey((Object)this.JSON_KEY_ENVIRONMENT) ? requestObject.getString(this.JSON_KEY_ENVIRONMENT) : null;
            String submissionComment = requestObject != null && requestObject.containsKey((Object)this.JSON_KEY_SUBMISSION_COMMENT) ? requestObject.getString(this.JSON_KEY_SUBMISSION_COMMENT) : null;
            String schDate = null;
            if (requestObject.containsKey((Object)this.JSON_KEY_SCHEDULED_DATE)) {
                schDate = requestObject.getString(this.JSON_KEY_SCHEDULED_DATE);
            }
            if (length > 0) {
                ArrayList<DmDependencyTO> submittedItems = new ArrayList<DmDependencyTO>();
                for (int index = 0; index < length; ++index) {
                    String stringItem = items.optString(index);
                    DmDependencyTO submittedItem = this.getSubmittedItem(site, stringItem, format, schDate, null);
                    String user = submittedBy;
                    submittedItems.add(submittedItem);
                    if (!delete) continue;
                    submittedItem.setSubmittedForDeletion(true);
                }
                submittedItems.addAll(this.addDependenciesForSubmitForApproval(site, submittedItems, format, schDate));
                ArrayList<String> submittedPaths = new ArrayList<String>();
                for (DmDependencyTO goLiveItem : submittedItems) {
                    submittedPaths.add(goLiveItem.getUri());
                    this.objectStateService.setSystemProcessing(site, goLiveItem.getUri(), true);
                    DependencyRules rule = new DependencyRules(site);
                    rule.setObjectStateService(this.objectStateService);
                    rule.setContentService(this.contentService);
                    Set depSet = rule.applySubmitRule(goLiveItem);
                    for (DmDependencyTO dep : depSet) {
                        submittedPaths.add(dep.getUri());
                        this.objectStateService.setSystemProcessing(site, dep.getUri(), true);
                    }
                }
                List errors = this.submitToGoLive(submittedItems, scheduledDate, sendEmail, delete, requestContext, submissionComment, environment);
                this.generateWorkflowActivity(site, submittedPaths, submittedBy, ActivityService.ActivityType.REQUEST_PUBLISH);
                result.setSuccess(true);
                result.setStatus(200);
                result.setMessage(this.notificationService.getNotificationMessage(site, NotificationMessageType.CompleteMessages, COMPLETE_SUBMIT_TO_GO_LIVE_MSG, Locale.ENGLISH, new Pair[0]));
                for (String relativePath : submittedPaths) {
                    this.objectStateService.setSystemProcessing(site, relativePath, false);
                }
            }
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setMessage(e.getMessage());
            logger.error("Error while submitting content for approval.", e, new Object[0]);
        }
        return result;
    }

    protected List<DmError> submitToGoLive(List<DmDependencyTO> submittedItems, ZonedDateTime scheduledDate, boolean sendEmail, boolean submitForDeletion, RequestContext requestContext, String submissionComment, String environment) throws ServiceException {
        ArrayList<DmError> errors = new ArrayList<DmError>();
        String site = requestContext.getSite();
        String submittedBy = requestContext.getUser();
        for (DmDependencyTO submittedItem : submittedItems) {
            try {
                DependencyRules rule = new DependencyRules(site);
                rule.setContentService(this.contentService);
                rule.setObjectStateService(this.objectStateService);
                this.submitThisAndReferredComponents(submittedItem, site, scheduledDate, sendEmail, submitForDeletion, submittedBy, rule, submissionComment, environment);
                List children = submittedItem.getChildren();
                if (children == null || submitForDeletion) continue;
                for (DmDependencyTO child : children) {
                    if (child.isReference()) continue;
                    this.submitThisAndReferredComponents(child, site, scheduledDate, sendEmail, submitForDeletion, submittedBy, rule, submissionComment, environment);
                }
            }
            catch (ContentNotFoundException e) {
                errors.add(new DmError(site, submittedItem.getUri(), (Exception)((Object)e)));
            }
        }
        this.notificationService.notifyApprovesContentSubmission(site, null, this.getDeploymentPaths(submittedItems), submittedBy, scheduledDate, submitForDeletion, submissionComment, Locale.ENGLISH);
        return errors;
    }

    private List<String> getDeploymentPaths(List<DmDependencyTO> submittedItems) {
        ArrayList<String> paths = new ArrayList<String>(submittedItems.size());
        for (DmDependencyTO submittedItem : submittedItems) {
            paths.add(submittedItem.getUri());
        }
        return paths;
    }

    protected void submitThisAndReferredComponents(DmDependencyTO submittedItem, String site, ZonedDateTime scheduledDate, boolean sendEmail, boolean submitForDeletion, String submittedBy, DependencyRules rule, String submissionComment, String environment) throws ServiceException {
        this.doSubmit(site, submittedItem, scheduledDate, sendEmail, submitForDeletion, submittedBy, true, submissionComment, environment);
        Set stringSet = submitForDeletion ? rule.applyDeleteDependencyRule(submittedItem) : rule.applySubmitRule(submittedItem);
        for (DmDependencyTO s : stringSet) {
            ContentItemTO contentItem = this.contentService.getContentItem(site, s.getUri());
            boolean lsendEmail = true;
            boolean lnotifyAdmin = true;
            lsendEmail = sendEmail && !contentItem.isDocument() && !contentItem.isComponent() && !contentItem.isAsset();
            lnotifyAdmin = !contentItem.isDocument() && !contentItem.isComponent() && !contentItem.isAsset();
            this.doSubmit(site, s, scheduledDate, lsendEmail, submitForDeletion, submittedBy, lnotifyAdmin, submissionComment, environment);
        }
    }

    protected void doSubmit(String site, DmDependencyTO dependencyTO, ZonedDateTime scheduledDate, boolean sendEmail, boolean submitForDeletion, String user, boolean notifyAdmin, String submissionComment, String environment) throws ServiceException {
        this.removeFromWorkflow(site, dependencyTO.getUri(), true);
        ContentItemTO item = this.contentService.getContentItem(site, dependencyTO.getUri());
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("submittedBy", user);
        properties.put("sendEmail", sendEmail ? 1 : 0);
        properties.put("submittedForDeletion", submitForDeletion ? 1 : 0);
        properties.put("submissionComment", submissionComment);
        properties.put("submittedToEnvironment", environment);
        if (null == scheduledDate) {
            properties.put("launchDate", null);
        } else {
            properties.put("launchDate", scheduledDate);
        }
        if (!this.objectMetadataManager.metadataExist(site, dependencyTO.getUri())) {
            this.objectMetadataManager.insertNewObjectMetadata(site, dependencyTO.getUri());
        }
        this.objectMetadataManager.setObjectMetadata(site, dependencyTO.getUri(), properties);
        if (scheduledDate != null) {
            this.objectStateService.transition(site, item, TransitionEvent.SUBMIT_WITH_WORKFLOW_SCHEDULED);
        } else {
            this.objectStateService.transition(site, item, TransitionEvent.SUBMIT_WITH_WORKFLOW_UNSCHEDULED);
        }
    }

    @ValidateParams
    public void submitToGoLive(@ValidateStringParam(name="site") String site, List<String> paths, ZonedDateTime scheduledDate, boolean sendApprovedNotice, @ValidateStringParam(name="submitter") String submitter) {
    }

    @ValidateParams
    public Map<String, Object> getGoLiveItems(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="sort") String sort, boolean ascending) throws ServiceException {
        DmContentItemComparator comparator = new DmContentItemComparator(sort, ascending, false, false);
        List items = this.getGoLiveItems(site, comparator);
        int total = 0;
        if (items != null) {
            for (ContentItemTO item : items) {
                total += item.getNumOfChildren();
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("total", total);
        result.put("sortedBy", sort);
        result.put("ascending", String.valueOf(ascending));
        result.put("documents", items);
        return result;
    }

    protected List<ContentItemTO> getGoLiveItems(String site, DmContentItemComparator comparator) throws ServiceException {
        List displayPatterns = this.servicesConfig.getDisplayInWidgetPathPatterns(site);
        List categoryItems = this.getCategoryItems(site);
        GoLiveQueue queue = new GoLiveQueue();
        this.fillQueue(site, queue, null);
        Set queueItems = queue.getQueue();
        GoLiveQueueChildFilter childFilter = new GoLiveQueueChildFilter(queue);
        GoLiveQueueOrganizer goLiveQueueOrganizer = new GoLiveQueueOrganizer(this.contentService, (ContentItemTO.ChildFilter)childFilter);
        for (ContentItemTO queueItem : queueItems) {
            if (queueItem.getLastEditDate() != null) {
                queueItem.setEventDate(queueItem.getLastEditDate());
            }
            goLiveQueueOrganizer.addToGoLiveItems(site, queueItem, categoryItems, comparator, false, displayPatterns);
        }
        return categoryItems;
    }

    protected List<ContentItemTO> getCategoryItems(String site) {
        String siteRootPrefix = this.servicesConfig.getRootPrefix(site);
        ArrayList<ContentItemTO> categories = new ArrayList<ContentItemTO>();
        List folders = this.servicesConfig.getFolders(site);
        for (DmFolderConfigTO folder : folders) {
            String uri;
            String string = uri = folder.isAttachRootPrefix() ? siteRootPrefix + folder.getPath() : folder.getPath();
            if (folder.isReadDirectChildren()) {
                ContentItemTO rootItem = this.contentService.getContentItemTree(site, siteRootPrefix + folder.getPath(), 1);
                if (rootItem == null) continue;
                if (rootItem.children != null) {
                    for (ContentItemTO childItem : rootItem.children) {
                        categories.add(childItem);
                    }
                }
                categories.add(rootItem);
                continue;
            }
            ContentItemTO categoryItem = new ContentItemTO();
            String timeZone = this.servicesConfig.getDefaultTimezone(site);
            categoryItem.setTimezone(timeZone);
            categoryItem.setName(folder.getName());
            categoryItem.setInternalName(folder.getName());
            categoryItem.setUri(uri);
            categoryItem.setPath(uri);
            categoryItem.setCategoryRoot(uri);
            categories.add(categoryItem);
        }
        return categories;
    }

    @ValidateParams
    public void fillQueue(@ValidateStringParam(name="site") String site, GoLiveQueue goLiveQueue, GoLiveQueue inProcessQueue) throws ServiceException {
        List changeSet = this.objectStateService.getSubmittedItems(site);
        if (changeSet != null) {
            for (ItemState state : changeSet) {
                try {
                    if (this.contentService.contentExists(state.getSite(), state.getPath())) {
                        ContentItemTO item = this.contentService.getContentItem(state.getSite(), state.getPath(), 0);
                        Set permissions = this.securityService.getUserPermissions(site, item.getUri(), this.securityService.getCurrentUser(), Collections.emptyList());
                        if (!permissions.contains("publish")) continue;
                        this.addToQueue(site, goLiveQueue, inProcessQueue, item, state);
                        continue;
                    }
                    this._cancelWorkflow(site, state.getPath());
                    this.objectStateService.deleteObjectStateForPath(site, state.getPath());
                    this.objectMetadataManager.deleteObjectMetadata(site, state.getPath());
                }
                catch (Exception e) {
                    logger.error("Could not warm cache for [" + state.getSite() + " : " + state.getPath() + "] " + e.getMessage(), new Object[0]);
                }
            }
        }
    }

    protected void addToQueue(String site, GoLiveQueue queue, GoLiveQueue inProcessQueue, ContentItemTO item, ItemState itemState) throws ServiceException {
        if (item != null) {
            State state = State.valueOf((String)itemState.getState());
            if (State.isSubmitted((State)state)) {
                queue.add(item);
            }
            if (inProcessQueue != null && !State.isLive((State)state)) {
                inProcessQueue.add(item);
                inProcessQueue.add(item.getPath(), item);
            }
        } else {
            this.objectStateService.deleteObjectState(itemState.getObjectId());
        }
    }

    @ValidateParams
    public Map<String, Object> getInProgressItems(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="sort") String sort, boolean ascending, boolean inProgressOnly) throws ServiceException {
        DmContentItemComparator comparator = new DmContentItemComparator(sort, ascending, true, true);
        comparator.setSecondLevelCompareRequired(true);
        comparator.setSecondLevelSortBy("path");
        List items = this.getInProgressItems(site, comparator, inProgressOnly);
        JSONObject jsonObject = new JSONObject();
        int total = 0;
        if (items != null) {
            for (ContentItemTO item : items) {
                total += item.getNumOfChildren();
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("total", total);
        result.put("sortedBy", sort);
        result.put("ascending", String.valueOf(ascending));
        result.put("documents", items);
        return result;
    }

    protected List<ContentItemTO> getInProgressItems(String site, DmContentItemComparator comparator, boolean inProgressOnly) throws ServiceException {
        ArrayList<ContentItemTO> categoryItems = new ArrayList<ContentItemTO>();
        List categoryItems1 = this.getCategoryItems(site);
        categoryItems.addAll(categoryItems1);
        long st = System.currentTimeMillis();
        List changeSet = this.objectStateService.getChangeSet(site);
        logger.debug("Time taken listChangedAll()  " + (System.currentTimeMillis() - st), new Object[0]);
        st = System.currentTimeMillis();
        if (changeSet != null) {
            List displayPatterns = this.servicesConfig.getDisplayInWidgetPathPatterns(site);
            for (ItemState state : changeSet) {
                if (!this.contentService.contentExists(state.getSite(), state.getPath()) || !ContentUtils.matchesPatterns((String)state.getPath(), (List)displayPatterns)) continue;
                ContentItemTO item = this.contentService.getContentItem(state.getSite(), state.getPath(), 0);
                this.addInProgressItems(site, item, categoryItems, comparator, inProgressOnly);
            }
        }
        logger.debug("Time taken after listChangedAll() : " + (System.currentTimeMillis() - st), new Object[0]);
        return categoryItems;
    }

    protected void addInProgressItems(String site, ContentItemTO item, List<ContentItemTO> categoryItems, DmContentItemComparator comparator, boolean inProgressOnly) {
        if (this.addToQueue(false, inProgressOnly, true)) {
            if (!item.isSubmitted() && !item.isInProgress()) {
                return;
            }
            item.setDeleted(false);
            ContentItemTO found = null;
            String uri = item.getUri();
            for (ContentItemTO categoryItem : categoryItems) {
                String categoryPath = categoryItem.getPath() + "/";
                if (!uri.startsWith(categoryPath)) continue;
                found = categoryItem;
                break;
            }
            if (found != null && !found.getUri().equals(item.getUri())) {
                found.addChild(item, comparator, true);
            }
        }
    }

    protected boolean addToQueue(boolean submitted, boolean inProgressOnly, boolean includeInProgress) {
        if (inProgressOnly && submitted) {
            return false;
        }
        if (submitted && !inProgressOnly) {
            return true;
        }
        return !submitted && (inProgressOnly || includeInProgress);
    }

    @ValidateParams
    public boolean removeFromWorkflow(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, boolean cancelWorkflow) throws ServiceException {
        HashSet processedPaths = new HashSet();
        return this.removeFromWorkflow(site, path, processedPaths, cancelWorkflow);
    }

    protected boolean removeFromWorkflow(String site, String path, Set<String> processedPaths, boolean cancelWorkflow) throws ServiceException {
        if (!processedPaths.contains(path)) {
            processedPaths.add(path);
            long startTime = System.currentTimeMillis();
            if (cancelWorkflow) {
                this._cancelWorkflow(site, path);
            }
            long duration = System.currentTimeMillis() - startTime;
            logger.debug("_cancelWorkflow Duration 111: {0}", new Object[]{duration});
        }
        return false;
    }

    protected void _cancelWorkflow(String site, String path) throws ServiceException {
        List allItemsToCancel = this.getWorkflowAffectedPathsInternal(site, path);
        ArrayList<String> paths = new ArrayList<String>();
        for (String affectedItem : allItemsToCancel) {
            try {
                this.deploymentService.cancelWorkflow(site, affectedItem);
                ItemMetadata itemMetadata = this.objectMetadataManager.getProperties(site, affectedItem);
                if (itemMetadata != null) {
                    itemMetadata.setSubmittedBy("");
                    itemMetadata.setSendEmail(0);
                    itemMetadata.setSubmittedForDeletion(0);
                    itemMetadata.setSubmissionComment("");
                    itemMetadata.setLaunchDate(null);
                    itemMetadata.setSubmittedToEnvironment("");
                    this.objectMetadataManager.updateObjectMetadata(itemMetadata);
                }
                paths.add(affectedItem);
            }
            catch (DeploymentException e) {
                logger.error("Error occurred while trying to cancel workflow for path [" + affectedItem + "], site " + site, (Exception)((Object)e), new Object[0]);
            }
        }
        this.objectStateService.transitionBulk(site, paths, TransitionEvent.REJECT, State.NEW_UNPUBLISHED_UNLOCKED);
    }

    protected List<String> getWorkflowAffectedPathsInternal(String site, String path) throws ServiceException {
        ArrayList<String> affectedPaths = new ArrayList<String>();
        ArrayList<String> filteredPaths = new ArrayList<String>();
        if (this.objectStateService.isInWorkflow(site, path)) {
            affectedPaths.add(path);
            boolean isNew = this.objectStateService.isNew(site, path);
            boolean isRenamed = this.objectMetadataManager.isRenamed(site, path);
            if (isNew || isRenamed) {
                this.getMandatoryChildren(site, path, affectedPaths);
            }
            ArrayList dependencyPaths = new ArrayList();
            dependencyPaths.addAll(this.dependencyService.getPublishingDependencies(site, affectedPaths));
            affectedPaths.addAll(dependencyPaths);
            ArrayList<String> candidates = new ArrayList<String>();
            for (String p : affectedPaths) {
                if (candidates.contains(p)) continue;
                candidates.add(p);
            }
            for (String cp : candidates) {
                if (!this.objectStateService.isInWorkflow(site, cp)) continue;
                filteredPaths.add(cp);
            }
        }
        return filteredPaths;
    }

    @ValidateParams
    public List<ContentItemTO> getWorkflowAffectedPaths(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) throws ServiceException {
        List affectedPaths = this.getWorkflowAffectedPathsInternal(site, path);
        return this.getWorkflowAffectedItems(site, affectedPaths);
    }

    private void getMandatoryChildren(String site, String path, List<String> affectedPaths) {
        ContentItemTO item = this.contentService.getContentItem(site, path);
        for (ContentItemTO child : item.getChildren()) {
            if (affectedPaths.contains(child.getUri())) continue;
            affectedPaths.add(child.getUri());
            this.getMandatoryChildren(site, child.getUri(), affectedPaths);
        }
    }

    protected List<ContentItemTO> getWorkflowAffectedItems(String site, List<String> paths) {
        ArrayList<ContentItemTO> items = new ArrayList<ContentItemTO>();
        for (String path : paths) {
            ContentItemTO item = this.contentService.getContentItem(site, path);
            items.add(item);
        }
        return items;
    }

    public void updateWorkflowSandboxes(String site, String path) {
    }

    @ValidateParams
    public ResultTO goDelete(@ValidateStringParam(name="site") String site, String request, @ValidateStringParam(name="user") String user) {
        return this.approve(site, request, Operation.DELETE);
    }

    protected ResultTO approve(String site, String request, Operation operation) {
        String approver = this.securityService.getCurrentUser();
        ResultTO result = new ResultTO();
        try {
            JSONObject requestObject = JSONObject.fromObject((Object)request);
            JSONArray items = requestObject.getJSONArray(this.JSON_KEY_ITEMS);
            String scheduledDate = null;
            if (requestObject.containsKey((Object)this.JSON_KEY_SCHEDULED_DATE)) {
                scheduledDate = requestObject.getString(this.JSON_KEY_SCHEDULED_DATE);
            }
            boolean isNow = requestObject.containsKey((Object)this.JSON_KEY_IS_NOW) ? requestObject.getBoolean(this.JSON_KEY_IS_NOW) : false;
            String publishChannelGroupName = requestObject.containsKey((Object)this.JSON_KEY_PUBLISH_CHANNEL) ? requestObject.getString(this.JSON_KEY_PUBLISH_CHANNEL) : null;
            JSONObject jsonObjectStatus = requestObject.getJSONObject(this.JSON_KEY_STATUS_SET);
            String statusMessage = jsonObjectStatus != null && jsonObjectStatus.containsKey((Object)this.JSON_KEY_STATUS_MESSAGE) ? jsonObjectStatus.getString(this.JSON_KEY_STATUS_MESSAGE) : null;
            String submissionComment = requestObject != null && requestObject.containsKey((Object)this.JSON_KEY_SUBMISSION_COMMENT) ? requestObject.getString(this.JSON_KEY_SUBMISSION_COMMENT) : "Test Go Live";
            MultiChannelPublishingContext mcpContext = new MultiChannelPublishingContext(publishChannelGroupName, statusMessage, submissionComment);
            int length = items.size();
            if (length == 0) {
                throw new ServiceException("No items provided to go live.");
            }
            String responseMessageKey = null;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
            ArrayList<DmDependencyTO> submittedItems = new ArrayList<DmDependencyTO>();
            for (int index = 0; index < length; ++index) {
                String stringItem = items.optString(index);
                DmDependencyTO submittedItem = null;
                submittedItem = this.getSubmittedItem(site, stringItem, format, scheduledDate, null);
                List submitForDeleteChildren = this.removeSubmitToDeleteChildrenForGoLive(submittedItem, operation);
                if (submittedItem.isReference()) {
                    submittedItem.setReference(false);
                }
                submittedItems.add(submittedItem);
                submittedItems.addAll(submitForDeleteChildren);
            }
            switch (1.$SwitchMap$org$craftercms$studio$impl$v1$service$workflow$WorkflowServiceImpl$Operation[operation.ordinal()]) {
                case 1: {
                    responseMessageKey = scheduledDate != null && !isNow ? "schedule-to-go-live" : "go-live";
                    ArrayList<DmDependencyTO> submitToDeleteItems = new ArrayList<DmDependencyTO>();
                    ArrayList<DmDependencyTO> goLiveItems = new ArrayList<DmDependencyTO>();
                    ArrayList<Object> renameItems = new ArrayList<Object>();
                    for (DmDependencyTO item : submittedItems) {
                        if (item.isSubmittedForDeletion()) {
                            submitToDeleteItems.add(item);
                            continue;
                        }
                        if (!this.isItemRenamed(site, item)) {
                            goLiveItems.add(item);
                            continue;
                        }
                        renameItems.add(item);
                    }
                    if (!submitToDeleteItems.isEmpty()) {
                        this.doDelete(site, submitToDeleteItems, approver);
                    }
                    if (!goLiveItems.isEmpty()) {
                        List references = this.getRefAndChildOfDiffDateFromParent(site, goLiveItems, true);
                        List children = this.getRefAndChildOfDiffDateFromParent(site, goLiveItems, false);
                        goLiveItems.addAll(references);
                        goLiveItems.addAll(children);
                        ArrayList goLivePaths = new ArrayList();
                        HashSet hashSet = new HashSet();
                        for (DmDependencyTO goLiveItem : goLiveItems) {
                            this.resolveSubmittedPaths(site, goLiveItem, (List)goLivePaths, hashSet);
                        }
                        ArrayList nodeRefs = new ArrayList();
                        this.goLive(site, goLiveItems, approver, mcpContext);
                    }
                    if (renameItems.isEmpty()) break;
                    ArrayList<String> renamePaths = new ArrayList<String>();
                    ArrayList renamedChildren = new ArrayList();
                    for (DmDependencyTO dmDependencyTO : renameItems) {
                        renamedChildren.addAll(this.getChildrenForRenamedItem(site, dmDependencyTO));
                        renamePaths.add(dmDependencyTO.getUri());
                        this.objectStateService.setSystemProcessing(site, dmDependencyTO.getUri(), true);
                    }
                    for (DmDependencyTO dmDependencyTO : renamedChildren) {
                        renamePaths.add(dmDependencyTO.getUri());
                        this.objectStateService.setSystemProcessing(site, dmDependencyTO.getUri(), true);
                    }
                    renameItems.addAll(renamedChildren);
                    for (int i = 0; i < renameItems.size(); ++i) {
                        DmDependencyTO dmDependencyTO = (DmDependencyTO)renameItems.get(i);
                        if (dmDependencyTO.getScheduledDate() != null && dmDependencyTO.getScheduledDate().isAfter(ZonedDateTime.now(ZoneOffset.UTC))) {
                            dmDependencyTO.setNow(false);
                        } else {
                            dmDependencyTO.setNow(true);
                        }
                        renameItems.set(i, dmDependencyTO);
                    }
                    this.goLive(site, renameItems, approver, mcpContext);
                    break;
                }
                case 2: {
                    responseMessageKey = "delete";
                    ArrayList<String> deletePaths = new ArrayList<String>();
                    ArrayList nodeRefs = new ArrayList();
                    for (DmDependencyTO dmDependencyTO : submittedItems) {
                        deletePaths.add(dmDependencyTO.getUri());
                        ContentItemTO contentItem = this.contentService.getContentItem(site, dmDependencyTO.getUri());
                        if (contentItem == null) continue;
                    }
                    this.doDelete(site, submittedItems, approver);
                }
            }
            result.setSuccess(true);
            result.setStatus(200);
            result.setMessage(this.notificationService.getNotificationMessage(site, NotificationMessageType.CompleteMessages, responseMessageKey, Locale.ENGLISH, new Pair[0]));
        }
        catch (JSONException e) {
            logger.error("error performing operation " + operation + " " + (Object)((Object)e), new Object[0]);
            result.setSuccess(false);
            result.setMessage(e.getMessage());
        }
        catch (ServiceException e) {
            logger.error("error performing operation " + operation + " " + (Object)((Object)e), new Object[0]);
            result.setSuccess(false);
            result.setMessage(e.getMessage());
        }
        return result;
    }

    protected ResultTO approve_new(String site, String request, Operation operation) {
        String approver = this.securityService.getCurrentUser();
        ResultTO result = new ResultTO();
        try {
            JSONObject requestObject = JSONObject.fromObject((Object)request);
            JSONArray items = requestObject.getJSONArray(this.JSON_KEY_ITEMS);
            String scheduledDate = null;
            if (requestObject.containsKey((Object)this.JSON_KEY_SCHEDULED_DATE)) {
                scheduledDate = requestObject.getString(this.JSON_KEY_SCHEDULED_DATE);
            }
            boolean isNow = requestObject.containsKey((Object)this.JSON_KEY_IS_NOW) ? requestObject.getBoolean(this.JSON_KEY_IS_NOW) : false;
            String publishChannelGroupName = requestObject.containsKey((Object)this.JSON_KEY_PUBLISH_CHANNEL) ? requestObject.getString(this.JSON_KEY_PUBLISH_CHANNEL) : null;
            JSONObject jsonObjectStatus = requestObject.getJSONObject(this.JSON_KEY_STATUS_SET);
            String statusMessage = jsonObjectStatus != null && jsonObjectStatus.containsKey((Object)this.JSON_KEY_STATUS_MESSAGE) ? jsonObjectStatus.getString(this.JSON_KEY_STATUS_MESSAGE) : null;
            String submissionComment = requestObject != null && requestObject.containsKey((Object)this.JSON_KEY_SUBMISSION_COMMENT) ? requestObject.getString(this.JSON_KEY_SUBMISSION_COMMENT) : "Test Go Live";
            MultiChannelPublishingContext mcpContext = new MultiChannelPublishingContext(publishChannelGroupName, statusMessage, submissionComment);
            int length = items.size();
            if (length == 0) {
                throw new ServiceException("No items provided to go live.");
            }
            ArrayList<String> submittedPaths = new ArrayList<String>();
            String responseMessageKey = null;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
            ArrayList<DmDependencyTO> submittedItems = new ArrayList<DmDependencyTO>();
            for (int index = 0; index < length; ++index) {
                String stringItem = items.optString(index);
                submittedPaths.add(stringItem);
                DmDependencyTO submittedItem = null;
                submittedItem = this.getSubmittedItem_new(site, stringItem, format, scheduledDate);
                List submitForDeleteChildren = this.removeSubmitToDeleteChildrenForGoLive(submittedItem, operation);
                if (submittedItem.isReference()) {
                    submittedItem.setReference(false);
                }
                submittedItems.add(submittedItem);
                submittedItems.addAll(submitForDeleteChildren);
            }
            switch (1.$SwitchMap$org$craftercms$studio$impl$v1$service$workflow$WorkflowServiceImpl$Operation[operation.ordinal()]) {
                case 1: {
                    responseMessageKey = scheduledDate != null && !isNow ? "schedule-to-go-live" : "go-live";
                    ArrayList<DmDependencyTO> submitToDeleteItems = new ArrayList<DmDependencyTO>();
                    ArrayList<DmDependencyTO> goLiveItems = new ArrayList<DmDependencyTO>();
                    ArrayList<Object> renameItems = new ArrayList<Object>();
                    for (DmDependencyTO item : submittedItems) {
                        if (item.isSubmittedForDeletion()) {
                            submitToDeleteItems.add(item);
                            continue;
                        }
                        if (!this.isItemRenamed(site, item)) {
                            goLiveItems.add(item);
                            continue;
                        }
                        renameItems.add(item);
                    }
                    if (!submitToDeleteItems.isEmpty()) {
                        this.doDelete(site, submitToDeleteItems, approver);
                    }
                    if (!goLiveItems.isEmpty()) {
                        List references = this.getRefAndChildOfDiffDateFromParent_new(site, goLiveItems, true);
                        List children = this.getRefAndChildOfDiffDateFromParent_new(site, goLiveItems, false);
                        goLiveItems.addAll(references);
                        goLiveItems.addAll(children);
                        List dependencies = this.addDependenciesForSubmittedItems(site, submittedItems, format, scheduledDate);
                        goLiveItems.addAll(dependencies);
                        ArrayList<String> arrayList = new ArrayList<String>();
                        for (DmDependencyTO goLiveItem : goLiveItems) {
                            arrayList.add(goLiveItem.getUri());
                        }
                        this.goLive(site, goLiveItems, approver, mcpContext);
                        if (scheduledDate != null && !isNow) {
                            this.generateWorkflowActivity(site, arrayList, approver, ActivityService.ActivityType.APPROVE_SCHEDULED);
                        } else {
                            this.generateWorkflowActivity(site, arrayList, approver, ActivityService.ActivityType.APPROVE);
                        }
                    }
                    if (renameItems.isEmpty()) break;
                    ArrayList<String> renamePaths = new ArrayList<String>();
                    ArrayList renamedChildren = new ArrayList();
                    for (DmDependencyTO dmDependencyTO : renameItems) {
                        renamedChildren.addAll(this.getChildrenForRenamedItem(site, dmDependencyTO));
                        renamePaths.add(dmDependencyTO.getUri());
                        this.objectStateService.setSystemProcessing(site, dmDependencyTO.getUri(), true);
                    }
                    for (DmDependencyTO dmDependencyTO : renamedChildren) {
                        renamePaths.add(dmDependencyTO.getUri());
                        this.objectStateService.setSystemProcessing(site, dmDependencyTO.getUri(), true);
                    }
                    renameItems.addAll(renamedChildren);
                    for (int i = 0; i < renameItems.size(); ++i) {
                        DmDependencyTO dmDependencyTO = (DmDependencyTO)renameItems.get(i);
                        if (dmDependencyTO.getScheduledDate() != null && dmDependencyTO.getScheduledDate().isAfter(ZonedDateTime.now(ZoneOffset.UTC))) {
                            dmDependencyTO.setNow(false);
                        } else {
                            dmDependencyTO.setNow(true);
                        }
                        renameItems.set(i, dmDependencyTO);
                    }
                    this.goLive(site, renameItems, approver, mcpContext);
                    break;
                }
                case 2: {
                    responseMessageKey = "delete";
                    ArrayList<String> deletePaths = new ArrayList<String>();
                    ArrayList nodeRefs = new ArrayList();
                    for (DmDependencyTO dmDependencyTO : submittedItems) {
                        deletePaths.add(dmDependencyTO.getUri());
                    }
                    this.doDelete(site, submittedItems, approver);
                    this.generateWorkflowActivity(site, deletePaths, approver, ActivityService.ActivityType.APPROVE);
                }
            }
            result.setSuccess(true);
            result.setStatus(200);
            result.setMessage(this.notificationService.getNotificationMessage(site, NotificationMessageType.CompleteMessages, responseMessageKey, Locale.ENGLISH, new Pair[0]));
        }
        catch (JSONException e) {
            logger.error("error performing operation " + operation + " " + (Object)((Object)e), new Object[0]);
            result.setSuccess(false);
            result.setMessage(e.getMessage());
        }
        catch (ServiceException e) {
            logger.error("error performing operation " + operation + " " + (Object)((Object)e), new Object[0]);
            result.setSuccess(false);
            result.setMessage(e.getMessage());
        }
        return result;
    }

    protected ResultTO approveWithoutDependencies(String site, String request, Operation operation) {
        String approver = this.securityService.getCurrentUser();
        ResultTO result = new ResultTO();
        try {
            JSONObject requestObject = JSONObject.fromObject((Object)request);
            JSONArray items = requestObject.getJSONArray(this.JSON_KEY_ITEMS);
            String scheduledDate = null;
            if (requestObject.containsKey((Object)this.JSON_KEY_SCHEDULED_DATE)) {
                scheduledDate = requestObject.getString(this.JSON_KEY_SCHEDULED_DATE);
            }
            boolean isNow = requestObject.containsKey((Object)this.JSON_KEY_IS_NOW) ? requestObject.getBoolean(this.JSON_KEY_IS_NOW) : false;
            String publishChannelGroupName = requestObject.containsKey((Object)this.JSON_KEY_PUBLISH_CHANNEL) ? requestObject.getString(this.JSON_KEY_PUBLISH_CHANNEL) : null;
            JSONObject jsonObjectStatus = requestObject.getJSONObject(this.JSON_KEY_STATUS_SET);
            String statusMessage = jsonObjectStatus != null && jsonObjectStatus.containsKey((Object)this.JSON_KEY_STATUS_MESSAGE) ? jsonObjectStatus.getString(this.JSON_KEY_STATUS_MESSAGE) : null;
            String submissionComment = requestObject != null && requestObject.containsKey((Object)this.JSON_KEY_SUBMISSION_COMMENT) ? requestObject.getString(this.JSON_KEY_SUBMISSION_COMMENT) : "Test Go Live";
            MultiChannelPublishingContext mcpContext = new MultiChannelPublishingContext(publishChannelGroupName, statusMessage, submissionComment);
            int length = items.size();
            if (length == 0) {
                throw new ServiceException("No items provided to go live.");
            }
            ArrayList<String> submittedPaths = new ArrayList<String>();
            String responseMessageKey = null;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
            ArrayList<DmDependencyTO> submittedItems = new ArrayList<DmDependencyTO>();
            for (int index = 0; index < length; ++index) {
                String stringItem = items.optString(index);
                submittedPaths.add(stringItem);
                DmDependencyTO submittedItem = null;
                submittedItem = this.getSubmittedItemApproveWithoutDependencies(site, stringItem, format, scheduledDate);
                List submitForDeleteChildren = this.removeSubmitToDeleteChildrenForGoLive(submittedItem, operation);
                if (submittedItem.isReference()) {
                    submittedItem.setReference(false);
                }
                submittedItems.add(submittedItem);
                submittedItems.addAll(submitForDeleteChildren);
            }
            switch (1.$SwitchMap$org$craftercms$studio$impl$v1$service$workflow$WorkflowServiceImpl$Operation[operation.ordinal()]) {
                case 1: {
                    responseMessageKey = scheduledDate != null && !isNow ? "schedule-to-go-live" : "go-live";
                    ArrayList<DmDependencyTO> submitToDeleteItems = new ArrayList<DmDependencyTO>();
                    ArrayList<DmDependencyTO> goLiveItems = new ArrayList<DmDependencyTO>();
                    ArrayList<Object> renameItems = new ArrayList<Object>();
                    for (DmDependencyTO item : submittedItems) {
                        if (item.isSubmittedForDeletion()) {
                            submitToDeleteItems.add(item);
                            continue;
                        }
                        if (!this.isItemRenamed(site, item)) {
                            goLiveItems.add(item);
                            continue;
                        }
                        renameItems.add(item);
                    }
                    if (!submitToDeleteItems.isEmpty()) {
                        this.doDelete(site, submitToDeleteItems, approver);
                    }
                    if (!goLiveItems.isEmpty()) {
                        ArrayList goLivePaths = new ArrayList();
                        HashSet processedPaths = new HashSet();
                        for (DmDependencyTO dmDependencyTO : goLiveItems) {
                            this.resolveSubmittedPaths(site, dmDependencyTO, goLivePaths, processedPaths);
                        }
                        this.goLive(site, goLiveItems, approver, mcpContext);
                    }
                    if (renameItems.isEmpty()) break;
                    ArrayList<String> renamePaths = new ArrayList<String>();
                    ArrayList renamedChildren = new ArrayList();
                    for (DmDependencyTO dmDependencyTO : renameItems) {
                        renamedChildren.addAll(this.getChildrenForRenamedItem(site, dmDependencyTO));
                        renamePaths.add(dmDependencyTO.getUri());
                        this.objectStateService.setSystemProcessing(site, dmDependencyTO.getUri(), true);
                    }
                    for (DmDependencyTO dmDependencyTO : renamedChildren) {
                        renamePaths.add(dmDependencyTO.getUri());
                        this.objectStateService.setSystemProcessing(site, dmDependencyTO.getUri(), true);
                    }
                    renameItems.addAll(renamedChildren);
                    for (int i = 0; i < renameItems.size(); ++i) {
                        DmDependencyTO dmDependencyTO = (DmDependencyTO)renameItems.get(i);
                        if (dmDependencyTO.getScheduledDate() != null && dmDependencyTO.getScheduledDate().isAfter(ZonedDateTime.now(ZoneOffset.UTC))) {
                            dmDependencyTO.setNow(false);
                        } else {
                            dmDependencyTO.setNow(true);
                        }
                        renameItems.set(i, dmDependencyTO);
                    }
                    this.goLive(site, renameItems, approver, mcpContext);
                    break;
                }
                case 2: {
                    responseMessageKey = "delete";
                    ArrayList<String> deletePaths = new ArrayList<String>();
                    ArrayList nodeRefs = new ArrayList();
                    for (DmDependencyTO dmDependencyTO : submittedItems) {
                        deletePaths.add(dmDependencyTO.getUri());
                        ContentItemTO contentItem = this.contentService.getContentItem(site, dmDependencyTO.getUri());
                        if (contentItem == null) continue;
                    }
                    this.doDelete(site, submittedItems, approver);
                }
            }
            result.setSuccess(true);
            result.setStatus(200);
            result.setMessage(this.notificationService.getNotificationMessage(site, NotificationMessageType.CompleteMessages, responseMessageKey, Locale.ENGLISH, new Pair[0]));
        }
        catch (JSONException e) {
            logger.error("error performing operation " + operation + " " + (Object)((Object)e), new Object[0]);
            result.setSuccess(false);
            result.setMessage(e.getMessage());
        }
        catch (ServiceException e) {
            logger.error("error performing operation " + operation + " " + (Object)((Object)e), new Object[0]);
            result.setSuccess(false);
            result.setMessage(e.getMessage());
        }
        return result;
    }

    protected DmDependencyTO getSubmittedItem(String site, JSONObject item, SimpleDateFormat format, String globalSchDate) throws JSONException, ServiceException {
        String dateStr;
        DmDependencyTO submittedItem = new DmDependencyTO();
        String uri = item.getString(this.JSON_KEY_URI);
        submittedItem.setUri(uri);
        boolean deleted = item.containsKey((Object)this.JSON_KEY_DELETED) ? item.getBoolean(this.JSON_KEY_DELETED) : false;
        submittedItem.setDeleted(deleted);
        boolean isNow = item.containsKey((Object)this.JSON_KEY_IS_NOW) ? item.getBoolean(this.JSON_KEY_IS_NOW) : false;
        submittedItem.setNow(isNow);
        boolean submittedForDeletion = item.containsKey((Object)this.JSON_KEY_SUBMITTED_FOR_DELETION) ? item.getBoolean(this.JSON_KEY_SUBMITTED_FOR_DELETION) : false;
        boolean submitted = item.containsKey((Object)this.JSON_KEY_SUBMITTED) ? item.getBoolean(this.JSON_KEY_SUBMITTED) : false;
        boolean inProgress = item.containsKey((Object)this.JSON_KEY_IN_PROGRESS) ? item.getBoolean(this.JSON_KEY_IN_PROGRESS) : false;
        boolean isReference = item.containsKey((Object)this.JSON_KEY_IN_REFERENCE) ? item.getBoolean(this.JSON_KEY_IN_REFERENCE) : false;
        submittedItem.setReference(isReference);
        submittedItem.setSubmittedForDeletion(submittedForDeletion);
        submittedItem.setSubmitted(submitted);
        submittedItem.setInProgress(inProgress);
        ZonedDateTime scheduledDate = null;
        if (globalSchDate != null && !StringUtils.isEmpty((CharSequence)globalSchDate)) {
            scheduledDate = this.getScheduledDate(site, format, globalSchDate);
        } else if (item.containsKey((Object)this.JSON_KEY_SCHEDULED_DATE) && !StringUtils.isEmpty((CharSequence)(dateStr = item.getString(this.JSON_KEY_SCHEDULED_DATE)))) {
            scheduledDate = this.getScheduledDate(site, format, dateStr);
        }
        if (scheduledDate == null && !isNow) {
            submittedItem.setNow(true);
        }
        submittedItem.setScheduledDate(scheduledDate);
        JSONArray components = item.containsKey((Object)this.JSON_KEY_COMPONENTS) && !item.getJSONObject(this.JSON_KEY_COMPONENTS).isNullObject() ? item.getJSONArray(this.JSON_KEY_COMPONENTS) : null;
        List submittedComponents = this.getSubmittedItems(site, components, format, globalSchDate);
        submittedItem.setComponents(submittedComponents);
        JSONArray documents = item.containsKey((Object)this.JSON_KEY_DOCUMENTS) && !item.getJSONObject(this.JSON_KEY_DOCUMENTS).isNullObject() ? item.getJSONArray(this.JSON_KEY_DOCUMENTS) : null;
        List submittedDocuments = this.getSubmittedItems(site, documents, format, globalSchDate);
        submittedItem.setDocuments(submittedDocuments);
        JSONArray assets = item.containsKey((Object)this.JSON_KEY_ASSETS) && !item.getJSONObject(this.JSON_KEY_ASSETS).isNullObject() ? item.getJSONArray(this.JSON_KEY_ASSETS) : null;
        List submittedAssets = this.getSubmittedItems(site, assets, format, globalSchDate);
        submittedItem.setAssets(submittedAssets);
        JSONArray templates = item.containsKey((Object)this.JSON_KEY_RENDERING_TEMPLATES) && !item.getJSONObject(this.JSON_KEY_RENDERING_TEMPLATES).isNullObject() ? item.getJSONArray(this.JSON_KEY_RENDERING_TEMPLATES) : null;
        List submittedTemplates = this.getSubmittedItems(site, templates, format, globalSchDate);
        submittedItem.setRenderingTemplates(submittedTemplates);
        JSONArray deletedItems = item.containsKey((Object)this.JSON_KEY_DELETED_ITEMS) && !item.getJSONObject(this.JSON_KEY_DELETED_ITEMS).isNullObject() ? item.getJSONArray(this.JSON_KEY_DELETED_ITEMS) : null;
        List deletes = this.getSubmittedItems(site, deletedItems, format, globalSchDate);
        submittedItem.setDeletedItems(deletes);
        JSONArray children = item.containsKey((Object)this.JSON_KEY_CHILDREN) ? item.getJSONArray(this.JSON_KEY_CHILDREN) : null;
        List submittedChidren = this.getSubmittedItems(site, children, format, globalSchDate);
        submittedItem.setChildren(submittedChidren);
        if (uri.endsWith(".xml")) {
            Set deps = this.dependencyService.getItemDependencies(site, uri, 1);
            List pagePatterns = this.servicesConfig.getPagePatterns(site);
            List documentPatterns = this.servicesConfig.getDocumentPatterns(site);
            ArrayList<DmDependencyTO> dependentPages = new ArrayList<DmDependencyTO>();
            ArrayList<DmDependencyTO> dependentDocuments = new ArrayList<DmDependencyTO>();
            for (String dep : deps) {
                DmDependencyTO dmDependencyTO;
                if (ContentUtils.matchesPatterns((String)dep, (List)pagePatterns)) {
                    dmDependencyTO = new DmDependencyTO();
                    dmDependencyTO.setUri(dep);
                    dependentPages.add(dmDependencyTO);
                    continue;
                }
                if (!ContentUtils.matchesPatterns((String)dep, (List)documentPatterns)) continue;
                dmDependencyTO = new DmDependencyTO();
                dmDependencyTO.setUri(dep);
                dependentDocuments.add(dmDependencyTO);
            }
            submittedItem.setPages(dependentPages);
            submittedItem.setDocuments(dependentDocuments);
        }
        return submittedItem;
    }

    protected DmDependencyTO getSubmittedItem(String site, String itemPath, SimpleDateFormat format, String globalSchDate, Set<String> processedDependencies) throws JSONException {
        DmDependencyTO submittedItem = new DmDependencyTO();
        submittedItem.setUri(itemPath);
        ZonedDateTime scheduledDate = null;
        if (globalSchDate != null && !StringUtils.isEmpty((CharSequence)globalSchDate)) {
            scheduledDate = this.getScheduledDate(site, format, globalSchDate);
        } else if (submittedItem.getScheduledDate() != null) {
            scheduledDate = this.getScheduledDate(site, format, submittedItem.getScheduledDate().format(DateTimeFormatter.ofPattern(format.toPattern())));
        }
        if (scheduledDate == null) {
            submittedItem.setNow(true);
        }
        submittedItem.setScheduledDate(scheduledDate);
        if (processedDependencies == null) {
            processedDependencies = new HashSet<String>();
        }
        if (CollectionUtils.isNotEmpty((Collection)submittedItem.getComponents())) {
            for (DmDependencyTO component : submittedItem.getComponents()) {
                if (processedDependencies.contains(component.getUri())) continue;
                component = this.getSubmittedItem(site, component.getUri(), format, globalSchDate, processedDependencies);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)submittedItem.getDocuments())) {
            for (DmDependencyTO document : submittedItem.getDocuments()) {
                if (processedDependencies.contains(document.getUri())) continue;
                document = this.getSubmittedItem(site, document.getUri(), format, globalSchDate, processedDependencies);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)submittedItem.getAssets())) {
            for (DmDependencyTO asset : submittedItem.getAssets()) {
                if (processedDependencies.contains(asset.getUri())) continue;
                asset = this.getSubmittedItem(site, asset.getUri(), format, globalSchDate, processedDependencies);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)submittedItem.getRenderingTemplates())) {
            for (DmDependencyTO template : submittedItem.getRenderingTemplates()) {
                if (processedDependencies.contains(template.getUri())) continue;
                template = this.getSubmittedItem(site, template.getUri(), format, globalSchDate, processedDependencies);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)submittedItem.getDeletedItems())) {
            for (DmDependencyTO deletedItem : submittedItem.getDeletedItems()) {
                if (processedDependencies.contains(deletedItem.getUri())) continue;
                deletedItem = this.getSubmittedItem(site, deletedItem.getUri(), format, globalSchDate, processedDependencies);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)submittedItem.getChildren())) {
            for (DmDependencyTO child : submittedItem.getChildren()) {
                if (processedDependencies.contains(child.getUri())) continue;
                child = this.getSubmittedItem(site, child.getUri(), format, globalSchDate, processedDependencies);
            }
        }
        return submittedItem;
    }

    protected DmDependencyTO getSubmittedItem_new(String site, String itemPath, SimpleDateFormat format, String globalSchDate) throws JSONException {
        DmDependencyTO submittedItem = new DmDependencyTO();
        submittedItem.setUri(itemPath);
        ZonedDateTime scheduledDate = null;
        if (globalSchDate != null && !StringUtils.isEmpty((CharSequence)globalSchDate)) {
            scheduledDate = this.getScheduledDate(site, format, globalSchDate);
        } else if (submittedItem.getScheduledDate() != null) {
            scheduledDate = this.getScheduledDate(site, format, submittedItem.getScheduledDate().format(DateTimeFormatter.ofPattern(format.toPattern())));
        }
        if (scheduledDate == null) {
            submittedItem.setNow(true);
        }
        submittedItem.setScheduledDate(scheduledDate);
        return submittedItem;
    }

    protected DmDependencyTO getSubmittedItemApproveWithoutDependencies(String site, String itemPath, SimpleDateFormat format, String globalSchDate) throws JSONException {
        DmDependencyTO submittedItem = new DmDependencyTO();
        submittedItem.setUri(itemPath);
        ZonedDateTime scheduledDate = null;
        if (globalSchDate != null && !StringUtils.isEmpty((CharSequence)globalSchDate)) {
            scheduledDate = this.getScheduledDate(site, format, globalSchDate);
        } else if (submittedItem.getScheduledDate() != null) {
            scheduledDate = this.getScheduledDate(site, format, submittedItem.getScheduledDate().format(DateTimeFormatter.ofPattern(format.toPattern())));
        }
        if (scheduledDate == null) {
            submittedItem.setNow(true);
        }
        submittedItem.setScheduledDate(scheduledDate);
        return submittedItem;
    }

    protected List<DmDependencyTO> getSubmittedItems(String site, JSONArray items, SimpleDateFormat format, String schDate) throws JSONException, ServiceException {
        int length;
        if (items != null && (length = items.size()) > 0) {
            ArrayList<DmDependencyTO> submittedItems = new ArrayList<DmDependencyTO>();
            for (int index = 0; index < length; ++index) {
                JSONObject item = items.getJSONObject(index);
                DmDependencyTO submittedItem = this.getSubmittedItem(site, item, format, schDate);
                submittedItems.add(submittedItem);
            }
            return submittedItems;
        }
        return null;
    }

    protected List<DmDependencyTO> removeSubmitToDeleteChildrenForGoLive(DmDependencyTO dependencyTO, Operation operation) {
        List children;
        ArrayList<DmDependencyTO> submitForDeleteChilds = new ArrayList<DmDependencyTO>();
        if (operation == Operation.GO_LIVE && !dependencyTO.isSubmittedForDeletion() && (children = dependencyTO.getChildren()) != null) {
            for (DmDependencyTO child : children) {
                if (!child.isSubmittedForDeletion()) continue;
                submitForDeleteChilds.add(child);
            }
            for (DmDependencyTO submitForDeleteChild : submitForDeleteChilds) {
                children.remove(submitForDeleteChild);
            }
        }
        return submitForDeleteChilds;
    }

    protected void doDelete(String site, List<DmDependencyTO> submittedItems, String approver) throws ServiceException {
        long start = System.currentTimeMillis();
        String user = this.securityService.getCurrentUser();
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        ArrayList<String> itemsToDelete = new ArrayList<String>();
        ArrayList<DmDependencyTO> deleteItems = new ArrayList<DmDependencyTO>();
        ArrayList<DmDependencyTO> scheItems = new ArrayList<DmDependencyTO>();
        for (DmDependencyTO submittedItem : submittedItems) {
            String uri = submittedItem.getUri();
            ZonedDateTime schDate = submittedItem.getScheduledDate();
            boolean isItemForSchedule = false;
            if (schDate == null || schDate.isBefore(now)) {
                if (StringUtils.isNotEmpty((CharSequence)approver) && submittedItem.isSendEmail()) {
                    this.sendDeleteApprovalNotification(site, submittedItem, approver);
                }
                if (submittedItem.getUri().endsWith("index.xml")) {
                    submittedItem.setUri(submittedItem.getUri().replace("/index.xml", ""));
                }
                itemsToDelete.add(uri);
            } else {
                scheItems.add(submittedItem);
                isItemForSchedule = true;
            }
            submittedItem.setDeleted(true);
            boolean isNew = this.objectStateService.isNew(site, uri);
            if (isNew && !isItemForSchedule) continue;
            deleteItems.add(submittedItem);
        }
        GoLiveContext context = new GoLiveContext(approver, site);
        String pathPrefix = "/wem-projects/" + site + "/" + site + "/" + "work-area";
        Map groupedPackages = this.groupByDate(deleteItems, now);
        if (groupedPackages.isEmpty()) {
            groupedPackages.put(now, Collections.emptyList());
        }
        for (ZonedDateTime scheduledDate : groupedPackages.keySet()) {
            List deletePackage = (List)groupedPackages.get(scheduledDate);
            SubmitPackage submitpackage = new SubmitPackage(pathPrefix);
            HashSet rescheduledUris = new HashSet();
            if (deletePackage == null) continue;
            ZonedDateTime launchDate = scheduledDate.equals(now) ? null : scheduledDate;
            HashSet processedUris = new HashSet();
            for (DmDependencyTO dmDependencyTO : deletePackage) {
                if (launchDate != null) {
                    this.handleReferences(site, submitpackage, dmDependencyTO, true, null, "", rescheduledUris, processedUris);
                    continue;
                }
                this.applyDeleteDependencyRule(site, submitpackage, dmDependencyTO);
            }
            String label = submitpackage.getLabel();
            PreScheduleDeleteOperation deleteOperation = null;
            HashSet liveDependencyItems = new HashSet();
            HashSet allItems = new HashSet();
            for (String string : itemsToDelete) {
                GoLiveDeleteCandidates deleteCandidate = this.contentService.getDeleteCandidates(context.getSite(), string);
                allItems.addAll(deleteCandidate.getAllItems());
                liveDependencyItems.addAll(deleteCandidate.getLiveDependencyItems());
            }
            List submitPackPaths = submitpackage.getPaths();
            if (launchDate != null) {
                deleteOperation = new PreScheduleDeleteOperation((WorkflowService)this, submitpackage.getUris(), launchDate, context, rescheduledUris);
                label = "schedule_submission:" + label;
            } else {
                for (String liveDependency : liveDependencyItems) {
                    submitpackage.addToPackage(liveDependency);
                }
                submitPackPaths = submitpackage.getPaths();
                deleteOperation = new PreSubmitDeleteOperation((WorkflowService)this, new HashSet(allItems), context, rescheduledUris);
                this.removeChildFromSubmitPackForDelete(submitPackPaths);
            }
            HashMap hashMap = new HashMap();
            this.workflowProcessor.addToWorkflow(site, new ArrayList(), launchDate, label, (SubmitLifeCycleOperation)deleteOperation, approver, null);
        }
        long end = System.currentTimeMillis();
        logger.debug("Submitted deleted items to queue time = " + (end - start), new Object[0]);
    }

    public Map<ZonedDateTime, List<DmDependencyTO>> groupByDate(List<DmDependencyTO> submittedItems, ZonedDateTime now) {
        HashMap<ZonedDateTime, List<DmDependencyTO>> groupedPackages = new HashMap<ZonedDateTime, List<DmDependencyTO>>();
        for (DmDependencyTO submittedItem : submittedItems) {
            ArrayList<DmDependencyTO> goLivePackage;
            ZonedDateTime scheduledDate;
            ZonedDateTime zonedDateTime = scheduledDate = submittedItem.isNow() ? null : submittedItem.getScheduledDate();
            if (scheduledDate == null || scheduledDate.isBefore(now)) {
                scheduledDate = now;
            }
            if ((goLivePackage = (ArrayList<DmDependencyTO>)groupedPackages.get(scheduledDate)) == null) {
                goLivePackage = new ArrayList<DmDependencyTO>();
            }
            goLivePackage.add(submittedItem);
            groupedPackages.put(scheduledDate, goLivePackage);
        }
        return groupedPackages;
    }

    protected void handleReferences(String site, SubmitPackage submitpackage, DmDependencyTO dmDependencyTO, boolean isNotScheduled, SubmitPackage dependencyPackage, String approver, Set<String> rescheduledUris, Set<String> processedUris) {
        if (!processedUris.contains(dmDependencyTO.getUri())) {
            ItemState state;
            ItemMetadata properties = this.objectMetadataManager.getProperties(site, dmDependencyTO.getUri());
            ZonedDateTime scheduledDate = null;
            if (properties != null) {
                scheduledDate = properties.getLaunchDate();
            }
            if ((state = this.objectStateService.getObjectState(site, dmDependencyTO.getUri())) != null && !State.isSubmitted((State)State.valueOf((String)state.getState())) && scheduledDate != null && scheduledDate.equals(dmDependencyTO.getScheduledDate())) {
                if (this.objectStateService.isScheduled(site, dmDependencyTO.getUri())) {
                    return;
                }
                submitpackage.addToPackage(dmDependencyTO);
            }
            if (!dmDependencyTO.isReference()) {
                submitpackage.addToPackage(dmDependencyTO);
            }
            if (this.isRescheduleRequest(dmDependencyTO, site)) {
                rescheduledUris.add(dmDependencyTO.getUri());
            }
            processedUris.add(dmDependencyTO.getUri());
        }
    }

    protected boolean areEqual(ZonedDateTime oldDate, ZonedDateTime newDate) {
        if (oldDate == null && newDate == null) {
            return true;
        }
        if (oldDate != null && newDate != null) {
            return oldDate.equals(newDate);
        }
        return false;
    }

    protected void applyDeleteDependencyRule(String site, SubmitPackage pack, DmDependencyTO dmDependencyTO) {
        pack.addToPackage(dmDependencyTO);
        DependencyRules rule = new DependencyRules(site);
        rule.setObjectStateService(this.objectStateService);
        rule.setContentService(this.contentService);
        Set dependencyTOSet = rule.applyDeleteDependencyRule(dmDependencyTO);
        for (DmDependencyTO dependencyTO : dependencyTOSet) {
            pack.addToPackage(dependencyTO);
        }
    }

    protected ZonedDateTime getScheduledDate(String site, SimpleDateFormat format, String dateStr) {
        return ContentFormatUtils.parseDate((SimpleDateFormat)format, (String)dateStr, (String)this.servicesConfig.getDefaultTimezone(site));
    }

    protected void removeChildFromSubmitPackForDelete(List<String> paths) {
        Iterator<String> itr = paths.iterator();
        while (itr.hasNext()) {
            String path = itr.next();
            if (!this.checkParentExistsInSubmitPackForDelete(paths, path)) continue;
            itr.remove();
        }
    }

    protected boolean checkParentExistsInSubmitPackForDelete(List<String> paths, String path) {
        String[] split = path.split("/");
        for (int i = split.length - 1; i >= 0; --i) {
            int lastIndex = path.lastIndexOf(split[i]) - 1;
            if (lastIndex <= 0 || !paths.contains(path = path.substring(0, lastIndex))) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void sendDeleteApprovalNotification(String site, DmDependencyTO submittedItem, String approver) {
        try {
            String uri;
            ContentItemTO contentItem;
            if (submittedItem.isSendEmail() && (contentItem = this.contentService.getContentItem(site, uri = submittedItem.getUri())) == null) return;
        }
        catch (Exception e) {
            logger.error("Could not send delete approval notification for newly created item", e, new Object[0]);
        }
    }

    protected List<DmDependencyTO> getRefAndChildOfDiffDateFromParent(String site, List<DmDependencyTO> submittedItems, boolean removeInPages) throws ServiceException {
        ArrayList<DmDependencyTO> childAndReferences = new ArrayList<DmDependencyTO>();
        for (DmDependencyTO submittedItem : submittedItems) {
            List children = submittedItem.getChildren();
            ZonedDateTime date = submittedItem.getScheduledDate();
            if (children != null) {
                Iterator childItr = children.iterator();
                while (childItr.hasNext()) {
                    DmDependencyTO child = (DmDependencyTO)childItr.next();
                    ZonedDateTime pageDate = child.getScheduledDate();
                    if ((date != null || pageDate == null) && (date == null || date.equals(pageDate))) continue;
                    if (!submittedItem.isNow()) {
                        child.setNow(false);
                        if (date != null && pageDate != null && pageDate.isBefore(date)) {
                            child.setScheduledDate(date);
                        }
                    }
                    childAndReferences.add(child);
                    List childDeps = child.flattenChildren();
                    for (DmDependencyTO childDep : childDeps) {
                        if (!this.objectStateService.isUpdatedOrNew(site, childDep.getUri())) continue;
                        childAndReferences.add(childDep);
                    }
                    child.setReference(false);
                    childItr.remove();
                    if (!removeInPages) continue;
                    String uri = child.getUri();
                    List pages = submittedItem.getPages();
                    if (pages == null) continue;
                    Iterator pagesIter = pages.iterator();
                    while (pagesIter.hasNext()) {
                        DmDependencyTO page = (DmDependencyTO)pagesIter.next();
                        if (!page.getUri().equals(uri)) continue;
                        pagesIter.remove();
                    }
                }
            }
            Set dependenciesPaths = this.dependencyService.getPublishingDependencies(site, submittedItem.getUri());
            for (String depPath : dependenciesPaths) {
                DmDependencyTO dmDependencyTO = new DmDependencyTO();
                dmDependencyTO.setUri(depPath);
                childAndReferences.add(dmDependencyTO);
            }
        }
        return childAndReferences;
    }

    protected List<DmDependencyTO> getRefAndChildOfDiffDateFromParent_new(String site, List<DmDependencyTO> submittedItems, boolean removeInPages) {
        ArrayList<DmDependencyTO> childAndReferences = new ArrayList<DmDependencyTO>();
        for (DmDependencyTO submittedItem : submittedItems) {
            List children = submittedItem.getChildren();
            ZonedDateTime date = submittedItem.getScheduledDate();
            if (children == null) continue;
            Iterator childItr = children.iterator();
            while (childItr.hasNext()) {
                DmDependencyTO child = (DmDependencyTO)childItr.next();
                ZonedDateTime pageDate = child.getScheduledDate();
                if ((date != null || pageDate == null) && (date == null || date.equals(pageDate))) continue;
                if (!submittedItem.isNow()) {
                    child.setNow(false);
                    if (date != null && pageDate != null && pageDate.isBefore(date)) {
                        child.setScheduledDate(date);
                    }
                }
                childAndReferences.add(child);
                List childDeps = child.flattenChildren();
                for (DmDependencyTO childDep : childDeps) {
                    if (!this.objectStateService.isUpdatedOrNew(site, childDep.getUri())) continue;
                    childAndReferences.add(childDep);
                }
                child.setReference(false);
                childItr.remove();
                if (!removeInPages) continue;
                String uri = child.getUri();
                List pages = submittedItem.getPages();
                if (pages == null) continue;
                Iterator pagesIter = pages.iterator();
                while (pagesIter.hasNext()) {
                    DmDependencyTO page = (DmDependencyTO)pagesIter.next();
                    if (!page.getUri().equals(uri)) continue;
                    pagesIter.remove();
                }
            }
        }
        return childAndReferences;
    }

    protected List<DmDependencyTO> addDependenciesForSubmittedItems(String site, List<DmDependencyTO> submittedItems, SimpleDateFormat format, String globalScheduledDate) throws ServiceException {
        ArrayList<DmDependencyTO> dependencies = new ArrayList<DmDependencyTO>();
        HashSet dependenciesPaths = new HashSet();
        for (DmDependencyTO submittedItem : submittedItems) {
            if (dependenciesPaths.contains(submittedItem.getUri())) continue;
            dependenciesPaths.addAll(this.dependencyService.getPublishingDependencies(site, submittedItem.getUri()));
        }
        for (String depPath : dependenciesPaths) {
            dependencies.add(this.getSubmittedItem_new(site, depPath, format, globalScheduledDate));
        }
        return dependencies;
    }

    protected List<DmDependencyTO> addDependenciesForSubmitForApproval(String site, List<DmDependencyTO> submittedItems, SimpleDateFormat format, String globalScheduledDate) throws ServiceException {
        ArrayList<DmDependencyTO> dependencies = new ArrayList<DmDependencyTO>();
        HashSet dependenciesPaths = new HashSet();
        for (DmDependencyTO submittedItem : submittedItems) {
            dependenciesPaths.addAll(this.dependencyService.getPublishingDependencies(site, submittedItem.getUri()));
        }
        for (String depPath : dependenciesPaths) {
            dependencies.add(this.getSubmittedItem(site, depPath, format, globalScheduledDate, null));
        }
        return dependencies;
    }

    protected void resolveSubmittedPaths(String site, DmDependencyTO item, List<String> submittedPaths, Set<String> processedPaths) throws ServiceException {
        if (!processedPaths.contains(item.getUri())) {
            List children;
            if (!submittedPaths.contains(item.getUri())) {
                submittedPaths.add(item.getUri());
            }
            if ((children = item.getChildren()) != null) {
                for (DmDependencyTO child : children) {
                    if (!this.objectStateService.isUpdatedOrNew(site, child.getUri())) continue;
                    if (!submittedPaths.contains(child.getUri())) {
                        submittedPaths.add(child.getUri());
                    }
                    this.resolveSubmittedPaths(site, child, submittedPaths, processedPaths);
                }
            }
            Set dependencyPaths = this.dependencyService.getPublishingDependencies(site, item.getUri());
            submittedPaths.addAll(dependencyPaths);
            processedPaths.addAll(dependencyPaths);
            processedPaths.add(item.getUri());
        }
    }

    protected List<DmDependencyTO> getChildrenForRenamedItem(String site, DmDependencyTO renameItem) {
        ArrayList<DmDependencyTO> toRet = new ArrayList<DmDependencyTO>();
        List children = renameItem.getChildren();
        ZonedDateTime date = renameItem.getScheduledDate();
        if (children != null) {
            Iterator childItr = children.iterator();
            while (childItr.hasNext()) {
                DmDependencyTO child = (DmDependencyTO)childItr.next();
                ZonedDateTime pageDate = child.getScheduledDate();
                if ((date != null || pageDate == null) && (date == null || date.equals(pageDate))) continue;
                if (!renameItem.isNow()) {
                    child.setNow(false);
                    if (date != null && pageDate != null && pageDate.isBefore(date)) {
                        child.setScheduledDate(date);
                    }
                }
                toRet.add(child);
                List childDeps = child.flattenChildren();
                for (DmDependencyTO childDep : childDeps) {
                    if (!this.objectStateService.isUpdatedOrNew(site, childDep.getUri())) continue;
                    toRet.add(childDep);
                }
                child.setReference(false);
                childItr.remove();
            }
        }
        return toRet;
    }

    public void preScheduleDelete(Set<String> urisToDelete, ZonedDateTime scheduleDate, GoLiveContext context, Set rescheduledUris) throws ServiceException {
        String site = context.getSite();
        ArrayList<String> itemsToDelete = new ArrayList<String>(urisToDelete);
        this.dmPublishService.unpublish(site, itemsToDelete, context.getApprover(), scheduleDate);
    }

    public List<String> preDelete(Set<String> urisToDelete, GoLiveContext context, Set<String> rescheduledUris) throws ServiceException {
        this.cleanUrisFromWorkflow(urisToDelete, context.getSite());
        this.cleanUrisFromWorkflow(rescheduledUris, context.getSite());
        List deletedItems = this.deleteInTransaction(context.getSite(), new ArrayList<String>(urisToDelete), true, context.getApprover());
        return deletedItems;
    }

    protected List<String> deleteInTransaction(String site, List<String> itemsToDelete, boolean generateActivity, String approver) throws ServiceException {
        this.dmPublishService.unpublish(site, itemsToDelete, approver);
        return null;
    }

    protected void cleanUrisFromWorkflow(Set<String> uris, String site) throws ServiceException {
        if (uris != null && !uris.isEmpty()) {
            for (String uri : uris) {
                this.cleanWorkflow(uri, site, Collections.emptySet());
            }
        }
    }

    @ValidateParams
    public ResultTO goLive(@ValidateStringParam(name="site") String site, String request) throws ServiceException {
        try {
            if (this.isEnablePublishingWithoutDependencies()) {
                return this.approveWithoutDependencies(site, request, Operation.GO_LIVE);
            }
            return this.approve_new(site, request, Operation.GO_LIVE);
        }
        catch (RuntimeException e) {
            logger.error("error making go live", (Exception)e, new Object[0]);
            throw e;
        }
    }

    @ValidateParams
    public boolean cleanWorkflow(@ValidateSecurePathParam(name="url") String url, @ValidateStringParam(name="site") String site, Set<DmDependencyTO> dependents) throws ServiceException {
        this._cancelWorkflow(site, url);
        return true;
    }

    protected void goLive(String site, List<DmDependencyTO> submittedItems, String approver) throws ServiceException {
        this.goLive(site, submittedItems, approver, null);
    }

    protected void goLive(String site, List<DmDependencyTO> submittedItems, String approver, MultiChannelPublishingContext mcpContext) throws ServiceException {
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        if (submittedItems != null) {
            Map groupedPackages = this.groupByDate(submittedItems, now);
            for (ZonedDateTime scheduledDate : groupedPackages.keySet()) {
                List goLivePackage = (List)groupedPackages.get(scheduledDate);
                if (goLivePackage == null) continue;
                ZonedDateTime launchDate = scheduledDate.equals(now) ? null : scheduledDate;
                boolean isNotScheduled = launchDate == null;
                SubmitPackage submitpackage = new SubmitPackage("");
                HashSet rescheduledUris = new HashSet();
                SubmitPackage dependencyPackage = new SubmitPackage("");
                HashSet processedUris = new HashSet();
                for (DmDependencyTO dmDependencyTO : goLivePackage) {
                    this.goLivepackage(site, submitpackage, dmDependencyTO, isNotScheduled, dependencyPackage, approver, rescheduledUris, processedUris);
                }
                List stringList = submitpackage.getPaths();
                String label = submitpackage.getLabel();
                PreGoLiveOperation operation = null;
                GoLiveContext context = new GoLiveContext(approver, site);
                if (!isNotScheduled) {
                    HashSet uris = new HashSet();
                    uris.addAll(dependencyPackage.getUris());
                    uris.addAll(submitpackage.getUris());
                    label = this.getScheduleLabel(submitpackage, dependencyPackage);
                    operation = new PreScheduleOperation((WorkflowService)this, uris, launchDate, context, rescheduledUris);
                } else {
                    operation = new PreGoLiveOperation((WorkflowService)this, submitpackage.getUris(), context, rescheduledUris);
                }
                if (stringList.isEmpty()) continue;
                HashMap submittedBy = new HashMap();
                for (String uri : stringList) {
                    this.dmPublishService.cancelScheduledItem(site, uri);
                }
                this.workflowProcessor.addToWorkflow(site, stringList, launchDate, label, (SubmitLifeCycleOperation)operation, approver, mcpContext);
            }
        }
    }

    protected void goLivepackage(String site, SubmitPackage submitpackage, DmDependencyTO dmDependencyTO, boolean isNotScheduled, SubmitPackage dependencyPackage, String approver, Set<String> rescheduledUris, Set<String> processedUris) {
        if (!processedUris.contains(dmDependencyTO.getUri())) {
            this.handleReferences(site, submitpackage, dmDependencyTO, isNotScheduled, dependencyPackage, approver, rescheduledUris, processedUris);
            List children = dmDependencyTO.getChildren();
            if (children != null) {
                for (DmDependencyTO child : children) {
                    this.handleReferences(site, submitpackage, child, isNotScheduled, dependencyPackage, approver, rescheduledUris, processedUris);
                    this.goLivepackage(site, submitpackage, child, isNotScheduled, dependencyPackage, approver, rescheduledUris, processedUris);
                }
            }
            processedUris.add(dmDependencyTO.getUri());
        }
    }

    protected String getScheduleLabel(SubmitPackage submitPackage, SubmitPackage dependencyPack) {
        StringBuilder builder = new StringBuilder("schedule_workflow:");
        builder.append(submitPackage.getLabel()).append(",").append(dependencyPack.getLabel());
        String label = builder.toString();
        if (label.length() > 255) {
            label = label.substring(0, 252) + "..";
        }
        return label;
    }

    protected void submitToWorkflow(String site, ZonedDateTime launchDate, String label, List<String> paths) throws ServiceException {
        this.submitToWorkflow(site, launchDate, label, paths, null);
    }

    protected void submitToWorkflow(String site, ZonedDateTime launchDate, String label, List<String> paths, MultiChannelPublishingContext mcpContext) throws ServiceException {
        this._submit(site, launchDate, label, paths, mcpContext);
    }

    protected void _submit(String site, ZonedDateTime launchDate, String label, List<String> paths, MultiChannelPublishingContext mcpContext) {
        if (label.length() > 255) {
            label = label.substring(0, 252) + "..";
        }
        logger.debug("[WORKFLOW] w1,publish for " + label + ",start," + System.currentTimeMillis(), new Object[0]);
        this.dmPublishService.publish(site, paths, launchDate, mcpContext);
    }

    @ValidateParams
    public boolean isRescheduleRequest(DmDependencyTO dependencyTO, @ValidateStringParam(name="site") String site) {
        if (dependencyTO.isDeleted() || !dependencyTO.isSubmitted() && !dependencyTO.isInProgress()) {
            ContentItemTO to = this.contentService.getContentItem(site, dependencyTO.getUri());
            ZonedDateTime newDate = dependencyTO.getScheduledDate();
            ZonedDateTime oldDate = to.getScheduledDate();
            return !this.areEqual(oldDate, newDate);
        }
        return false;
    }

    public void preGoLive(Set<String> uris, GoLiveContext context, Set<String> rescheduledUris) {
    }

    public void preSchedule(Set<String> uris, ZonedDateTime date, GoLiveContext context, Set<String> rescheduledUris) {
    }

    @ValidateParams
    public ResultTO reject(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="user") String user, String request) throws ServiceException {
        ResultTO result = new ResultTO();
        try {
            int length;
            JSONObject requestObject;
            String approver = user;
            if (StringUtils.isEmpty((CharSequence)approver)) {
                approver = this.securityService.getCurrentUser();
            }
            String reason = (requestObject = JSONObject.fromObject((Object)request)).containsKey((Object)this.JSON_KEY_REASON) ? requestObject.getString(this.JSON_KEY_REASON) : "";
            JSONArray items = requestObject.getJSONArray(this.JSON_KEY_ITEMS);
            String scheduledDate = null;
            if (requestObject.containsKey((Object)this.JSON_KEY_SCHEDULED_DATE)) {
                scheduledDate = requestObject.getString(this.JSON_KEY_SCHEDULED_DATE);
            }
            if ((length = items.size()) > 0) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
                ArrayList<DmDependencyTO> submittedItems = new ArrayList<DmDependencyTO>();
                for (int index = 0; index < length; ++index) {
                    String stringItem = items.optString(index);
                    DmDependencyTO submittedItem = null;
                    submittedItem = this.getSubmittedItem(site, stringItem, format, scheduledDate, null);
                    submittedItems.add(submittedItem);
                }
                ArrayList<String> paths = new ArrayList<String>();
                for (DmDependencyTO goLiveItem : submittedItems) {
                    if (!this.contentService.contentExists(site, goLiveItem.getUri())) continue;
                    paths.add(goLiveItem.getUri());
                }
                this.objectStateService.setSystemProcessingBulk(site, paths, true);
                HashSet<String> cancelPaths = new HashSet<String>();
                cancelPaths.addAll(paths);
                this.deploymentService.cancelWorkflowBulk(site, cancelPaths);
                this.reject(site, submittedItems, reason, approver);
                this.generateWorkflowActivity(site, paths, approver, ActivityService.ActivityType.REJECT);
                this.objectStateService.setSystemProcessingBulk(site, paths, false);
                result.setSuccess(true);
                result.setStatus(200);
                result.setMessage(this.notificationService.getNotificationMessage(site, NotificationMessageType.CompleteMessages, "reject", Locale.ENGLISH, new Pair[0]));
            } else {
                result.setSuccess(false);
                result.setMessage("No items provided for preparation.");
            }
        }
        catch (JSONException | DeploymentException e) {
            result.setSuccess(false);
            result.setMessage(e.getMessage());
        }
        return result;
    }

    protected void generateWorkflowActivity(String site, List<String> paths, String username, ActivityService.ActivityType activityType) {
        HashMap<String, String> extraInfo = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        for (String p : paths) {
            sb.append(p).append("; ");
        }
        extraInfo.put("contentType", "user");
        this.activityService.postActivity(site, username, sb.toString(), activityType, ActivityService.ActivitySource.API, extraInfo);
    }

    protected void reject(String site, List<DmDependencyTO> submittedItems, String reason, String approver) {
        if (submittedItems != null) {
            for (DmDependencyTO dmDependencyTO : submittedItems) {
                DependencyRules rule = new DependencyRules(site);
                rule.setContentService(this.contentService);
                rule.setObjectStateService(this.objectStateService);
                this.rejectThisAndReferences(site, dmDependencyTO, rule, approver, reason);
                List children = dmDependencyTO.getChildren();
                if (children == null) continue;
                for (DmDependencyTO child : children) {
                    this.rejectThisAndReferences(site, child, rule, approver, reason);
                }
            }
            if (!submittedItems.isEmpty()) {
                ItemMetadata metaData = this.objectMetadataManager.getProperties(site, submittedItems.get(0).getUri());
                String whoToBlame = "admin";
                if (metaData != null && StringUtils.isNotBlank((CharSequence)metaData.getModifier())) {
                    whoToBlame = metaData.getModifier();
                }
                this.notificationService.notifyContentRejection(site, whoToBlame, this.getDeploymentPaths(submittedItems), reason, approver, Locale.ENGLISH);
            }
        }
    }

    protected void rejectThisAndReferences(String site, DmDependencyTO dmDependencyTO, DependencyRules rule, String approver, String reason) {
        this._reject(site, dmDependencyTO, approver, true, reason);
        Set dependencyTOSet = rule.applyRejectRule(dmDependencyTO);
        for (DmDependencyTO dependencyTO : dependencyTOSet) {
            boolean lsendEmail = true;
            try {
                ContentItemTO contentItem = this.contentService.getContentItem(site, dependencyTO.getUri());
                lsendEmail = !contentItem.isDocument() && !contentItem.isComponent() && !contentItem.isAsset();
            }
            catch (Exception e) {
                logger.error("during rejection, content retrieve failed", new Object[0]);
                lsendEmail = false;
            }
            this._reject(site, dependencyTO, approver, lsendEmail, reason);
        }
    }

    protected void _reject(String site, DmDependencyTO dmDependencyTO, String approver, boolean sendEmail, String reason) {
        boolean contentExists = this.contentService.contentExists(site, dmDependencyTO.getUri());
        if (contentExists) {
            if (!this.objectMetadataManager.metadataExist(site, dmDependencyTO.getUri())) {
                this.objectMetadataManager.insertNewObjectMetadata(site, dmDependencyTO.getUri());
            }
            HashMap<String, Object> newProps = new HashMap<String, Object>();
            newProps.put("submittedBy", "");
            newProps.put("sendEmail", 0);
            newProps.put("submittedForDeletion", 0);
            newProps.put("launchDate", null);
            newProps.put("submittedToEnvironment", "");
            this.objectMetadataManager.setObjectMetadata(site, dmDependencyTO.getUri(), newProps);
            ContentItemTO item = this.contentService.getContentItem(site, dmDependencyTO.getUri());
            this.objectStateService.transition(site, item, TransitionEvent.REJECT);
        }
    }

    protected boolean isItemRenamed(String site, DmDependencyTO item) {
        if (item.getUri().endsWith(".xml") || !item.getUri().contains(".")) {
            return this.objectMetadataManager.isRenamed(site, item.getUri());
        }
        return false;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public void setDependencyService(DependencyService dependencyService) {
        this.dependencyService = dependencyService;
    }

    public void setDmFilterWrapper(DmFilterWrapper dmFilterWrapper) {
        this.dmFilterWrapper = dmFilterWrapper;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }

    public DmPublishService getDmPublishService() {
        return this.dmPublishService;
    }

    public void setDmPublishService(DmPublishService dmPublishService) {
        this.dmPublishService = dmPublishService;
    }

    public GeneralLockService getGeneralLockService() {
        return this.generalLockService;
    }

    public void setGeneralLockService(GeneralLockService generalLockService) {
        this.generalLockService = generalLockService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public WorkflowProcessor getWorkflowProcessor() {
        return this.workflowProcessor;
    }

    public void setWorkflowProcessor(WorkflowProcessor workflowProcessor) {
        this.workflowProcessor = workflowProcessor;
    }

    public ObjectMetadataManager getObjectMetadataManager() {
        return this.objectMetadataManager;
    }

    public void setObjectMetadataManager(ObjectMetadataManager objectMetadataManager) {
        this.objectMetadataManager = objectMetadataManager;
    }

    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public ActivityService getActivityService() {
        return this.activityService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public boolean isEnablePublishingWithoutDependencies() {
        boolean toReturn = Boolean.parseBoolean(this.studioConfiguration.getProperty("studio.workflow.publishingWithoutDependencies.enabled"));
        return toReturn;
    }
}

