/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.util;

import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentFormatUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentFormatUtils.class);
    public static final String DATE_PATTERN_TIMEZONE_GMT = "GMT";

    public static ZonedDateTime parseDate(SimpleDateFormat format, String dateStr, String timeZone) {
        ZonedDateTime retDate = null;
        if (format != null && dateStr != null) {
            if (StringUtils.isEmpty((CharSequence)timeZone)) {
                format.setTimeZone(TimeZone.getTimeZone(DATE_PATTERN_TIMEZONE_GMT));
            } else {
                format.setTimeZone(TimeZone.getTimeZone(timeZone));
            }
            retDate = ZonedDateTime.parse(dateStr, DateTimeFormatter.ISO_DATE_TIME);
        } else {
            LOGGER.error("Requested date format with null args dateStr: " + dateStr + " using format: " + format);
        }
        return retDate;
    }

    public static boolean getBooleanValue(String str) {
        return !StringUtils.isEmpty((CharSequence)str) && str.equalsIgnoreCase("true");
    }

    public static int getIntValue(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            LOGGER.error("failed to get a number from " + str, (Throwable)e);
            return -1;
        }
    }
}

