/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.util.StudioConfiguration;
import org.springframework.core.io.ClassPathResource;
import org.yaml.snakeyaml.Yaml;

public class StudioConfigurationImpl
implements StudioConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(StudioConfigurationImpl.class);
    private Map<String, String> properties = new HashMap();
    protected String configLocation;

    public void init() {
        this.loadConfig();
    }

    public void loadConfig() {
        Yaml yaml2;
        Throwable throwable;
        InputStream in;
        Map baseProperties = new HashMap();
        Map overrideProperties = new HashMap();
        ClassPathResource resource = new ClassPathResource(this.configLocation);
        try {
            in = resource.getInputStream();
            throwable = null;
            try {
                yaml2 = new Yaml();
                baseProperties = (Map)yaml2.loadAs(in, baseProperties.getClass());
                logger.debug("Loaded configuration from location: " + this.configLocation + "\n" + baseProperties.toString(), new Object[0]);
            }
            catch (Throwable yaml2) {
                throwable = yaml2;
                throw yaml2;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable yaml2) {
                            throwable.addSuppressed(yaml2);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (IOException e) {
            logger.error("Failed to load studio configuration from: " + this.configLocation, new Object[0]);
        }
        if (baseProperties.get("studio.config.overrideConfig") != null) {
            resource = new ClassPathResource(baseProperties.get("studio.config.overrideConfig").toString());
            try {
                in = resource.getInputStream();
                throwable = null;
                try {
                    yaml2 = new Yaml();
                    overrideProperties = (Map)yaml2.loadAs(in, overrideProperties.getClass());
                    if (overrideProperties != null) {
                        logger.debug("Loaded additional configuration from location: " + baseProperties.get("studio.config.overrideConfig") + "\n" + overrideProperties.toString(), new Object[0]);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                logger.error("Failed to load studio configuration from: " + baseProperties.get("studio.config.overrideConfig"), new Object[0]);
            }
        }
        for (Map.Entry entry : baseProperties.entrySet()) {
            this.properties.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        if (overrideProperties != null) {
            for (Map.Entry entry : overrideProperties.entrySet()) {
                this.properties.put(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
    }

    public String getProperty(String key) {
        return (String)this.properties.get(key);
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }
}

