/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.web.http;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.craftercms.studio.impl.v1.web.http.MultiReadHttpServletRequestWrapper;

/*
 * Exception performing whole class analysis ignored.
 */
public class MultiReadHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    public static final String UTF8 = "UTF-8";
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private ByteArrayOutputStream cachedBytes;
    private Map<String, String[]> parameterMap;

    public MultiReadHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public static void toMap(Iterable<NameValuePair> inputParams, Map<String, String[]> toMap) {
        for (NameValuePair e : inputParams) {
            String key = e.getName();
            String value = e.getValue();
            if (toMap.containsKey(key)) {
                String[] newValue = (String[])ArrayUtils.addAll((Object[])toMap.get(key), (Object[])new String[]{value});
                toMap.remove(key);
                toMap.put(key, newValue);
                continue;
            }
            toMap.put(key, new String[]{value});
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.cachedBytes == null) {
            this.cacheInputStream();
        }
        return new CachedServletInputStream(this);
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    private void cacheInputStream() throws IOException {
        this.cachedBytes = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)super.getInputStream(), (OutputStream)this.cachedBytes);
    }

    public String getParameter(String key) {
        Map parameterMap = this.getParameterMap();
        String[] values = (String[])parameterMap.get(key);
        return values != null && values.length > 0 ? values[0] : null;
    }

    public String[] getParameterValues(String key) {
        Map parameterMap = this.getParameterMap();
        return (String[])parameterMap.get(key);
    }

    public Map<String, String[]> getParameterMap() {
        if (this.parameterMap == null) {
            LinkedHashMap result = new LinkedHashMap();
            this.decode(this.getQueryString(), result);
            this.decode(this.getPostBodyAsString(), result);
            this.parameterMap = Collections.unmodifiableMap(result);
        }
        return this.parameterMap;
    }

    private void decode(String queryString, Map<String, String[]> result) {
        if (queryString != null) {
            MultiReadHttpServletRequestWrapper.toMap((Iterable)this.decodeParams(queryString), result);
        }
    }

    private Iterable<NameValuePair> decodeParams(String body) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(URLEncodedUtils.parse((String)body, (Charset)UTF8_CHARSET));
        try {
            ContentType ct;
            String cts = this.getContentType();
            if (cts != null && (ct = ContentType.parse((String)cts)).getMimeType().equals(ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
                List postParams = URLEncodedUtils.parse((String)IOUtils.toString((Reader)this.getReader()), (Charset)UTF8_CHARSET);
                CollectionUtils.addAll(params, (Iterable)postParams);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return params;
    }

    public String getPostBodyAsString() {
        try {
            if (this.cachedBytes == null) {
                this.cacheInputStream();
            }
            return this.cachedBytes.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        String query = StringUtils.isEmpty((CharSequence)this.getQueryString()) ? "" : this.getQueryString();
        StringBuilder sb = new StringBuilder();
        sb.append("URL='").append(this.getRequestURI()).append(query.isEmpty() ? "" : "?" + query).append("', body='");
        sb.append(this.getPostBodyAsString());
        sb.append("'");
        return sb.toString();
    }

    static /* synthetic */ ByteArrayOutputStream access$000(MultiReadHttpServletRequestWrapper x0) {
        return x0.cachedBytes;
    }
}

