/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.web.security.access;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.dal.User;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.security.SecurityProvider;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.util.StudioConfiguration;
import org.springframework.security.access.AccessDecisionVoter;

public abstract class StudioAbstractAccessDecisionVoter
implements AccessDecisionVoter {
    private static final Logger logger = LoggerFactory.getLogger(StudioAbstractAccessDecisionVoter.class);
    protected SecurityProvider securityProvider;
    protected SecurityService securityService;
    protected StudioConfiguration studioConfiguration;
    protected SiteService siteService;

    protected boolean isSiteMember(User currentUser, String userParam) {
        try {
            int total1 = this.siteService.getSitesPerUserTotal(userParam);
            List sitesFeed1 = this.siteService.getSitesPerUser(userParam, 0, total1);
            int total2 = this.siteService.getSitesPerUserTotal(currentUser.getUsername());
            List sitesFeed2 = this.siteService.getSitesPerUser(currentUser.getUsername(), 0, total2);
            HashSet<String> sites1 = new HashSet<String>();
            HashSet<String> sites2 = new HashSet<String>();
            for (SiteFeed site : sitesFeed1) {
                sites1.add(site.getSiteId());
            }
            for (SiteFeed site : sitesFeed2) {
                sites2.add(site.getSiteId());
            }
            Collection intersection = CollectionUtils.intersection(sites1, sites2);
            return CollectionUtils.isNotEmpty((Collection)intersection);
        }
        catch (UserNotFoundException e) {
            logger.info("User is not site member", new Object[]{e});
            return false;
        }
    }

    protected boolean isSiteMember(String siteId, User currentUser) {
        try {
            int total = this.siteService.getSitesPerUserTotal(currentUser.getUsername());
            List sitesFeed = this.siteService.getSitesPerUser(currentUser.getUsername(), 0, total);
            HashSet<String> sites = new HashSet<String>();
            for (SiteFeed site : sitesFeed) {
                sites.add(site.getSiteId());
            }
            return sites.contains(siteId);
        }
        catch (UserNotFoundException e) {
            logger.info("User is not site member", new Object[]{e});
            return false;
        }
    }

    protected boolean isSiteAdmin(String siteId, User currentUser) {
        try {
            int total = this.siteService.getSitesPerUserTotal(currentUser.getUsername());
            List sitesFeed = this.siteService.getSitesPerUser(currentUser.getUsername(), 0, total);
            HashSet<String> sites = new HashSet<String>();
            for (SiteFeed site : sitesFeed) {
                sites.add(site.getSiteId());
            }
            boolean toRet = sites.contains(siteId);
            if (toRet) {
                Set userGroups = this.securityProvider.getUserGroupsPerSite(currentUser.getUsername(), siteId);
                toRet = userGroups.contains(this.studioConfiguration.getProperty("studio.configuration.site.defaultAdminGroup"));
            }
            return toRet;
        }
        catch (UserNotFoundException e) {
            logger.info("User is not site member", new Object[]{e});
            return false;
        }
    }

    protected boolean isSelf(User currentUser, String userParam) {
        return StringUtils.equals((CharSequence)userParam, (CharSequence)currentUser.getUsername());
    }

    protected boolean isAdmin(User user) {
        Set userGroups = this.securityProvider.getUserGroups(user.getUsername());
        boolean toRet = false;
        if (CollectionUtils.isNotEmpty((Collection)userGroups)) {
            for (String group : userGroups) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)group, (CharSequence)this.studioConfiguration.getProperty("studio.security.global.adminGroup"))) continue;
                toRet = true;
                break;
            }
        }
        return toRet;
    }

    public SecurityProvider getSecurityProvider() {
        return this.securityProvider;
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }
}

