/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.web.security.access;

import java.util.Collection;
import java.util.List;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.AuthorizationServiceException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.vote.AbstractAccessDecisionManager;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;

public class StudioAccessDecisionManager
extends AbstractAccessDecisionManager {
    private static final Logger loggerCrafter = LoggerFactory.getLogger(StudioAccessDecisionManager.class);

    protected StudioAccessDecisionManager(List<AccessDecisionVoter<?>> decisionVoters) {
        super(decisionVoters);
    }

    public void decide(Authentication authentication, Object object, Collection<ConfigAttribute> configAttributes) throws AccessDeniedException, InsufficientAuthenticationException {
        int granted = 0;
        for (AccessDecisionVoter voter : this.getDecisionVoters()) {
            int result = voter.vote(authentication, object, configAttributes);
            loggerCrafter.debug("Voter: " + voter + ", returned: " + result, new Object[0]);
            switch (result) {
                case 1: {
                    ++granted;
                    break;
                }
                case -1: {
                    loggerCrafter.debug("Access denied by " + voter.getClass().getCanonicalName(), new Object[0]);
                    throw new AuthorizationServiceException(this.messages.getMessage("AbstractAccessDecisionManager.accessDenied", "Access is denied"));
                }
            }
        }
        if (granted > 0) {
            loggerCrafter.debug("Access granted", new Object[0]);
            return;
        }
        if (authentication.isAuthenticated() && !authentication.getPrincipal().equals("anonymousUser")) {
            loggerCrafter.debug("User authenticated allow access", new Object[0]);
            return;
        }
        loggerCrafter.debug("All voters abstained and user not authenticated", new Object[0]);
        this.checkAllowIfAllAbstainDecisions();
    }
}

