/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.web.security.access;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.RandomStringUtils;
import org.craftercms.commons.entitlements.exception.EntitlementException;
import org.craftercms.commons.http.HttpUtils;
import org.craftercms.studio.api.v1.exception.security.AuthenticationSystemException;
import org.craftercms.studio.api.v1.exception.security.BadCredentialsException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.security.SecurityProvider;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.security.UserDetailsManager;
import org.craftercms.studio.api.v1.util.StudioConfiguration;
import org.craftercms.studio.impl.v1.util.SessionTokenUtils;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.filter.GenericFilterBean;

public class StudioAuthenticationTokenProcessingFilter
extends GenericFilterBean {
    private static final Logger crafterLogger = LoggerFactory.getLogger(StudioAuthenticationTokenProcessingFilter.class);
    private static ReentrantLock semaphore = new ReentrantLock();
    private UserDetailsManager userDetailsManager;
    private SecurityService securityService;
    private StudioConfiguration studioConfiguration;
    private SecurityProvider securityProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = this.getAsHttpRequest(servletRequest);
        HttpSession httpSession = httpRequest.getSession();
        semaphore.lock();
        try {
            String userName = this.securityService.getCurrentUser();
            String authToken = this.securityService.getCurrentToken();
            if (userName != null) {
                UserDetails userDetails = this.userDetailsManager.loadUserByUsername(userName);
                if (SessionTokenUtils.validateToken((String)authToken, (String)userDetails.getUsername())) {
                    UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                    SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
                    if (httpRequest.getRequestURI().startsWith(httpRequest.getContextPath() + "/api/1") && !this.getIgnoreRenewTokenUrls().contains(HttpUtils.getRequestUriWithoutContextPath((HttpServletRequest)httpRequest))) {
                        int timeout = Integer.parseInt(this.studioConfiguration.getProperty("studio.security.sessionTimeout"));
                        String newToken = SessionTokenUtils.createToken((String)userDetails.getUsername(), (int)timeout);
                        httpSession.setAttribute("studioSessionToken", (Object)newToken);
                    }
                } else {
                    crafterLogger.debug("Session is not valid. Clearing HttpSession", new Object[0]);
                    httpSession.removeAttribute("studioSessionToken");
                    httpSession.invalidate();
                }
            } else if (this.isAuthenticationHeadersEnabled()) {
                String usernameHeader = httpRequest.getHeader(this.studioConfiguration.getProperty("studio.authentication.headers.username"));
                try {
                    this.securityService.authenticate(usernameHeader, RandomStringUtils.randomAlphanumeric((int)16));
                    UserDetails userDetails = this.userDetailsManager.loadUserByUsername(usernameHeader);
                    UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                    SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
                }
                catch (EntitlementException | AuthenticationSystemException | BadCredentialsException e) {
                    crafterLogger.error("Unable to authenticate user using authentication headers.", new Object[0]);
                }
            }
        }
        finally {
            semaphore.unlock();
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private HttpServletRequest getAsHttpRequest(ServletRequest request) {
        if (!(request instanceof HttpServletRequest)) {
            throw new RuntimeException("Expecting an HTTP request");
        }
        return (HttpServletRequest)request;
    }

    public List<String> getIgnoreRenewTokenUrls() {
        return Arrays.asList(this.studioConfiguration.getProperty("studio.security.ignoreRenewTokenUrls").split(","));
    }

    public boolean isAuthenticationHeadersEnabled() {
        String enabledString = this.studioConfiguration.getProperty("studio.authentication.headers.enabled");
        return Boolean.parseBoolean(enabledString);
    }

    public UserDetailsManager getUserDetailsManager() {
        return this.userDetailsManager;
    }

    public void setUserDetailsManager(UserDetailsManager userDetailsManager) {
        this.userDetailsManager = userDetailsManager;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public SecurityProvider getSecurityProvider() {
        return this.securityProvider;
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }
}

