/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.web.security.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.impl.v1.web.security.access.StudioAbstractAccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;

public class StudioGeneralAccessDecisionVoter
extends StudioAbstractAccessDecisionVoter {
    private static final Logger logger = LoggerFactory.getLogger(StudioGeneralAccessDecisionVoter.class);

    public boolean supports(ConfigAttribute attribute) {
        return true;
    }

    public int vote(Authentication authentication, Object object, Collection collection) {
        int toRet = authentication.isAuthenticated() ? 0 : -1;
        String requestUri = "";
        if (object instanceof FilterInvocation) {
            FilterInvocation filterInvocation = (FilterInvocation)object;
            HttpServletRequest request = filterInvocation.getRequest();
            requestUri = request.getRequestURI().replace(request.getContextPath(), "");
            if (this.getPublicUrls().contains(requestUri)) {
                toRet = 1;
            }
        }
        logger.debug("Request: " + requestUri + " - Access: " + toRet, new Object[0]);
        return toRet;
    }

    public boolean supports(Class clazz) {
        return true;
    }

    protected List<String> getPublicUrls() {
        StringTokenizer st = new StringTokenizer(this.studioConfiguration.getProperty("studio.security.publicUrls"), ",");
        ArrayList<String> publicUrls = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            publicUrls.add(st.nextToken().trim());
        }
        return publicUrls;
    }
}

