/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.web.security.access;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.dal.User;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.impl.v1.web.security.access.StudioAbstractAccessDecisionVoter;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;

public class StudioSiteAPIAccessDecisionVoter
extends StudioAbstractAccessDecisionVoter {
    private static final Logger logger = LoggerFactory.getLogger(StudioSiteAPIAccessDecisionVoter.class);
    private static final String CREATE = "/api/1/services/api/1/site/create.json";
    private static final String DELETE = "/api/1/services/api/1/site/delete-site.json";

    public boolean supports(ConfigAttribute configAttribute) {
        return true;
    }

    public int vote(Authentication authentication, Object o, Collection collection) {
        int toRet = 0;
        String requestUri = "";
        if (o instanceof FilterInvocation) {
            User currentUser;
            block15: {
                FilterInvocation filterInvocation = (FilterInvocation)o;
                HttpServletRequest request = filterInvocation.getRequest();
                requestUri = request.getRequestURI().replace(request.getContextPath(), "");
                String userParam = request.getParameter("username");
                if (StringUtils.isEmpty((CharSequence)userParam) && StringUtils.equalsIgnoreCase((CharSequence)request.getMethod(), (CharSequence)HttpMethod.POST.name()) && !ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                    try {
                        JSONObject jsonObject;
                        ServletInputStream is = request.getInputStream();
                        is.mark(0);
                        String jsonString = IOUtils.toString((InputStream)is);
                        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{jsonString}) && (jsonObject = JSONObject.fromObject((Object)jsonString)).has("username")) {
                            userParam = jsonObject.getString("username");
                        }
                        is.reset();
                    }
                    catch (IOException | JSONException e) {
                        logger.debug("Failed to extract username from POST request", new Object[0]);
                    }
                }
                currentUser = null;
                try {
                    currentUser = (User)authentication.getPrincipal();
                }
                catch (ClassCastException e) {
                    if (authentication.getPrincipal().toString().equals("anonymousUser")) break block15;
                    logger.info("Error getting current user", new Object[]{e});
                    return 0;
                }
            }
            switch (requestUri) {
                case "/api/1/services/api/1/site/create.json": 
                case "/api/1/services/api/1/site/delete-site.json": {
                    if (currentUser != null && this.isAdmin(currentUser)) {
                        toRet = 1;
                        break;
                    }
                    toRet = -1;
                    break;
                }
                default: {
                    toRet = 0;
                }
            }
        }
        logger.debug("Request: " + requestUri + " - Access: " + toRet, new Object[0]);
        return toRet;
    }

    public boolean supports(Class aClass) {
        return true;
    }
}

