/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.web.security.access;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.dal.User;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.impl.v1.web.security.access.StudioAbstractAccessDecisionVoter;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;

public class StudioUserAPIAccessDecisionVoter
extends StudioAbstractAccessDecisionVoter {
    private static final Logger logger = LoggerFactory.getLogger(StudioUserAPIAccessDecisionVoter.class);
    private static final String CHANGE_PASSWORD = "/api/1/services/api/1/user/change-password.json";
    private static final String CREATE = "/api/1/services/api/1/user/create.json";
    private static final String DELETE = "/api/1/services/api/1/user/delete.json";
    private static final String DISABLE = "/api/1/services/api/1/user/disable.json";
    private static final String ENABLE = "/api/1/services/api/1/user/enable.json";
    private static final String FORGOT_PASSWORD = "/api/1/services/api/1/user/forgot-password.json";
    private static final String GET = "/api/1/services/api/1/user/get.json";
    private static final String GET_ALL = "/api/1/services/api/1/user/get-all.json";
    private static final String GET_PER_SITE = "/api/1/services/api/1/user/get-per-site.json";
    private static final String LOGIN = "/api/1/services/api/1/security/login.json";
    private static final String LOGOUT = "/api/1/services/api/1/security/logout.json";
    private static final String RESET_PASSWORD = "/api/1/services/api/1/user/reset-password.json";
    private static final String SET_PASSWORD = "/api/1/services/api/1/user/set-password.json";
    private static final String STATUS = "/api/1/services/api/1/user/status.json";
    private static final String UPDATE = "/api/1/services/api/1/user/update.json";
    private static final String VALIDATE_TOKEN = "/api/1/services/api/1/user/validate-token.json";

    public boolean supports(ConfigAttribute configAttribute) {
        return true;
    }

    public int vote(Authentication authentication, Object o, Collection collection) {
        int toRet = 0;
        String requestUri = "";
        if (o instanceof FilterInvocation) {
            User currentUser;
            String userParam;
            block42: {
                FilterInvocation filterInvocation = (FilterInvocation)o;
                HttpServletRequest request = filterInvocation.getRequest();
                requestUri = request.getRequestURI().replace(request.getContextPath(), "");
                userParam = request.getParameter("username");
                String siteParam = request.getParameter("site_id");
                if (StringUtils.isEmpty((CharSequence)userParam) && StringUtils.equalsIgnoreCase((CharSequence)request.getMethod(), (CharSequence)HttpMethod.POST.name()) && !ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                    try {
                        ServletInputStream is = request.getInputStream();
                        is.mark(0);
                        String jsonString = IOUtils.toString((InputStream)is);
                        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{jsonString})) {
                            JSONObject jsonObject = JSONObject.fromObject((Object)jsonString);
                            if (jsonObject.has("username")) {
                                userParam = jsonObject.getString("username");
                            }
                            if (jsonObject.has("site_id")) {
                                siteParam = jsonObject.getString("site_id");
                            }
                        }
                        is.reset();
                    }
                    catch (IOException | JSONException e) {
                        logger.debug("Failed to extract username from POST request", new Object[0]);
                    }
                }
                currentUser = null;
                try {
                    currentUser = (User)authentication.getPrincipal();
                }
                catch (ClassCastException e) {
                    if (authentication.getPrincipal().toString().equals("anonymousUser")) break block42;
                    logger.info("Error getting current user", new Object[]{e});
                    return 0;
                }
            }
            switch (requestUri) {
                case "/api/1/services/api/1/user/forgot-password.json": 
                case "/api/1/services/api/1/security/login.json": 
                case "/api/1/services/api/1/security/logout.json": 
                case "/api/1/services/api/1/user/set-password.json": 
                case "/api/1/services/api/1/user/validate-token.json": {
                    toRet = 1;
                    break;
                }
                case "/api/1/services/api/1/user/change-password.json": {
                    if (currentUser != null && this.isSelf(currentUser, userParam)) {
                        toRet = 1;
                        break;
                    }
                    toRet = -1;
                    break;
                }
                case "/api/1/services/api/1/user/create.json": 
                case "/api/1/services/api/1/user/delete.json": 
                case "/api/1/services/api/1/user/disable.json": 
                case "/api/1/services/api/1/user/enable.json": 
                case "/api/1/services/api/1/user/reset-password.json": 
                case "/api/1/services/api/1/user/status.json": {
                    if (currentUser != null && this.isAdmin(currentUser)) {
                        toRet = 1;
                        break;
                    }
                    toRet = -1;
                    break;
                }
                case "/api/1/services/api/1/user/get-all.json": {
                    if (currentUser != null) {
                        toRet = 1;
                        break;
                    }
                    toRet = -1;
                    break;
                }
                case "/api/1/services/api/1/user/get.json": {
                    if (currentUser != null && (this.isAdmin(currentUser) || this.isSelf(currentUser, userParam) || this.isSiteMember(currentUser, userParam))) {
                        toRet = 1;
                        break;
                    }
                    toRet = -1;
                    break;
                }
                case "/api/1/services/api/1/user/get-per-site.json": {
                    if (currentUser != null && (this.isAdmin(currentUser) || this.isSiteMember(currentUser, userParam))) {
                        toRet = 1;
                        break;
                    }
                    toRet = -1;
                    break;
                }
                case "/api/1/services/api/1/user/update.json": {
                    if (currentUser != null && (this.isAdmin(currentUser) || this.isSelf(currentUser, userParam))) {
                        toRet = 1;
                        break;
                    }
                    toRet = -1;
                    break;
                }
                default: {
                    toRet = 0;
                }
            }
        }
        logger.debug("Request: " + requestUri + " - Access: " + toRet, new Object[0]);
        return toRet;
    }

    public boolean supports(Class aClass) {
        return true;
    }
}

