/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.webdav;

import java.io.InputStream;
import java.util.List;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.craftercms.studio.api.v1.exception.WebDavException;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.webdav.WebDavProfile;
import org.craftercms.studio.api.v1.webdav.WebDavProfileReader;
import org.springframework.beans.factory.annotation.Required;

public class WebDavProfileReaderImpl
implements WebDavProfileReader {
    private static final String CONFIG_KEY_PROFILE = "profile";
    private static final String CONFIG_KEY_ID = "id";
    private static final String CONFIG_KEY_BASE_URL = "baseUrl";
    private static final String CONFIG_KEY_USERNAME = "username";
    private static final String CONFIG_KEY_PASSWORD = "password";
    protected String configPath;
    protected ContentService contentService;

    @Required
    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    @Required
    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    protected HierarchicalConfiguration getConfiguration(String site) throws WebDavException {
        try {
            InputStream input = this.contentService.getContent(site, this.configPath);
            Parameters params = new Parameters();
            FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(XMLConfiguration.class);
            XMLConfiguration config = (XMLConfiguration)builder.configure(new BuilderParameters[]{params.xml()}).getConfiguration();
            FileHandler fileHandler = new FileHandler((FileBased)config);
            fileHandler.setEncoding("UTF-8");
            fileHandler.load(input);
            return config;
        }
        catch (Exception e) {
            throw new WebDavException("Unable to read configuration file", e);
        }
    }

    public WebDavProfile getProfile(String site, String profileId) throws WebDavException {
        HierarchicalConfiguration config = this.getConfiguration(site);
        List profiles = config.configurationsAt(CONFIG_KEY_PROFILE);
        HierarchicalConfiguration profileConfig = profiles.stream().filter(c -> profileId.equals(c.getString(CONFIG_KEY_ID))).findFirst().orElseThrow(() -> new WebDavException("Profile '" + profileId + "' not found"));
        WebDavProfile profile = new WebDavProfile();
        profile.setBaseUrl(profileConfig.getString(CONFIG_KEY_BASE_URL));
        profile.setUsername(profileConfig.getString(CONFIG_KEY_USERNAME));
        profile.setPassword(profileConfig.getString(CONFIG_KEY_PASSWORD));
        return profile;
    }
}

