/*
 * Crafter Studio Web-content authoring solution
 * Copyright (C) 2007-2016 Crafter Software Corporation.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.craftercms.studio.api.v1.job;

public class CronJobContext {

    private static ThreadLocal<CronJobContext> threadLocal = new ThreadLocal<>();

    public static CronJobContext getCurrent() {
        return threadLocal.get();
    }

    public static void setCurrent(CronJobContext cronJobContext) {
        threadLocal.set(cronJobContext);
    }

    public static void clear() {
        threadLocal.remove();
    }

    public CronJobContext(String authenticationToken, String currentUser) {
        this.authenticationToken = authenticationToken;
        this.currentUser = currentUser;
    }

    public String getAuthenticationToken() { return authenticationToken; }
    public void setAuthenticationToken(String authenticationToken) { this.authenticationToken = authenticationToken; }

    public String getCurrentUser() { return currentUser; }
    public void setCurrentUser(String currentUser) { this.currentUser = currentUser; }

    private String authenticationToken;
    private String currentUser;
}
