/*
 * Copyright (C) 2007-2020 Crafter Software Corporation. All Rights Reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

CStudioAuthoring.Messages.registerBundle('siteDashboard', 'es', {
  dashboardTitle: 'Panel de Control',

  dashboardCollapseAll: 'Desplegar todo',
  dashboardExpandAll: 'Expandir todo',
  dashboardEdit: 'Editar',

  approvedScheduledCollapseAll: 'Desplegar todo',

  dashletFilterPages: 'Páginas',
  dashletFilterComponents: 'Componentes',
  dashletFilterDocuments: 'Documentos',
  dashletFilterAssets: 'Recursos',
  dashletFilterAll: 'Todo',

  dashletGoLiveQueueTitle: 'Articulos Esperando por Aprobación',
  dashletGoLiveCollapseAll: 'Desplegar todo',
  dashletGoLiveExpandAll: 'Expandir todo',
  dashletGoLiveShowInProgress: 'Mostrar Artículos "En-Progreso" ',
  dashletGoLiveHideInProgress: 'Esconder Artículos "En-Progreso " ',
  dashletGoLiveColPageName: 'Nombre del Artículo',
  dashletGoLiveColEdit: 'Editar',
  dashletGoLiveColView: 'Ver',
  dashletGoLiveColURL: 'URL',
  dashletGoLiveColEnvironment: 'Ambiente',
  dashletGoLiveColPublishDate: 'Fecha de Publicación',
  dashletGoLiveColLastEditedBy: 'Ultima Edición por',
  dashletGoLiveColLastEditedDate: 'Última Edición',
  dashletGoLivePages: 'Páginas ({0})',
  dashletGoLiveComponents: 'Componentes ({0})',
  dashletGoLiveAssets: 'Recursos ({0})',
  dashletGoLiveEdit: 'Editar',

  dashletApprovedSchedTitle: 'Artículos Publicados',
  dashletApprovedSchedCollapseAll: 'Desplegar todo',
  dashletApprovedSchedExpandAll: 'Expandir todo',
  dashletApprovedSchedShow: 'Mostrar',
  dashletApprovedSchedColGoLiveDate: 'Fecha para ir en Vivo',
  dashletApprovedSchedColEdit: 'Editar',
  dashletApprovedSchedColURL: 'URL',
  dashletApprovedSchedColEnvironment: 'Ambiente',
  dashletApprovedSchedColPackageId: 'Id del Paquete',
  dashletApprovedSchedColLastEdited: 'Última Edición',
  dashletApprovedSchedFilterPages: 'Páginas',
  dashletApprovedSchedFilterComponents: 'Componentes',
  dashletApprovedSchedFilterDocuments: 'Documentos',
  dashletApprovedSchedFilterAll: 'Todo',

  showNumItems: 'Mostrar',

  dashletRecentDeployTitle: 'Recientemente Publicados',
  dashletRecentDeployCollapseAll: 'Desplegar todo',
  dashletRecentDeployExpandAll: 'Expandir todo',
  dashletRecentDeployShow: 'Mostrar',
  dashletRecentDeployColMadeLiveDateDate: 'Fecha de Publicación',
  dashletRecentDeployColEdit: 'Editar',
  dashletRecentDeployColURL: 'URL',
  dashletRecentDeployColEndpoint: 'Ambiente',
  dashletRecentDeployColDeployBy: 'Publicado por',
  dashletRecentDeployColLastEdited: 'Última Edición',
  dashletRecentDeployColPageName: 'Nombre del Artículo',

  dashletMyRecentActivityTitle: 'Mi actividad reciente',
  dashletMyRecentActivityCollapseAll: 'Desplegar todo',
  dashletMyRecentActivityExpandAll: 'Expandir todo',
  dashletMyRecentActivityHideLiveItems: 'Enconder Artículos en Vivo',
  dashletMyRecentActivityShowLiveItems: 'Mostrar Artículos en Vivo',
  ddashletMyRecentActivityShow: 'Mostrar',
  dashletMyRecentActivityColPageName: 'Nombre del Artículo',
  dashletMyRecentActivityColEdit: 'Editar',
  dashletMyRecentActivityColURL: 'URL',
  dashletMyRecentActivityColPublishDate: 'Fecha de Publicación',
  dashletMyRecentActivityColLastEditedBy: 'Ultima Edición por',
  dashletMyRecentActivityColMyLastEdit: 'Mi Ultima Edición',

  dashletIconGuideTitle: 'Guía de Íconos',
  dashletWorkflowStatesTitle: 'Estados de Flujo de Trabajo',
  dashletItemTypesTitle: 'Tipos de Elementos',
  dashletIconGuideNavigationPage: 'Pagina de Navegación',
  dashletIconGuideFloatingPage: 'Página flotante',
  dashletIconGuideComponent: 'Componente',
  dashletIconGuideDocument: 'Documento',
  dashletIconGuideStateNew: 'Nunca Publicado',
  dashletIconGuideStateDisabled: 'Deshabilitado',
  dashletIconGuideStateDeleted: 'Eliminado',
  dashletIconGuideStateInProgress: 'Editado',
  dashletIconGuideStateInWorkflow: 'En Flujo de Trabajo',
  dashletIconGuideStateScheduled: 'Programado',
  dashletIconGuideStateSystemProcessing: 'Procesando',
  dashletIconGuideStateLocked: 'Bloqueado para editar',
  dashletIconGuideTemplateScript: 'Template o Script',
  dashletIconGuideTaxonomy: 'Taxonomia',
  dashletIconGuideImage: 'Imagen',
  dashletIconGuideVideo: 'Video',
  dashletIconGuideCss: 'CSS',
  dashletIconGuideFont: 'Font',
  dashletIconGuidePdf: 'PDF',
  dashletIconGuidePowerPoint: 'MS PowerPoint',
  dashletIconGuideWord: 'MS Word',
  dashletIconGuideExcel: 'MS Excel',
  dashletIconGuideZip: 'Zip',
  dashletIconGuideGroovy: 'Groovy',
  dashletIconGuideOtherFiles: 'Otros Archivos',

  dependenciesLabel: 'Dependencias'
});

CStudioAuthoring.Messages.registerBundle('contextnav', 'es', {
  siteContent: 'Contenido del Sitio',
  sideBar: 'Barra lateral',

  wcmContentEdit: 'Editar',
  wcmContentView: 'Ver',
  wcmContentSubmit: 'Solicitud de Publicación',
  wcmContentDependencies: 'Dependencias',
  wcmContentDelete: 'Eliminar',
  wcmContentSubmitDelete: 'Solicitud de Eliminación',
  wcmContentReject: 'Rechazar',
  wcmContentSchedule: 'Programar',
  wcmContentApprove: 'Aprobar y Publicar',
  wcmContentDuplicate: 'Duplicar',
  wcmContentHistory: 'Historial',
  wcmContentPageDisabled: 'Este contenido está deshabilitado',

  InProgress: 'Editado',
  Deleted: 'Eliminado',
  SubmittedforDelete: 'Presentado para Eliminar',
  mixedStates: 'Artículos (Estados Mixtos)',
  Submitted: 'Presentado para Aprobar',
  Live: 'En Vivo',
  Scheduled: 'Programado',

  search: 'Busqueda',

  logout: 'Cerrar Sesión',
  close: 'Cerrar',

  variableLabel: 'Ejemplos de Código de Plantilla',

  networkError: 'Error de red. Ciertas funcionalidades pueden no estar disponibles.',

  notification: 'Notificación',
  noEventError: 'No se ha asociado ningún controlador de eventos.',

  publishStatus: 'Estado de Publicación',
  idle: 'Desocupado',
  busy: 'Ocupado',
  ready: 'Listo',
  stopped: 'Detenido',
  started: 'Empezado',
  quickCreateEmpty:
    'No existe configuración para la creación rápida. Solicite al administrador del sistema que configure los tipos de contenido de creación rápida que desee.'
});

CStudioAuthoring.Messages.registerBundle('previewTools', 'es', {
  previewToolsTitle: 'Herramientas de Vista Previa',
  inContextEditing: 'Edición En-Contexto',
  pageComponents: 'Componentes de Página',
  responsivePreview: 'Vista Previa Responsive',
  desktop: 'Escritorio',
  browser: 'Navegador',
  iphone: 'iPhone5 / iPhone5S',
  iPad: 'iPad',
  targeting: 'Orientación',
  translation: 'Traducción',
  inContextEditOn: 'Encender Edición En-Contexto',
  inContextEditOff: 'Apagar Edición En-Contexto',
  publishingChannel: 'Canal para Publicar',
  web: 'Web',
  smartPhone: 'Teléfono Inteligente',
  tablet: 'Tableta',
  multiVariantTesting: 'Pruebas Multi-Variante',
  YellowVsBlue: 'Máscaras Amarillas vs Azul en Inicio',
  yellow: 'Amarillo',
  blue: 'Azul',
  FacetedVsKeyword: 'Buscar: Facetas vs Palabra Clave',
  faceted: 'Facetas',
  facetedKeyword: 'Facetas + Palabra Clave',
  keywordOnly: 'Solo Palabra Clave',
  HomeRedVsBlue: 'Botones de Inicio Rojo vs Azul',
  red: 'Rojo',
  catalogPageSorting: 'Ordernar Página del Catálogo',
  arrivalDate: 'Fecha de Llegada',
  priceHightoLow: 'Precio de mayor a menor',
  priceLowtoHigh: 'Precio de menor a mayor',
  editTemplate: 'Editar Plantilla',
  editController: 'Ediar Controlador',
  jumpToRegion: 'Saltar a la Región',
  dimensionsPx: 'Dimensiones (px)',
  viewPortSize: 'Tamaño del Viewport (px)',
  presets: 'Preajustes',
  custom: 'Personalizado',
  addComponent: 'Añadir componentes',
  done: 'Terminado',
  general: 'General',
  components: 'Componentes',
  persona: 'Persona',
  properties: 'Propiedades',
  assume: 'Asumir',
  update: 'Actualizar',
  active: 'Activo',
  reportsOff: 'Reportes Fuera',
  reportsError: 'Incapaz de rendir informe debido a error',
  addComponent: 'Añadir componentes',
  done: 'Listo',
  components: 'Componentes',
  general: 'General',
  text: 'Texto',

  //login
  login: 'Iniciar sesión',
  emailUsername: 'Correo electrónico / Nombre de usuario',
  password: 'Contraseña de Email',
  signIn: 'Registrarse',
  signBackIn: 'Vuelve a iniciar sesión',
  signInContinueWorking: 'Iniciar sesión y seguir trabajando',
  sessionExpireInactivity: 'Su sesión ha caducado debido a la inactividad',
  doneSignOut: 'He terminado. Desloguearme',

  search: 'Búsqueda',
  publishingStatus: 'Estatus de Publicación',
  users: 'Usuarios',
  sites: 'Sitios',
  help: 'Ayuda',
  documentation: 'Documentación',
  about: 'Acerca De',
  settings: 'Preferencias',
  signOut: 'Desloguearse',
  mainMenu: 'Menu Principal',

  videoProcessed: 'El video se está procesado, la vista previa estará disponible cuando se complete el procesamiento',
  quickCreate: 'Creación Rápida',
  inContextEdit: 'Edición en Contexto'
});

CStudioAuthoring.Messages.registerBundle('siteDropdown', 'es', {
  pages: 'Páginas',
  Pages: 'Páginas',
  page: 'Página',
  components: 'Componentes',
  Components: 'Componentes',
  component: 'Componente',
  staticassets: 'Activos Estáticos',
  classes: 'Clases',
  templates: 'Plantillas',
  scripts: 'Scripts',
  adminConsole: 'Consola de Administración',
  siteconfig: 'Configuración del sitio',
  previewSync: 'Vista previa de Sincronización',
  syncrepo: 'Sincronizar del Repositorio',
  allSites: 'Todos los Sitios',
  dashboard: 'Panel de Control',
  newContent: 'Nuevo Contenido',
  newFolder: 'Nueva Carpeta',
  upload: 'Subir',
  edit: 'Editar',
  view: 'Ver',
  changeTemplate: 'Cambiar la Plantilla',
  delete: 'Eliminar',
  cut: 'Cortar',
  copy: 'Copiar',
  paste: 'Pegar',
  duplicate: 'Duplicar',
  history: 'Historial',
  unlock: 'Desbloquear',
  noActionsAvailable: 'No Hay Acciones Disponibles',
  createFolder: 'Crear Carpeta',
  renameFolder: 'Renombrar Carpeta',
  createTemplate: 'Crear Plantilla',
  templateFilename: 'Ingrese un nombre de archivo para la plantilla',
  createController: 'Crear Controlador',
  controllerFilename: 'Ingrese un nombre de archivo para el controlador',
  bulkUploadAssets: 'Subir Activos Granel',
  lastEdited: 'Última Edición',
  editedBy: 'Editado Por',
  lockedBy: 'Bloqueado Por',
  status: 'Estado',
  scheduled: 'Programado',
  loading: 'Cargando...',

  /*tooltip-Status*/
  statusDeleted: 'Eliminado',
  statusScheduledForDelete: 'Programado para Eliminar',
  statusSubmittedForDelete: 'Presentado para Eliminar',
  statusAndDisabled: 'y Deshabilitado',
  statusProcessing: 'Procesando',
  statusInProgress: 'Editado',
  statusLive: 'En Vivo',
  statusAnd: 'y',
  statusSubmitted: 'Enviado',
  statusScheduled: 'Programado',
  statusDisabled: 'Deshabilitado',
  wcmContentSubmit: 'Solicitud de Publicación',
  wcmContentApprove: 'Aprobar y Publicar',

  notification: 'Notificación',
  previewInitiated: 'Sincronización del servidor de previsualización iniciado.',
  syncfromRepoInitiated: 'Sincronización del repositorio iniciado.',

  lookUpItemError: 'No se puede buscar el elemento. Por favor, póngase en contacto con el administrador del sistema.',
  pathSameError: 'Las rutas de origen y destino son las mismas.',
  pageExistError: 'Página ya existe en el destino.',
  wcmContentDependencies: 'Dependencias',

  create: 'Crear',
  rename: 'Renombrar',
  cancel: 'Cancelar'
});

CStudioAuthoring.Messages.registerBundle('forms', 'es', {
  new: 'Nuevo',
  expandAll: 'Expandir Todo',
  collapseAll: 'Collapsar Todo',
  pageName: 'Item Name',
  location: 'Ubicación',
  sectionValidation: '{0} de {1} campos requeridos son invalidos',
  saveAndClose: 'Guardar y Cerrar',
  saveAndCloseDraft: 'Guardar como Borrador',
  saveAndPreview: 'Guardar y Mostrar',
  save: 'Guardar',
  cancel: 'Cancelar',
  close: 'Cerrar',
  repeatAddAnother: 'Agregar Otro',
  repeatMoveUp: 'Mover Arriba',
  repeatMoveDown: 'Mover Abajo',
  repeatDelete: 'Eliminar',
  errMissingRequirements: 'You cannot save until all form requirements are satisfied',
  errSaveFailed: 'Unable to save form content. Please try again or contact or your system administrator.',
  errOnRepeat: 'Error on repeater operation: {0}',
  errFailedToLoadContent: 'Error loading content: {0}',
  errExpectedIndexXml: 'Not expecting file-name other than index.xml',
  ok: 'Aceptar',
  yes: 'Si',
  no: 'No',
  openType: 'Abrir Tipo',
  submit: 'Enviar',
  loading: 'Cargando&hellip;',
  viewSample: 'Ver Ejemplo',
  hideSample: 'Esconder Ejemplo',
  continueEditing: 'Continuar Editando',
  notification: 'Notificación',
  previewLoaded: 'Vista previa cargada.',

  copy: 'Copiar',
  copyDescription:
    'Por favor seleccione las subpaginas que le gustaria copar.<br/> Al pegar, se conservarán las sub-páginas seleccionadas y su jerarquía posicional.',
  page: 'Página',
  loadingContents: 'Cargando Contenidos...',
  cut: 'Cut',
  cutDescription:
    'Por favor seleccione las subpaginas que le gustaria cortar.<br/> Al pegar, se conservarán las sub-páginas seleccionadas y su jerarquía posicional.',

  create: 'Crear',
  newFolderTitle: 'Crear una carpeta nueva',
  newFolderBody: 'Porfavor ingrese el nombre de la carpeta',
  newFolderLabel: 'Nombre de la carpeta:',
  newFolderUpdating: 'Creando la carpeta...',

  chooseContentType: 'Elige un tipo de contenido',
  chooseContentTypeBody: 'Las siguientes plantillas de inicio están disponibles para su uso dentro de esta sección.',
  chooseContentTypeLabel: 'Nombre de la Plantilla:',
  chooseContentTypePreview: 'Vista Previa:',

  cancelDialogHeader: 'Crafter Studio',
  cancelDialogBody: 'Desea cerrar este formulario sin guardar los cambios?',
  noContentTypes: 'No hay tipos de contenido desponibles en la siguiente ruta:',
  noTemplatesAssoc: 'No hay plantillas asociadas a la página:',
  noTemplateAssocAdm:
    'No existe una plantilla asociada con este tipo de contenido. Haga clic en Guardar para proceder con la operación de guardar o Continuar para actualizar el tipo de contenido (en Propiedades básicas de tipo de contenido) con una plantilla.',

  changeTemplateDialogTitle: 'Advertencia: Cambiando el Tipo de Contenido',
  changeTemplateDialogSubTitle: 'Crafter Studio',
  changeTemplateDialogBody: 'La siguiente operación puede provocar la pérdida de datos. ¿Quieres continuar?',

  bulkPublishDialogTitle: 'Advertencia: Publicación en cantidades',
  bulkPublishDialogBody:
    'Publicar en cantidades forzará una publicación de todos los elementos que coincidan con el patrón solicitado incluyendo sus dependencias.</br> Por favor asegúrese de que todos los elementos modificados (incluyendo aquello en progreso de alguien más) estén </br> listos para publicarse antes de continuar.',
  bulkPublish: 'Publicar en cantidades',
  bulkPublishPathToPublish: 'Ruta para Publicar',
  bulkPublishPublishingEnv: 'Ambiente a Publicar',
  bulkPublishPublish: 'Publicar',

  historyDialogTitle: 'Historial de las Versiones',
  historyDialogSubTitle: 'Historial mostrado para:',
  historyDialogTableRowVersion: 'Fecha y Hora de la Versión',
  historyDialogTableRowTime: 'Tiempo de Edición',
  historyDialogTableRowEditBy: 'Editado por',
  historyDialogTableRowComment: 'Comentario',
  historyDialogRevert: 'Revertir',
  historyDialogTableRowActions: 'Acciones',
  historyDialogLoadingWait: 'Cargando, por favor esperar&hellip;',
  historyDialogNoVersionsFound: 'No hay versiones encontradas.',
  historyDialogUnable: 'No se puede cargar el historial de versiones.',
  historyDialogTryAgain: 'Inténtalo de nuevo',
  historyDialogViewFileMessage: 'Ver esta versión',
  historyDialogCompareFileMessage: 'Comparar con el actual',
  historyDialogRevertFileMessage: 'Revertir a esta versión',
  historyDialogCompare: 'Comparar',

  deleteDialogTitle: 'Eliminar',
  deleteDialogSubTitle:
    'Los elementos seleccionados se eliminarán junto con sus elementos hijos. Revise los elementos dependientes antes de eliminarlos, ya que estos terminarán con referencias de enlaces rotos.',
  deleteDialogSetLink: 'Establecer todo para "Ahora"',
  deleteDialogPage: 'Página',
  deleteDialogDelete: 'Eliminar',
  deleteDialogNow: 'Ahora',
  deleteDialogFeedBack: 'Las dependencias deben comprobarse antes de enviarlas',
  deleteDialogNoItemsSelected: 'No hay artículos seleccionados',
  deletedTitle: 'Selección eliminada',
  deletedMessage: 'La selección se está eliminando y será removida pronto.',

  deleteSubmitDialogTitle: 'Enviar para su eliminación',
  deleteSubmitDialogTime: '¿Cuándo desea eliminar los artículos marcados?',
  deleteSubmitEmailMe: 'Enviarme un correo cuando los artículos son eliminados.',
  deleteSubmitDialogAsSoon: 'Lo antes posible.',

  approveDialogTitle: 'Aprobar para Publicar',
  approveDialogSubTitle:
    'Los archivos seleccionados serán publicados. Las dependencias fuertes se incluyen automáticamente. Las dependencias suaves son opcionales y puede elegir cuál incluir.',
  approveDialogWarning:
    'ADVERTENCIA: los elementos que ha seleccionado para su aprobación se enviaron con diferentes fechas/horas de publicación solicitadas.',
  dependenciesDialogTitle: 'Dependencias',
  dependenciesDialogSubTitle: 'Dependencias mostradas para:',
  dependsOn: 'Depende de',
  dependsOnMe: 'Dependen de mi',
  selectDeps: 'Mostrar contenido que:',
  dependenciesDialogItem: 'Ítem',
  approveDialogPage: 'Página',
  approveDialogOriginalSchedule: 'Horario original',
  approveDialogSubmissionComment: 'Comentario de envio',
  approveDialogSelectedScheduling: 'Seleccionado artículo Programado',
  approveDialogItemsLiveNow: 'Los artículos deben publicarse ahora.',
  approveDialogItemsLiveDate: 'Los artículos se publicarán en una fecha y hora específica',
  approveDialogPublishContent: 'Publicar Contenido',
  approveDialogPublishingOptions: 'Objetivo de publicación',
  approveDialogBroadcastUpdate: 'Actualización de contenido',

  requestApproveDialogTitle: 'Solicitud de Publicación',
  requestApproveDialogSubTitle: 'Cuando desea que los artículos se publiquen?',
  requestApproveDialogEmailMe: 'Enviarme un correo cuando los artículos sean aprobados para publicarse.',

  itemsForPublish: 'Articulos para publicar',
  selectAll: 'Seleccionar todo',
  hardDependencies: 'Dependencias fuertes',
  submissionMandatory: 'Presentación obligatoria',
  softDependencies: 'Dependencias suaves',
  submissionOptional: 'Presentación opcional',
  showAllDependencies: 'Mostrar todas las dependencias',
  changesSelectionItems:
    'Los cambios en la selección de elementos para publicar requerirán que se recalculen "todas las dependencias".',
  loadingDependencies: 'Cargando dependencias, por favor espere ...',

  childItemsText: 'Artículos hijos',
  willGetDeleted: 'Será eliminado',
  dependendtItems: 'Artículos dependientes',
  brokenItems: 'Habrá referencias rotas',
  deleteItems: 'Eliminar ítems',
  uploadingDepenedents: 'Updating dependents, please wait...',

  newContTypeDialogTitle: 'Crear Tipo de Contenido',
  newContTypeDialogDisplayLabel: 'Etiqueta a Mostrar',
  newContTypeDialogContentTypeName: 'Nombre',
  newContTypeDialogType: 'Tipo',
  newContTypeDialogPage: 'Página',
  component: 'Componente',
  newContTypeDialogLabelMsg: 'Proporcione una etiqueta de visualización de este Tipo de Contenido',
  newContTypeDialogContentTypeNamelMsg: 'Proporcione un nombre de sistema para este Tipo de Contenido',
  newContTypeDialogTypeMsg: 'Seleccione el tipo de este Tipo de Contenido',

  adminHelpDialogTitle: 'Contenido del Campo',

  adminKeyValDialogTitle: 'Valores',
  adminKeyValDialogKey: 'Clave',
  adminKeyValDialogValue: 'Valor',
  addAnother: 'Agregar Otro',

  supportedChannelsDialogLabel: 'Etiqueta',
  supportedChannelsDialogName: 'Nombre',
  supportedChannelsDialogSize: 'Tamaño',

  setStatedDialogTitle: 'Seleccione Estados',
  setStatedDialogSetStates: 'Establezca Estados',
  setStatedDialogSystemProcessing: 'Procesamiento de Sistema',

  currentPage: 'Página Actual',

  previewInitiated: 'Sincronización del servidor de previsualización iniciado.',
  synchronizationRepo: 'Se inició la sincronización desde el repositorio.',

  /*Preview*/
  previewToolsTitle: 'Herramientas de Vista Previa',
  inContextEditing: 'Edición En-Contexto',
  pageComponents: 'Componentes de Página',
  publishingChannel: 'Canal para Publicar',
  inContextEdit: 'Edición en Contexto',

  /*Error*/
  legacyFormNoSupported: 'Servidor de formulario heredado ya no es soportado.',
  loadContentsError: 'No se puede cargar contenido. Por favor, cierre la ventana de diálogo e inténtelo de nuevo.',
  taxonomyError: 'No hay tipos de taxonomía disponibles para',
  getDomainNameError: 'Service.getDomainName obsoleto.',
  changeContTypeError: 'Error al cambiar el tipo de contenido.',
  notImplemented: 'No esta implementado.',
  timeFormatError: 'No es un formato de hora válido, proporcione un tiempo válido.',
  localStoreExceeded: 'Se sobrepasó la cuota de almacenamiento local.',
  invalidFormat: 'No es un formato de hora válido, proporcione un tiempo válido.',
  addMoreItemsError: 'No puede agregar más elementos, Quite uno e inténtelo de nuevo.',
  imgReq: 'Se requiere descripción de la imagen.',
  datasourceNotImageManager: 'El origen de datos configurado no es un gestor de imágenes.',
  noDatasourceAssociated: 'No se ha asociado ninguna fuente de datos con este editor.',
  notAComponent: ' no es un componente o no tiene elementos.',
  unableLoad: 'El sistema no pudo cargar ',
  failure: 'Fallo.',
  loadFormDefError: 'Error al cargar la definición del formulario.',
  loadModelError: 'Error al cargar el modelo.',
  controllerError: 'No se encontró ningún controlador.',
  notExist: ' no existe.',
  translationSubmitted: 'Traducción presentada.',
  numberPerPage: 'Introduzca un número en el elemento de muestra por página.',
  revertError: 'Error al revertir.',
  legacyError: 'El servidor de formulario heredado ya no es compatible.',
  contentTypesEmpty: 'No hay tipos de contenido disponibles que se pueden crear en la ruta de configuración.',
  componentCategoriesError: 'No hay categorías disponibles que puedan ser creadas.',
  pluginError: 'Se encontraron problemas con la configuración de su plugin. Faltan las siguientes propiedades:',
  pluginErrorSolution:
    "Vaya a <a id='siteConfigURL'> [página de configuración del sitio] </a> y seleccione 'Herramientas de configuración del sitio' en el menú desplegable para editar el archivo.",
  control: 'Control: ',
  datasource: 'Fuente de datos: ',
  propertyMessage: ' propiedad esta faltando',
  propertiesMessage: ' propiedades están faltando'
});

CStudioAuthoring.Messages.registerBundle('search', 'es', {
  searchInput: 'Buscar',
  numResults: 'Número de Resultados',
  selectAll: 'Seleccionar Todos',
  filters: 'Filtros',
  Relevance: 'Relevancia',
  asc: 'Ascendente',
  desc: 'Descendente',
  moreRelevance: 'Mayor relevancia primero',
  lessRelevance: 'Menor relevancia primero',
  sortOrder: 'Orden',
  sortBy: 'Ordenar Por',
  name: 'Nombre',
  images: 'Imágenes',
  videos: 'Videos',
  width: 'Ancho',
  height: 'Alto',
  path: 'Ruta',
  'content-type': 'Content Type',
  'mime-type': 'MIME Type',
  'last-edit-date': 'Fecha de Última Edición',
  size: 'Tamaño de contenido',
  today: 'Hoy',
  'in-last-day': 'El último día',
  'in-last-week': 'La última semana',
  'over-a-month-ago': 'Hace más de un mes',
  'over-six-months-ago': 'Hace más de seis meses',
  'over-a-week-ago': 'Hace más de una semana',
  'over-a-year-ago': 'Hace más de un año',
  paginationFirst: 'Primero',
  paginationPrev: 'Anterior',
  paginationNext: 'Siguiente',
  paginationLast: 'Último',
  seeMore: 'Ver Más',
  seeLess: 'Ver Menos',
  under: 'Menos de ',
  above: 'y más',
  errorMessage: 'Hubo un problema completando su búsqueda, por favor contacte al Administrador si el problema persite.',
  clear: 'Limpiar',
  apply: 'Aplicar'
});

CStudioAuthoring.Messages.registerBundle('browse', 'es', {
  labelUrl: 'URL',
  labelType: 'Tipo',
  labelAddClose: 'Agregar & Cerrar',
  labelAddLink: 'Agregar Enlace',
  labelClone: 'Clonar',
  selectAll: 'Seleccionar Todo',
  clearAll: 'Limpiar Selección',
  uploadLabel: 'Subir',
  notification: 'Notificación',
  lookUpChildError: 'No puede buscar la devolución de llamada del formulario secundario para la búsqueda: ',
  lookUpParentError: 'No puede buscar el contexto del padre para la búsqueda: ',
  loading: 'Cargando',
  noBrowseResults: 'No hay archivos en esta ruta.',
  noSearchResults: 'No hay resultados.',
  showMore: 'Mostrar Más',
  400: 'Parámetro(s) CMIS Inválidos. Configuración de la fuente de datos de CMIS inválida (nombre de host, número de puerto, etc.), por favor contacte al administrador del sitio.',
  401: 'CMIS no autorizado: Nombre de usuario o contraseña inválidos en la configuración de la fuente de datos, por favor contacte al administrador del sitio.',
  404: 'Ruta del CMIS no encontrada.',
  408: 'Tiempo de espera de CMIS agotado.',
  500: 'Error interno del server.',
  503: 'CMIS no disponible.'
});

CStudioAuthoring.Messages.registerBundle('contentTypes', 'es', {
  contenttypes: 'Tipos de Contenido',
  bulkoperations: 'Operaciones en Cantidades',
  workflowjobs: 'Flujo de Trabajo de Tareas',
  workflowstates: 'Flujo de Trabajo de Estados',
  logginglevels: 'Niveles de Registro',
  logconsole: 'Consola de Registros',
  publishing: 'Publicación',
  status: 'Estado',
  audit: 'Auditoría',
  groups: 'Grupos',
  contentTypes: 'Tipos de Contenido',
  configuration: 'Configuración',
  workflowJobs: 'Flujo de Trabajo de Empleos',
  workflowStates: 'Flujo de Trabajo de Estados',
  loggingLevels: 'Niveles de Registro',
  logConsole: 'Consola de Log',
  previewsync: 'Sincronización de Vista Previa',
  syncfromrepository: 'Sincronización Desde el Repo',
  label: 'Tipos de contenido',
  openExistingType: 'Abrir un Tipo Existente',
  createNewType: 'Crear un Nuevo Tipo',
  save: 'Guardar',
  cancel: 'Cancelar',
  create: 'Crear',
  close: 'Cerrar',
  saved: 'Guardado',
  clearVal: 'Limpiar Valor',
  saveFailed: 'No Se Pudo Guardar',
  formSection: 'Sección del Formulario',
  repeatingGroup: 'Repetir Grupo',
  minOccurs: 'Mínimo de Ocurrencias',
  maxOccurs: 'Máximo de Ocurrencias',
  formBasics: 'Conceptos básicos del formulario',
  formTitle: 'Título',
  description: 'Descripción',
  objectType: 'Tipo de Objeto',
  contentType: 'Tipo de Contenido',
  datasourceBasics: 'Conceptos básicos de origen de datos',
  title: 'Título',
  name: 'Nombre',
  properties: 'Propiedades',
  sectionBasics: 'Sección de Fundamentos',
  variableName: 'Nombre / Nombre de la variable',
  iceGroup: 'Grupo ICE',
  fieldBasics: 'Fundamentos de Campo',
  defaultValue: 'Valor por defecto',
  help: 'Ayuda',
  constraints: 'Restricciones',
  propertiesExplorer: 'Propiedades de Explorador',
  controls: 'Controles',
  datasources: 'Fuentes de Datos',
  defaultOpen: 'Abrir por Defecto',
  showInNav: 'Mostrar en Navegación',
  descriptorMapper: 'Descriptor del Mapeo',
  previewImage: 'Imagen (vista previa)',
  config: 'Configuración',
  controller: 'Controlador',
  notification: 'Notificación',
  deploymentCanceled: 'Elementos de implementación cancelados.',

  createTemplate: 'Crear Plantilla',
  templateFilename: 'Ingrese un nombre de archivo para la plantilla',

  /*Controls*/
  textArea: 'Área de Texto',
  linkTextarea: 'Área de Texto Vinculante',
  richTextEditor: 'Editor de Texto Enriquecido (TinyMCE 2)',
  rteTinyMCE5: 'Editor de Texto Enriquecido (TinyMCE 5)',
  input: 'Campo de Entrada',
  numericInput: 'Entrada numérica',
  uuid: 'UUID',
  linkInput: 'Campo de Entrada Vinculante',
  dropdown: 'Menú Desplegable',
  linkedDropdown: 'Menú Desplegable Vinculado',
  dateTime: 'Fecha Y Hora',
  time: 'Hora',
  checkBox: 'Casilla de Verificación',
  groupedCheckboxes: 'Grupo de Casillas de Verificación',
  itemSelector: 'Selector de Elementos',
  image: 'Imagen',
  video: 'Video',
  label: 'Etiqueta',
  pageOrder: 'Orden de Páginas',
  fileName: 'Nombre del Archivo',
  autoFilename: 'Generar Nombre',
  forceHTTPS: 'Forzar HTTPS',
  disabled: 'Discapacitados',
  flash: 'Flash',
  internalName: 'Nombre Interno',
  basicContentTypeProp: 'Propiedades Baásicas del Tipo de Contenido',
  publishStarted: 'Se ha iniciado el proceso de publicación.',

  /*Datasources */
  childContent: 'Contenido Hijo',
  embeddedContent: 'Contenido Empotrado',
  imageUploadedDesktop: 'Imagen Subida Desde El Escritorio',
  WebDAVUploadImage: 'Imagen cargada en el repositorio de WebDav',
  WebDAVUploadVideo: 'Video cargado en el repositorio de WebDav',
  imageWebDavRepository: 'Imagen del repositorio de WebDav',
  videoWebDavRepository: 'Video del repositorio de WebDav',
  fileWebDavRepository: 'Archivo del repositorio de WebDav',
  fileUploadedWebDavRepository: 'Archivo cargado en el repositorio de WebDav',
  S3UploadImage: 'Imagen cargada en el repositorio de S3',
  S3UploadVideo: 'Video cargado en el repositorio de S3',
  imageS3Repository: 'Imagen del repositorio de S3',
  videoS3Repository: 'Video del repositorio de S3',
  videos3Transcoding: 'Transcodificación de video del repositorio de S3',
  fileS3Repository: 'Archivo del repositorio de S3',
  fileUploadedS3Repository: 'Archivo cargado en el repositorio de S3',
  DAMImage: 'Imagen DAM (Flickr)',
  fileUploadedDesktop: 'Archivo Subido Desde El Escritorio',
  flashUploadedDesktop: 'Flash Subido Desde El Escritorio',
  videoUploadedDesktop: 'Video Subido Desde El Escritorio',
  videoBrowse: 'Video Del Repositorio',
  videoCMISRepository: 'Video Del Repositorio CMIS',
  staticKeyValuePairs: 'Pares Estáticos De Valores Clave',
  configuredListOfPairs: 'Configurado Lista De Pares',
  fileBrowse: 'Navegador De Archivos',
  hubspotForms: 'Formularios Hubspot',
  imageFromRepository: 'Imagen Del Repositorio',
  imageFromCMISRepository: 'Imagen Del Repositorio CMIS',
  CMISRepository: 'Archivo del repositorio de CMIS',
  CMISUpload: 'Archivo cargado en el repositorio CMIS',
  CMISUploadImage: 'Imagen cargada en el repositorio CMIS',
  CMISUploadVideo: 'Video subido al repositorio de CMIS',
  salesforceCampaigns: 'Campañas de Salesforce',
  treeContent: 'Contenido del Árbol',

  /*Properties*/
  Size: 'Tamaño',
  maxLength: 'Tamaño Máximo',
  width: 'Ancho',
  height: 'Altura',
  autoGrow: 'Auto Crecimiento',
  allowResize: 'Permitir Cambio de Tamaño',
  forceRootBlockP: 'Forzar Etiqueta p en Bloque ',
  forcePNewLines: 'Forzar Etiqueta p en Línea',
  forceBRNewLines: 'Forzar Etiqueta p en Nueva Línea',
  requireImageAlt: 'Propiedad Alt de Imágen Requerida',
  supportedChannels: 'Canales soportados',
  RTEConfiguration: 'Configuración RTE',
  imageManager: 'Administrador de Imágenes',
  videoManager: 'Administrador de Videos',
  showDate: 'Mostrar Fecha',
  showTime: 'Mostrar Hora',
  showClear: 'Mostrar Limpiar Valor',
  setNowLink: 'Establecer Link de Ahora',
  populated: 'Poblado',
  allowPastDate: 'Permitir Fecha Pasada',
  populateExpression: 'Expresion valor por defecto',
  useCustomTimezone: 'Usar Timezone Personalizado',
  readonly: 'Solo Lectura',
  readonlyOnEdit: 'Editar en Solo Lectura',
  datasource: 'Fuentes de Dato',
  showSelectAll: 'Mostrar "Seleccionar Todo"',
  allowEmptyValue: 'Permitir Valor Vacío',
  thumbnailWidth: 'Ancho de Imágen Miniatura',
  thumbnailHeight: 'Altura de Imágen Miniatura',
  displaySize: 'Tamaño a Mostrar',
  text: 'Texto',
  minSize: 'Tamaño Mínimo',
  maxSize: 'Tamaño Máximo',
  itemManager: 'Administración de Elementos',
  disableFlatteningSearch: 'Desactivar Acoplamiento de Búsqueda',
  singleValueFilename: 'Utilizar solo el nombre de archivo de valor (compat hacia atrás)',
  columns: 'Columnas',
  rows: 'Filas',
  dataType: 'Tipo de Dato',
  listName: 'Nombre de la Lista',
  repositoryId: 'Identificación del Repositorio',
  repositoryPath: 'Ubicación del Repositorio',
  studioPath: 'Ruta de Studio',
  allowedOperations: 'Operaciones Permitidas',
  clone: 'Clonar',
  link: 'Link',
  cloneAndLink: 'Clonar y Link',
  string: 'Cadena de Caracteres',
  integer: 'Numérico',
  float: 'Decimal',
  date: 'Fecha',
  HTML: 'HTML',
  options: 'Opciones',
  showKeys: 'Mostrar Claves (Artículo Sel. Solamente)',
  taxonomyName: 'Nombre de Taxonomía',
  defaultType: 'Tipo por Defecto',
  displayTemplate: 'Plantilla de Pantalla',
  noTemplateRequired: 'Plantilla no Requerida',
  mergeStrategy: 'Combinar Estrategia',
  dependsOn: 'Depende En',
  profileId: 'ID de perfil',
  path: 'Ruta',
  type: 'Tipo',
  quickCreate: 'Creación Rápida',
  showQuickCreate: 'Mostrat en Creación Rápida',
  destinationPath: 'Patrón de ruta de destino',
  inputProfileId: 'Id de perfil de entrada',
  outputProfileId: 'Id de perfil de salida',
  postfixes: 'Postfixes',
  enableCreateNew: "Mostrar 'Crear nuevo'",
  enableBrowseExisting: "Mostrar 'Seleccionar Existentes'",
  enableSearchExisting: "Mostrar 'Buscar Existentes'",
  useSearch: 'Usar Búsqueda',

  /*Restrictions*/
  required: 'Requerido',
  minimumSelection: 'Selección Mínima',
  matchPattern: 'Patrón de Compatibilidad',
  allowDuplicate: 'Permitir Duplicados',

  /*Values*/
  noDatasources: 'No hay fuentes de datos disponibles para este control',
  editMessage: 'Editar el mensaje',
  setMessage: 'Agregar el mensaje',

  /*States Workflow*/
  setStatedTabID: 'ID',
  setStatedTabState: 'Estado',
  setStatedTabSystemProcessing: 'Procesamiento de Sistema',
  setStatedTabSelectAll: 'Seleccionar Todo',
  false: 'Falso',
  true: 'Verdadero',

  /*Jobs Workflow*/
  jobWorkflowTabAct: 'Ley',
  jobWorkflowTabJobID: 'Id del Empleo',
  jobWorkflowTabProcessName: 'Nombre del Proceso',
  jobWorkflowTabCreatedDate: 'Fecha<br/>de Creación',
  jobWorkflowTabModifiedDate: 'Fecha<br/>de Modificación',
  jobWorkflowTabSiteId: 'Id del Sitio',
  jobWorkflowTabItemsInJob: 'Los ítems <br/> de Trabajo',
  jobWorkflowTabProperties: 'Propiedades',
  jobWorkflowTabStatus: 'Estado',

  /*Loggin Levels*/
  logginLevelsTabLogger: 'Logger',
  logginLevelsTabCurrentLevel: 'Nivel Actual',
  logginLevelsTabChangeLevel: 'Cambiar Nivel a',
  debug: 'depurar',
  warn: 'advertir',
  info: 'info',
  error: 'error',

  /*Configuration*/
  confTabSelectConf: 'Seleccione la Configuracioón',
  confTabConfigurations: 'Configuraciones',
  confTabConfDesc: 'Define esta lista de configuraciones',
  confTabContextualNavigationConf: 'Configuración de Navegación Contextual',
  confTabContextualNavigationConfDesc: 'Define los módulos de la barra de navegación contextual del sitio',
  confTabSidebarConf: 'Configuración del Menu barra lateral',
  confTabSidebarConfDesc: 'Define los módulos de la barra lateral',
  confTabEndpointsConf: 'Configuración de los puntos finales',
  confTabEndpointsConfDesc: 'Define una lista de puntos finales disponibles',
  confTabDevEnvironmentConf: 'Configuración del Ambiente Dev',
  confTabDevEnvironmentConfDesc: 'Define una configuración de entorno de desarrollo',
  confTabTargetsConf: 'Configuración de objetivos',
  confTabTargetsConfDesc: 'Define una lista de objetivos para la forma de fuente de datos utilizada',
  confTabRTEConf: 'Configuración RTE',
  confTabRTEConfDesc: 'Define la configuraciones de editores de texto enriquecido en formularios',
  confTabRTEtMCE5Conf: 'Configuración RTE (TinyMCE 5)',
  confTabRTEtMCE5Desc: 'Define la configuraciones de editores de texto enriquecido en formularios',
  confTabCodeEditorConf: 'Configuración de Editor de Código',
  confTabCodeEditorConfDesc: 'Define las configuraciones del Editor de Código',
  confTabPreviewAssetConf: 'Configuración de Vista Previa de Activos',
  confTabPreviewAssetConfDesc: 'Define una lista de activos editables asociados con contenido XML',
  confTabPreviewComponentsConf: 'Configuración de los Componentes de Vista Previa',
  confTabPreviewComponentsConfDesc:
    'Define una lista de componentes que se pueden crear de forma dinámica en la vista previa',
  confTabPreviewPanelConf: 'Configuración del Panel de Vista Previa',
  confTabconfTabPreviewPanelConfDesc: 'Define una lista de herramientas disponibles en la vista previa',
  confTabPersonasConf: 'Configuración de las Personas',
  confTabPersonasConfDesc: 'Personas define una lista de personajes disponibles para asumir en la vista previa',
  confTabNotificationConf: 'Notification Configuration',
  confTabNotificationConfDesc: 'Define una lista de mensajes de interfaz de usuario',
  confTabPermissionsMappings: 'Asignación de Permisos',
  confTabPermissionsMappingsDesc: 'Define un mapa de permisos y caminos',
  confTabRoleMappings: 'Asignaciones de Roles',
  confTabRoleMappingsDesc: 'Define una lista de funciones disponibles en el sitio',
  confTabSiteConfiguration: 'Configuración del Sitio',
  confTabSiteConfigurationDesc: 'Define la configuración general del sitio',
  confTabSiteConf: 'Herramientas de Configuración del sitio',
  confTabSiteConfDesc: 'Define la lista de herramientas de administración disponibles',
  confTabWorkflowConf: 'Configuración del Flujo de Trabajo',
  confTabWorkflowConfDesc: 'Define los flujos de trabajo disponibles en el sistema',
  confCacheCleared: 'Se ha eliminado el caché de configuración.',
  confTabTargetingConfiguration: 'Configuración de orientación',
  confTabTargetingConfigurationDesc:
    'Este archivo configura el sistema de orientación de Crafter Studio para ayudar a proporcionar a Crafter Engine propiedades de usuario falsas que ayudan a conducir el sistema de orientación',
  confTabEnvironmentConfiguration: 'Configuración del entorno',
  confTabEnvironmentConfigurationDesc: 'Este archivo configura los entornos que Crafter Studio puede publicar',
  confTabCMISConfiguration: 'Configuración de CMIS',
  confTabCMISConfigurationDesc:
    'Estos archivos configuran 0 o más repositorios capaces de CMIS como fuentes de datos que los autores de contenido pueden elegir',
  confTabEngineSiteConfiguration: 'Configuración de Sitio de Engine',
  confTabEngineSiteConfigurationDesc: 'Configuración del Sitio usada por Crafter Engine',
  confTabEngineSiteAppContextConfiguration: 'Configuración de Contexto de Aplicación de Sitio de Engine',
  confTabEngineSiteAppContextConfigurationDesc: 'Configuración del Contexto de Aplicación para el Sitio de Engine',

  /*Postfixes*/
  iDescription: 'Para nuúmero entero.',
  sDescription: 'Para texto.',
  lDescription: 'Para número entero largo.',
  tDescription: 'Para múltiples palabras o tokens.',
  bDescription: 'Para booleano (verdadero o falso).',
  fDescription: 'Para numero de punto flotante.',
  dDescription: 'Para número de punto flotante largo.',
  dtDescription: 'Para fecha en formato de fecha ISO 8601.',
  toDescription: 'Por tiempo en formato HH: mm: ss.',
  htmlDescription: 'Para texto con etiquetas html.',
  oDescription: 'Para objeto.',
  enDescription: 'Para múltiples palabras o tokens.',
  txtDescription: 'Para múltiples palabras o tokens.',

  /* Errors */
  error: 'Error',
  errorTitle: '. Rellene todos los títulos de los campos y fuentes de datos.',
  postfixError: 'Los campos del modelo requieren su respectivo tipo de datos postfix: ',
  optionsPostfixError: 'las opciones son ',
  optionPostfixError: 'la opción es ',
  andPostfixError: 'y',
  errorName: '. Por favor, rellene el nombre de variable para: ',
  contentTypeNotFound: 'El content type del componente no fue encontrado.',
  failConfig: 'La configuracioón no pudo ser cargada.',
  noConfPathError: 'No se ha definido ninguna ruta de configuración',
  clearCacheError: 'Error al borrar la caché de configuración.',
  endpointsError: 'Error al cargar los puntos finales.',
  jobsError: 'Error al cargar trabajos.',
  cancelDeploymentError: 'Error al cancelar la implementación.',
  saveDateError:
    'No se puede guardar el campo Fecha / Hora. Por favor, póngase en contacto con el administrador del sistema.',
  contentTypeModifiedWarn: 'Se ha modificado el tipo de contenido, ¿está seguro de que desea abandonar los cambios?',
  noPathSetError:
    'El campo de ruta del origen de datos {DATASOURCENAME} no está configurado correctamente. Por favor contacte a su administrador.',

  add: 'Agregar',
  replace: 'Reemplazar',
  delete: 'Borrar',
  edit: 'Editar',
  createNew: 'Crear Nuevo',
  browseExisting: 'Buscar Existentes',
  searchExisting: 'Buscar Existentes',

  /*help popover*/
  pattern: 'Patrón',
  objectIdPattern: 'Inserta un GUID.',
  yearPattern: 'Inserta el año actual (año de 4 dígitos).',
  monthPattern: 'Inserta el mes actual (mes de 2 dígitos del año).',
  yyyyPattern: 'Inserta el año actual (año de 4 dígitos).',
  mmPattern: 'Inserta el mes actual (mes de 2 dígitos del año).',
  ddPattern: 'Inserta el día actual (día de 2 dígitos del mes).'
});

CStudioAuthoring.Messages.registerBundle('targeting', 'es', {
  targeting: 'Público Meta',
  clear: 'Limpiar',
  apply: 'Aplicar',
  cancel: 'Cancelar',
  userProps: 'Propiedades de Usuario'
});

CStudioAuthoring.Messages.registerBundle('dialogs', 'es', {
  upload: 'Subir',
  uploadSelect: 'Por favor seleccionar un archivo para subir',
  file: 'Archivo',
  chooseFile: 'Seleccionar archivo',
  noFileChosen: 'Ningún archivo seleccionado',
  uploadBtn: 'Subir',
  cancelBtn: 'Cancelar',
  uploading: 'Subiendo'
});
