/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.cache;

import java.util.List;
import java.util.function.Supplier;
import org.craftercms.core.exception.AuthenticationException;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.RootFolderNotFoundException;
import org.craftercms.core.exception.StoreException;
import org.craftercms.core.exception.XmlFileParseException;
import org.craftercms.core.service.CacheService;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Content;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.store.ContentStoreAdapter;
import org.craftercms.core.util.ContentStoreUtils;
import org.craftercms.engine.cache.PreloadedFolder;
import org.craftercms.engine.cache.PreloadedFoldersAwareContext;
import org.craftercms.engine.util.store.decorators.ContentStoreAdapterDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class CacheWarmingAwareContentStoreAdapterDecorator
implements ContentStoreAdapterDecorator {
    private static final Logger logger = LoggerFactory.getLogger(CacheWarmingAwareContentStoreAdapterDecorator.class);
    protected boolean warmUpEnabled;
    protected ContentStoreAdapter actualStoreAdapter;
    protected CacheService cacheService;

    @Required
    public void setWarmUpEnabled(boolean warmUpEnabled) {
        this.warmUpEnabled = warmUpEnabled;
    }

    @Override
    public void setActualStoreAdapter(ContentStoreAdapter actualStoreAdapter) {
        this.actualStoreAdapter = actualStoreAdapter;
    }

    @Required
    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public Context createContext(String id, String rootFolderPath, boolean mergingOn, boolean cacheOn, int maxAllowedItemsInCache, boolean ignoreHiddenFiles) throws RootFolderNotFoundException, StoreException, AuthenticationException {
        Context context = this.actualStoreAdapter.createContext(id, rootFolderPath, mergingOn, cacheOn, maxAllowedItemsInCache, ignoreHiddenFiles);
        if (this.warmUpEnabled) {
            return new PreloadedFoldersAwareContext(context, this.actualStoreAdapter, this.cacheService);
        }
        return context;
    }

    public boolean validate(Context context) throws StoreException, AuthenticationException {
        if (this.warmUpEnabled) {
            return this.actualStoreAdapter.validate(((PreloadedFoldersAwareContext)context).getActualContext());
        }
        return this.actualStoreAdapter.validate(context);
    }

    public void destroyContext(Context context) throws StoreException, AuthenticationException {
        if (this.warmUpEnabled) {
            this.actualStoreAdapter.destroyContext(((PreloadedFoldersAwareContext)context).getActualContext());
        } else {
            this.actualStoreAdapter.destroyContext(context);
        }
    }

    public boolean exists(Context context, CachingOptions cachingOptions, String path) throws InvalidContextException, StoreException {
        return this.findItem(context, cachingOptions, path, false) != null;
    }

    public Content findContent(Context context, CachingOptions cachingOptions, String path) throws InvalidContextException, StoreException {
        if (this.warmUpEnabled) {
            String normalizedPath = ContentStoreUtils.normalizePath((String)path);
            PreloadedFoldersAwareContext contextWrapper = (PreloadedFoldersAwareContext)context;
            Context actualContext = contextWrapper.getActualContext();
            return this.executeIfNotPreloadedOrIfExistsInPreloadedPaths(contextWrapper, normalizedPath, () -> this.actualStoreAdapter.findContent(actualContext, cachingOptions, normalizedPath));
        }
        return this.actualStoreAdapter.findContent(context, cachingOptions, path);
    }

    public Item findItem(Context context, CachingOptions cachingOptions, String path, boolean withDescriptor) throws InvalidContextException, XmlFileParseException, StoreException {
        if (this.warmUpEnabled) {
            String normalizedPath = ContentStoreUtils.normalizePath((String)path);
            PreloadedFoldersAwareContext contextWrapper = (PreloadedFoldersAwareContext)context;
            Context actualContext = contextWrapper.getActualContext();
            return this.executeIfNotPreloadedOrIfExistsInPreloadedPaths(contextWrapper, normalizedPath, () -> this.actualStoreAdapter.findItem(actualContext, cachingOptions, normalizedPath, withDescriptor));
        }
        return this.actualStoreAdapter.findItem(context, cachingOptions, path, withDescriptor);
    }

    public List<Item> findItems(Context context, CachingOptions cachingOptions, String path) throws InvalidContextException, XmlFileParseException, StoreException {
        if (this.warmUpEnabled) {
            String normalizedPath = ContentStoreUtils.normalizePath((String)path);
            PreloadedFoldersAwareContext contextWrapper = (PreloadedFoldersAwareContext)context;
            Context actualContext = contextWrapper.getActualContext();
            return this.executeIfNotPreloadedOrIfExistsInPreloadedPaths(contextWrapper, normalizedPath, () -> this.actualStoreAdapter.findItems(actualContext, cachingOptions, normalizedPath));
        }
        return this.actualStoreAdapter.findItems(context, cachingOptions, path);
    }

    protected <T> T executeIfNotPreloadedOrIfExistsInPreloadedPaths(PreloadedFoldersAwareContext contextWrapper, String path, Supplier<T> actualCall) {
        Boolean exists;
        PreloadedFolder preloadedAncestor = this.findPreloadedAncestor(contextWrapper.getPreloadedFolders(), path);
        if (preloadedAncestor != null && (exists = preloadedAncestor.exists(path)) != null && !exists.booleanValue()) {
            logger.debug("Path {} not found in preloaded descendants of {}", (Object)path, (Object)preloadedAncestor);
            return null;
        }
        return actualCall.get();
    }

    protected PreloadedFolder findPreloadedAncestor(List<PreloadedFolder> preloadedFolders, String path) {
        return preloadedFolders.stream().filter(folder -> path.startsWith(folder.getPath())).findFirst().orElse(null);
    }
}

