/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.util.ContentStoreUtils;
import org.craftercms.engine.cache.ContextCacheWarmer;
import org.craftercms.engine.cache.PreloadedFolder;
import org.craftercms.engine.cache.PreloadedFoldersAwareContext;
import org.craftercms.engine.properties.SiteProperties;
import org.craftercms.engine.util.CacheUtils;
import org.craftercms.engine.util.store.decorators.DecoratedStoreAdapterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class ContentStoreAdapterPreloadedFoldersBasedCacheWarmer
implements ContextCacheWarmer {
    private static final Logger logger = LoggerFactory.getLogger(ContentStoreAdapterPreloadedFoldersBasedCacheWarmer.class);
    protected boolean warmUpEnabled;
    protected Map<String, Integer> descriptorPreloadFolders;
    protected Map<String, Integer> contentPreloadFolders;

    @Required
    public void setWarmUpEnabled(boolean warmUpEnabled) {
        this.warmUpEnabled = warmUpEnabled;
    }

    @Required
    public void setDescriptorPreloadFolders(String[] descriptorPreloadFolders) {
        this.descriptorPreloadFolders = CacheUtils.parsePreloadFoldersList(descriptorPreloadFolders);
    }

    @Required
    public void setContentPreloadFolders(String[] contentPreloadFolders) {
        this.contentPreloadFolders = CacheUtils.parsePreloadFoldersList(contentPreloadFolders);
    }

    @Override
    public void warmUpCache(Context context) {
        ArrayList<PreloadedFolder> preloadedFolders = new ArrayList<PreloadedFolder>();
        PreloadedFoldersAwareContext contextWrapper = this.findPreloadedFoldersAwareContext(context);
        if (contextWrapper == null) {
            throw new IllegalStateException("PreloadedFoldersAwareContext expected but not found");
        }
        for (Map.Entry<String, Integer> entry : this.getContentPreloadFolders().entrySet()) {
            this.preloadFolder(contextWrapper, entry.getKey(), entry.getValue(), true, preloadedFolders);
        }
        for (Map.Entry<String, Integer> entry : this.getDescriptorPreloadFolders().entrySet()) {
            this.preloadFolder(contextWrapper, entry.getKey(), entry.getValue(), false, preloadedFolders);
        }
        contextWrapper.setPreloadedFolders(preloadedFolders);
    }

    protected PreloadedFoldersAwareContext findPreloadedFoldersAwareContext(Context context) {
        if (context instanceof PreloadedFoldersAwareContext) {
            return (PreloadedFoldersAwareContext)context;
        }
        if (context instanceof DecoratedStoreAdapterContext) {
            return this.findPreloadedFoldersAwareContext(((DecoratedStoreAdapterContext)context).getActualContext());
        }
        return null;
    }

    protected void preloadFolder(PreloadedFoldersAwareContext contextWrapper, String path, int depth, boolean contentOnly, List<PreloadedFolder> preloadedFolders) {
        path = ContentStoreUtils.normalizePath((String)path);
        Context actualContext = contextWrapper.getActualContext();
        StopWatch stopWatch = new StopWatch();
        logger.info("Starting preload of folder [{}] with depth {}", (Object)path, (Object)depth);
        stopWatch.start();
        Item rootFolder = actualContext.getStoreAdapter().findItem(actualContext, null, path, true);
        if (rootFolder == null || !rootFolder.isFolder()) {
            throw new IllegalStateException("Can't preload folder " + path + ": it doesn't exist or is not a folder");
        }
        TreeSet<String> preloadedDescendants = new TreeSet<String>();
        try {
            this.preloadFolderChildren(actualContext, path, depth, contentOnly, preloadedDescendants);
            preloadedFolders.add(new PreloadedFolder(path, depth, preloadedDescendants));
        }
        catch (Exception e) {
            logger.error("Error while preloading folder [{}]", (Object)path, (Object)e);
        }
        stopWatch.stop();
        logger.info("Preload of folder [{}] with depth {} completed in {} secs", new Object[]{path, depth, stopWatch.getTime(TimeUnit.SECONDS)});
    }

    protected void preloadFolderChildren(Context context, String path, int depth, boolean contentOnly, Set<String> preloadedPaths) {
        if (depth == -1 || depth >= 1) {
            List children;
            if (depth >= 1) {
                --depth;
            }
            if (CollectionUtils.isNotEmpty((Collection)(children = context.getStoreAdapter().findItems(context, null, path)))) {
                for (Item item : children) {
                    String childPath = item.getUrl();
                    if (item.isFolder()) {
                        logger.debug("Preloading folder [{}]", (Object)childPath);
                        if (!contentOnly) {
                            context.getStoreAdapter().findItem(context, null, childPath, true);
                        }
                        preloadedPaths.add(childPath);
                        this.preloadFolderChildren(context, childPath, depth, contentOnly, preloadedPaths);
                        continue;
                    }
                    if (contentOnly) {
                        logger.debug("Preloading content [{}]", (Object)childPath);
                        context.getStoreAdapter().findContent(context, null, childPath);
                        preloadedPaths.add(childPath);
                        continue;
                    }
                    logger.debug("Preloading item [{}]", (Object)childPath);
                    context.getStoreAdapter().findItem(context, null, childPath, true);
                    preloadedPaths.add(childPath);
                }
            }
        }
    }

    protected Map<String, Integer> getDescriptorPreloadFolders() {
        Map<String, Integer> preloadFolders = SiteProperties.getDescriptorPreloadFolders();
        if (MapUtils.isNotEmpty(preloadFolders)) {
            return preloadFolders;
        }
        return this.descriptorPreloadFolders;
    }

    protected Map<String, Integer> getContentPreloadFolders() {
        Map<String, Integer> preloadFolders = SiteProperties.getContentPreloadFolders();
        if (MapUtils.isNotEmpty(preloadFolders)) {
            return preloadFolders;
        }
        return this.contentPreloadFolders;
    }
}

