/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.cache;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.engine.cache.ContextCacheWarmer;
import org.craftercms.engine.properties.SiteProperties;
import org.craftercms.engine.util.CacheUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class ContentStoreServiceTreeBasedContextCacheWarmer
implements ContextCacheWarmer {
    private static final Logger logger = LoggerFactory.getLogger(ContentStoreServiceTreeBasedContextCacheWarmer.class);
    protected boolean warmUpEnabled;
    protected ContentStoreService contentStoreService;
    protected Map<String, Integer> descriptorPreloadFolders;

    @Required
    public void setWarmUpEnabled(boolean warmUpEnabled) {
        this.warmUpEnabled = warmUpEnabled;
    }

    @Required
    public void setContentStoreService(ContentStoreService contentStoreService) {
        this.contentStoreService = contentStoreService;
    }

    @Required
    public void setDescriptorPreloadFolders(String[] descriptorPreloadFolders) {
        this.descriptorPreloadFolders = CacheUtils.parsePreloadFoldersList(descriptorPreloadFolders);
    }

    @Override
    public void warmUpCache(Context context) {
        for (Map.Entry<String, Integer> entry : this.getDescriptorPreloadFolders().entrySet()) {
            String treeRoot = entry.getKey();
            int depth = entry.getValue();
            StopWatch stopWatch = new StopWatch();
            logger.info("Starting preload of tree [{}] with depth {}", (Object)treeRoot, (Object)depth);
            stopWatch.start();
            try {
                this.contentStoreService.getTree(context, treeRoot, depth);
            }
            catch (Exception e) {
                logger.error("Error while preloading tree at [{}]", (Object)treeRoot, (Object)e);
            }
            stopWatch.stop();
            logger.info("Preload of tree [{}] with depth {} completed in {} secs", new Object[]{treeRoot, depth, stopWatch.getTime(TimeUnit.SECONDS)});
        }
    }

    protected Map<String, Integer> getDescriptorPreloadFolders() {
        Map<String, Integer> preloadFolders = SiteProperties.getDescriptorPreloadFolders();
        if (MapUtils.isNotEmpty(preloadFolders)) {
            return preloadFolders;
        }
        return this.descriptorPreloadFolders;
    }
}

