/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.cache;

import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class PreloadedFolder {
    private String path;
    private int depth;
    private Set<String> descendants;

    public PreloadedFolder(String path, int depth, Set<String> descendants) {
        this.path = StringUtils.appendIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        this.depth = depth;
        this.descendants = descendants;
    }

    public String getPath() {
        return this.path;
    }

    public Boolean exists(String descendant) {
        if (this.depth == -1) {
            return this.descendants.contains(descendant);
        }
        int childDepth = this.getDepth(descendant);
        if (childDepth > this.depth) {
            return null;
        }
        return this.descendants.contains(descendant);
    }

    private int getDepth(String child) {
        String afterParentPath = StringUtils.substringAfter((String)child, (String)this.path);
        String[] pathComponents = afterParentPath.split("/");
        return pathComponents.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreloadedFolder that = (PreloadedFolder)o;
        return this.depth == that.depth && this.path.equals(that.path);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.depth);
    }

    public String toString() {
        return "PreloadedFolder{path='" + this.path + '\'' + ", depth=" + this.depth + '}';
    }
}

