/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.cache;

import java.util.Collections;
import java.util.List;
import org.craftercms.core.service.CacheService;
import org.craftercms.core.service.Context;
import org.craftercms.core.store.ContentStoreAdapter;
import org.craftercms.engine.cache.PreloadedFolder;
import org.craftercms.engine.util.store.decorators.DecoratedStoreAdapterContext;

class PreloadedFoldersAwareContext
extends DecoratedStoreAdapterContext {
    public static final String PRELOADED_FOLDERS_CACHE_KEY = "cache.warmUp.preloadedFolders";
    protected CacheService cacheService;

    public PreloadedFoldersAwareContext(Context actualContext, ContentStoreAdapter decoratedStoreAdapter, CacheService cacheService) {
        super(actualContext, decoratedStoreAdapter);
        this.cacheService = cacheService;
    }

    public List<PreloadedFolder> getPreloadedFolders() {
        List folders = (List)this.cacheService.get((Context)this, (Object)PRELOADED_FOLDERS_CACHE_KEY);
        if (folders != null) {
            return folders;
        }
        return Collections.emptyList();
    }

    public void setPreloadedFolders(List<PreloadedFolder> preloadedFolders) {
        this.cacheService.put((Context)this, (Object)PRELOADED_FOLDERS_CACHE_KEY, preloadedFolders);
    }

    @Override
    public Context clone() {
        return new PreloadedFoldersAwareContext(this.actualContext.clone(), this.decoratedStoreAdapter, this.cacheService);
    }
}

