/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.cache;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;
import org.craftercms.core.exception.CrafterException;
import org.craftercms.core.service.CacheService;
import org.craftercms.core.service.Context;
import org.craftercms.engine.cache.ContextCacheWarmer;
import org.craftercms.engine.cache.SiteCacheWarmer;
import org.craftercms.engine.service.context.SiteContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class SiteCacheWarmerImpl
implements SiteCacheWarmer {
    private static final Logger logger = LoggerFactory.getLogger(SiteCacheWarmerImpl.class);
    protected CacheService cacheService;
    protected List<ContextCacheWarmer> contextCacheWarmers;

    @Required
    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    @Required
    public void setContextCacheWarmers(List<ContextCacheWarmer> contextCacheWarmers) {
        this.contextCacheWarmers = contextCacheWarmers;
    }

    @Override
    public void warmUpCache(SiteContext siteContext, boolean switchCache) {
        String siteName = siteContext.getSiteName();
        StopWatch stopWatch = new StopWatch();
        if (switchCache) {
            Context currentContext = siteContext.getContext();
            long oldCacheVersion = currentContext.getCacheVersion();
            long newCacheVersion = System.nanoTime();
            Context tmpContext = currentContext.clone();
            tmpContext.setCacheVersion(newCacheVersion);
            this.cacheService.addScope(tmpContext);
            try {
                logger.info("Starting warm up for new cache of site '{}'", (Object)siteName);
                stopWatch.start();
                this.doCacheWarmUp(tmpContext);
                if (!siteContext.isValid()) {
                    throw new CrafterException("The site context has become invalid (possibly destroyed)");
                }
                currentContext.setCacheVersion(newCacheVersion);
                tmpContext.setCacheVersion(oldCacheVersion);
                this.cacheService.removeScope(tmpContext);
                stopWatch.stop();
                logger.info("Warm up for new cache of site '{}' completed (switched with old cache) in {} secs", (Object)siteName, (Object)stopWatch.getTime(TimeUnit.SECONDS));
            }
            catch (Exception e) {
                this.cacheService.removeScope(tmpContext);
                logger.error("Cache warm up failed", (Throwable)e);
            }
        } else {
            logger.info("Starting warm up for cache of site '{}'", (Object)siteName);
            stopWatch.start();
            this.doCacheWarmUp(siteContext.getContext());
            stopWatch.stop();
            logger.info("Warm up for cache of site '{}' completed in {} secs", (Object)siteName, (Object)stopWatch.getTime(TimeUnit.SECONDS));
        }
    }

    private void doCacheWarmUp(Context cacheContext) {
        for (ContextCacheWarmer cacheWarmer : this.contextCacheWarmers) {
            cacheWarmer.warmUpCache(cacheContext);
        }
    }
}

