/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.controller;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.file.stores.RemoteFile;
import org.craftercms.commons.file.stores.RemoteFileResolver;
import org.craftercms.engine.util.spring.resources.RangeAwareResourceRegionHttpMessageConverter;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;
import org.springframework.http.CacheControl;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

public class RemoteAssetsRequestHandler
extends ResourceHttpRequestHandler {
    private RemoteFileResolver remoteFileResolver;
    private boolean disableCaching;

    protected void init() {
        if (this.disableCaching) {
            this.setCacheControl(CacheControl.noCache());
        }
        this.setRequireSession(false);
        this.setResourceRegionHttpMessageConverter(new RangeAwareResourceRegionHttpMessageConverter());
    }

    @Required
    public void setRemoteFileResolver(RemoteFileResolver remoteFileResolver) {
        this.remoteFileResolver = remoteFileResolver;
    }

    public void setDisableCaching(boolean disableCaching) {
        this.disableCaching = disableCaching;
    }

    protected Resource getResource(HttpServletRequest request) throws IOException {
        String path = this.getPath(request);
        RemoteFile file = this.remoteFileResolver.resolve(path);
        if (file != null) {
            return file.toResource();
        }
        throw new FileNotFoundException("No remote file found for " + path);
    }

    protected String getPath(HttpServletRequest request) {
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            return !path.startsWith("/") ? "/" + path : path;
        }
        throw new IllegalStateException("Required request attribute '" + HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE + "' is not set");
    }
}

