/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.controller.rest;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.exceptions.InvalidManagementTokenException;
import org.craftercms.core.cache.CacheStatistics;
import org.craftercms.core.controller.rest.RestControllerBase;
import org.craftercms.engine.event.SiteContextCreatedEvent;
import org.craftercms.engine.event.SiteEvent;
import org.craftercms.engine.service.context.SiteContext;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${crafter.core.rest.base.uri}/site/cache"})
public class SiteCacheRestController
extends RestControllerBase {
    private static final Log logger = LogFactory.getLog(SiteCacheRestController.class);
    public static final String URL_ROOT = "/site/cache";
    public static final String URL_CLEAR = "/clear";
    public static final String URL_STATS = "/statistics";
    private String configuredToken;

    @RequestMapping(value={"/clear"}, method={RequestMethod.GET})
    public Map<String, Object> clear(HttpServletRequest request, @RequestParam String token) throws InvalidManagementTokenException {
        if (StringUtils.equals((CharSequence)token, (CharSequence)this.getConfiguredToken())) {
            SiteContext siteContext = SiteContext.getCurrent();
            String siteName = siteContext.getSiteName();
            if (SiteEvent.getLatestRequestEvent(SiteContextCreatedEvent.class, request) != null) {
                return SiteCacheRestController.createResponseMessage((String)("Site context for '" + siteName + "' created during the request. Cache clear not necessary"));
            }
            siteContext.startCacheClear();
            String msg = "Cache clear for site '" + siteName + "' started";
            logger.debug((Object)msg);
            return SiteCacheRestController.createResponseMessage((String)msg);
        }
        throw new InvalidManagementTokenException("Management authorization failed, invalid token.");
    }

    @RequestMapping(value={"/statistics"}, method={RequestMethod.GET})
    public CacheStatistics getStatistics(@RequestParam String token) throws InvalidManagementTokenException {
        if (StringUtils.isNotEmpty((CharSequence)token) && StringUtils.equals((CharSequence)token, (CharSequence)this.getConfiguredToken())) {
            SiteContext siteContext = SiteContext.getCurrent();
            return siteContext.getCacheTemplate().getCacheService().getStatistics(siteContext.getContext());
        }
        throw new InvalidManagementTokenException("Management authorization failed, invalid token.");
    }

    public String getConfiguredToken() {
        return this.configuredToken;
    }

    @Required
    public void setConfiguredToken(String configuredToken) {
        this.configuredToken = configuredToken;
    }
}

