/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.controller.rest;

import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.exceptions.InvalidManagementTokenException;
import org.craftercms.core.controller.rest.RestControllerBase;
import org.craftercms.engine.event.SiteContextCreatedEvent;
import org.craftercms.engine.event.SiteEvent;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.service.context.SiteContextManager;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${crafter.core.rest.base.uri}/site/context"})
public class SiteContextRestController
extends RestControllerBase {
    public static final String URL_ROOT = "/site/context";
    public static final String URL_CONTEXT_ID = "/id";
    public static final String URL_DESTROY = "/destroy";
    public static final String URL_REBUILD = "/rebuild";
    public static final String URL_GRAPHQL = "/graphql";
    public static final String URL_STATUS = "/status";
    public static final String MODEL_ATTR_ID = "id";
    public static final String MODEL_ATTR_STATUS = "status";
    private SiteContextManager contextManager;
    private String configuredToken;

    @Required
    public void setContextManager(SiteContextManager contextManager) {
        this.contextManager = contextManager;
    }

    protected void validateToken(String token) throws InvalidManagementTokenException {
        if (!StringUtils.equals((CharSequence)token, (CharSequence)this.getConfiguredToken())) {
            throw new InvalidManagementTokenException("Management authorization failed, invalid token.");
        }
    }

    @GetMapping(value={"/id"})
    public Map<String, String> getContextId(@RequestParam String token) throws InvalidManagementTokenException {
        this.validateToken(token);
        return Collections.singletonMap(MODEL_ATTR_ID, SiteContext.getCurrent().getContext().getId());
    }

    @GetMapping(value={"/destroy"})
    public Map<String, Object> destroy(@RequestParam String token) throws InvalidManagementTokenException {
        this.validateToken(token);
        String siteName = SiteContext.getCurrent().getSiteName();
        this.contextManager.startDestroyContext(siteName);
        return SiteContextRestController.createResponseMessage((String)("Started destroy site context  for '" + siteName + "'. Will be recreated on next request"));
    }

    @GetMapping(value={"/rebuild"})
    public Map<String, Object> rebuild(HttpServletRequest request, @RequestParam String token) throws InvalidManagementTokenException {
        this.validateToken(token);
        SiteContext siteContext = SiteContext.getCurrent();
        String siteName = siteContext.getSiteName();
        if (SiteEvent.getLatestRequestEvent(SiteContextCreatedEvent.class, request) != null) {
            return SiteContextRestController.createResponseMessage((String)("Site context for '" + siteName + "' created during the request. Context rebuild not necessary"));
        }
        this.contextManager.startContextRebuild(siteName, siteContext.isFallback());
        return SiteContextRestController.createResponseMessage((String)("Started rebuild for Site context for '" + siteName + "'"));
    }

    @GetMapping(value={"/graphql/rebuild"})
    public Map<String, Object> rebuildSchema(HttpServletRequest request, @RequestParam String token) throws InvalidManagementTokenException {
        this.validateToken(token);
        SiteContext siteContext = SiteContext.getCurrent();
        String siteName = siteContext.getSiteName();
        if (SiteEvent.getLatestRequestEvent(SiteContextCreatedEvent.class, request) != null) {
            return SiteContextRestController.createResponseMessage((String)("Site context for '" + siteName + "' created during the request. GraphQL schema rebuild not necessary"));
        }
        siteContext.startGraphQLSchemaBuild();
        return SiteContextRestController.createResponseMessage((String)("Rebuild of GraphQL schema started for '" + siteName + "'"));
    }

    @GetMapping(value={"/status"})
    public Map<String, Object> getStatus(@RequestParam String token) throws InvalidManagementTokenException {
        this.validateToken(token);
        return SiteContextRestController.createSingletonModifiableMap((String)MODEL_ATTR_STATUS, (Object)((Object)SiteContext.getCurrent().getState()));
    }

    public String getConfiguredToken() {
        return this.configuredToken;
    }

    @Required
    public void setConfiguredToken(String configuredToken) {
        this.configuredToken = configuredToken;
    }
}

